<?php

use Elementor\Post_CSS_File;
use Elementor\Core\Files\CSS\Post;

/** no direct access */
if (!defined('ABSPATH')) {
	exit;
}

if (!class_exists('MEC_Features_RegForm')) :

	/**
	 * MEC_Features_RegForm.
	 *
	 * @author     author
	 * @package     package
	 * @since     1.0.0
	 */
	class MEC_Features_RegForm
	{


		/**
		 * Instance of this class.
		 *
		 * @since     1.0.0
		 * @access     private
		 * @var     MEC_Features_RegForm
		 */
		private static $instance;

		/**
		 * the object created its own class
		 * Provided that the class has no other occurences
		 *
		 * @since  1.0.0
		 * @return MEC_Form_Builder
		 */
		public static function get_instance()
		{
			if (self::$instance === null) {
				self::$instance = new self();
			}
			return self::$instance;
		}

		public function style_detector()
		{
			if(!class_exists('\Elementor\Core\Files\CSS\Post')) {
				return;
			}

			$global_inheritance = get_post_meta(get_the_ID(), 'mec_reg_fields_global_inheritance', 1);
			if (trim($global_inheritance) == '') {
				$global_inheritance = 1;
			}
			$mainClass      = new \MEC_main();
			$set            = $mainClass->get_options();
			if ((int) $global_inheritance === 1) {
				if(!isset($set['default_form']['form_id'])) {
					return;
				}

				if(!$set['default_form']['form_id']) {
					return;
				}
			}

			if (is_single() && 'mec-events' == get_post_type()) {
				if ((int) $global_inheritance === 1) {
					$f_id = $set['default_form']['form_id'];
				} else {
					$p_id = get_the_ID();
					$f_id = get_post_meta($p_id, 'mec_reg_form_id', true);
				}
				if(!$f_id) {
					return;
				}

				$css_file = new \Elementor\Core\Files\CSS\Post( $f_id );
				$css_file->enqueue();
			}
		}

		/**
		 * Define the core functionality of the MEC_Features_RegForm.
		 * Load the dependencies.
		 *
		 * @since     1.0.0
		 */
		public function __construct()
		{
			$this->actions();
		}
		/**
		 * Actions
		 *
		 * @since     1.0.0
		 */
		public function actions()
		{
			add_action('mec_reg_fields_form_start', [$this, 'render_select_forms_in_reg_form']);
			add_action('admin_footer', [$this, 'render_the_scripts_in_reg_form']);

			add_action('wp_enqueue_scripts', [$this, 'style_detector']);
			add_action('mec_meta_box_reg_fields_form', [$this, 'render_select_forms_in_events'], 1, 1);
			add_action('mec_events_meta_box_regform_end', [$this, 'render_the_scripts_in_events'], 1, 1);

			add_action('mec_save_options', [$this, 'save_options'], 1, 1);
			add_action('mec_save_reg_fields', [$this, 'mec_save_reg_fields'], 1, 2);
			add_filter('mec_get_reg_fields', [$this, 'mec_get_reg_fields'], 1, 2);
			add_filter('mec_get_bfixed_fields', [$this, 'mec_get_bfixed_fields'], 1, 2);
			add_filter('mec-booking-attendees-title', [$this, 'mec_attendees_title'], 1, 2);

			add_filter('mec_have_custom_view_fields',[$this,'mec_have_custom_view'], 10, 4);
			add_filter('mec_booking_attendee_form_custom_view',[$this,'booking_attendee_form_custom_view'], 10, 3);

		}

		/**
		 * Change MEC Attendees Title
		 *
		 * @since     1.0.0
		 */
		public function mec_attendees_title ($title, $event_id) {
			$global_inheritance = get_post_meta($event_id, 'mec_reg_fields_global_inheritance', 1);
			$mainClass      = new \MEC_main();
			$set            = $mainClass->get_options();

			if (trim($global_inheritance) == '') {
				$global_inheritance = 1;
			}
			if ((int) $global_inheritance === 1) {
				if (!isset($set['default_form']['form_id'])) {
					return $title;
				}

				if (!$set['default_form']['form_id']) {
					return $title;
				}
				$form_id = $set['default_form']['form_id'];
			} else {
				$form_id = get_post_meta($event_id, 'mec_reg_form_id', true);
			}

			if(!$form_id) {
				return $title;
			}
			$_title = get_post_meta($form_id, 'mec-booking-attendees-title', true);
			if($_title !== false) {
				return $_title;
			}
			return $title;
		}

		/**
		 * MEC Get Reg Fields
		 *
		 * @since     1.0.0
		 */
		public function mec_get_reg_fields($fields, $e_id)
		{
			if (is_admin() && !wp_doing_ajax() && isset($_GET['page']) && isset($_GET['tab']) && $_GET['page'] == 'MEC-settings' && $_GET['tab'] == 'MEC-reg-form') {
				return $fields;
			}

			$global_inheritance = get_post_meta($e_id, 'mec_reg_fields_global_inheritance', 1);
			if (trim($global_inheritance) == '') {
				$global_inheritance = 1;
			}

			if ((int) $global_inheritance === 1) {
				$mec_default_form_id = get_option('mec_default_form_id', false);
				$reg_fields          = get_post_meta($mec_default_form_id, 'mec_reg_fields', true);
				if (!is_array($reg_fields) || empty($reg_fields) || !$mec_default_form_id) {
					return $fields;
				} else {
					return $reg_fields;
				}
			} elseif( $e_id ) {
				$mec_reg_form_id = get_post_meta($e_id, 'mec_reg_form_id', true);
				$reg_fields      = get_post_meta($mec_reg_form_id, 'mec_reg_fields', true);
				if (!is_array($reg_fields)) {
					return $fields;
				}

				foreach ($reg_fields as $key => $field) {
					if (isset($field['type']) && $field['type'] == 'h') {
						unset($reg_fields[$key]);
					}
					if (isset($field['type']) && $field['type'] == 'p') {
						$reg_fields[$key]['paragraph'] = isset($reg_fields[$key]['paragraph']) ? $reg_fields[$key]['paragraph'] : '';
						$reg_fields[$key]['content'] = $reg_fields[$key]['paragraph'];
						unset($reg_fields[$key]['paragraph']);
					}
				}

				if (!is_array($reg_fields) || empty($reg_fields)) {
					return $fields;
				}
			}

			return !empty( $reg_fields ) ? $reg_fields : $fields;
		}

		public function get_form_id( $event_id ) {

			$global_inheritance = get_post_meta($event_id, 'mec_reg_fields_global_inheritance', 1);

			if ((int) $global_inheritance === 1) {

				return get_option('mec_default_form_id', false);
			} else {

				return get_post_meta($event_id, 'mec_reg_form_id', true);
			}

			return false;
		}

		/**
		 * MEC Have Custom View for Event
		 *
		 * @since     1.0.0
		 */
		public function mec_have_custom_view( $have, $fields, $section, $event_id ){

			$mec_default_form_id = $this->get_form_id( $event_id );
			$reg_fields          = get_post_meta($mec_default_form_id, 'mec_reg_fields', true);
			if (!is_array($reg_fields) || empty($reg_fields) || !$mec_default_form_id) {

				return false;
			} else {

				return true;
			}

			return $have;
		}

		public function booking_attendee_form_custom_view( $event, $event_id, $form_args ) {

			$form_id = $this->get_form_id( $event_id );

			global $mec_fb_form_args;
			$form_args['event'] = $event;
			$mec_fb_form_args = $form_args;

			echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $form_id, true );
		}

		/**
		 * MEC Get bfixed Fields
		 *
		 * @since     1.0.0
		 */
		public function mec_get_bfixed_fields($fields, $event_id)
		{
			if (is_admin() && !wp_doing_ajax() && isset($_GET['page']) && isset($_GET['tab']) && $_GET['page'] == 'MEC-settings' && $_GET['tab'] == 'MEC-reg-form') {
				return $fields;
			}

			$global_inheritance = get_post_meta($event_id, 'mec_reg_fields_global_inheritance', 1);
			if (trim($global_inheritance) == '') {
				$global_inheritance = 1;
			}
			if ((int) $global_inheritance === 1) {
				$mec_default_form_id = get_option('mec_default_form_id', false);
				$bfixed_fields       = get_post_meta($mec_default_form_id, 'mec_bfixed_fields', true);
				if (!is_array($bfixed_fields) || empty($bfixed_fields) || !$mec_default_form_id) {
					return $fields;
				} else {
					return $bfixed_fields;
				}
			} elseif( $event_id ) {
				$mec_reg_form_id = get_post_meta($event_id, 'mec_reg_form_id', true);
				$bfixed_fields      = get_post_meta($mec_reg_form_id, 'mec_bfixed_fields', true);
				if (!is_array($bfixed_fields)) {
					return $fields;
				}

				foreach ($bfixed_fields as $key => $field) {
					if (isset($field['type']) && $field['type'] == 'h') {
						unset($bfixed_fields[$key]);
					}
					if (isset($field['type']) && $field['type'] == 'p') {
						$bfixed_fields[$key]['paragraph'] = isset($bfixed_fields[$key]['paragraph']) ? $bfixed_fields[$key]['paragraph'] : '';
						$bfixed_fields[$key]['content'] = $bfixed_fields[$key]['paragraph'];
						unset($bfixed_fields[$key]['paragraph']);
					}
				}

				if (!is_array($bfixed_fields) || empty($bfixed_fields)) {
					return $fields;
				}
			}

			return is_array($bfixed_fields) ? $bfixed_fields : [];
		}

		/**
		 * Description
		 *
		 * @since     1.0.0
		 */
		public function mec_save_reg_fields($post_id, $fields)
		{
			$reg_fields_global_inheritance = isset($_REQUEST['reg_fields_global_inheritance']) ? $_REQUEST['reg_fields_global_inheritance'] : 0;
			if ('1' != $reg_fields_global_inheritance) {
				$default_form_id = isset($_REQUEST['mec']['default_form']['form_id']) ? $_REQUEST['mec']['default_form']['form_id'] : '';
				update_post_meta($post_id, 'mec_reg_form_id', $default_form_id);
			} else {
				update_post_meta($post_id, 'mec_reg_form_id', '');
			}
		}

		public function render_select_forms_in_events($post_id)
		{
			$global_inheritance = get_post_meta($post_id, 'mec_reg_fields_global_inheritance', true);
			if (trim($global_inheritance) == '') {
				$global_inheritance = 1;
			}

			$mec_reg_form_id = get_post_meta($post_id, 'mec_reg_form_id', true);
			$mec_reg_form_id = is_array($mec_reg_form_id) && isset($mec_reg_form_id[0]) ? $mec_reg_form_id[0] : $mec_reg_form_id;
			$class           = ($global_inheritance) ? 'mec-util-hidden' : '';
			$html            = '<div class="mec-select-default-form-in-events ' . $class . '">';
			$args            = array(
				'posts_per_page' => 500,
				'category_name'  => '',
				'orderby'        => 'date',
				'order'          => 'DESC',
				'post_type'      => 'mec_form',
				'post_status'    => 'publish',
			);

			$posts_array = get_posts($args);
			$html 		.= '<div class="mec-form-row">';
			$html       .= '<label><input type="radio" data-name="custom" value="0" name="mec[default_form][form_id]">' . esc_html__('Classic Form Builder', 'mec-form-builder') . ' </label></br>';
			$html       .= '<label><input type="radio" data-name="formBuilder" name="mec[default_form][form_id]" value="'. ($mec_reg_form_id ? $mec_reg_form_id : 'formBuilderForms') .'">' . esc_html__('Elementor Form Builder', 'mec-form-builder') . ' </label>';
			$html 		.= '</div>';
			$html 		.= '<div id="mec_fb_form_id" class="mec-form-row mec-util-hidden">';
			$html 		.= '<label class="mec-col-3" for="mec_default_form_type">' . esc_html__('Select Form Template', 'mec-form-builder') . '</label>';
			$html 		.= '<div class="mec-col-9">';
			$html       .= '<select>';
			$html       .= '<option value="0">' . esc_html__('Select Form', 'mec-form-builder') . '</option>';
			foreach ($posts_array as $f) :
				$html .= '<option value="' . $f->ID . '"';
				if ($f->ID == $mec_reg_form_id) {
					echo '<script>var mec_default_form_id = "' . $f->ID . '";</script>';
					$html .= ' selected="selected"';
				}
				$html .= '>' . $f->post_title . '</option>';
			endforeach;

			$html 		.= '</select>';
			$html 		.= '</div>';
			$html 		.= '</div>';

			echo $html;
		}

		/**
		 * Render the scripts in events
		 *
		 * @since     1.0.0
		 */
		public function render_the_scripts_in_events($post_id)
		{
			$feature_mec = new MEC_feature_mec();
			$settings    = $feature_mec->main->get_default_form();

			$global_inheritance = get_post_meta($post_id, 'mec_reg_fields_global_inheritance', true);
			if (trim($global_inheritance) == '') {
				$global_inheritance = 1;
			}

			$mec_reg_form_id = get_post_meta($post_id, 'mec_reg_form_id', '');
			$mec_reg_form_id = is_array($mec_reg_form_id) && isset($mec_reg_form_id[0]) ? $mec_reg_form_id[0] : $mec_reg_form_id;

			$script = '
                <script type="text/javascript">
                    jQuery(document).ready(function() {
						jQuery(' . "'" . 'input[name="mec[default_form][form_id]"]' . "'" . ').on("change", function() {
							if (jQuery(this).data("name") == "custom") {
								jQuery("div#mec_regform_container_toggle").removeClass("mec-util-hidden");
								jQuery("#mec_fb_form_id").addClass("mec-util-hidden");
							} else {
								jQuery("div#mec_regform_container_toggle").addClass("mec-util-hidden");
								jQuery("#mec_fb_form_id").removeClass("mec-util-hidden");
								jQuery(this).val( jQuery("#mec_fb_form_id").val() );
							}
						});

						  jQuery(' . "'" . 'input[name="mec[reg_fields_global_inheritance]"]' . "'" . ').attr("onchange", "").on("change", function(event) {
								if(jQuery(this).is(":checked")) {
									if ( jQuery(\'input[name="mec[default_form][form_id]"][data-name="formBuilder"]\').is(":checked") ) {
										jQuery("div#mec_regform_container_toggle").removeClass("mec-util-hidden ");
									} else {
										jQuery("div#mec_regform_container_toggle").addClass("mec-util-hidden ");
                                    }
                                    jQuery("div#mec_regform_container_toggle").addClass("mec-util-hidden ");
                                    jQuery(".mec-select-default-form-in-events").addClass("mec-util-hidden");
                                } else {
									jQuery(".mec-select-default-form-in-events").removeClass("mec-util-hidden");
									if (jQuery(\'input[name="mec[default_form][form_id]"][data-name="formBuilder"]\').is(":checked")) {
										jQuery("div#mec_regform_container_toggle").addClass("mec-util-hidden ");
									} else {
										jQuery("div#mec_regform_container_toggle").removeClass("mec-util-hidden ");
									}
                                }
                        });

						jQuery("#mec_fb_form_id").on("change", function() {
							jQuery("input[data-name=formBuilder]").val( jQuery(this).val() );
						});

						if ( typeof(mec_default_form_id) != "undefined" ) {
							jQuery("input[data-name=formBuilder]").prop("checked", true);
							jQuery("#mec_fb_form_id").removeClass("mec-util-hidden");
							jQuery("div#mec_regform_container_toggle").addClass("mec-util-hidden");
						} else {
							jQuery("input[data-name=custom]").prop("checked", true);
							if(jQuery(' . "'" . 'input[name="mec[reg_fields_global_inheritance]"]' . "'" . ').is(":checked")) {
								jQuery("div#mec_regform_container_toggle").addClass("mec-util-hidden ");
							} else {
								jQuery("div#mec_regform_container_toggle").removeClass("mec-util-hidden ");
							}
						}

                    });
                </script>
            ';

			if (isset($settings['form_id']) && $settings['form_id'] && (int)$mec_reg_form_id ) {
				$script .= '
					<script type="text/javascript">
						jQuery(document).ready(function() {
							if ( typeof(mec_default_form_id) != "undefined" ) {
								return false;
							}
							jQuery("input[data-name=formBuilder]").prop("checked", true);
							jQuery("#mec_fb_form_id").val("' . $settings['form_id'] . '");
							jQuery("#mec_fb_form_id").removeClass("mec-util-hidden");
							jQuery("div#mec_regform_container_toggle").addClass("mec-util-hidden");
						});
				</script>';
			}
			echo $script;
		}

		public function render_select_forms_in_reg_form()
		{
			$feature_mec = new MEC_feature_mec();
			$settings    = $feature_mec->main->get_default_form();
			$html        = '';
			$form_id = isset( $settings['form_id'] ) ? $settings['form_id'] : 'formBuilderForms';

			$args        = array(
				'posts_per_page' => 500,
				'category_name'  => '',
				'orderby'        => 'date',
				'order'          => 'DESC',
				'post_type'      => 'mec_form',
				'post_status'    => 'publish',
			);


			$posts_array = get_posts($args);
			$html 		.= '<div class="mec-form-row">';
			$html       .= '<label><input type="radio" data-name="custom" value="0" name="mec[default_form][form_id]">' . esc_html__('Classic Form Builder', 'mec-form-builder') . ' </label></br>';
			$html       .= '<label><input type="radio" data-name="formBuilder" name="mec[default_form][form_id]" value="'. $form_id .'">' . esc_html__('Elementor Form Builder', 'mec-form-builder') . ' </label>';
			$html 		.= '</div>';
			$html 		.= '<div id="form_id" class="mec-form-row mec-util-hidden">';
			$html 		.= '<label class="mec-col-3" for="mec_default_form_type">' . esc_html__('Select Form Template', 'mec-form-builder') . '</label>';
			$html 		.= '<div class="mec-col-9">';
			$html       .= '<select>';
			$html       .= '<option value="0">' . esc_html__('Select Default Form', 'mec-form-builder') . '</option>';
			foreach ($posts_array as $f) :
				$html .= '<option value="' . $f->ID . '"';
				if (isset($settings['form_id']) && $f->ID == $form_id) {
					echo '<script>var mec_default_form_id = "' . $f->ID . '";</script>';
					$html .= ' selected="selected"';
				}
				$html .= '>' . $f->post_title . '</option>';
			endforeach;
			$html 		.= '</select>';
			$html 		.= '</div>';
    		$html 		.= '</div>';

			echo $html;
		}

		/**
		 * Render the scripts in reg form
		 *
		 * @since     1.0.0
		 */
		public function render_the_scripts_in_reg_form()
		{
			if (isset($_GET['page']) && $_GET['page'] == 'MEC-settings') {
				$feature_mec = new MEC_feature_mec();
				$settings    = $feature_mec->main->get_default_form();
			} else {
				return;
			}

			$script = '
                <script type="text/javascript">
                    jQuery(document).ready(function($) {
						jQuery(\'[name="mec[default_form][form_id]"]\').on("change", function() {
							console.log($(this));
							if (jQuery(this).data("name") == "custom") {
								jQuery("div#mec_reg_form_container").removeClass("mec-util-hidden");
								jQuery("#form_id").addClass("mec-util-hidden");
							} else {
								jQuery("div#mec_reg_form_container").addClass("mec-util-hidden");
								jQuery("#form_id").removeClass("mec-util-hidden");
								jQuery(this).val( jQuery("#form_id").val() );
							}
						});
						jQuery("#form_id").on("change", function() {
							jQuery("input[data-name=formBuilder]").val( jQuery(this).val() );
						})

						if ( typeof(mec_default_form_id) != "undefined" ) {
							jQuery("input[data-name=formBuilder]").prop("checked", true);
							jQuery("#form_id").removeClass("mec-util-hidden");
							jQuery("div#mec_reg_form_container").addClass("mec-util-hidden");
						} else {
							jQuery("input[data-name=custom]").prop("checked", true);
						}
                    });
                </script>
            ';

			if (isset($settings['form_id'])) {
				if (!empty($settings['form_id']) && $settings['form_id']) {
					$script .= '
                        <script type="text/javascript">
                            jQuery(document).ready(function() {
                                jQuery("div#mec_reg_form_container").addClass("mec-util-hidden");
                            });
                        </script>
                    ';
				}
			}
			echo $script;
		}

		/**
		 * save options
		 *
		 * @since     1.0.0
		 */
		public function save_options($data)
		{
			if (isset($_REQUEST['mec']['default_form']['form_id'])) {
				if ('0' != $_REQUEST['mec']['default_form']['form_id']) {
					$id = esc_attr($_REQUEST['mec']['default_form']['form_id']);
					update_option('mec_default_form_id', $id);
				} else {
					delete_option('mec_default_form_id');
				}
			}
		}
	} //Class
	MEC_Features_RegForm::get_instance();
endif;
