<?php

namespace MEC_Virtual_Events\Core\addEventOptions;

use MEC_Virtual_Events\Single\SinglePageAddon;

// don't load directly.
if (!defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}

/**
 * MecCTP.
 *
 * @author      author
 * @package     package
 * @since       1.0.0
 */
class MecAddEventOptions
{

    /**
     * Instance of this class.
     *
     * @since   1.0.0
     * @access  public
     * @var     MEC_Virtual_Events
     */
    public static $instance;

    /**
     * The directory of the file.
     *
     * @access  public
     * @var     string
     */
    public static $dir;

    /**
     * The Args
     *
     * @access  public
     * @var     array
     */
    public static $args;

    /**
     * Provides access to a single instance of a module using the singleton pattern.
     *
     * @since   1.0.0
     * @return  object
     */
    public static function instance()
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    public function __construct()
    {
        self::settingUp();
        self::setHooks($this);
        self::init();
    }

    /**
     * Set Hooks.
     *
     * @since   1.0.0
     */
    public static function setHooks($This)
    {
        add_filter('mec-single-event-meta-title', [$This, 'add_options'] , 99 , 2);
        add_filter('MEC_extra_info_gateways', [$This, 'display_password_in_booking'] , 99 , 3);

        add_filter('mec_monthly_virtual_badge', [$This, 'display_badge_in_monthly'] , 99 , 2);

        add_action('wp_enqueue_scripts', [$This, 'assets']);
        add_action('mec_virtual_event_form', [$This, 'meta_box_virtual']);
        add_action('mec_metabox_details', [$This, 'meta_box_virtual'], 60);
        add_action('save_post', [$This, 'save_event']);
        add_action('mec_single_after_content', [__CLASS__, 'display_in_single_page']);
        add_action('mec_single_virtual_badge', [__CLASS__, 'display_badge_in_single'] , 99 ,1);
        add_action('mec_shortcode_virtual_badge', [$This, 'display_badge_in_shortcode'] , 99, 1);
        add_action('mec_extra_field_notifications', [$This, 'display_notification_field']);

        add_action('save_fes_meta_action',[$This, 'save_fes_form'], 99, 2);
        //add_filter( 'the_content', [$This,'display_in_single_page'], 1 );

        // define in mec
        add_filter('mec_render_message_email', [__CLASS__, 'render_email_notification'], 10,4);
        add_filter('mec_profile_event_detail', [__CLASS__, 'add_event_detail_to_dashboard'], 10,3);
        add_filter('mec_profile_event_detail_header', [__CLASS__, 'add_header_event_detail_to_dashboard'], 10,3);

    }

    public function save_fes_form($post_id, $mec) {

        $mec_virtual_event = (isset($mec['mec_virtual_event']) and !empty($mec['mec_virtual_event'])) ? true : false;
        update_post_meta($post_id, 'mec_virtual_event', $mec_virtual_event);

        $mec_virtual_badge_shortcode = (isset($mec['mec_virtual_badge_shortcode']) and !empty($mec['mec_virtual_badge_shortcode'])) ? true : false;
        update_post_meta($post_id, 'mec_virtual_badge_shortcode', $mec_virtual_badge_shortcode);

        $mec_virtual_badge_single = (isset($mec['mec_virtual_badge_single']) and !empty($mec['mec_virtual_badge_single'])) ? true : false;
        update_post_meta($post_id, 'mec_virtual_badge_single', $mec_virtual_badge_single);

        $mec_virtual_display_user_booking_history = (isset($mec['mec_virtual_display_user_booking_history']) and !empty($mec['mec_virtual_display_user_booking_history'])) ? 'yes' : 'no';
        update_post_meta($post_id, 'mec_virtual_display_user_booking_history', $mec_virtual_display_user_booking_history);

        $mec_virtual_link_url = (isset($mec['mec_virtual_link_url']) and !empty($mec['mec_virtual_link_url'])) ? $mec['mec_virtual_link_url'] : '';
        update_post_meta($post_id, 'mec_virtual_link_url', $mec_virtual_link_url);

        $mec_virtual_link_title = (isset($mec['mec_virtual_link_title']) and !empty($mec['mec_virtual_link_title'])) ? $mec['mec_virtual_link_title'] : '';
        update_post_meta($post_id, 'mec_virtual_link_title', $mec_virtual_link_title);

        $mec_virtual_link_target = (isset($mec['mec_virtual_link_target']) and !empty($mec['mec_virtual_link_target'])) ? $mec['mec_virtual_link_target'] : '';
        update_post_meta($post_id, 'mec_virtual_link_target', $mec_virtual_link_target);

        $mec_virtual_embed = (isset($mec['mec_virtual_embed']) and !empty($mec['mec_virtual_embed'])) ? $mec['mec_virtual_embed'] : '';
        update_post_meta($post_id, 'mec_virtual_embed', $mec_virtual_embed);

        $mec_virtual_show_info_time = (isset($mec['mec_virtual_show_info_time']) and !empty($mec['mec_virtual_show_info_time'])) ? $mec['mec_virtual_show_info_time'] : '';
        update_post_meta($post_id, 'mec_virtual_show_info_time', $mec_virtual_show_info_time);

        $mec_virtual_show_info_hm = (isset($mec['mec_virtual_show_info_hm']) and !empty($mec['mec_virtual_show_info_hm'])) ? $mec['mec_virtual_show_info_hm'] : '';
        update_post_meta($post_id, 'mec_virtual_show_info_hm', $mec_virtual_show_info_hm);

        $mec_virtual_hide_info = (isset($mec['mec_virtual_hide_info']) and !empty($mec['mec_virtual_hide_info'])) ? true : false;
        update_post_meta($post_id, 'mec_virtual_hide_info', $mec_virtual_hide_info);

        $mec_virtual_hide_info_before_start = (isset($mec['mec_virtual_hide_info_before_start']) and !empty($mec['mec_virtual_hide_info_before_start'])) ? true : false;
        update_post_meta($post_id, 'mec_virtual_hide_info_before_start', $mec_virtual_hide_info_before_start);

        $mec_virtual_password = (isset($mec['mec_virtual_password']) and !empty($mec['mec_virtual_password'])) ? $mec['mec_virtual_password'] : '';
        update_post_meta($post_id, 'mec_virtual_password', $mec_virtual_password);

        $mec_virtual_display_password_in_booking = (isset($mec['mec_virtual_display_password_in_booking']) and !empty($mec['mec_virtual_display_password_in_booking'])) ? true : false;
        update_post_meta($post_id, 'mec_virtual_display_password_in_booking', $mec_virtual_display_password_in_booking);

        $mec_virtual_display_link_in_booking = (isset($mec['mec_virtual_display_link_in_booking']) and !empty($mec['mec_virtual_display_link_in_booking'])) ? true : false;
        update_post_meta($post_id, 'mec_virtual_display_link_in_booking', $mec_virtual_display_link_in_booking);

        $mec_virtual_display_embed_in_booking = (isset($mec['mec_virtual_display_embed_in_booking']) and !empty($mec['mec_virtual_display_embed_in_booking'])) ? true : false;
        update_post_meta($post_id, 'mec_virtual_display_embed_in_booking', $mec_virtual_display_embed_in_booking);

        return true;
    }

    /**
     * Global Variables.
     *
     * @since   1.0.0
     */
    public static function settingUp(){}

    public function assets() {
        wp_enqueue_style('mec-virtual-style', MECVIRTUALDASSETS . 'mec-virtual.css' );
    }

    /**
     * Global Variables.
     *
     * @since   1.0.0
     */
    public function add_options( $tabs, $activated ) {
        $virtualTab =  array(
            __('Virtual Event', 'mec-virtual') => 'mec-virtual',
        );
        $tabs = array_merge($tabs, $virtualTab);
        return $tabs;
    }

    public function meta_box_virtual($post)
    {
        $mec_virtual_event = get_post_meta($post->ID, 'mec_virtual_event', true);
        $mec_virtual_badge_shortcode = get_post_meta($post->ID, 'mec_virtual_badge_shortcode', true);
        $mec_virtual_badge_single = get_post_meta($post->ID, 'mec_virtual_badge_single', true);
        $mec_virtual_book_history_in_single = 'yes' === get_post_meta($post->ID,'mec_virtual_display_user_booking_history',true);

        $virtual_link_url = get_post_meta($post->ID, 'mec_virtual_link_url', true);
        $virtual_link_title = get_post_meta($post->ID, 'mec_virtual_link_title', true);
        $virtual_link_target = get_post_meta($post->ID, 'mec_virtual_link_target', true);

        $virtual_embed = get_post_meta($post->ID, 'mec_virtual_embed', true);
        $mec_virtual_display_embed_in_booking = '1' === get_post_meta($post->ID, 'mec_virtual_display_embed_in_booking', true);

        $virtual_hide_info_before_start = get_post_meta($post->ID, 'mec_virtual_hide_info_before_start', true);
        $virtual_show_info_time = get_post_meta($post->ID, 'mec_virtual_show_info_time', true);
        $virtual_show_info_hm = get_post_meta($post->ID, 'mec_virtual_show_info_hm', true);

        $mec_virtual_hide_info = get_post_meta($post->ID, 'mec_virtual_hide_info', true);

        $mec_virtual_password = get_post_meta($post->ID, 'mec_virtual_password', true);
        $mec_virtual_display_password_in_booking = '1' === get_post_meta($post->ID, 'mec_virtual_display_password_in_booking', true);

        $mec_virtual_display_link_in_booking = '1' === get_post_meta($post->ID, 'mec_virtual_display_link_in_booking', true);

        ?>
        <div class="mec-meta-box-fields mec-event-tab-content" id="mec-virtual">
            <h4><?php echo __('Virtual Event', 'mec-virtual'); ?></h4>
            <div class="mec-form-row">
                <input
                    <?php
                    if (isset($mec_virtual_event) and $mec_virtual_event == true) {
                        echo 'checked="checked"';
                    }
                    ?>
                        type="checkbox" name="mec[mec_virtual_event]" onchange="jQuery('#mec_fes_virtual_event_wrap').toggle();" id="mec_virtual_event" value="1"/><label
                        for="mec_virtual_event"><input id="mec_virtual_event_hidden" type="hidden" value="" /><?php _e('Enable Virtual Event', 'mec-virtual'); ?></label>
            </div>
            <div class="mec-virtual-event-wrap <?php if((isset($mec_virtual_event) and !$mec_virtual_event) or !isset($mec_virtual_event)) echo 'mec-util-hidden'; ?>" id="mec_fes_virtual_event_wrap">
                <div class="mec-form-row">
                    <input
                        <?php
                        if (isset($mec_virtual_badge_shortcode) and $mec_virtual_badge_shortcode == true) {
                            echo 'checked="checked"';
                        }
                        ?>
                            type="checkbox" name="mec[mec_virtual_badge_shortcode]" id="mec_virtual_badge_shortcode" value="1"/><label
                            for="mec_virtual_badge_shortcode"><?php _e('Display virtual badge in shortcode', 'mec-virtual'); ?></label>
                </div>
                <div class="mec-form-row">
                    <input
                        <?php
                        if (isset($mec_virtual_badge_single) and $mec_virtual_badge_single == true) {
                            echo 'checked="checked"';
                        }
                        ?>
                            type="checkbox" name="mec[mec_virtual_badge_single]" id="mec_virtual_badge_single" value="1"/><label
                            for="mec_virtual_badge_single"><?php _e('Display virtual badge in single event', 'mec-virtual'); ?></label>
                </div>
                <div class="mec-form-row">
                    <input <?php checked(true,$mec_virtual_book_history_in_single) ?> type="checkbox" name="mec[mec_virtual_display_user_booking_history]" id="mec_virtual_display_user_booking_history" value="yes"/><label for="mec_virtual_display_user_booking_history"><?php _e('Display booking history in Single Event page', 'mec-virtual'); ?></label>
                </div>
                <div class="mec-form-row">
                    <label class="mec-col-1" for="mec_virtual_link_url"><?php esc_html_e('Link' , 'mec-virtual'); ?></label>
                    <input class="mec-col-4" type="text" name="mec[mec_virtual_link_url]" id="mec_virtual_link_url" value="<?php echo esc_attr($virtual_link_url); ?>" placeholder="eg. https://youtube.com">
                    <input class="mec-col-2" type="text" name="mec[mec_virtual_link_title]" id="mec_virtual_link_title" value="<?php echo esc_attr($virtual_link_title); ?>" placeholder="Title">
                    <select class="mec-col-2" name="mec[mec_virtual_link_target]" id="mec_virtual_link_target">
                        <option value="_self" <?php echo($virtual_link_target == '_self' ? 'selected="selected"' : ''); ?>><?php _e('Current Window', 'mec-virtual'); ?></option>
                        <option value="_blank" <?php echo($virtual_link_target == '_blank' ? 'selected="selected"' : ''); ?>><?php _e('New Window', 'mec-virtual'); ?></option>
                    </select>
                    <label class="mec-col-3 label-checkbox" for="mec_virtual_display_link_in_booking"><input
                        <?php
                        if (isset($mec_virtual_display_link_in_booking) and $mec_virtual_display_link_in_booking == true) {
                            echo 'checked="checked"';
                        }
                        ?>
                            type="checkbox"  name="mec[mec_virtual_display_link_in_booking]" id="mec_virtual_display_link_in_booking" value="1"/><?php esc_html_e('Display when booking is complete' , 'mec-virtual'); ?></label>
                </div>
                <div class="mec-form-row">
                    <label class="mec-col-1" for="mec_virtual_password"><?php esc_html_e('Password' , 'mec-virtual'); ?></label>
                    <input class="mec-col-6" type="text" name="mec[mec_virtual_password]" id="mec_virtual_password" value="<?php echo esc_attr($mec_virtual_password); ?>"/>
                    <label class="mec-col-5 label-checkbox" for="mec_virtual_display_password_in_booking"><input
                        <?php
                        if (isset($mec_virtual_display_password_in_booking) and $mec_virtual_display_password_in_booking == true) {
                            echo 'checked="checked"';
                        }
                        ?>
                            type="checkbox"  name="mec[mec_virtual_display_password_in_booking]" id="mec_virtual_display_password_in_booking" value="1"/><?php esc_html_e('Display when booking is complete' , 'mec-virtual'); ?></label>
                </div>
                <div class="mec-form-row">
                    <label class="mec-col-1" for="mec_virtual_embed"><?php esc_html_e('Embed' , 'mec-virtual'); ?></label>
                    <textarea class="mec-col-6" type="text" name="mec[mec_virtual_embed]" id="mec_virtual_embed" ><?php echo esc_attr($virtual_embed); ?></textarea>
                    <label class="mec-col-5 label-checkbox" for="mec_virtual_display_embed_in_booking"><input
                        <?php
                        if (isset($mec_virtual_display_embed_in_booking) and $mec_virtual_display_embed_in_booking == true) {
                            echo 'checked="checked"';
                        }
                        ?>
                            type="checkbox"  name="mec[mec_virtual_display_embed_in_booking]" id="mec_virtual_display_embed_in_booking" value="1"/><?php esc_html_e('Display when booking is complete' , 'mec-virtual'); ?></label>
                </div>
                <div class="mec-form-row">

                    <label class="mec-col-3 label-checkbox" for="mec_virtual_hide_info_before_start"><input
                        <?php
                        if (isset($virtual_hide_info_before_start) and $virtual_hide_info_before_start == true) {
                            echo 'checked="checked"';
                        }
                        ?>
                            type="checkbox"  name="mec[mec_virtual_hide_info_before_start]" id="mec_virtual_hide_info_before_start" value="1"/><?php esc_html_e('Display above information until' , 'mec-virtual'); ?></label>
                    <input class="mec-col-1" type="number" name="mec[mec_virtual_show_info_time]" value="<?php echo((isset($virtual_show_info_time) and trim($virtual_show_info_time)) ? esc_attr($virtual_show_info_time) : '0'); ?>" placeholder="<?php _e('e.g. 0', 'mec-virtual'); ?>">
                    <select class="mec-col-1" name="mec[mec_virtual_show_info_hm]" id="mec_virtual_show_info_hm">
                        <option value="day" <?php echo($virtual_show_info_hm == 'day' ? 'selected="selected"' : ''); ?>><?php _e('Day', 'mec-virtual'); ?></option>
                        <option value="hour" <?php echo($virtual_show_info_hm == 'hour' ? 'selected="selected"' : ''); ?>><?php _e('Hour', 'mec-virtual'); ?></option>
                        <option value="minute" <?php echo($virtual_show_info_hm == 'minute' ? 'selected="selected"' : ''); ?>><?php _e('Minute', 'mec-virtual'); ?></option>
                    </select>
                    <label class="mec-col-2" for="mec_virtual_show_info_time"><?php esc_html_e('before event start.' , 'mec-virtual'); ?></label>
                </div>
                <div class="mec-form-row">
                    <input
                        <?php
                        if (isset($mec_virtual_hide_info) and $mec_virtual_hide_info == true) {
                            echo 'checked="checked"';
                        }
                        ?>
                            type="checkbox" name="mec[mec_virtual_hide_info]" id="mec_virtual_hide_info" value="1"/><label
                            for="mec_virtual_hide_info" class="label-checkbox"><?php _e('Hide above information when event is live', 'mec-virtual'); ?></label>
                </div>
            </div>
        </div>

        <?php
    }

    public function save_event($post_id)
    {
        // Check if our nonce is set.
        if(!isset($_POST['mec_event_nonce'])) return false;

        // Verify that the nonce is valid.
        if(!wp_verify_nonce(sanitize_text_field($_POST['mec_event_nonce']), 'mec_event_data')) return false;

        // If this is an autosave, our form has not been submitted, so we don't want to do anything.
        if(defined('DOING_AUTOSAVE') and DOING_AUTOSAVE) return false;

        // Get Modern Events Calendar Data
        $_mec = isset($_POST['mec']) ? $_POST['mec'] : array();

        $mec_virtual_event = (isset($_mec['mec_virtual_event']) and !empty($_mec['mec_virtual_event'])) ? true : false;
        update_post_meta($post_id, 'mec_virtual_event', $mec_virtual_event);

        $mec_virtual_badge_shortcode = (isset($_mec['mec_virtual_badge_shortcode']) and !empty($_mec['mec_virtual_badge_shortcode'])) ? true : false;
        update_post_meta($post_id, 'mec_virtual_badge_shortcode', $mec_virtual_badge_shortcode);

        $mec_virtual_badge_single = (isset($_mec['mec_virtual_badge_single']) and !empty($_mec['mec_virtual_badge_single'])) ? true : false;
        update_post_meta($post_id, 'mec_virtual_badge_single', $mec_virtual_badge_single);

        $mec_virtual_display_user_booking_history = (isset($_mec['mec_virtual_display_user_booking_history']) and !empty($_mec['mec_virtual_display_user_booking_history'])) ? 'yes' : 'no';
        update_post_meta($post_id, 'mec_virtual_display_user_booking_history', $mec_virtual_display_user_booking_history);

        $mec_virtual_link_url = (isset($_mec['mec_virtual_link_url']) and !empty($_mec['mec_virtual_link_url'])) ? $_mec['mec_virtual_link_url'] : '';
        update_post_meta($post_id, 'mec_virtual_link_url', $mec_virtual_link_url);

        $mec_virtual_link_title = (isset($_mec['mec_virtual_link_title']) and !empty($_mec['mec_virtual_link_title'])) ? $_mec['mec_virtual_link_title'] : '';
        update_post_meta($post_id, 'mec_virtual_link_title', $mec_virtual_link_title);

        $mec_virtual_link_target = (isset($_mec['mec_virtual_link_target']) and !empty($_mec['mec_virtual_link_target'])) ? $_mec['mec_virtual_link_target'] : '';
        update_post_meta($post_id, 'mec_virtual_link_target', $mec_virtual_link_target);

        $mec_virtual_embed = (isset($_mec['mec_virtual_embed']) and !empty($_mec['mec_virtual_embed'])) ? $_mec['mec_virtual_embed'] : '';
        update_post_meta($post_id, 'mec_virtual_embed', $mec_virtual_embed);

        $mec_virtual_display_embed_in_booking = (isset($_mec['mec_virtual_display_embed_in_booking']) and !empty($_mec['mec_virtual_display_embed_in_booking'])) ? true : false;
        update_post_meta($post_id, 'mec_virtual_display_embed_in_booking', $mec_virtual_display_embed_in_booking);

        $mec_virtual_show_info_time = (isset($_mec['mec_virtual_show_info_time']) and !empty($_mec['mec_virtual_show_info_time'])) ? $_mec['mec_virtual_show_info_time'] : '';
        update_post_meta($post_id, 'mec_virtual_show_info_time', $mec_virtual_show_info_time);

        $mec_virtual_show_info_hm = (isset($_mec['mec_virtual_show_info_hm']) and !empty($_mec['mec_virtual_show_info_hm'])) ? $_mec['mec_virtual_show_info_hm'] : '';
        update_post_meta($post_id, 'mec_virtual_show_info_hm', $mec_virtual_show_info_hm);

        $mec_virtual_hide_info = (isset($_mec['mec_virtual_hide_info']) and !empty($_mec['mec_virtual_hide_info'])) ? true : false;
        update_post_meta($post_id, 'mec_virtual_hide_info', $mec_virtual_hide_info);

        $mec_virtual_hide_info_before_start = (isset($_mec['mec_virtual_hide_info_before_start']) and !empty($_mec['mec_virtual_hide_info_before_start'])) ? true : false;
        update_post_meta($post_id, 'mec_virtual_hide_info_before_start', $mec_virtual_hide_info_before_start);

        $mec_virtual_password = (isset($_mec['mec_virtual_password']) and !empty($_mec['mec_virtual_password'])) ? $_mec['mec_virtual_password'] : '';
        update_post_meta($post_id, 'mec_virtual_password', $mec_virtual_password);

        $mec_virtual_display_password_in_booking = (isset($_mec['mec_virtual_display_password_in_booking']) and !empty($_mec['mec_virtual_display_password_in_booking'])) ? true : false;
        update_post_meta($post_id, 'mec_virtual_display_password_in_booking', $mec_virtual_display_password_in_booking);

        $mec_virtual_display_link_in_booking = (isset($_mec['mec_virtual_display_link_in_booking']) and !empty($_mec['mec_virtual_display_link_in_booking'])) ? true : false;
        update_post_meta($post_id, 'mec_virtual_display_link_in_booking', $mec_virtual_display_link_in_booking);

        return true;
    }

    /**
     * @deprecated 1.1.1
     *
     * @param object $event
     * @return void
     */
    public static function display_in_single_page($event) {

        SinglePageAddon::getInstance()->display_in_single_page($event);

    }

    public static function display_badge_in_single( $event_data ) {
        $main = new \MEC_main();
        $event_id = $event_data->ID;
        $timestamp = $event_data->time['start_timestamp'];
        $timestamp = $main->get_start_time_of_multiple_days($event_id, $timestamp);
        $settings = $main->get_settings();

        $ex = explode(':', $timestamp);
        $timestamp = (int) $ex[0];

        $year = date('Y', $timestamp);
        $month = date('m', $timestamp);
        $day = date('d', $timestamp);
        $hour = date('H', $timestamp);
        $minutes = date('i', $timestamp);
        $event_date = date('Y-m-d h:i a', $timestamp);

        $virtual_hide_info_before_start = get_post_meta($event_id, 'mec_virtual_hide_info_before_start', true);
        $virtual_show_info_time = get_post_meta($event_id, 'mec_virtual_show_info_time', true);
        $virtual_show_info_hm = get_post_meta($event_id, 'mec_virtual_show_info_hm', true);
        $mec_virtual_hide_info = get_post_meta($event_id, 'mec_virtual_hide_info', true);

        $enable_single_badge = get_post_meta($event_id, 'mec_virtual_badge_single', true);
        $enable_virtual_event = get_post_meta($event_id, 'mec_virtual_event', true);

        $single = new \MEC_skin_single();
        $display_badge = false;
        if($single->found_value('virtual_events_module', $settings) == 'on'){
            $display_badge = true;
        }

        if (!empty($enable_virtual_event) && ( !empty($enable_single_badge) && isset($enable_single_badge) && $display_badge )) {
            $content = '
                <div class="mec-single-virtual-badge">
                    <i class="mec-sl-camrecorder"></i><h3>'.esc_html__('Virtual Event' , 'mec-virtual').'</h3>
                </div>
            ';
        } else {
            $content = '';
        }

        if ( $virtual_hide_info_before_start and $virtual_show_info_time > 0  and $main->check_date_time_validation('Y-m-d h:i a', strtolower($event_date)) and strtotime("-{$virtual_show_info_time}{$virtual_show_info_hm}", strtotime($event_date)) > current_time('timestamp', 0) and !$mec_virtual_hide_info ) {
            echo $content;
        } elseif (!$mec_virtual_hide_info and !$virtual_hide_info_before_start) {
            echo $content;
        }
    }

    /**
     * TODO: must be moved
     */
    public function display_badge_in_shortcode( $event_id ) {
        $virtual_event = get_post_meta($event_id, 'mec_virtual_event', true);
        $get_meta = get_post_meta($event_id, 'mec_virtual_badge_shortcode', true);

        if ($virtual_event && $get_meta) {
        ?>
            <span class="mec-shortcode-virtual-badge">
                <i class="mec-sl-camrecorder"></i><span><?php echo esc_html__('Virtual Event' , 'mec-virtual')?></span>
            </span>
        <?php
        }
    }

    /**
     * TODO: must be moved
     */
    public function display_badge_in_monthly($events_str,$event_id)
    {

        $get_meta = get_post_meta($event_id, 'mec_virtual_badge_shortcode', true);
        $new_events_str = '';
        if ($get_meta) {
            $new_events_str =
            '
            <span class="mec-shortcode-virtual-badge">
                <i class="mec-sl-camrecorder"></i><span>'.esc_html__('Virtual Event' , 'mec-virtual').'</span>
            </span>
            ';

            $events_str = $new_events_str;
        }

        return $events_str;
    }

    /**
     * TODO: must be moved
     */
    public function display_password_in_booking($content, $event_id,$book_id) {
        $virtual_link_url = get_post_meta($event_id, 'mec_virtual_link_url', true);
        $virtual_link_title = get_post_meta($event_id, 'mec_virtual_link_title', true);
        $virtual_link_target = get_post_meta($event_id, 'mec_virtual_link_target', true);
        $mec_virtual_display_link_in_booking = get_post_meta($event_id, 'mec_virtual_display_link_in_booking', true);

        $virtual_link = ($virtual_link_title and $mec_virtual_display_link_in_booking == '1')  ? '<div class="mec-event-virtual-link-wrap"><strong>'.esc_html('Virtual Event Link:' ,'mec-virtual').'</strong> <a class="mec-virtual-link-in-booking" href="'.$virtual_link_url.'" target="'.$virtual_link_target.'">'.$virtual_link_title.'</a></div>' : '' ;

        $virtual_display_password_in_booking = get_post_meta($event_id, 'mec_virtual_display_password_in_booking', true);
        $virtual_password = (get_post_meta($event_id, 'mec_virtual_password', true) and $virtual_display_password_in_booking == '1') ? '<div class="mec-virtual-password-in-booking"><strong>'.esc_html__('Virtual Event Password:' ,'mec-virtual') . '</strong> <span>' .get_post_meta($event_id, 'mec_virtual_password', true) . '</span></div>' : '';
        $mec_confirmed = get_post_meta($book_id, 'mec_confirmed', true);

        //( $user_has_book ||
        $mec_virtual_display_embed_in_booking = get_post_meta($event_id, 'mec_virtual_display_embed_in_booking', true);
        $virtual_embed =  $mec_virtual_display_embed_in_booking == '1' && get_post_meta($event_id, 'mec_virtual_embed', true) ? '<div class="mec-virtual-embed-in-booking">'.get_post_meta($event_id, 'mec_virtual_embed', true).'</div>' : '';

        if ( !$mec_confirmed ) return;
        $content .= $virtual_embed . $virtual_link . $virtual_password;

        return $content;
    }

    public function display_notification_field() {
        ?>
        <li><span>%%virtual_link%%</span>: <?php _e('Virtual link', 'mec-virtual'); ?></li>
        <li><span>%%virtual_password%%</span>: <?php _e('Virtual password', 'mec-virtual'); ?></li>
        <li><span>%%virtual_embed%%</span>: <?php _e('Virtual embed', 'mec-virtual'); ?></li>
        <?php
    }

    public static function render_email_notification( $message, $book_id, $attendee, $timestamps ) {

        $event_id = get_post_meta( $book_id,'mec_event_id', true );
        if( !$event_id ){

            return $message;
        }

        $ex = explode( ':', $timestamps );
        $timestamp = $ex[0];

        $info = SinglePageAddon::getInstance()->get_event_access_info( $event_id, $timestamp );

        //link_title
        $message = str_replace('%%virtual_link%%', $info['link_url'], $message);
        $message = str_replace('%%virtual_password%%', $info['password'], $message);
        $message = str_replace('%%virtual_embed%%', $info['embed'], $message);

        return $message;
    }

    public static function add_header_event_detail_to_dashboard() {

        echo '<td>'.__( 'Virtual', 'mec-virtual').'</td>';
    }

    public static function add_event_detail_to_dashboard( $event_id, $book_id, $event ) {

        if( !$event_id || !$book_id ){

            echo '<td>-</td>';
            return;
        }

        $timestamp = get_post_meta( $book_id, 'mec_attention_time_start', true );

        $info = SinglePageAddon::getInstance()->get_event_access_info( $event_id, $timestamp );
        $info['booked'] = $book_id ? true : false;

        $html = SinglePageAddon::getInstance()->display_event_access_html($info);
        ?>
        <td>
            <?php if( !empty( $html ) ): ?>
                <a class="mec-booking-access-info-link mec-booking-number-of-attendees"  href="#mec_profile_booking_access_info_<?php echo $book_id; ?>">
                    <?php echo __('<i class="mec-sl-eye"></i>', 'mec-virtual'); ?>
                </a>
                <div id="mec_profile_booking_access_info_<?php echo $book_id; ?>" class="mec-booking-access-info-content mec-booking-attendees lity-hide">
                    <?php echo $html; ?>
                </div>
            <?php else: ?>
                -
            <?php endif; ?>
        </td>
        <?php
    }

    /**
     * Register Autoload Files
     *
     * @since     1.0.0
     */
    public function init()
    {
        if (!class_exists('\MEC_Virtual_Events\Autoloader')) {
            return;
        }
    }
} //MecCTP
