<?php
// don't load directly.

use MEC_Virtual_Events\Single\SinglePageAddon;

if (!defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}

/**
 * MecCTP.
 *
 * @author      author
 * @package     package
 * @since       1.0.0
 */
class MecAddWidget extends \WP_Widget
{

    /**
     * Instance of this class.
     *
     * @since   1.0.0
     * @access  public
     * @var     MEC_Virtual_Events
     */
    public static $instance;

    /**
     * The directory of the file.
     *
     * @access  public
     * @var     string
     */
    public static $dir;

    /**
     * The Args
     *
     * @access  public
     * @var     array
     */
    public static $args;

    /**
     * Provides access to a single instance of a module using the singleton pattern.
     *
     * @since   1.0.0
     * @return  object
     */
    public static function instance()
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }


    public function __construct()
    {
        self::init();
        parent::__construct('MecAddWidget', __('MEC Virtual Event', 'mec-virtual'), array('description'=>__('Show events based on created shortcodes.', 'mec-virtual')));

    }



    /**
     * How to display the widget on the screen.
     * @param array $args
     * @param array $instance
     * @author Webnus <info@webnus.biz>
     * @return void
     */
    public function widget($args, $instance)
    {
        $current_post = get_queried_object();
        $post_id = $current_post ? $current_post->ID : null;
        $single_page_addon = SinglePageAddon::getInstance();
        if(!$single_page_addon->is_virtual_event($post_id)){

            return;
        }
        $main = new \MEC_Main();
        $single = new \MEC_skin_single();
        $event = current(
            $single->get_event_mec($post_id)
        );
        $event_id = $event->data->ID;
        $timestamp = $event->data->time['start_timestamp'];
        $timestamp = $main->get_start_time_of_multiple_days($event_id, $timestamp);

        $ex = explode(':', $timestamp);
        $timestamp = (int) $ex[0];


        $date_format = get_option('date_format');
        $books_times = $single_page_addon->get_user_books_times_for_event($event_id);

        $inside_html = '';
        $html = '';
        if($books_times){

            arsort($books_times);
            $books_times = array_unique($books_times);
            $global_info = $single_page_addon->get_global_access_info_for_event($event_id);
            $html = '';
            $inside_html = '';
            foreach($books_times as $book_id => $b_timestamp){

                $can_display = $single_page_addon->can_display_access_info($event,$main,$b_timestamp);

                if(!$can_display){
                    continue;
                }

                $class = $timestamp === $b_timestamp ? 'mec-box-marker' : '';

                $custom_event_access = $single_page_addon->get_custom_event_access($event_id,$b_timestamp);
                if($custom_event_access){
                    $info = $custom_event_access;
                }else{
                    $info = $global_info;
                }
                $info['booked'] = true;
                unset($info['embed']);

                $html_event_access = $this->display_event_access_html($info);
                if(!empty($html_event_access)){

                    $inside_html .= $main->date_i18n($date_format,$b_timestamp);

                    $inside_html .= $html_event_access;
                }
            }

            if(!empty($inside_html)){

                $html .= $inside_html;
            }

        }

        // Before Widget
        echo '<div class="mec-event-virtual-info mec-frontbox">';
        echo (isset($args['before_widget']) ? $args['before_widget'] : '');
        // Print the widget title
        if(!empty($instance['title']))
        {
            echo '<h3 class="mec-virtual-info-single mec-frontbox-title">';
            echo $instance['title'];
            echo '</h3>';
        }

        if ( is_user_logged_in() ) {

            if ( !empty($inside_html) ) {
                $content = $html;
            } else {
                $content = '<center><strong>' . esc_html__('Please first book this event.') . '</strong></center>';
            }

            if (!empty($content)) {
                echo $content;
            } else {
                echo '<center><strong>' . esc_html__('Find event login credentials on the event details.') . '</strong></center>';
            }

        } else {
            echo '<center><strong>' . esc_html__('Please first login to website.') . '</strong></center>';
        }
        // After Widget
        echo (isset($args['after_widget']) ? $args['after_widget'] : '');
        echo '</div>';


    }

    /**
     * @param array $access_info link_title,link_url,link_target,display_link_in_booking,password,password,display_password_in_booking,booked
     * @param string $class
     * @since 1.1.1
     * @return string
     */
    public function display_event_access_html($access_info,$class = ''){

        $is_booked = isset($access_info['booked']) ? $access_info['booked'] : false;
        //generate html start
        $link_html = $password_html = '';

        $display_link_in_booking = isset($access_info['display_link_in_booking']) ? $access_info['display_link_in_booking'] != '1' : false;
        if($access_info['link_title'] && ($display_link_in_booking || $is_booked)){

            $link_html = '<div class="mec-event-virtual-link-wrap">'
                            .'<strong>'.esc_html__('Virtual Event Link:' ,'mec-virtual').'</strong>'
                            .' <a class="mec-virtual-link-in-booking" href="'.$access_info['link_url'].'" target="'.$access_info['link_target'].'">'.$access_info['link_title'].'</a>'
                        .'</div>';
        }

        $display_password_in_booking = isset($access_info['display_password_in_booking']) ? $access_info['display_password_in_booking'] != '1' : false;
        if($access_info['password'] && ($display_password_in_booking || $is_booked)){

            $password_html = '<div class="mec-virtual-password-in-booking">'
                                .'<strong>'.esc_html__('Virtual Event Password:' ,'mec-virtual') . '</strong>'
                                .' <span>' .$access_info['password'] . '</span>'
                            .'</div>';
        }

        $display_embed_in_booking = isset($access_info['display_embed_in_booking']) ? $access_info['display_embed_in_booking'] != '1' : false;
        if($access_info['embed'] && ($display_embed_in_booking || $is_booked)){

            $embed_html = '<div class="mec-virtual-embed-in-booking">'
                                .'<strong>'.esc_html__('Virtual Event Password:' ,'mec-virtual') . '</strong>'
                                .' <span>' .$access_info['embed'] . '</span>'
                            .'</div>';
        }
        //generate html end

        if( !empty($link_html) or !empty($password_html) or !empty($embed_html)){

            return $embed_html.$link_html.$password_html;
        }

        return '';
    }

    /**
     * Displays the widget settings controls on the widget panel.
     * @param array $instance
     * @author Webnus <info@webnus.biz>
     * @return void
     */
    public function form($instance)
    {
        echo '<p class="mec-widget-row-container">'
        .'<label for="'.$this->get_field_id('title').'">'.__('Title:', 'mec-virtual').'</label>'
        .'<input class="widefat" type="text" id="'.$this->get_field_id('title').'" name="'.$this->get_field_name('title').'" value="'.(isset($instance['title']) ? $instance['title'] : '').'" />'
        .'</p>';
    }

    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        return $instance;
    }


    /**
     * Register Autoload Files
     *
     * @since     1.0.0
     */
    public function init()
    {
        if (!class_exists('\MEC_Virtual_Events\Autoloader')) {
            return;
        }
    }
} //MecCTP
