<?php

namespace MEC_Virtual_Events\Core;
// don't load directly.
if (!defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}
/**
 * Loader.
 *
 * @author      author
 * @package     package
 * @since       1.0.0
 */
class Loader
{

    /**
     * Instance of this class.
     *
     * @since   1.0.0
     * @access  public
     * @var     MEC_Invoice
     */
    public static $instance;

    /**
     * The directory of the file.
     *
     * @access  public
     * @var     string
     */
    public static $dir;

    /**
     * Provides access to a single instance of a module using the singleton pattern.
     *
     * @since   1.0.0
     * @return  object
     */
    public static function instance()
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }


    public function __construct()
    {
        self::settingUp();
        self::preLoad();
        self::setHooks();
        self::registerAutoloadFiles();
        self::loadInits();

        
    }

    /**
     * Global Variables.
     *
     * @since   1.0.0
     */
    public static function settingUp()
    {
        self::$dir     = MECVIRTUALDIR . 'core';
    }

    /**
     * Hooks
     *
     * @since     1.0.0
     */
    public static function setHooks()
    { 
        add_action('admin_init', function () {
            if (!defined('MECVIRTUAL_API_URL')) return; 
            \MEC_Virtual_Events\Autoloader::load('MEC_Virtual_Events\Core\checkLicense\VirtualEventAddonUpdateActivation');
        });

        

    }

    

    /**
     * preLoad
     *
     * @since     1.0.0
     */
    public static function preLoad()
    {
        include_once self::$dir . DS . 'autoloader' . DS . 'autoloader.php';
    }

    /**
     * Register Autoload Files
     *
     * @since     1.0.0
     */
    public static function registerAutoloadFiles()
    {
        if (!class_exists('\MEC_Virtual_Events\Autoloader')) {
            return;
        }

        \MEC_Virtual_Events\Autoloader::addClasses(
            [
                'MEC_Virtual_Events\\Core\\addEventOptions\\MecAddEventOptions' => self::$dir . '/addEventOptions/add-event-options.php',
                //'MEC_Virtual_Events\\Core\\addWidget\\MecAddWidget' => self::$dir . '/addWidget/add-widget.php',

                // License
                'MEC_Virtual_Events\\Core\\checkLicense\\VirtualEventAddonUpdateActivation' => self::$dir . '/checkLicense/update-activation.php',
            ]
        );
    }

    /**
     * Load Init
     *
     * @since     1.0.0
     */
    public static function loadInits()
    {
        \MEC_Virtual_Events\Autoloader::load('MEC_Virtual_Events\Core\addEventOptions\MecAddEventOptions');
        //\MEC_Virtual_Events\Autoloader::load('MEC_Virtual_Events\Core\addWidget\MecAddWidget');

        
        
    }
} //Loader

Loader::instance();
