<?php

namespace MEC_Virtual_Events\Admin;

class Admin{

    private static $instance;

    /**
     * Get Instance
     *
     * @return self $instance
     */
    public static function getInstance(){

        if(is_null(static::$instance)){

            static::$instance = new static();
        }

        return static::$instance;
    }

    public function init(){

        add_action('add_meta_boxes',[__CLASS__,'meta_boxes']);
        add_action('save_post',[__CLASS__,'save_post_page']);
        OccurrencesFields::instance()->init();
    }

    public static function meta_boxes(){
        $post_type = get_post_type();

        if(!$post_type && isset($_GET['post_type']) ){
            $post_type = $_GET['post_type'];
        }

        if(in_array($post_type,array('post','page') ) ){

            add_meta_box(
                'mec-restrict',
                __('Restrict display to specific events','mec-virtual'),
                [__CLASS__,'restrict_metabox_callback'],
                null,
                'side',
            );
        }
    }

    public static function restrict_metabox_callback($post){

        $args = array(
            'post_type' => 'mec-events',
            'limit' => -1,
            // 'post_status' => 'all',
        );

        $events = get_posts($args);

        wp_nonce_field('mec_restrict_nf','mec_restrict_nonce');

        echo '<label>'.__('Events','mec-virtual').'</label><br/>';
        echo '<script>
            jQuery(document).ready(function($){
                jQuery(".mec-select2-events").select2({width: "100%"});
            });
        </script>';

        $event_ids = get_post_meta( $post->ID ,'mec_restrict_for_events', true );
        $event_ids = is_array( $event_ids ) ? $event_ids : array();
        echo '<select name="mec-restrict-for-events[]" class="mec-select2-events" multiple="multiple" >';
        foreach($events as $event){

            $selected = in_array($event->ID,$event_ids,false);
            echo '<option value="'.$event->ID.'" '.selected(true,$selected,false).'>'.$event->post_title.'</option>';
        }
        echo '</select>';

    }

    public static function save_post_page($post_id){

        if(!isset($_POST['mec_restrict_nonce'])) return;

        $nonce = sanitize_text_field($_POST['mec_restrict_nonce']);
        if(!wp_verify_nonce($nonce, 'mec_restrict_nf')) return;


        $post_type = get_post_type($post_id);
        if(!in_array($post_type,array('post','page'))){
            return;
        }

        $event_ids = isset($_POST['mec-restrict-for-events']) && is_array($_POST['mec-restrict-for-events']) ? $_POST['mec-restrict-for-events'] : array();
        update_post_meta( $post_id ,'mec_restrict_for_events', $event_ids );
    }

}