<?php 

namespace MEC_Virtual_Events\Admin;

class OccurrencesFields{

    private static $instance;

    public static function instance(){

        if(is_null(static::$instance)){
            static::$instance = new static();
        }

        return static::$instance;
    }

    public function init(){

        add_action('mec_occurrences_fields',[__CLASS__,'add_fields'],10,3);
        add_action('mec_occurrences_save',[__CLASS__,'save'],10,2);
    }

    public static function add_fields($occurrence_id, $event_id, $occurrence_data){

        $group_id = 'virtual';
        $group_title = __('Virtual','mec-virtual');
        $label = sprintf(__('Custom %s Event Detail','mec-virtual'),$group_title);
        ?>
        <script>
            jQuery(document).ready(function($){
                function mec_enable_or_disable_custom_access(e){
                    var el;
                    if(typeof e.currentTarget !== 'undefined'){

                        el = e.currentTarget;
                    }else{

                        el = e;
                    }
                    var checked = $(el).is(':checked');
                    if(checked){

                        $('.mec-event-custom-access-box-<?php echo $group_id; ?>').removeClass('mec-util-hidden');
                    }else{

                        $('.mec-event-custom-access-box-<?php echo $group_id; ?>').addClass('mec-util-hidden');
                    }
                }

                $.each($('#mec_<?php echo $group_id; ?>_event'),function(i,v){
                    mec_enable_or_disable_custom_access(v);
                });
                $('#mec_<?php echo $group_id; ?>_event').on('change',mec_enable_or_disable_custom_access);
            });
        </script>
        <?php     
            $data = get_post_meta($event_id,'_mec_'.$group_id.'_event_access',true);
    
            $occurrence_key = $occurrence_data['occurrence'];
            $data = $data[$occurrence_key] ? $data[$occurrence_key] : array();
            $custom_access_checked = isset($data['custom_event_access']) ? 'yes' === $data['custom_event_access'] : false;
            $link_title = $data['link_title'] ? $data['link_title'] : '';
            $link_url = $data['link_url'] ? $data['link_url'] : '';
            $link_target = $data['link_target'] ? $data['link_target'] : '';
            $display_link_in_booking = isset($data['display_link_in_booking']) ? 'yes' === $data['display_link_in_booking'] : false;
            $password = $data['password'] ? $data['password'] : '';
            $display_password_in_booking = isset($data['display_password_in_booking']) ? 'yes' === $data['display_password_in_booking'] : false;
        ?>
        <div class="mec-event-custom-access-box-<?php echo $group_id; ?>">
            <div class="mec-form-row">
                <label style="width:auto"><input onchange="jQuery('#mec_<?php echo $group_id; ?>_event_custom_access_wrap').toggle();" type="checkbox" name="mec[occurrences][<?php echo $occurrence_id; ?>][<?php echo $group_id; ?>][custom_event_access]" <?php checked(true,$custom_access_checked) ?> value="yes"><?php echo $label; ?></label>
            </div>
            <input type="hidden" name="mec[occurrences][<?php echo $occurrence_id; ?>][<?php echo $group_id; ?>][occurrence]" value="<?php echo $occurrence_key; ?>" />
            <div id="mec_<?php echo $group_id; ?>_event_custom_access_wrap" class="<?php echo !$custom_access_checked ? 'mec-util-hidden': ''  ?>">
                <div class="mec-form-row">
                    <label class="mec-col-1" for="mec_<?php echo $group_id; ?>_link_url"><?php esc_html_e('Link' , 'mec-virtual'); ?></label>
                    <input class="mec-col-4" type="text" name="mec[occurrences][<?php echo $occurrence_id; ?>][<?php echo $group_id; ?>][link_url]" value="<?php echo esc_attr($link_url); ?>" placeholder="eg. https://youtube.com">
                    <input class="mec-col-2" type="text" name="mec[occurrences][<?php echo $occurrence_id; ?>][<?php echo $group_id; ?>][link_title]" value="<?php echo esc_attr($link_title); ?>" placeholder="<?php esc_attr_e('Title','mec-fl'); ?>">
                    <select class="mec-col-2" name="mec[occurrences][<?php echo $occurrence_id; ?>][<?php echo $group_id; ?>][link_target]" >
                        <option value="_self" <?php selected('_self',$link_target); ?> > <?php _e('Current Window', 'mec-virtual'); ?></option>
                        <option value="_blank" <?php selected('_blank',$link_target); ?> ><?php _e('New Window', 'mec-virtual'); ?></option>
                    </select>
                    <label class="" style="width:auto" for="<?php echo $group_id; ?>_display_link_in_booking"><input <?php checked(true,$display_link_in_booking) ?> type="checkbox"  name="mec[occurrences][<?php echo $occurrence_id; ?>][<?php echo $group_id; ?>][display_link_in_booking]" value="yes"/><?php esc_html_e('Display when booking is complete' , 'mec-virtual'); ?></label>
                </div>
                <div class="mec-form-row">
                    <label class="mec-col-1" for="<?php echo $group_id; ?>_password"><?php esc_html_e('Password' , 'mec-virtual'); ?></label>
                    <input class="mec-col-6" type="text" name="mec[occurrences][<?php echo $occurrence_id; ?>][<?php echo $group_id; ?>][password]" value="<?php echo esc_attr($password); ?>"/>
                    <label class="mec-col-5" style="width:auto" for="<?php echo $group_id; ?>_display_password_in_booking"><input <?php checked(true,$display_password_in_booking) ?> type="checkbox"  name="mec[occurrences][<?php echo $occurrence_id; ?>][<?php echo $group_id; ?>][display_password_in_booking]" value="yes"/><?php esc_html_e('Display when booking is complete' , 'mec-virtual'); ?></label>
                </div>
            </div>
        </div>
        <?php
    }

    public static function save($event_id, &$occurrences){

        $group_id = 'virtual';
        $data = array();
        foreach($occurrences as $id => $d){
            $is_enable = isset($d[$group_id]['custom_event_access']) ? 'yes' === $d[$group_id]['custom_event_access'] : false;
            if($is_enable){

                $occurrence_id = $d[$group_id]['occurrence'] ? $d[$group_id]['occurrence'] : $id;
                $data[$occurrence_id] = $d['virtual'] ? $d['virtual'] : array();
            }
        }
        
        update_post_meta($event_id,'_mec_'.$group_id.'_event_access',$data);
    }

}