<?php 

namespace MEC_Virtual_Events\Shortcodes;

use MEC_Virtual_Events\Core\Books\BooksQuery;

class RestrictedContent{

    private static $instance;

    /**
     * Get Instance
     *
     * @return self $instance
     */
    public static function getInstance(){
        
        if(is_null(static::$instance)){

            static::$instance = new static();
        }

        return static::$instance;
    }

    public function init(){

        add_shortcode('mec-restricted-content',[$this,'output'],10,2);
    }
    
    public function can_current_user_see_vip_content(){

        if(current_user_can('edit_posts') || current_user_can('edit_post',get_the_ID())){

            return true;
        }

        return false;
    }

    public function has_current_user_booked_the_event($event_id){

        if(!$event_id){

            return false;
        }

        $user_data = wp_get_current_user();
        $email = $user_data->user_email;
        if(!empty($email) || !$event_id){

            return false;
        }

        $q_args = array(
            'email' => $email,
            'event_id' => $event_id,
            'confirmed' => 1,
			'verified' => 1,
        );
        $books = BooksQuery::getInstance()->get_books($q_args);
        if(empty($books)){

            return false;
        }

        return true;
    }

    public function display_notice_vip_content($event_id = 0){

        $event_link = '';
        if(get_the_ID() !== $event_id){

            $title = get_the_title($event_id);
            $permalink = get_permalink($event_id);

            $event_link = ' "<a href="'.$permalink.'">'.$title.'</a>"';
        }
        return '<div class="mec-vip-content-notice">'.__('This section is only visible to those who have booked the event','mec-virtual') .' '.$event_link.'</div>';
    }

    public function output($atts,$content){

        $pairs = array(
            'event_id' => null,
        );

        $atts = shortcode_atts($pairs,$atts);
        $event_id = is_numeric($atts['event_id']) && $atts['event_id'] > 0 ? $atts['event_id'] : get_the_ID();

        if(!is_user_logged_in()){

            return $this->display_notice_vip_content($event_id);
        }
        
        if(!$this->can_current_user_see_vip_content()){

            if(!$this->has_current_user_booked_the_event($event_id)){

                return $this->display_notice_vip_content($event_id);
            };
        }
        
        return '<div class="mec-vip-content">'.$content.'</div>';
    }
}