<?php

function mec_admin_notifications_field_creator($notifications,$section){

    $group_id = $section;
    $box_id = 'mec_'.$group_id.'_send_custom_message_for_virtual_events_toggle';
    ?>
    <div class="mec-form-row">
        <?php 
           $checked = (isset($notifications[$group_id]['send_custom_message_for_virtual_events']) and $notifications[$group_id]['send_custom_message_for_virtual_events'] == 1) ? true : false;
        ?>
		<input onchange="jQuery('#<?php echo $box_id; ?>').toggle();" type="checkbox" name="mec[notifications][<?php echo $group_id; ?>][send_custom_message_for_virtual_events]" value="1" id="mec_notifications_<?php echo $group_id; ?>_custom_message_for_virtual_events" <?php checked(true,$checked) ?> />
		<label for="mec_notifications_<?php echo $group_id; ?>_custom_message_for_virtual_events"><?php _e('Custom message for virtual events', 'mec'); ?></label>
	</div>
    <div id="<?php echo $box_id; ?>" class="<?php echo !$checked ? 'mec-util-hidden': ''  ?>">
        <div class="mec-form-row">
            <label for="mec_notifications_<?php echo $group_id; ?>_virtual_content"><?php _e('Email virtual event Content', 'mec'); ?></label>
            <?php
                $content = isset($notifications[$group_id]['virtual_content']) ? stripslashes($notifications[$group_id]['virtual_content']) : '';
                wp_editor(
                    $content,
                    'mec_notifications_'.$group_id.'_virtual_content',
                     array(
                        'textarea_name'=>'mec[notifications]['.$group_id.'][virtual_content]'
                    )
                );
            ?>
        </div>
    </div>
    <?php
}

function mec_admin_notifications_field_creator_for_event($notifications,$section){

    $group_id = $section;
    ?>
    <div class="mec-form-row">
        <?php $checked = (isset($notifications[$group_id]['send_custom_message_for_virtual_events']) and $notifications[$group_id]['send_custom_message_for_virtual_events'] == 1) ? true : false; ?>
        <input onchange="jQuery('#mec_notification_<?php echo $group_id; ?>_virtual_container_toggle').toggle();" type="checkbox" name="mec[notifications][<?php echo $group_id; ?>][send_custom_message_for_virtual_events]" value="1" id="mec_notifications_<?php echo $group_id; ?>_custom_message_for_virtual_events" <?php checked(true,$checked) ?> />
        <label for="mec_notifications_<?php echo $group_id; ?>_virtual_custom_message_for_virtual_events"><?php _e('Custom message for virtual events', 'mec'); ?></label>
	</div>
    <?php
        $hidden_class = '';
        $hidden = (isset($notifications[$group_id]['send_custom_message_for_virtual_events']) and !$notifications[$group_id]['send_custom_message_for_virtual_events']) || !isset($notifications[$group_id]['send_custom_message_for_virtual_events']) ? true : false;
        if($hidden) {

            $hidden_class = 'mec-util-hidden';
        }
    ?>
    
    <div id="mec_notification_<?php echo $group_id; ?>_virtual_container_toggle" class="<?php echo $hidden_class ?>">

        <div class="mec-form-row">
            <label for="mec_notifications_<?php echo $group_id; ?>_virtual_subject"><?php _e('Email Subject', 'mec'); ?></label>
            <input type="text" name="mec[notifications][<?php echo $group_id; ?>][virtual_subject]" id="mec_notifications_<?php echo $group_id; ?>_virtual_subject" value="<?php echo (isset($notifications[$group_id]['virtual_subject']) ? stripslashes($notifications[$group_id]['virtual_subject']) : ''); ?>" />
        </div>

        <div class="mec-form-row">
            <div class="mec-col-2">
                <label for="mec_notifications_<?php echo $group_id; ?>_virtual_content"><?php _e('Email virtual event Content', 'mec'); ?></label>
            </div>

            <div class="mec-col-10">
                <?php
                    $content = isset($notifications[$group_id]['virtual_content']) ? stripslashes($notifications[$group_id]['virtual_content']) : '';
                    wp_editor(
                        $content,
                        'mec_notifications_'.$group_id.'_virtual_content',
                        array(
                            'textarea_name'=>'mec[notifications]['.$group_id.'][virtual_content]'
                        )
                    );
                ?>
            </div>
        </div>
    </div>
    <?php
}

function mec_add_virtual_type_to_settings_notifications_js_content_types($content_types){

    $content_types['virtual'] = "_virtual";

    return $content_types;
}

function mec_get_custom_args_for_virtual_event_notifications($text,$notification_type,$event_id){

    $is_virtual_event = get_post_meta($event_id, 'mec_virtual_event', true);
    if(!$is_virtual_event){

        return $text;
    }

    $mec_options = get_option('mec_options', array());

    $notification = $mec_options['notifications'][$notification_type] ? $mec_options['notifications'][$notification_type] : false;
    $global_text = '';
    if($notification){
        $is_enabled_virtual_notification_in_global = isset($notification['send_custom_message_for_virtual_events']) && $notification['send_custom_message_for_virtual_events'] ? true : false;
        if($is_enabled_virtual_notification_in_global){

            if('mec_notification_get_content' === current_filter()){
                
                $global_text = $notification['virtual_content'] ? $notification['virtual_content'] : null;
            }elseif('mec_notification_get_subject' === current_filter()){

                $global_text = $notification['subject'] ? $notification['subject'] : null;
            }            
        }
    }

    $custom_event_notification = false;
    if(isset($mec_options['settings']['notif_per_event']) && $mec_options['settings']['notif_per_event']){
        
        $notifications = get_post_meta($event_id,'mec_notifications',true);
        $notification = $notifications[$notification_type] ? $notifications[$notification_type] : false;
        if($notification){

            $custom_event_notification = isset($notification['status']) && '1' == $notification['status'];
            if($custom_event_notification){
                
                $is_enabled_virtual_notification_in_local = isset($notification['send_custom_message_for_virtual_events']) && $notification['send_custom_message_for_virtual_events'] ? true : false;
                if($is_enabled_virtual_notification_in_local){
    
                    if('mec_notification_get_content' === current_filter()){
                        
                        return $notification['virtual_content'] ? $notification['virtual_content'] : null;
                    }elseif('mec_notification_get_subject' === current_filter()){
        
                        return $notification['virtual_subject'] ? $notification['virtual_subject'] : null;
                    }
                }
            }
            

        }
    }

    return $custom_event_notification ? $text : $global_text;
}