<?php
/**
*	Plugin Name: MEC Virtual Events
*	Plugin URI: http://webnus.net/modern-events-calendar/
*	Description: This addon allows you to turn your events into virtual ones and provide an embeded link or directed link and password of your online event to your attendees.
*	Author: Webnus
*	Version: 1.2.2
*	Text Domain: mec-virtual
*	Domain Path: /languages
*	Author URI: http://webnus.net
**/
namespace MEC_Virtual_Events;

use MEC_Virtual_Events\Admin\Admin;
use MEC_Virtual_Events\Core\Books\BooksQuery;
use MEC_Virtual_Events\Single\SinglePageAddon;

// don't load directly.
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}
/**
 * Base.
 *
 * @author     author
 * @package     package
 * @since     1.0.0
 */
class Base {

	/**
	 * Instance of this class.
	 *
	 * @since   1.0.0
	 * @access  public
	 * @var     MEC_Virtual_Events
	 */
	public static $instance;

	/**
	 * Provides access to a single instance of a module using the singleton pattern.
	 *
	 * @since   1.0.0
	 * @return  object
	 */
	public static function instance() {
		if ( self::$instance === null ) {
			self::$instance = new self();
			self::init();
		}

		return self::$instance;
	}


	public function __construct() {
		self::settingUp();
		self::preLoad();
		self::setHooks($this);

		do_action( 'MEC_Virtual_Events_init' );
	}

	/**
	 * Global Variables.
	 *
	 * @since   1.0.0
	 */
	public static function settingUp() {
		define('MECVIRTUALVERSION' , '1.2.2');
		define('MECVIRTUALDIR' , plugin_dir_path(__FILE__));
		define('MECVIRTUALURL' , plugin_dir_url(__FILE__));
		define('MECVIRTUALDASSETS' , MECVIRTUALURL . 'assets/' );
		define('MECVIRTUALNAME' , 'Virtual Events');
		define('MECVIRTUALSLUG' , 'mec-virtual-events');
		define('MECVIRTUALOPTIONS' , 'mec_virtual_events_options');
		define('MECVIRTUALTEXTDOMAIN' , 'mec-virtual');
		define('MECVIRTUALMAINFILEPATH' ,__FILE__);
		define('MECVIRTUALABSPATH', dirname(__FILE__));
		define('MECVIRTUAL_API_URL', 'https://webnus.net/api/v3');

		if ( ! defined( 'DS' ) ) {
			define( 'DS', DIRECTORY_SEPARATOR );
		}
	}

	/**
	 * Set Hooks
	 *
	 * @since     1.0.0
	 */
	public static function setHooks($This) {
		require_once(MECVIRTUALDIR . '/core/addWidget/add-widget.php');
		add_action( 'widgets_init',array($This,'hstngr_register_widget') );
		add_action( 'plugins_loaded', [$This,'addon_load_text_domain'] );

	}

	public function hstngr_register_widget() {
		register_widget( 'MecAddWidget' );
	}

	/**
	 * Load plugin textdomain.
	 */
	public function addon_load_text_domain() {
		load_plugin_textdomain( 'mec-virtual', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
	}

	/**
	 * preLoad
	 *
	 * @since     1.0.0
	 */
	public static function preLoad() {
		include_once MECVIRTUALDIR . DS . 'core' . DS . 'autoloader.php';
		spl_autoload_register( __CLASS__.'::autoload' );
		include_once __DIR__ .'/includes/functions.php';
	}

	public static function init(){
		//admin
		add_action('mec_display_notification_settings','mec_admin_notifications_field_creator',10,2);
		add_action('mec_display_notification_settings_for_event','mec_admin_notifications_field_creator_for_event',10,2);
		add_filter('mec_settings_notifications_js_content_types','mec_add_virtual_type_to_settings_notifications_js_content_types');

		//wp
		// MEC notifications
		add_filter('mec_notification_get_content','mec_get_custom_args_for_virtual_event_notifications',10,3);
		add_filter('mec_notification_get_subject','mec_get_custom_args_for_virtual_event_notifications',10,3);


		if(is_admin()){

			Admin::getInstance()->init();
		}

		Shortcodes\RestrictedContent::getInstance()->init();
		add_action('mec_after_fes_form',[__CLASS__,'display_description_shortcode']);

		add_filter( 'mec_ical_single_description', array( __CLASS__, 'filter_ical_single_description' ), 10, 3 );
		add_action( 'mec_add_to_calander_event_description', array( __CLASS__, 'add_to_calendar_event_description' ), 10, 1 );

		add_filter('the_content',[__CLASS__,'filter_content_post_and_page_by_event_id']);
	}

	public static function display_description_shortcode(){

		echo '<div style="font-size: 14px">'.__('If you want to display a piece of content only to those who book the event, place it between [mec-restricted-content] and [/mec-restricted-content]','mec-virtual') .'</div>';
	}

	public static function filter_content_post_and_page_by_event_id($content){

		$event_ids = get_post_meta( get_the_ID() ,'mec_restrict_for_events', true );
		if(!empty($event_ids)){

			$error = '<div class="mec-vip-content-notice">'.__('You are not allowed to view the content of this page','mec-virtual').'</div>';

			if(!is_user_logged_in()){

				return $error;
			}

			$user_data = wp_get_current_user();

			$email = $user_data->user_email;
			if(empty($email)){

				return $error;
			}

			$books = BooksQuery::getInstance()->get_books_ids(
				array(
					'attendee_email'=> $email,
					'event_ids__in' => $event_ids,
					'confirmed' => 1,
					'verified' => 1,
				)
			);

			if(empty($books)){

				return $error;
			}
		}

		return $content;
	}

	/**
	 * Autoload Class
	 *
	 * @param string $class_name
	 *
	 * @return bool
	 */
	public static function autoload( string $class_name ): bool {

		if ( ! ( false !== strpos( $class_name, 'MEC_Virtual_Events' ) ) ) {

			return false;
		}

		$class_name = str_replace( 'MEC_Virtual_Events\\', '', $class_name );
		$ex         = explode( '\\', $class_name );
		$class_name = $ex[ count( $ex ) - 1 ];
		unset( $ex[ count( $ex ) - 1 ] );
		if ( ! empty( $ex ) ) {

			$class_name = implode( '/', $ex ) . '/' . $class_name;
		}

		$filename = __DIR__.'/includes/' . $class_name . '.php';
		if ( file_exists( $filename ) ) {

			require $filename;

			return true;
		}

		return false;
	}

	public static function filter_ical_single_description( $content, $event_id, $event ){

		$is_virtual_event = (bool)get_post_meta( $event_id, 'mec_virtual_event', true );

		if( $is_virtual_event ){

			$content .= self::get_description_details_for_export( $event );;
		}

		return $content;
	}

	public static function add_to_calendar_event_description( $event ){

		$event_id = $event->ID;
		echo self::filter_ical_single_description('', $event_id, $event );
	}

	public static function get_description_details_for_export( $event ){

		$single = new SinglePageAddon();
		ob_start();
			$single->display_in_single_page( $event );
		$html = ob_get_clean();

		$html = str_replace( '<div', '<p',$html );
		$html = str_replace( '</div', '</p', $html );

		return $html;
	}

} //Base

include_once ABSPATH . 'wp-admin/includes/plugin.php';
if ( is_plugin_active('modern-events-calendar/mec.php') || is_plugin_active('modern-events-calendar-lite/modern-events-calendar-lite.php') ) {
	Base::instance();
}
