
# Card

Represents the payment details of a card to be used for payments. These
details are determined by the payment token generated by Web Payments SDK.

## Structure

`Card`

## Fields

| Name | Type | Tags | Description | Getter | Setter |
|  --- | --- | --- | --- | --- | --- |
| `id` | `?string` | Optional | Unique ID for this card. Generated by Square.<br>**Constraints**: *Maximum Length*: `64` | getId(): ?string | setId(?string id): void |
| `cardBrand` | [`?string (CardBrand)`](../../doc/models/card-brand.md) | Optional | Indicates a card's brand, such as `VISA` or `MASTERCARD`. | getCardBrand(): ?string | setCardBrand(?string cardBrand): void |
| `last4` | `?string` | Optional | The last 4 digits of the card number.<br>**Constraints**: *Maximum Length*: `4` | getLast4(): ?string | setLast4(?string last4): void |
| `expMonth` | `?int` | Optional | The expiration month of the associated card as an integer between 1 and 12. | getExpMonth(): ?int | setExpMonth(?int expMonth): void |
| `expYear` | `?int` | Optional | The four-digit year of the card's expiration date. | getExpYear(): ?int | setExpYear(?int expYear): void |
| `cardholderName` | `?string` | Optional | The name of the cardholder.<br>**Constraints**: *Maximum Length*: `96` | getCardholderName(): ?string | setCardholderName(?string cardholderName): void |
| `billingAddress` | [`?Address`](../../doc/models/address.md) | Optional | Represents a postal address in a country.<br>For more information, see [Working with Addresses](https://developer.squareup.com/docs/build-basics/working-with-addresses). | getBillingAddress(): ?Address | setBillingAddress(?Address billingAddress): void |
| `fingerprint` | `?string` | Optional | Intended as a Square-assigned identifier, based<br>on the card number, to identify the card across multiple locations within a<br>single application.<br>**Constraints**: *Maximum Length*: `255` | getFingerprint(): ?string | setFingerprint(?string fingerprint): void |
| `customerId` | `?string` | Optional | **Required** The ID of a customer created using the Customers API to be associated with the card. | getCustomerId(): ?string | setCustomerId(?string customerId): void |
| `merchantId` | `?string` | Optional | The ID of the merchant associated with the card. | getMerchantId(): ?string | setMerchantId(?string merchantId): void |
| `referenceId` | `?string` | Optional | An optional user-defined reference ID that associates this card with<br>another entity in an external system. For example, a customer ID from an<br>external customer management system.<br>**Constraints**: *Maximum Length*: `128` | getReferenceId(): ?string | setReferenceId(?string referenceId): void |
| `enabled` | `?bool` | Optional | Indicates whether or not a card can be used for payments. | getEnabled(): ?bool | setEnabled(?bool enabled): void |
| `cardType` | [`?string (CardType)`](../../doc/models/card-type.md) | Optional | Indicates a card's type, such as `CREDIT` or `DEBIT`. | getCardType(): ?string | setCardType(?string cardType): void |
| `prepaidType` | [`?string (CardPrepaidType)`](../../doc/models/card-prepaid-type.md) | Optional | Indicates a card's prepaid type, such as `NOT_PREPAID` or `PREPAID`. | getPrepaidType(): ?string | setPrepaidType(?string prepaidType): void |
| `bin` | `?string` | Optional | The first six digits of the card number, known as the Bank Identification Number (BIN). Only the Payments API<br>returns this field.<br>**Constraints**: *Maximum Length*: `6` | getBin(): ?string | setBin(?string bin): void |
| `version` | `?int` | Optional | Current version number of the card. Increments with each card update. Requests to update an<br>existing Card object will be rejected unless the version in the request matches the current<br>version for the Card. | getVersion(): ?int | setVersion(?int version): void |
| `cardCoBrand` | [`?string (CardCoBrand)`](../../doc/models/card-co-brand.md) | Optional | Indicates the brand for a co-branded card. | getCardCoBrand(): ?string | setCardCoBrand(?string cardCoBrand): void |

## Example (as JSON)

```json
{
  "card_brand": null,
  "exp_month": null,
  "exp_year": null,
  "cardholder_name": null,
  "billing_address": null,
  "customer_id": null,
  "reference_id": null,
  "card_type": null,
  "prepaid_type": null,
  "version": null,
  "card_co_brand": null
}
```

