<?php

declare(strict_types=1);

namespace Square\Models;

use stdClass;

/**
 * Represents details about an `ACTIVATE` [gift card activity type]($m/GiftCardActivityType).
 */
class GiftCardActivityActivate implements \JsonSerializable
{
    /**
     * @var Money|null
     */
    private $amountMoney;

    /**
     * @var string|null
     */
    private $orderId;

    /**
     * @var string|null
     */
    private $lineItemUid;

    /**
     * @var string|null
     */
    private $referenceId;

    /**
     * @var string[]|null
     */
    private $buyerPaymentInstrumentIds;

    /**
     * Returns Amount Money.
     * Represents an amount of money. `Money` fields can be signed or unsigned.
     * Fields that do not explicitly define whether they are signed or unsigned are
     * considered unsigned and can only hold positive amounts. For signed fields, the
     * sign of the value indicates the purpose of the money transfer. See
     * [Working with Monetary Amounts](https://developer.squareup.com/docs/build-basics/working-with-
     * monetary-amounts)
     * for more information.
     */
    public function getAmountMoney(): ?Money
    {
        return $this->amountMoney;
    }

    /**
     * Sets Amount Money.
     * Represents an amount of money. `Money` fields can be signed or unsigned.
     * Fields that do not explicitly define whether they are signed or unsigned are
     * considered unsigned and can only hold positive amounts. For signed fields, the
     * sign of the value indicates the purpose of the money transfer. See
     * [Working with Monetary Amounts](https://developer.squareup.com/docs/build-basics/working-with-
     * monetary-amounts)
     * for more information.
     *
     * @maps amount_money
     */
    public function setAmountMoney(?Money $amountMoney): void
    {
        $this->amountMoney = $amountMoney;
    }

    /**
     * Returns Order Id.
     * The ID of the [order]($m/Order) that contains the `GIFT_CARD` line item.
     *
     * Applications that use the Square Orders API to process orders must specify the order ID
     * [CreateGiftCardActivity]($e/GiftCardActivities/CreateGiftCardActivity) request.
     */
    public function getOrderId(): ?string
    {
        return $this->orderId;
    }

    /**
     * Sets Order Id.
     * The ID of the [order]($m/Order) that contains the `GIFT_CARD` line item.
     *
     * Applications that use the Square Orders API to process orders must specify the order ID
     * [CreateGiftCardActivity]($e/GiftCardActivities/CreateGiftCardActivity) request.
     *
     * @maps order_id
     */
    public function setOrderId(?string $orderId): void
    {
        $this->orderId = $orderId;
    }

    /**
     * Returns Line Item Uid.
     * The UID of the `GIFT_CARD` line item in the order that represents the gift card purchase.
     *
     * Applications that use the Square Orders API to process orders must specify the line item UID
     * in the [CreateGiftCardActivity]($e/GiftCardActivities/CreateGiftCardActivity) request.
     */
    public function getLineItemUid(): ?string
    {
        return $this->lineItemUid;
    }

    /**
     * Sets Line Item Uid.
     * The UID of the `GIFT_CARD` line item in the order that represents the gift card purchase.
     *
     * Applications that use the Square Orders API to process orders must specify the line item UID
     * in the [CreateGiftCardActivity]($e/GiftCardActivities/CreateGiftCardActivity) request.
     *
     * @maps line_item_uid
     */
    public function setLineItemUid(?string $lineItemUid): void
    {
        $this->lineItemUid = $lineItemUid;
    }

    /**
     * Returns Reference Id.
     * A client-specified ID that associates the gift card activity with an entity in another system.
     *
     * Applications that use a custom order processing system can use this field to track information
     * related to an order or payment.
     */
    public function getReferenceId(): ?string
    {
        return $this->referenceId;
    }

    /**
     * Sets Reference Id.
     * A client-specified ID that associates the gift card activity with an entity in another system.
     *
     * Applications that use a custom order processing system can use this field to track information
     * related to an order or payment.
     *
     * @maps reference_id
     */
    public function setReferenceId(?string $referenceId): void
    {
        $this->referenceId = $referenceId;
    }

    /**
     * Returns Buyer Payment Instrument Ids.
     * The payment instrument IDs used to process the gift card purchase, such as a credit card ID
     * or bank account ID.
     *
     * Applications that use a custom order processing system must specify payment instrument IDs in
     * the [CreateGiftCardActivity]($e/GiftCardActivities/CreateGiftCardActivity) request.
     * Square uses this information to perform compliance checks.
     *
     * For applications that use the Square Orders API to process payments, Square has the necessary
     * instrument IDs to perform compliance checks.
     *
     * @return string[]|null
     */
    public function getBuyerPaymentInstrumentIds(): ?array
    {
        return $this->buyerPaymentInstrumentIds;
    }

    /**
     * Sets Buyer Payment Instrument Ids.
     * The payment instrument IDs used to process the gift card purchase, such as a credit card ID
     * or bank account ID.
     *
     * Applications that use a custom order processing system must specify payment instrument IDs in
     * the [CreateGiftCardActivity]($e/GiftCardActivities/CreateGiftCardActivity) request.
     * Square uses this information to perform compliance checks.
     *
     * For applications that use the Square Orders API to process payments, Square has the necessary
     * instrument IDs to perform compliance checks.
     *
     * @maps buyer_payment_instrument_ids
     *
     * @param string[]|null $buyerPaymentInstrumentIds
     */
    public function setBuyerPaymentInstrumentIds(?array $buyerPaymentInstrumentIds): void
    {
        $this->buyerPaymentInstrumentIds = $buyerPaymentInstrumentIds;
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->amountMoney)) {
            $json['amount_money']                 = $this->amountMoney;
        }
        if (isset($this->orderId)) {
            $json['order_id']                     = $this->orderId;
        }
        if (isset($this->lineItemUid)) {
            $json['line_item_uid']                = $this->lineItemUid;
        }
        if (isset($this->referenceId)) {
            $json['reference_id']                 = $this->referenceId;
        }
        if (isset($this->buyerPaymentInstrumentIds)) {
            $json['buyer_payment_instrument_ids'] = $this->buyerPaymentInstrumentIds;
        }
        $json = array_filter($json, function ($val) {
            return $val !== null;
        });

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
