<?php
/**
 *	Plugin Name: MEC Square Payment
 *	Plugin URI: http://webnus.net/modern-events-calendar/
 *	Description: Through this plugin, you can add Square payment for selling tickets
 *	Author: Webnus
 *	Version: 1.2.0
 *	Text Domain: mec-square
 *	Domain Path: /languages
 *	Author URI: http://webnus.net
 **/
namespace MEC_Square;

// don't load directly.
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}
/**
 * Base.
 *
 * @author     author
 * @package     package
 * @since     1.0.0
 */
class Base {

	/**
	 * Instance of this class.
	 *
	 * @since   1.0.0
	 * @access  public
	 * @var     MEC_Square
	 */
	public static $instance;

	/**
	 * Provides access to a single instance of a module using the singleton pattern.
	 *
	 * @since   1.0.0
	 * @return  object
	 */
	public static function instance() {
		if ( self::$instance === null ) {
			self::$instance = new self();
		}

		return self::$instance;
	}


	public function __construct() {
		self::settingUp();
		self::preLoad();
		self::setHooks($this);

		do_action( 'MEC_Square_init' );
	}

	/**
	 * Global Variables.
	 *
	 * @since   1.0.0
	 */
	public static function settingUp() {
		define('MECSQUAREVERSION' , '1.2.0');
		define('MECSQUAREDIR' , plugin_dir_path(__FILE__));
		define('MECSQUAREURL' , plugin_dir_url(__FILE__));
		define('MECSQUAREDASSETS' , MECSQUAREURL . '/assets/' );
		define('MECSQUARENAME' , 'Square Payment');
		define('MECSQUARESLUG' , 'mec-square-payment');
		define('MECSQUAREOPTIONS' , 'MEC_SQUARE_PAYMENT_options');
		define('MECSQUARETEXTDOMAIN' , 'mec-square');
		define('MECSQUAREMAINFILEPATH' ,__FILE__);
		define('MECSQUAREABSPATH', dirname(__FILE__));

		if ( ! defined( 'DS' ) ) {
			define( 'DS', DIRECTORY_SEPARATOR );
		}
	}

	/**
	 * Set Hooks
	 *
	 * @since     1.0.0
	 */
	public static function setHooks($This) {
	}

	/**
	 * preLoad
	 *
	 * @since     1.0.0
	 */
	public static function preLoad() {
		include_once MECSQUAREDIR . DS . 'core' . DS . 'autoloader.php';
	}

} //Base

Base::instance();
