<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class B_Anysidebutton extends \Bricks\Element {
  public $category     = 'Next Bricks - Buttons';
  public $name         = 'anysidebutton';
  public $icon         = 'fa-solid fa-square-minus';
  public $tag      = 'div';
  public $scripts      = ['anysidebutton'];

  public function get_label() {
    return esc_html__( 'Anyside Button', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'span' => 'span',
          'button' => 'button',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['inner_title'] = [
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Anyside Button', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    $this->controls['iconsSeparator'] = [
      'label'      => esc_html__( 'Icons', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['includeLeftIcon'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Left Icon', 'bricks' ),
      'type' => 'checkbox',
      'default' => false,
    ];
    $this->controls['leftIcon'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Icon', 'bricks' ),
      'type' => 'icon',
      'css' => [
        [
          'selector' => '&{pseudo} .bc-anyside-button__left-icon',
        ],
      ],
      'required'   => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['leftIconMargin'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Margin', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'margin',
          'selector' => '&{pseudo} .bc-anyside-button__left-icon',
        ],
      ],
      'required' => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['leftIconSize'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Size', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'css'   => [
        [
          'property' => 'font-size',
          'selector' => '&{pseudo} .bc-anyside-button__left-icon',
        ],
      ],
      'required' => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['leftIconColor'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Color', 'bricks' ),
      'type'  => 'color',
      'css'   => [
        [
          'property' => 'color',
          'selector' => '&{pseudo} .bc-anyside-button__left-icon',
        ],
      ],
      'required' => [ 'includeLeftIcon', '=', true ],
      'default' => [
        'hex' => '#ffffff',
      ],
    ];
    $this->controls['includeRightIcon'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Right Icon', 'bricks' ),
      'type' => 'checkbox',
      'default' => false,
    ];
    $this->controls['rightIcon'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Icon', 'bricks' ),
      'type' => 'icon',
      'css' => [
        [
          'selector' => '&{pseudo} .bc-anyside-button__right-icon',
        ],
      ],
      'required'   => [ 'includeRightIcon', '=', true ],
    ];
    $this->controls['rightIconMargin'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Margin', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'margin',
          'selector' => '&{pseudo} .bc-anyside-button__right-icon',
        ],
      ],
      'required' => [ 'includeRightIcon', '=', true ],
    ];
    $this->controls['rightIconSize'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Size', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'css'   => [
        [
          'property' => 'font-size',
          'selector' => '&{pseudo} .bc-anyside-button__right-icon',
        ],
      ],
      'required' => [ 'includeRightIcon', '=', true ],
    ];
    $this->controls['rightIconColor'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Color', 'bricks' ),
      'type'  => 'color',
      'css'   => [
        [
          'property' => 'color',
          'selector' => '&{pseudo} .bc-anyside-button__right-icon',
        ],
      ],
      'required' => [ 'includeRightIcon', '=', true ],
      'default' => [
        'hex' => '#ffffff',
      ],
    ];

    $this->controls['styleSeparator'] = [
      'label'      => esc_html__( 'Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['whitespace'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'White space', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'wrap' => 'wrap',
          'nowrap' => 'nowrap',
      ],
      'inline'      => true,
      'css'     => [
          [
            'property' => 'white-space',
            'selector' => '',
          ],
        ],
      'placeholder'        => 'wrap',
      'default'            => 'wrap',
  ];
    $this->controls['padding'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Padding', 'bricks' ),
      'type'        => 'spacing',
      'css'     => [
          [
            'property' => 'padding',
            'selector' => '',
          ],
        ],
        'placeholder' => [
          'top' => 40,
          'right' => 40,
          'bottom' => 40,
          'left' => 40,
        ],
        'default' => [
          'top'    => 40,
          'right'  => 40,
          'bottom' => 40,
          'left'   => 40,
        ],
  ];
    $this->controls['background'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Background', 'bricks' ),
        'type'        => 'background',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'background',
              'selector' => '',
            ],
          ],
        'default' => [
          'color' => [
            'hex' => '#ffffff',
          ],
        ],
    ];
    $this->controls['color'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Typography', 'bricks' ),
        'type'        => 'typography',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'typography',
              'selector' => '',
            ],
          ],
        'default' => [
          'color' => [
            'hex' => '#1a1a1a',
          ],
          'text-align' => 'center',
        ],
    ];
    $this->controls['border'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Border', 'bricks' ),
        'type'        => 'border',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'border',
              'selector' => '',
            ],
          ],
        'default' => [
          'width' => [
            'top'    => 0,
            'right'  => 0,
            'bottom' => 0,
            'left'   => 0,
          ],
          'style' => 'none',
          'radius' => [
            'top'    => 15,
            'right'  => 15,
            'bottom' => 15,
            'left'   => 15,
          ],
        ],
    ];

    $this->controls['animationSeparator'] = [
      'label'      => esc_html__( 'Animation', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['anysidetype'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Event', 'bricks' ),
      'type'        => 'select',
      'options'     => [
        'hover' => 'hover',
        'click' => 'click',
      ],
      'inline' => true,
      'placeholder' => 'hover',
      'default' => 'hover',
    ];
    $this->controls['transitionseasing'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'CSS easing', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'hasDynamicData' => false,
      'css'     => [
          [
            'property' => '--easing',
            'selector' => '',
          ],
      ],
      'placeholder'  => 'ease',
      'required' => [ 'anysidetype', '!=', 'click'],
      'default'     => 'ease',
    ];
    $this->controls['pathSeparator'] = [
      'label'      => esc_html__( 'Path transition', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['circledimensions'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Circle dimensions', 'bricks' ),
      'type'        => 'number',
      'units'      => true,
      'inline'      => true,
      'css'     => [
          [
            'property' => '--click-dimensions',
            'selector' => '',
          ],
      ],
      'placeholder'  => '500px',
      'required' => [ 'anysidetype', '=', 'click'],
      'default'     => '500px',
    ];
    $this->controls['hoverbackground'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Path background', 'bricks' ),
        'type'        => 'background',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'background',
              'selector' => '&{pseudo} .bc-anyside-button__anyside-div',
            ],
            [
              'property' => 'background',
              'selector' => '&{pseudo} .bc-anyside-button__anyside-span',
            ],
          ],
        'default' => [
          'color' => [
            'hex' => '#252527',
          ],
        ],
    ];
    $this->controls['pathtransitionida'] = [ /*define el duration en click*/
      'tab'         => 'content',
      'label'       => esc_html__( 'In path transition', 'bricks' ),
      'type'        => 'number',
      'unit'      => 'ms',
      'inline'      => true,
      'css'     => [
          [
            'property' => '--pathtransition-ida',
            'selector' => '',
          ],
      ],
      'placeholder'        => '800ms',
      'required' => [ 'anysidetype', '!=', 'click'],
      'default'            => '800ms',
    ];
    $this->controls['pathtransition'] = [ /*define el duration en click*/
        'tab'         => 'content',
        'label'       => esc_html__( 'Out path transition', 'bricks' ),
        'type'        => 'number',
        'unit'      => 'ms',
        'inline'      => true,
        'css'     => [
            [
              'property' => '--pathtransition',
              'selector' => '',
            ],
        ],
        'placeholder'        => '800ms',
        'default'            => '800ms',
    ];
    $this->controls['colorSeparator'] = [
      'label'      => esc_html__( 'Color transition', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['hovercolor'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Color', 'bricks' ),
        'type'        => 'color',
        'inline'      => true,
        'css'     => [
            [
              'property' => '--hover-color',
              'selector' => '',
            ],
          ],
        'required' => [ 'anysidetype', '!=', 'click'],
        'default' => [
          'hex' => '#ffffff',
        ],
    ];
    $this->controls['colortransitionida'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'In color transition', 'bricks' ),
      'type'        => 'number',
      'unit'      => 'ms',
      'inline'      => true,
      'css'     => [
          [
            'property' => '--colortransition-ida',
            'selector' => '',
          ],
      ],
      'placeholder'        => '800ms',
      'required' => [ 'anysidetype', '!=', 'click'],
      'default'            => '800ms',
    ];
    $this->controls['colortransition'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Out color transition', 'bricks' ),
      'type'        => 'number',
      'unit'      => 'ms',
      'inline'      => true,
      'css'     => [
          [
            'property' => '--colortransition',
            'selector' => '',
          ],
      ],
      'placeholder'        => '800ms',
      'required' => [ 'anysidetype', '!=', 'click'],
      'default'            => '800ms',
    ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'anysidebutton', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_anyside_button.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Next Bricks';
    $anysidetype    = ! empty( $settings['anysidetype'] ) ? $settings['anysidetype'] : 'hover';
    $anysidedurationclick    = ! empty( $settings['pathtransition'] ) ? $settings['pathtransition'] : 800;

    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = $this->tag;
    }

    $includeLeftIcon = ! empty( $settings['includeLeftIcon'] ) ? $settings['includeLeftIcon'] : 0;
    $includeRightIcon = ! empty( $settings['includeRightIcon'] ) ? $settings['includeRightIcon'] : 0;
    if ( $includeLeftIcon !== 0 ) {
      $leftIcon = self::render_icon( $settings['leftIcon'], [ 'bc-anyside-button__left-icon' ] );
    }else{
      $leftIcon = '';
    }
    if ( $includeRightIcon !== 0 ) {
      $rightIcon = self::render_icon( $settings['rightIcon'], [ 'bc-anyside-button__right-icon' ] );
    }else{
      $rightIcon = '';
    }

    $this->set_attribute( '_root', 'class', 'bc-anyside-button' );

    if($anysidetype == 'hover'){
      $output = "
      <$root_tag  {$this->render_attributes( '_root' )}
      data-type=\"$anysidetype\"
      data-durationclick=\"$anysidedurationclick\">
        <span class='bc-anyside-button__title'>$leftIcon$inner_title$rightIcon</span>
        <div class='bc-anyside-button__anyside-div'></div>
      </$root_tag>
      ";
    }else if($anysidetype == 'click'){
      $output = "
      <$root_tag  {$this->render_attributes( '_root' )}
      data-type=\"$anysidetype\"
      data-durationclick=\"$anysidedurationclick\">
        <span class='bc-anyside-button__title'>$leftIcon$inner_title$rightIcon</span>
      </$root_tag>
      ";
    }

	echo $output;
  }
}
