<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class B_Back_To_Top extends \Bricks\Element {
  public $category     = 'Next Bricks - Cores';
  public $name         = 'back-to-top';
  public $icon         = 'ti-arrow-circle-up';
  public $scripts      = ['next_backtotop'];
  public $custom_attributes = false;

  public function get_label() {
    return esc_html__( 'Back to Top', 'bricks' );
  }

  public function set_controls() {
    $this->controls['right'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Right', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'right',
            'selector' => '',
          ]
        ],
        'placeholder' => '50px',
        'default'     => '50px',
    ];
    $this->controls['sbottom'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Bottom', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'bottom',
            'selector' => '',
          ]
        ],
        'placeholder' => '50px',
        'default'     => '50px',
    ];
    $this->controls['circlecolor'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Circle color', 'bricks' ),
        'type'  => 'background',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'background',
            'selector' => '',
          ]
        ],
        'default' => [
          'color' => [
            'hex' => '#00000000',
          ],
        ],
    ];
    $this->controls['insidecolor'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Path color', 'bricks' ),
        'type'  => 'color',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'color',
            'selector' => '',
          ]
        ],
        'default' => [
          'hex' => '#ffffff33',
        ],
    ];
    $this->controls['progresscolor'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Progress color', 'bricks' ),
        'type'  => 'color',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'stroke',
            'selector' => '.bc-back-to-top__circle-path',
          ]
        ],
        'default' => [
          'hex' => '#808080',
        ],
    ];

    $this->controls['arrowSeparator'] = [
      'label'      => esc_html__( 'Arrow', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['arrowtype'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Type', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'type1' => 'Arrow',
          'type2' => 'Angle',
          'type3' => 'Angles',
      ],
      'inline' => true,
      'placeholder' => 'Arrow',
      'default' => 'type1',
  ];
    $this->controls['arrowcolor'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Color', 'bricks' ),
      'type' => 'color',
      'inline' => true,
      'css' => [
        [
          'property' => 'fill',
          'selector' => '.bc-back-to-top__arrow-svg',
        ]
      ],
      'default' => [
        'hex' => '#808080',
      ],
    ];
    $this->controls['arrowdimensions'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Dimensions', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'inline' => true,
      'css' => [
        [
          'property' => 'width',
          'selector' => '.bc-back-to-top__arrow-svg',
        ]
      ],
      'placeholder' => '25px',
      'default'     => '25px',
  ];

    $this->controls['backToTopSeparator'] = [
      'label'      => esc_html__( 'Back to Top', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['scrollToPixel'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Scroll to', 'bricks' ),
      'type' => 'number',
      'units' => true,
      'inline' => true,
      'placeholder' => '0px',
  ];
    $this->controls['backDuration'] = [
      'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 'ms',
        'inline' => true,
        'placeholder' => '550ms',
    ];
    $this->controls['backEasing'] = [
      'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP easing', 'bricks' ),
        'type' => 'select',
        'options'     => [
          'none' => 'none',
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps',
          'custom' => 'custom'
        ],
        'inline' => true,
        'placeholder' => 'power3',
    ];
    $this->controls['customBackEasing'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'backEasing', '=', 'custom' ],
    ];


    $this->controls['animationSeparator'] = [
      'label'      => esc_html__( 'Element Animation', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['speed'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Progress speed', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '10',
    ];
    $this->controls['ease'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Progress ease', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => 'linear',
    ];
    $this->controls['entranceDistance'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Entrance distance', 'bricks' ),
      'type' => 'number',
      'units' => true,
      'inline' => true,
      'placeholder' => '50px',
  ];
    $this->controls['entrancespeed'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Entrance speed', 'bricks' ),
        'type' => 'number',
        'unit' => 'ms',
        'inline' => true,
        'css' => [
          [
            'property' => 'transition-duration',
            'selector' => '',
          ]
        ],
        'placeholder' => '200ms',
        'default'     => '200ms',
    ];
    $this->controls['entranceease'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Entrance ease', 'bricks' ),
        'type'  => 'text',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'transition-timing-function',
            'selector' => '',
          ]
        ],
        'placeholder' => 'linear',
        'default'     => 'linear',
    ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'next-gsap-scroll-to-top', NEXTBRICKS_PLUGIN_URL . 'local_assets/next_gsap_scroll_to.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    wp_enqueue_script( 'back_to_top', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_back_to_top.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;

    $scrollToPixel = ! empty( $settings['scrollToPixel'] ) ? $settings['scrollToPixel'] : 0;
    $backDuration = ! empty( $settings['backDuration'] ) ? $settings['backDuration'] : 550;
    $backEasing = ! empty( $settings['backEasing'] ) ? $settings['backEasing'] : 'power3';
    if ($backEasing === 'custom') {
      $backEasing = ! empty( $settings['customBackEasing'] ) ? $settings['customBackEasing'] : 'power3';
    }

    $entranceDistance = ! empty( $settings['entranceDistance'] ) ? $settings['entranceDistance'] : '50px';
    $speed = ! empty( $settings['speed'] ) ? $settings['speed'] : '10';
    $ease = ! empty( $settings['ease'] ) ? $settings['ease'] : 'linear';
    $arrowtype = ! empty( $settings['arrowtype'] ) ? $settings['arrowtype'] : 'type1';

    if($arrowtype == 'type1'){
      $arrow = 
      "<svg class='bc-back-to-top__arrow-svg' xmlns='http://www.w3.org/2000/svg' data-name='Layer 1' viewBox='0 0 24 24' id='arrow-up'>
        <path class='bc-back-to-top__arrow-path' d='M17.71,11.29l-5-5a1,1,0,0,0-.33-.21,1,1,0,0,0-.76,0,1,1,0,0,0-.33.21l-5,5a1,1,0,0,0,1.42,1.42L11,9.41V17a1,1,0,0,0,2,0V9.41l3.29,3.3a1,1,0,0,0,1.42,0A1,1,0,0,0,17.71,11.29Z'/>
      </svg>";
    }
    if($arrowtype == 'type2'){
      $arrow = 
      "<svg class='bc-back-to-top__arrow-svg' xmlns='http://www.w3.org/2000/svg' data-name='Layer 1' viewBox='0 0 512 512' id='arrow-up'>
        <path d='M233.4 105.4c12.5-12.5 32.8-12.5 45.3 0l192 192c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L256 173.3 86.6 342.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l192-192z'/>
      </svg>";
    }
    if($arrowtype == 'type3'){
      $arrow = 
      "<svg class='bc-back-to-top__arrow-svg' xmlns='http://www.w3.org/2000/svg' data-name='Layer 1' viewBox='0 0 24 24' id='arrow-up'>
        <path d='m12 6.414 7.293 7.293 1.414-1.414L12 3.586l-8.707 8.707 1.414 1.414L12 6.414z'/><path d='m3.293 18.293 1.414 1.414L12 12.414l7.293 7.293 1.414-1.414L12 9.586l-8.707 8.707z'/>
      </svg>";
    }

    $this->set_attribute( '_root', 'data-scroll-to-pixel', "$scrollToPixel");
    $this->set_attribute( '_root', 'data-back-easing', "$backEasing");
    $this->set_attribute( '_root', 'data-back-duration', "$backDuration");

    $this->set_attribute( '_root', 'data-speed', "$speed");
    $this->set_attribute( '_root', 'data-ease', "$ease");
    $this->set_attribute( '_root', 'data-entrance-distance', "$entranceDistance");

    $this->set_attribute( '_root', 'class', 'bc-back-to-top' );
    $this->set_attribute( '_root', 'class', 'bc-to-hide' );

    $output = "<div {$this->render_attributes( '_root' )}>
    <svg class='bc-back-to-top__progress-circle bc-back-to-top__svg-content' width='100%' height='100%' viewBox='-1 -1 102 102'>
      <path class='bc-back-to-top__circle-path' d='M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98'/>
    </svg>
    $arrow
    ";
    $output .= '</div>';

	echo $output;
  }
}
