<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class B_Cursor extends \Bricks\Element {
  public $category     = 'Next Bricks - Cursors';
  public $name         = 'Cursor';
  public $icon         = 'fa-regular fa-circle';
  public $css_selector = '';


  public function get_label() {
    return esc_html__( 'Next Cursor', 'bricks' );
  }

  public function set_control_groups() {
    $this->control_groups['magneticgroup'] = [
      'title' => esc_html__( 'Magnetic', 'bricks' ),
      'tab'   => 'content',
    ];
    $this->control_groups['repelgroup'] = [
      'title' => esc_html__( 'Repel', 'bricks' ),
      'tab'   => 'content',
    ];
    $this->control_groups['skewgroup'] = [
      'title' => esc_html__( 'Skew', 'bricks' ),
      'tab'   => 'content',
    ];
    $this->control_groups['stickgroup'] = [
      'title' => esc_html__( 'Stick', 'bricks' ),
      'tab'   => 'content',
    ];
    $this->control_groups['sizegroup'] = [
      'title' => esc_html__( 'Size', 'bricks' ),
      'tab'   => 'content',
    ];
    $this->control_groups['bordergroup'] = [
      'title' => esc_html__( 'Border', 'bricks' ),
      'tab'   => 'content',
    ];
    $this->control_groups['colorgroup'] = [
      'title' => esc_html__( 'Color', 'bricks' ),
      'tab'   => 'content',
    ];
    $this->control_groups['exclusiongroup'] = [
      'title' => esc_html__( 'Exclusion', 'bricks' ),
      'tab'   => 'content',
    ];
    $this->control_groups['textgroup'] = [
      'title' => esc_html__( 'Text', 'bricks' ),
      'tab'   => 'content',
    ];
    $this->control_groups['backdropgroup'] = [
      'title' => esc_html__( 'Backdrop', 'bricks' ),
      'tab'   => 'content',
    ];
    $this->control_groups['blurgroup'] = [
      'title' => esc_html__( 'Blur', 'bricks' ),
      'tab'   => 'content',
    ];
    $this->control_groups['imagegroup'] = [
      'title' => esc_html__( 'Media', 'bricks' ),
      'tab'   => 'content',
    ];
    $this->control_groups['hiddengroup'] = [
      'title' => esc_html__( 'Hidden', 'bricks' ),
      'tab'   => 'content',
    ];
  }

  public function set_controls() {
    $this->controls['note'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( 'Cursor can only be visible on the front.', 'bricks' )))
    ];
    $this->controls['styleSeparator'] = [
      'label'      => esc_html__( 'Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['defaultcursor'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'CSS Cursor', 'bricks' ),
      'type'        => 'select',
			'options'     => [
				'generalGroupTitle'   => esc_html__( 'General', 'bricks' ),
				'auto'                => 'auto',
				'default'             => 'default',
				'none'                => 'none',

				'linkGroupTitle'      => esc_html__( 'Link & status', 'bricks' ),
				'pointer'             => 'pointer',
				'context-menu'        => 'context-menu',
				'help'                => 'help',
				'progress'            => 'progress',
				'wait'                => 'wait',

				'selectionGroupTitle' => esc_html__( 'Selection', 'bricks' ),
				'cell'                => 'cell',
				'crosshair'           => 'crosshair',
				'text'                => 'text',
				'vertical-text'       => 'vertical-text',

				'dndGroupTitle'       => esc_html__( 'Drag & drop', 'bricks' ),
				'alias'               => 'alias',
				'copy'                => 'copy',
				'move'                => 'move',
				'no-drop'             => 'no-drop',
				'not-allowed'         => 'not-allowed',
				'grab'                => 'grab',
				'grabbing'            => 'grabbing',

				'zoomGroupTitle'      => esc_html__( 'Zoom', 'bricks' ),
				'zoom-in'             => 'zoom-in',
				'zoom-out'            => 'zoom-out',

				'scrollGroupTitle'    => esc_html__( 'Resize', 'bricks' ),
				'col-resize'          => 'col-resize',
				'row-resize'          => 'row-resize',
				'n-resize'            => 'n-resize',
				'e-resize'            => 'e-resize',
				's-resize'            => 's-resize',
				'w-resize'            => 'w-resize',
				'ne-resize'           => 'ne-resize',
				'nw-resize'           => 'nw-resize',
				'se-resize'           => 'se-resize',
				'sw-resize'           => 'sw-resize',
				'ew-resize'           => 'ew-resize',
				'ns-resize'           => 'ns-resize',
				'nesw-resize'         => 'nesw-resize',
				'nwse-resize'         => 'nwse-resize',
				'all-scroll'          => 'all-scroll',
			],
      'inline' => true,
      'placeholder' => 'default',
    ];
    $this->controls['defaultcolor'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Color', 'bricks' ),
      'type' => 'color',
      'inline' => true,
    ];
    $this->controls['defaultsize'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Size', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'scale(0.2)',
    ];
    $this->controls['defaultactive'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Active size', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'scale(0.5)',
    ];
    $this->controls['defaultskew'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Skew', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => '0',
    ];
    $this->controls['defaultzindex'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'zIndex', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => '99999',
    ];
    $this->controls['defaultvisible'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Visible by default', 'bricks' ),
      'type' => 'select',
      'options'     => [
        'true' => 'true',
        'false' => 'false',
      ],
      'inline' => true,
      'placeholder' => 'true',
    ];
    $this->controls['defaultborder'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Border', 'bricks' ),
      'type' => 'border',
      'inline' => true,
    ];

    $this->controls['settingsSeparator'] = [
      'label'      => esc_html__( 'Settings', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['defaultspeed'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Speed', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => '0.55',
    ];
    $this->controls['defaultease'] = [
      'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP easing', 'bricks' ),
        'type' => 'select',
        'options'     => [
          'none' => 'none',
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps',
          'custom' => 'custom'
        ],
        'inline' => true,
        'placeholder' => 'expo',
    ];
    $this->controls['customDefaultease'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'defaultease', '=', 'custom' ],
    ];

    $this->controls['defaulthide'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Hide on leave', 'bricks' ),
      'type' => 'select',
      'options'     => [
        'true' => 'true',
        'false' => 'false',
      ],
      'inline' => true,
      'placeholder' => 'true',
    ];

    //States
    $this->controls['statesSeparator'] = [
      'label'      => esc_html__( 'States', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['noteStates'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( 'Assign a class to the element you want to target. Then put the class at the state you want to apply to that element.', 'bricks' )))
    ];
    $this->controls['magnetic'] = [
      'tab'           => 'content',
      'type'          => 'repeater',
      'group'			=> 'magneticgroup',
      'label'         => esc_html__( 'Magnetic elements', 'bricks' ),
      'placeholder'   => esc_html__( 'Magnetic element', 'bricks' ),
      'titleProperty' => 'title',
      'fields'        => [
        'class'       => [
          'type'    => 'text',
          'label'   => esc_html__( 'Element', 'bricks' ),
          'placeholder' => 'className or tag',
        ],
        'speed'       => [
          'label' => esc_html__( 'Speed', 'bricks' ),
          'type' => 'text',
          'placeholder' => '1',
          'inline' => true,
          'hasDynamicData' => false,
        ],
        'intensity'       => [
          'label' => esc_html__( 'Intensity', 'bricks' ),
          'type' => 'text',
          'placeholder' => '1',
          'inline' => true,
          'hasDynamicData' => false,
        ],
      ],
    ];
    $this->controls['repel'] = [
      'tab'           => 'content',
      'type'          => 'repeater',
      'group'			=> 'repelgroup',
      'label'         => esc_html__( 'Repel elements', 'bricks' ),
      'placeholder'   => esc_html__( 'Repel element', 'bricks' ),
      'titleProperty' => 'title',
      'fields'        => [
        'class'       => [
          'type'    => 'text',
          'label'   => esc_html__( 'Element', 'bricks' ),
          'placeholder' => 'className or tag',
        ],
        'speed'       => [
          'label' => esc_html__( 'Speed', 'bricks' ),
          'type' => 'text',
          'placeholder' => '1',
          'inline' => true,
          'hasDynamicData' => false,
        ],
        'intensity'       => [
          'label' => esc_html__( 'Intensity', 'bricks' ),
          'type' => 'text',
          'placeholder' => '1',
          'inline' => true,
          'hasDynamicData' => false,
        ],
      ],
    ];
    $this->controls['hidden'] = [
      'tab'           => 'content',
      'type'          => 'repeater',
      'group'			=> 'hiddengroup',
      'label'         => esc_html__( 'Hidden elements', 'bricks' ),
      'placeholder'   => esc_html__( 'Hidden element', 'bricks' ),
      'titleProperty' => 'title',
      'fields'        => [
        'class'       => [
          'type'    => 'text',
          'label'   => esc_html__( 'Element', 'bricks' ),
          'placeholder' => 'className or tag',
        ],
      ],
    ];
    $this->controls['exclusion'] = [
      'tab'           => 'content',
      'type'          => 'repeater',
      'group'			=> 'exclusiongroup',
      'label'         => esc_html__( 'Exclusion elements', 'bricks' ),
      'placeholder'   => esc_html__( 'Exclusion element', 'bricks' ),
      'titleProperty' => 'title',
      'fields'        => [
        'class'       => [
          'type'    => 'text',
          'label'   => esc_html__( 'Element', 'bricks' ),
          'placeholder' => 'className or tag',
        ],
      ],
    ];
    $this->controls['backdrop'] = [
      'tab'           => 'content',
      'type'          => 'repeater',
      'group'			=> 'backdropgroup',
      'label'         => esc_html__( 'Backdrop elements', 'bricks' ),
      'placeholder'   => esc_html__( 'Backdrop element', 'bricks' ),
      'titleProperty' => 'title',
      'fields'        => [
        'class'       => [
          'type'    => 'text',
          'label'   => esc_html__( 'Element', 'bricks' ),
          'placeholder' => 'className or tag',
        ],
        'backdrop'       => [
          'label' => esc_html__( 'Backdrop', 'bricks' ),
          'type' => 'text',
          'placeholder' => '0px',
          'inline' => true,
          'hasDynamicData' => false,
        ],
      ],
    ];
    $this->controls['blur'] = [
      'tab'           => 'content',
      'type'          => 'repeater',
      'group'			=> 'blurgroup',
      'label'         => esc_html__( 'Blur elements', 'bricks' ),
      'placeholder'   => esc_html__( 'Blur element', 'bricks' ),
      'titleProperty' => 'title',
      'fields'        => [
        'class'       => [
          'type'    => 'text',
          'label'   => esc_html__( 'Element', 'bricks' ),
          'placeholder' => 'className or tag',
        ],
        'blur'       => [
          'label' => esc_html__( 'Blur', 'bricks' ),
          'type' => 'text',
          'placeholder' => '0px',
          'hasDynamicData' => false,
          'inline' => true,
        ],
      ],
    ];
    $this->controls['skew'] = [
      'tab'           => 'content',
      'type'          => 'repeater',
      'group'			=> 'skewgroup',
      'label'         => esc_html__( 'Skew elements', 'bricks' ),
      'placeholder'   => esc_html__( 'Skew element', 'bricks' ),
      'titleProperty' => 'title',
      'fields'        => [
        'class'       => [
          'type'    => 'text',
          'label'   => esc_html__( 'Element', 'bricks' ),
          'placeholder' => 'className or tag',
        ],
        'skew'       => [
          'label' => esc_html__( 'Skew', 'bricks' ),
          'type' => 'text',
          'hasDynamicData' => false,
          'inline' => true,
          'placeholder ' => '0',
        ],
      ],
    ];
    $this->controls['color'] = [
      'tab'           => 'content',
      'type'          => 'repeater',
      'group'			=> 'colorgroup',
      'label'         => esc_html__( 'Color elements', 'bricks' ),
      'placeholder'   => esc_html__( 'Color element', 'bricks' ),
      'titleProperty' => 'title',
      'fields'        => [
        'class'       => [
          'type'    => 'text',
          'label'   => esc_html__( 'Element', 'bricks' ),
          'placeholder' => 'className or tag',
        ],
        'color'       => [
          'type'    => 'color',
          'label'   => esc_html__( 'Color', 'bricks' ),
        ],
      ],
    ];
    $this->controls['border'] = [
      'tab'           => 'content',
      'type'          => 'repeater',
      'group'			=> 'bordergroup',
      'label'         => esc_html__( 'Border elements', 'bricks' ),
      'placeholder'   => esc_html__( 'Border element', 'bricks' ),
      'titleProperty' => 'title',
      'fields'        => [
        'class'       => [
          'type'    => 'text',
          'label'   => esc_html__( 'Element', 'bricks' ),
          'placeholder' => 'className or tag',
        ],
        'border'       => [
          'type'    => 'border',
          'exclude'    => 'border-radius',
          'label'   => esc_html__( 'Border', 'bricks' ),
        ],
      ],
    ];
    $this->controls['size'] = [
      'tab'           => 'content',
      'type'          => 'repeater',
      'group'			=> 'sizegroup',
      'label'         => esc_html__( 'Size elements', 'bricks' ),
      'placeholder'   => esc_html__( 'Size element', 'bricks' ),
      'titleProperty' => 'title',
      'fields'        => [
        'class'       => [
          'type'    => 'text',
          'label'   => esc_html__( 'Element', 'bricks' ),
          'placeholder' => 'className or tag',
        ],
        'size'       => [
          'label' => esc_html__( 'Size', 'bricks' ),
          'type' => 'text',
          'placeholder' => 'scale(0.2)',
          'hasDynamicData' => false,
          'inline' => true,
        ],
      ],
    ];
    $this->controls['texto'] = [
      'tab'           => 'content',
      'type'          => 'repeater',
      'group'			=> 'textgroup',
      'label'         => esc_html__( 'Text elements', 'bricks' ),
      'placeholder'   => esc_html__( 'Text element', 'bricks' ),
      'titleProperty' => 'title',
      'fields'        => [
        'class'       => [
          'type'    => 'text',
          'label'   => esc_html__( 'Element', 'bricks' ),
          'placeholder' => 'className or tag',
        ],
        'texto'       => [
          'type' => 'text',
          'label' => esc_html__( 'Text', 'bricks' ),
        ],
        'infontfamily'       => [
          'type' => 'typography',
          'exclude' => [
            'font-variation-settings',
            'text-align',
            'text-shadow',
            'font-weight',
            'font-style',
            'text-align',
            'text-transform',
            'text-decoration',
            'font-size',
            'line-height',
            'letter-spacing',
            'color',
            'text-shadow',
          ],
          'css'     => [
            [
              'property' => '--font-family',
              'selector' => '',
            ],
          ],
          'popup' => false,
        ],
        'infontsize'       => [
          'label' => esc_html__( 'Font size', 'bricks' ),
          'units' => true,
          'inline' => true,
          'type' => 'number',
          'placeholder' => '16px',
          'popup' => false,
        ],
        'infontcolor'       => [
          'label' => esc_html__( 'Color', 'bricks' ),
          'type' => 'color',
          'inline' => true,
        ],
      ],
    ];
    $this->controls['image'] = [
      'tab'           => 'content',
      'type'          => 'repeater',
      'group'			=> 'imagegroup',
      'label'         => esc_html__( 'Media elements', 'bricks' ),
      'placeholder'   => esc_html__( 'Media element', 'bricks' ),
      'titleProperty' => 'title',
      'fields'        => [
        'class'       => [
          'type'    => 'text',
          'label'   => esc_html__( 'Element', 'bricks' ),
          'placeholder' => 'className or tag',
        ],
        'image'       => [
          'type'    => 'link',
          'label'   => esc_html__( 'Media', 'bricks' ),
          'exclude'     => [
            'lightboxVideo',
            'lightboxImage',
            'internal',
            'meta',
            'ariaLabel',
            'rel',
            'title',
            'newTab',
          ],
        ],
      ],
    ];
    $this->controls['stickdelta'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'group'			=> 'stickgroup',
      'label' => esc_html__( 'Stick delta', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => '0.15',
    ];
    $this->controls['stick'] = [
      'tab'           => 'content',
      'type'          => 'repeater',
      'group'			=> 'stickgroup',
      'label'         => esc_html__( 'Sticky elements', 'bricks' ),
      'placeholder'   => esc_html__( 'Sticky element', 'bricks' ),
      'titleProperty' => 'title',
      'fields'        => [
        'fromclass'       => [
          'type'    => 'text',
          'label'   => esc_html__( 'From element class', 'bricks' ),
          'placeholder' => 'className or tag',
        ],
        'toclass'       => [
          'type'    => 'text',
          'label'   => esc_html__( 'To element class', 'bricks' ),
          'placeholder' => 'className or tag',
        ],
      ],
    ];
  }

  


  public function enqueue_scripts() {
    wp_enqueue_script( 'bc-cursor', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_cursor.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);

    wp_enqueue_style( 'cursor-css-stylesheet', NEXTBRICKS_PLUGIN_URL . 'local_assets/cursor.min.css', array(), NEXTBRICKS_VERSION, false );

    wp_enqueue_script( 'mouse-follower-js', NEXTBRICKS_PLUGIN_URL . 'local_assets/bc_mouse_follower.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
}


  public function render() {
    $settings = $this->settings;

    if ( isset($settings['defaultcolor']) && is_array($settings['defaultcolor']) && count($settings['defaultcolor']) > 0 ) {
      if (isset($settings['defaultcolor']['rgb'])) {
        $defaultcolor = $settings['defaultcolor']['rgb'];
      } else if(isset($settings['defaultcolor']['raw'])){
        $defaultcolor = $settings['defaultcolor']['raw'];
      }else {
        $defaultcolor = $settings['defaultcolor']['hex'];
      }
    }else{
      $defaultcolor = 'black';
    }

    //Get old font family or set a default
    $statecolordefaultfamily = !empty($settings['fontfamily']) ? $settings['fontfamily'] : 'Helvetica';
    //Get old font color or set a default
    $statecolordefaultcolor = !empty($settings['fontcolor']) ? $settings['fontcolor'] : 'black';
    //Get old font size or set a default
    $statecolordefaultsize = !empty($settings['fontsize']) ? $settings['fontsize'] : '16px';

    //Default border
    if (isset($border['defaultborder']['color']['rgb'])) {
      $bordercolor = $settings['defaultborder']['color']['rgb'];
    }else if(isset($settings['defaultborder']['color']['raw'])){
      $bordercolor = $settings['defaultborder']['color']['raw'];
    }else if(isset($settings['defaultborder']['color']['hex'])){
      $bordercolor = $settings['defaultborder']['color']['hex'];
    }else{
      $bordercolor = 'unset';
    }
    $borderradiustop = isset($settings['defaultborder']['radius']['top']) ? $settings['defaultborder']['radius']['top'] : 'unset';
    $borderradiusright = isset($settings['defaultborder']['radius']['right']) ? $settings['defaultborder']['radius']['right'] : 'unset';
    $borderradiusbottom = isset($settings['defaultborder']['radius']['bottom']) ? $settings['defaultborder']['radius']['bottom'] : 'unset';
    $borderradiusleft = isset($settings['defaultborder']['radius']['left']) ? $settings['defaultborder']['radius']['left'] : 'unset';
    $borderstyle = !empty($settings['defaultborder']['style']) ? $settings['defaultborder']['style'] : 'unset';
    $borderwidthtop = isset($settings['defaultborder']['width']['top']) ? $settings['defaultborder']['width']['top'] : 'unset';
    $borderwidthright = isset($settings['defaultborder']['width']['right']) ? $settings['defaultborder']['width']['right'] : 'unset';
    $borderwidthbottom = isset($settings['defaultborder']['width']['bottom']) ? $settings['defaultborder']['width']['bottom'] : 'unset';
    $borderwidthleft = isset($settings['defaultborder']['width']['left']) ? $settings['defaultborder']['width']['left'] : 'unset';
    $this->set_attribute( '_root', 'data-border-color', "$bordercolor");
    $this->set_attribute( '_root', 'data-border-top-radius', "$borderradiustop");
    $this->set_attribute( '_root', 'data-border-right-radius', "$borderradiusright");
    $this->set_attribute( '_root', 'data-border-bottom-radius', "$borderradiusbottom");
    $this->set_attribute( '_root', 'data-border-left-radius', "$borderradiusleft");
    $this->set_attribute( '_root', 'data-border-style', "$borderstyle");
    $this->set_attribute( '_root', 'data-border-top-width', "$borderwidthtop");
    $this->set_attribute( '_root', 'data-border-right-width', "$borderwidthright");
    $this->set_attribute( '_root', 'data-border-bottom-width', "$borderwidthbottom");
    $this->set_attribute( '_root', 'data-border-left-width', "$borderwidthleft");

    $defaultcursor = !empty($settings['defaultcursor']) ? $settings['defaultcursor'] : false;
    $defaultsize = !empty($settings['defaultsize']) ? $settings['defaultsize'] : 'scale(0.2)';
    $defaultactive = !empty($settings['defaultactive']) ? $settings['defaultactive'] : 'scale(0.5)';
    $defaultvisible = !empty($settings['defaultvisible']) ? $settings['defaultvisible'] : true;
    $defaultspeed = !empty($settings['defaultspeed']) ? $settings['defaultspeed'] : 0.55;
    $defaultskew = !empty($settings['defaultskew']) ? $settings['defaultskew'] : 0;
    $defaultease = !empty($settings['defaultease']) ? $settings['defaultease'] : 'expo.out';
    if ($defaultease === 'custom') {
      $defaultease = ! empty( $settings['customDefaultease'] ) ? $settings['customDefaultease'] : 'expo.out';
    }
    $defaultzindex = !empty($settings['defaultzindex']) ? $settings['defaultzindex'] : 99999;
    $defaulthide = !empty($settings['defaulthide']) ? $settings['defaulthide'] : true;
    $magnetics = ! empty( $settings['magnetic'] ) ? $settings['magnetic'] : false;
    $repels = ! empty( $settings['repel'] ) ? $settings['repel'] : false;
    $hiddens = ! empty( $settings['hidden'] ) ? $settings['hidden'] : false;
    $exclusions = ! empty( $settings['exclusion'] ) ? $settings['exclusion'] : false;
    $colors = ! empty( $settings['color'] ) ? $settings['color'] : false;
    $backdrops = ! empty( $settings['backdrop'] ) ? $settings['backdrop'] : false;
    $blurs = ! empty( $settings['blur'] ) ? $settings['blur'] : false;
    $skews = ! empty( $settings['skew'] ) ? $settings['skew'] : false;
    $borders = isset( $settings['border'] ) ? $settings['border'] : false;
    $sizes = ! empty( $settings['size'] ) ? $settings['size'] : false;
    $texts = ! empty( $settings['texto'] ) ? $settings['texto'] : false;
    $images = ! empty( $settings['image'] ) ? $settings['image'] : false;
    $stickdelta = !empty($settings['stickdelta']) ? $settings['stickdelta'] : 0.15;
    $sticks = ! empty( $settings['stick'] ) ? $settings['stick'] : false;

    $this->set_attribute( '_root', 'class', 'bc-cursor' );
    $this->set_attribute( '_root', 'data-defaultcursor', "$defaultcursor");
    $this->set_attribute( '_root', 'data-defaultcolor', "$defaultcolor");
    $this->set_attribute( '_root', 'data-defaultsize', "$defaultsize");
    $this->set_attribute( '_root', 'data-defaultactive', "$defaultactive");
    $this->set_attribute( '_root', 'data-defaultvisible', "$defaultvisible");
    $this->set_attribute( '_root', 'data-defaultspeed', "$defaultspeed");
    $this->set_attribute( '_root', 'data-defaultskew', "$defaultskew");
    $this->set_attribute( '_root', 'data-defaultease', "$defaultease");
    $this->set_attribute( '_root', 'data-defaultzindex', "$defaultzindex");
    $this->set_attribute( '_root', 'data-defaulthide', "$defaulthide");
    $this->set_attribute( '_root', 'data-stickdelta', "$stickdelta");

    $output = "<div {$this->render_attributes( '_root' )} >";

    if ($backdrops) {
      $output .= '<div class="bc-cursor__list-backdrops" data-clases="';
      foreach ( $backdrops as $backdrop ) {
        $output .= $backdrop['class'] . ' ';
      }
      $output .= '" data-backdrops="';
      foreach ( $backdrops as $backdrop ) {
        if ( isset($backdrop['backdrop']) ) {
          $output .= $backdrop['backdrop'] . ' ';
        }
        else{
          $output .= 'unset' . ' ';
        }
      }
      $output .= '"></div>';
    }
    if ($blurs) {
      $output .= '<div class="bc-cursor__list-blurs" data-clases="';
      foreach ( $blurs as $blur ) {
        $output .= $blur['class'] . ' ';
      }
      $output .= '" data-blurs="';
      foreach ( $blurs as $blur ) {
        if ( isset($blur['blur']) ) {
          $output .= $blur['blur'] . ' ';
        }
        else{
          $output .= 'unset' . ' ';
        }
      }
      $output .= '"></div>';
    }
    if ($images) {
      $output .= '<div class="bc-cursor__list-images" data-clases="';
      foreach ( $images as $image ) {
        $output .= $image['class'] . ' ';
      }
      $output .= '" data-images="';
      foreach ( $images as $image ) {
        if ( isset($image['image'])) {
          if ( isset($image['image']['mediaData']['url'])) {
            $last_image = $image['image']['mediaData']['url'];
            $output .= $last_image . 'd110777';
          }
          else if ( isset($image['image']['url'])) {
            $last_image = $image['image']['url'];
            $output .= $last_image . 'd110777';
          }
        }
        else{
          $output .= 'unset' . ' ';
        }
      }
      $output .= '"></div>';
    }
    if ($magnetics) {
      $output .= '<div class="bc-cursor__list-magnetics" data-clases="';
      foreach ( $magnetics as $magnetic ) {
        $output .= $magnetic['class'] . ' ';
      }
      $output .= '" data-speed="';
      foreach ( $magnetics as $magnetic ) {
        if ( isset($magnetic['speed'])) {
          $output .= $magnetic['speed'] . ' ';
        }
        else{
          $output .= '1' . ' ';
        }
      }
      $output .= '" data-intensity="';
      foreach ( $magnetics as $magnetic ) {
        if ( isset($magnetic['intensity'])) {
          $output .= $magnetic['intensity'] . ' ';
        }
        else{
          $output .= '1' . ' ';
        }
      }
      $output .= '"></div>';
    }
    if ($repels) {
      $output .= '<div class="bc-cursor__list-repels" data-clases="';
      foreach ( $repels as $repel ) {
        $output .= $repel['class'] . ' ';
      }
      $output .= '" data-speed="';
      foreach ( $repels as $repel ) {
        if ( isset($repel['speed'])) {
          $output .= $repel['speed'] . ' ';
        }
        else{
          $output .= '1' . ' ';
        }
      }
      $output .= '" data-intensity="';
      foreach ( $repels as $repel ) {
        if ( isset($repel['intensity'])) {
          $output .= $repel['intensity'] . ' ';
        }
        else{
          $output .= '1' . ' ';
        }
      }
      $output .= '"></div>';
    }
    if ($sticks) {
      $output .= '<div class="bc-cursor__list-sticks" data-fromclases="';
      foreach ( $sticks as $stick ) {
        $output .= $stick['fromclass'] . ' ';
      }
      $output .= '" data-toclases="';
      foreach ( $sticks as $stick ) {
        $output .= $stick['toclass'] . ' ';
      }
      $output .= '"></div>';
    }
    if ($hiddens) {
      $output .= '<div class="bc-cursor__list-hiddens" data-clases="';
      foreach ( $hiddens as $hidden ) {
        $output .= $hidden['class'] . ' ';
      }
      $output .= '"></div>';
    }
    if ($exclusions) {
      $output .= '<div class="bc-cursor__list-exclusions" data-clases="';
      foreach ( $exclusions as $exclusion ) {
        $output .= $exclusion['class'] . ' ';
      }
      $output .= '"></div>';
    }
    if ($colors) {
      $output .= '<div class="bc-cursor__list-colors" data-clases="';
      foreach ( $colors as $color ) {
        $output .= $color['class'] . ' ';
      }
      $output .= '" data-colors="';
      foreach ( $colors as $color ) {
        if ( isset($color['color']) && is_array($color['color']) && count($color['color']) > 0 ) {

        if (isset($color['color']['rgb'])) {
          $color_string = $color['color']['rgb'];
        } else if(isset($color['color']['raw'])){
          $color_string = $color['color']['raw'];
        }else {
          $color_string = $color['color']['hex'];
        }
        $output .= $color_string . 'd110777';
        }
        else{
          $output .= 'unset' . ' ';
        }
      }
      $output .= '"></div>';
    }
    if ($borders) {
      $output .= '<div class="bc-cursor__list-borders" data-clases="';
      foreach ( $borders as $border ) {
        $output .= $border['class'] . ' ';
      }
      $output .= '" data-borders="';
      foreach ( $borders as $border ) {
        if ( isset($border['border']) ) {
          /*border width*/
          if ( isset($border['border']['width']['top']) ){
            $output .= $border['border']['width']['top'] . ' ';
          }else{$output .= '0' . ' ';}
          if ( isset($border['border']['width']['right']) ){
            $output .= $border['border']['width']['right'] . ' ';
          }else{$output .= '0' . ' ';}
          if ( isset($border['border']['width']['bottom']) ){
            $output .= $border['border']['width']['bottom'] . ' ';
          }else{$output .= '0' . ' ';}
          if ( isset($border['border']['width']['left']) ){
            $output .= $border['border']['width']['left'] . ' ';
          }else{$output .= '0' . ' ';}

          /*style*/
          if ( isset($border['border']['style']) ){
            $output .= $border['border']['style'] . ' ';
          }else{$output .= 'unset' . ' ';}

          /*color*/
          if (isset($border['border']['color']['rgb'])) {
            $color_string = $border['border']['color']['rgb'];
          }else if(isset($border['border']['color']['raw'])){
            $color_string = $border['border']['color']['raw'];
          }else if(isset($border['border']['color']['hex'])){
            $color_string = $border['border']['color']['hex'];
          }else{
            $color_string = 'unset';
          }
          $output .= $color_string . ' ';

          /*border radius*/
          if ( isset($border['border']['radius']['top']) ){
            $output .= $border['border']['radius']['top'] . ' ';
          }else{$output .= 'auto' . ' ';}
          if ( isset($border['border']['radius']['right']) ){
            $output .= $border['border']['radius']['right'] . ' ';
          }else{$output .= 'auto' . ' ';}
          if ( isset($border['border']['radius']['bottom']) ){
            $output .= $border['border']['radius']['bottom'] . ' ';
          }else{$output .= 'auto' . ' ';}
          if ( isset($border['border']['radius']['left']) ){
            $output .= $border['border']['radius']['left'] . ' ';
          }else{$output .= 'auto' . ' ';}

          /*separación entre cada ajuste de border*/
          $output .= 'd110777' . ' ';
        }
        else{
          $output .= 'd110777' . ' ';
        }
      }
      $output .= '"></div>';
    }
    if ($skews) {
      $output .= '<div class="bc-cursor__list-skews" data-clases="';
      foreach ( $skews as $skew ) {
        $output .= $skew['class'] . ' ';
      }
      $output .= '" data-skews="';
      foreach ( $skews as $skew ) {
        if ( isset($skew['skew']) ) {
          $output .= $skew['skew'] . ' ';
        }
        else{
          $output .= 'unset' . ' ';
        }
      }
      $output .= '"></div>';
    }
    if ($sizes) {
      $output .= '<div class="bc-cursor__list-sizes" data-clases="';
      foreach ( $sizes as $size ) {
        $output .= $size['class'] . ' ';
      }
      $output .= '" data-sizes="';
      foreach ( $sizes as $size ) {
        if ( isset($size['size']) ) {
          $output .= $size['size'] . ' ';
        }
        else{
          $output .= 'unset' . ' ';
        }
      }
      $output .= '"></div>';
    }
    if ($texts) {
      $output .= '<div class="bc-cursor__list-texts" data-clases="';
      foreach ( $texts as $texto ) {
        $output .= $texto['class'] . ' ';
      }
      $output .= '" data-texts="';
      foreach ( $texts as $texto ) {
        if (isset($texto['texto'])) {
          $output .= $texto['texto'] . 'd110777';
        }
      }

      //Font family
      $output .= '" data-fontfamily="';
      foreach ( $texts as $texto ) {
        if (isset($texto['infontfamily']['font-family'])) {
          $font_family = $texto['infontfamily']['font-family'];
          
          // Check if it's a custom font
          if (strpos($font_family, 'custom_font_') === 0) {
              $font_id = intval(str_replace('custom_font_', '', $font_family));
              $font_name = get_the_title($font_id);
              $output .= $font_name . 'd110777';
          } else {
              $output .= $font_family . 'd110777';
          }
        } else if(isset($statecolordefaultfamily['font-family'])){
            $output .= $statecolordefaultfamily['font-family'] . 'd110777';
        } else {
            $output .= $statecolordefaultfamily . 'd110777';
        }
      }

      //Font color
      $output .= '" data-fontcolor="';
      foreach ( $texts as $texto ) {
        if (isset($texto['infontcolor']['rgb'])) {
          $fontcolor = $texto['infontcolor']['rgb'];
        }else if (isset($texto['infontcolor']['raw'])){
          $fontcolor = $texto['infontcolor']['raw'];
        }else if (isset($texto['infontcolor']['hex'])){
          $fontcolor = $texto['infontcolor']['hex'];
        }else if (isset($statecolordefaultcolor['rgb'])){
          $fontcolor = $statecolordefaultcolor['rgb'];
        }else if (isset($statecolordefaultcolor['raw'])){
          $fontcolor = $statecolordefaultcolor['raw'];
        }else if (isset($statecolordefaultcolor['hex'])){
          $fontcolor = $statecolordefaultcolor['hex'];
        }else{
          $fontcolor = $statecolordefaultcolor;
        }

        $output .= $fontcolor . 'd110777';
      }

      //Font size
      $output .= '" data-fontsize="';
      foreach ( $texts as $texto ) {
        if (isset($texto['infontsize'])) {
          $output .= $texto['infontsize'] . 'd110777';
        }else{
          $output .= $statecolordefaultsize . 'd110777';
        }
      }

      $output .= '"></div>';
    }

    $output .= '</div>';

		echo $output;
  }
}
