<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Decode_Hover extends \Bricks\Element {
  public $category     = 'Next Bricks - Texts';
  public $name         = 'decode-hover';
  public $icon         = 'ti-text';
  public $tag      = 'h3';
  public $css_selector = '';
  public $scripts      = ['decodehover'];

  public function get_label() {
    return esc_html__( 'Decode Hover', 'bricks' );
  }

  public function set_control_groups() {
    $this->control_groups['gradient'] = [
      'title' => esc_html__( 'Gradient', 'bricks' ),
      'tab'   => 'content',
    ];
  }

  public function set_controls() {
    $this->controls['inner_title'] = [
      'tab'            => 'content',
      'type'           => 'text',
	    'hasDynamicData' => 'text',
      'default'        => esc_html__( 'Decode Hover', 'bricks' ),
      'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['tag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'HTML tag', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'h1' => 'h1',
            'h2' => 'h2',
            'h3' => 'h3',
            'h4' => 'h4',
            'h5' => 'h5',
            'h6' => 'h6',
            'p' => 'p',
            'span' => 'span',
            'custom' => 'custom',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'h3',
        'default'     => 'h3',
    ];
    $this->controls['customTag'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Custom tag', 'bricks' ),
			'type'        => 'text',
			'inline'      => true,
			'placeholder' => 'h3',
			'required'    => [ 'tag', '=', 'custom' ],
    ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    $this->controls['styleSeparator'] = [
      'label'      => esc_html__( 'Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['titleTypography'] = [
      'tab'     => 'content',
      'label'   => esc_html__( 'Typography', 'bricks' ),
      'type'    => 'typography',
            'css'     => [
        [
          'property' => 'typography',
          'selector' => '.bc-decode-hover__element',
        ],
      ],
      'default' => [],
  ];
    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Animation', 'bricks' ),
        'type'       => 'separator',
    ];

    $this->controls['decodealphabet'] = [
      'hasDynamicData' => false,
      'tab'         => 'content',
      'label'       => esc_html__( 'Decode alphabet', 'bricks' ),
      'type' => 'textarea',
      'placeholder' => 'abcdefghijklmnopqrstuvwxyz1234567890!@#$^&*()…æ_+-=;[]/~`',
  ];
    $this->controls['from'] = [
        'hasDynamicData' => false,
        'tab'         => 'content',
        'label'       => esc_html__( 'From', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            '-1' => 'left',
            '1' => 'right',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'left',
    ];
    $this->controls['duration'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '20',
    ];
    $this->controls['delay'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Delay', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'placeholder' => '0.1s',
    ];
    $this->controls['ease'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP easing', 'bricks' ),
        'type' => 'select',
        'options'     => [
          'none' => 'none',
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps',
          'custom' => 'custom'
        ],
        'inline' => true,
        'placeholder' => 'power4',
    ];
    $this->controls['customEase'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'ease', '=', 'custom' ],
    ];


    //Gradient
  $this->controls['titleGradient'] = [
    'group' => 'gradient',
    'tab' => 'content',
    'type' => 'gradient',
    'css' => [
      [
        'property' => 'background-image',
        'selector' => '.bc-decode-hover__element',
      ],
    ],
    'default' => [
      'applyTo' => 'background',
      'gradientType' => 'linear',
      'colors' => [],
      'angle' => '0',
    ],
  ];

    //Padding from style tab applied to the root without link and to the link if exists
    $this->controls['_padding'] = [
      'tab'   => 'style',
      'group' => '_layout',
      'label' => esc_html__( 'Padding', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'padding',
          'selector' => '&:not(:has(> a)), > a',
        ]
      ],
      'default' => [
        'top'    => 0,
        'right'  => 0,
        'bottom' => 0,
        'left'   => 0,
      ],
    ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'bc_decode_hover', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_decode_hover.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Next Bricks';
    $delay    = ! empty( $settings['delay'] ) ? $settings['delay'] : 0.1;
    $duration    = ! empty( $settings['duration'] ) ? $settings['duration'] : 20;
    $ease    = ! empty( $settings['ease'] ) ? $settings['ease'] : 'power4';
    if ($ease === 'custom') {
      $ease = ! empty( $settings['customEase'] ) ? $settings['customEase'] : 'power4';
    }
    $from    = ! empty( $settings['from'] ) ? $settings['from'] : -1;
    $decodealphabet    = ! empty( $settings['decodealphabet'] ) ? $settings['decodealphabet'] : 'abcdefghijklmnopqrstuvwxyz1234567890!@#$^&*()…æ_+-=;[]/~`';

    $this->set_attribute( '_root', 'class', 'bc-decode-hover');

    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = 'span';
    }

    if($from == -1){
        $this->set_attribute( '_inner', 'data-from-left', '' );
    }else if($from == 1){
        $this->set_attribute( '_inner', 'data-from-right', '' );
    }
    
    $this->set_attribute( '_inner', 'class', 'bc-decode-hover__element' );
    $this->set_attribute( '_inner', 'data-delay', $delay );
    $this->set_attribute( '_inner', 'data-duration', $duration );
    $this->set_attribute( '_inner', 'data-ease', $ease );
    $this->set_attribute( '_inner', 'data-decodealphabet', $decodealphabet );
    
    if ( ! empty( $settings['link'] ) ) {
			$this->set_link_attributes( '_link', $settings['link'] );
      $output ="
      <{$this->tag} {$this->render_attributes( '_root' )}>
        <a class='bc-decode-hover__anchor' {$this->render_attributes( '_link' )}>
          <span {$this->render_attributes( '_inner' )}>$inner_title</span>
        </a>
      </{$this->tag}>
      ";
		}else{
      $output ="
      <{$this->tag} {$this->render_attributes( '_root' )}>
        <span {$this->render_attributes( '_inner' )}>$inner_title</span>
      </{$this->tag}>
      ";
    }

	echo $output;
  }
}
