<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Divider extends \Bricks\Element {
  public $category     = 'Next Bricks - Cores';
  public $name         = 'bc_divider';
  public $icon         = 'ti-layout-line-solid';
  public $scripts      = ['bc_divider'];

  public function get_label() {
    return esc_html__( 'Motion Divider', 'bricks' );
  }

  public function set_controls() {
    $this->controls['height'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Height', 'bricks' ),
        'type'  => 'number',
        'units'  => true,
        'css'   => [
            [
                'property' => '--height',
                'selector' => '.bc-divider__motion',
            ],
        ],
        'placeholder' => '1px',
        'default'     => '1px',
    ];
    $this->controls['width'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type'  => 'number',
        'units'  => true,
        'css'   => [
            [
                'property' => 'width',
                'selector' => '',
            ],
        ],
        'placeholder' => '100%',
        'default'     => '100%',
    ];

    $this->controls['type'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Type', 'bricks' ),
        'type' => 'select',
        'options'     => [
          'fromLeft' => 'fromLeft',
          'fromRight' => 'fromRight',
          'fromCenter' => 'fromCenter',
        ],
        'inline' => true,
        'placeholder' => 'fromLeft',
    ];

    $this->controls['style'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Style', 'bricks' ),
        'type'        => 'select',
        'options'     => $this->control_options['borderStyle'],
        'css'         => [
            [
                'property' => 'border-top-style',
                'selector' => '.bc-divider__motion',
            ],
        ],
        'inline'      => true,
        'placeholder' => esc_html__( 'Solid', 'bricks' ),
        'default'     => 'solid',
    ];

    $this->controls['color'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Color', 'bricks' ),
        'type'  => 'color',
        'css'   => [
            [
                'property' => 'border-top-color',
                'selector' => '.bc-divider__motion',
            ],
        ],
        'default' => [
          'hex' => '#000000',
        ],
    ];

    $this->controls['animation'] = [
        'label'      => esc_html__( 'Animation', 'bricks' ),
        'type'       => 'separator',
    ];
      
    $this->controls['duration'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'placeholder' => '0.6s',
    ];

    $this->controls['ease'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP easing', 'bricks' ),
        'type' => 'select',
        'options'     => [
          'none' => 'none',
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps',
          'custom' => 'custom'
        ],
        'inline' => true,
        'placeholder' => 'power1',
    ];
    $this->controls['customEase'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'ease', '=', 'custom' ],
    ];


    $this->controls['scrolltrigger'] = [
      'label'      => esc_html__( 'ScrollTrigger', 'bricks' ),
      'type'       => 'separator',
      'description' => sprintf(esc_html__( 'Scrolltrigger %s', 'bricks' ), '<a href="https://greensock.com/docs/v3/Plugins/ScrollTrigger" target="_blank">documentation</a>'),
    ];

    $this->controls['trigger'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Trigger', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => 'this',
    ];

    $this->controls['start'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Start', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => 'top bottom',
    ];

    $this->controls['end'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'End', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => 'unset',
    ];

    $this->controls['delay'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Delay', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '0.2',
    ];

    $this->controls['scrub'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Scrub', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => 'false',
    ];

    $this->controls['toggleActions'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'toggleActions', 'bricks' ),
        'type' => 'text',
        'placeholder' => 'play none none none',
    ];

    //Additional triggers
    $this->controls['triggerSeparator'] = [
        'label'      => esc_html__( 'Additional Triggers', 'bricks' ),
        'type'       => 'separator',
    ];

    $this->controls['animationType'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Trigger on', 'bricks' ),
        'type' => 'select',
        'options'     => [
            'Click' => 'Click',
            'Hover' => 'Hover',
        ],
        'inline' => true,
        'placeholder' => ' ',
    ];

    $this->controls['classTriggerClick'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Element', 'bricks' ),
        'type' => 'text',
        'placeholder' => '.className',
        'inline' => true,
        'required' => [ 'animationType', '=', 'Click'],
    ];
    $this->controls['classTriggerHover'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Element', 'bricks' ),
        'type' => 'text',
        'placeholder' => '.className',
        'inline' => true,
        'required' => [ 'animationType', '=', 'Hover'],
    ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'bc-divider', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_divider.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $start = ! empty( $settings['start'] ) ? $settings['start'] : 'top bottom';
    $end = ! empty( $settings['end'] ) ? $settings['end'] : 'unset';
    $duration = ! empty( $settings['duration'] ) ? $settings['duration'] : 0.6;
    $delay = ! empty( $settings['delay'] ) ? $settings['delay'] : 0.2;
    $trigger = ! empty( $settings['trigger'] ) ? $settings['trigger'] : 'this';
    $ease = ! empty( $settings['ease'] ) ? $settings['ease'] : 'power1';
    if ($ease === 'custom') {
      $ease = ! empty( $settings['customEase'] ) ? $settings['customEase'] : 'power1';
    }
    $scrub = ! empty( $settings['scrub'] ) ? $settings['scrub'] : 'false';
    $type = ! empty( $settings['type'] ) ? $settings['type'] : 'fromLeft';
    $width = ! empty( $settings['width'] ) ? $settings['width'] : '100%';
    $toggleActions = ! empty( $settings['toggleActions'] ) ? $settings['toggleActions'] : 'play none none none';

    $animationType    = ! empty( $settings['animationType'] ) ? $settings['animationType'] : '';
    $classTriggerClick    = ! empty( $settings['classTriggerClick'] ) ? $settings['classTriggerClick'] : 0;
    $classTriggerHover    = ! empty( $settings['classTriggerHover'] ) ? $settings['classTriggerHover'] : 0;

    $this->set_attribute( '_root', 'class', 'bc-divider' );

    $this->set_attribute( '_inner', 'class', 'bc-divider__motion' );
    $this->set_attribute( '_inner', 'data-end', $end);
    $this->set_attribute( '_inner', 'data-duration', $duration);
    $this->set_attribute( '_inner', 'data-delay', $delay);
    $this->set_attribute( '_inner', 'data-trigger', $trigger);
    $this->set_attribute( '_inner', 'data-ease', $ease);
    $this->set_attribute( '_inner', 'data-scrub', $scrub);
    $this->set_attribute( '_inner', 'data-type', $type);
    $this->set_attribute( '_inner', 'data-width', $width);
    $this->set_attribute( '_inner', 'data-toggleActions', "$toggleActions");

    $this->set_attribute( '_inner', 'data-animationType', $animationType);
    $this->set_attribute( '_inner', 'data-classTriggerClick', $classTriggerClick);
    $this->set_attribute( '_inner', 'data-classTriggerHover', $classTriggerHover);

    $output = "
    <div {$this->render_attributes( '_root' )}>
    <div {$this->render_attributes( '_inner' )}>
    </div>
    </div>";

	echo $output;
  }
}
