<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Flipbox extends \Bricks\Element {
    public $category     = 'Next Bricks - Cores';
    public $name         = 'flipbox';
    public $icon         = 'ti-layout-sidebar-right';
    public $scripts      = ['flipbox'];
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Flipbox', 'bricks' );
    }

    public function set_controls() {
        $this->controls['width'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css'     => [
              [
                  'property' => 'width',
                  'selector' => '',
              ],
            ],
            'placeholder' => '300px',
            'default' => '300px',
        ];
        $this->controls['height'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Height', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css'     => [
              [
                  'property' => '--height',
                  'selector' => '',
              ],
            ],
            'placeholder' => '300px',
            'rerender' => true,
            'default' => '300px',
        ];

        $this->controls['frontandback'] = [
            'label'      => esc_html__( 'Front & Back Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['padding'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Padding', 'bricks' ),
            'type'  => 'spacing',
            'css'     => [
              [
                  'property' => 'padding',
                  'selector' => '.bc-flipbox__flip',
              ],
            ],
        ];
        $this->controls['background'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Background', 'bricks' ),
            'type'  => 'background',
            'inline' => true,
            'css'     => [
              [
                  'property' => 'background',
                  'selector' => '.bc-flipbox__flip',
              ],
            ],
            'default' => [
                'color' => [
                    'hex' => '#ffffff',
                ],
            ],
        ];
        $this->controls['border'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Border', 'bricks' ),
            'type'  => 'border',
            'inline' => true,
            'css'     => [
              [
                  'property' => 'border',
                  'selector' => '.bc-flipbox__wrapper, .bc-flipbox__flip',
              ],
            ],
        ];
        $this->controls['boxShadow'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Box shadow', 'bricks' ),
            'type'  => 'box-shadow',
            'inline' => true,
            'css'     => [
              [
                  'property' => 'box-shadow',
                  'selector' => '.bc-flipbox__wrapper',
              ],
            ],
        ];

        $this->controls['animationSeparator'] = [
            'label'      => esc_html__( 'Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['type'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Type', 'bricks' ),
            'type'        => 'select',
            'options'     => [
              'horizontal' => 'horizontal',
              'horizontal-reverse' => 'horizontal-reverse',
              'vertical' => 'vertical',
              'vertical-reverse' => 'vertical-reverse',
            ],
            'inline'      => true,
            'placeholder' => 'horizontal',
            'default' => 'horizontal',
        ];
        $this->controls['trigger'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Trigger', 'bricks' ),
            'type'        => 'select',
            'options'     => [
              'hover' => 'hover',
              'click' => 'click',
            ],
            'inline'      => true,
            'placeholder' => 'hover',
            'default' => 'hover',
        ];
        $this->controls['perspective'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Perspective', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css'     => [
              [
                  'property' => 'perspective',
                  'selector' => '',
              ],
            ],
            'placeholder' => '800px',
            'default' => '800px',
        ];
        $this->controls['duration'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Duration', 'bricks' ),
            'type'  => 'number',
            'unit' => 's',
            'inline' => true,
            'css'     => [
              [
                  'property' => '--trans-duration',
                  'selector' => '.bc-flipbox__wrapper',
              ],
            ],
            'placeholder' => '1.3s',
            'default' => '1.3s',
        ];
        $this->controls['easing'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'CSS Easing', 'bricks' ),
            'type'  => 'text',
            'inline' => true,
            'css'     => [
              [
                  'property' => '--trans-easing',
                  'selector' => '.bc-flipbox__wrapper',
              ],
            ],
            'placeholder' => 'cubic-bezier(0.175, 0.885, 0.32, 1.275)',
            'default' => 'cubic-bezier(0.175, 0.885, 0.32, 1.275)',
        ];

        $this->controls['myscSeparator'] = [
            'label'      => esc_html__( 'Mysc', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['note'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Reset is to go from back to front after x seconds.', 'bricks' )))
        ];
        $this->controls['reset'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Reset', 'bricks' ),
            'type'  => 'checkbox',
            'default' => false,
        ];
        $this->controls['resetAfter'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Reset After', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'placeholder' => '5s',
            'required' => [ 'reset', '=', true ],
        ];
        $this->controls['note2'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Keep open is to keep the Flipbox opened when the next element clicked in the page is also a Flipbox.', 'bricks' ))),
            'required' => [ 'trigger', '=', 'click' ],
        ];
        $this->controls['keepOpen'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Keep open', 'bricks' ),
            'type'  => 'checkbox',
            'default' => false,
            'required' => [ 'trigger', '=', 'click' ],
        ];
    }

    /*Render children*/
    public function get_nestable_children() {
        return [
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Front', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'bc-flipbox__flip bc-flipbox__flip--front',
                    ],
                    '_attributes' => [
                        [
                        'name' => 'tabindex',
                        'value' => '0',
                        ],
                    ]
                ],
                'children' => [
                    [
                        'name'     => 'heading',
                        'label'    => esc_html__( 'Title', 'bricks' ),
                        'settings' => [
                            'text' => esc_html__( 'Flipbox', 'bricks' ),
                            'tag'  => 'h3',
                        ],
                    ],
                ],
            ],

            [
                'name'     => 'block',
                'label'    => esc_html__( 'Back', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'bc-flipbox__flip bc-flipbox__flip--back',
                    ],
                    '_attributes' => [
                        [
                        'name' => 'tabindex',
                        'value' => '0',
                        ],
                    ]
                ],
                'children' => [
                        [
                            'name'     => 'heading',
                            'label'    => esc_html__( 'Title', 'bricks' ),
                            'settings' => [
                                'text' => esc_html__( 'Flipbox', 'bricks' ),
                                'tag'  => 'h3',
                            ],
                        ],
                    ],
            ],
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'flipbox', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_flipbox.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $type    = ! empty( $settings['type'] ) ? $settings['type'] : 'horizontal';
        $trigger    = ! empty( $settings['trigger'] ) ? $settings['trigger'] : 'hover';
        $reset    = ! empty( $settings['reset'] ) ? $settings['reset'] : 0;
        $resetAfter    = ! empty( $settings['resetAfter'] ) ? $settings['resetAfter'] : '5s';
        $keepOpen    = ! empty( $settings['keepOpen'] ) ? $settings['keepOpen'] : 0;

        $this->set_attribute( '_root', 'class', "bc-flipbox");
        $this->set_attribute( '_inner', 'class', "bc-flipbox__wrapper");

        $innerDataAttr = '';
        if($type == 'horizontal'){
            $innerDataAttr = "data-x=''";
        }else if($type == 'horizontal-reverse'){
            $innerDataAttr = "data-x-reverse=''";
        }else if($type == 'vertical'){
            $innerDataAttr = "data-y=''";
        }else if($type == 'vertical-reverse'){
            $innerDataAttr = "data-y-reverse=''";
        }

        $output = "<div {$this->render_attributes( '_root' )}
        data-bc-hide=''
        data-trigger='{$trigger}'
        data-reset='{$reset}'
        data-reset-after='{$resetAfter}'
        data-keep-open='{$keepOpen}'>";
        $output .= "<div {$this->render_attributes( '_inner' )} {$innerDataAttr}>";
        $output .= Frontend::render_children( $this );
        $output .= "</div>";
        $output .= '</div>';

        echo $output;
    }
}