<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class B_Glitchy extends \Bricks\Element {
  public $category     = 'Next Bricks - Cores';
  public $name         = 'glitchy';
  public $icon         = 'fa-solid fa-bolt-lightning';
  public $scripts      = ['glitchy'];

  public function get_label() {
    return esc_html__( 'Glitchy', 'bricks' );
  }

  public function set_controls() {
    $this->controls['glitchyelements'] = [
      'tab'           => 'content',
      'type'          => 'repeater',
      'label'         => esc_html__( 'Glitchy elements', 'bricks' ),
      'placeholder'   => esc_html__( 'Glitchy element', 'bricks' ),
      'titleProperty' => 'title',
      'fields'        => [
        'class'       => [
          'type'    => 'text',
          'label'   => esc_html__( 'Element', 'bricks' ),
          'placeholder' => 'className',
        ],
        'playmode'       => [
          'label'   => esc_html__( 'Play mode', 'bricks' ),
          'type'        => 'select',
          'options'     => [
              'hover' => 'hover',
              'click' => 'click',
              'always' => 'always',
          ],
          'clearable'   => false,
          'inline'      => true,
          'placeholder' => 'hover',
        ],
        'duration'       => [
          'type'    => 'text',
          'type'  => 'number',
          'unit' => 'ms',
          'label'   => esc_html__( 'Animation duration', 'bricks' ),
          'placeholder' => '1000',
        ],
        'iteration'       => [
          'type'    => 'text',
          'label'   => esc_html__( 'Repeat number', 'bricks' ),
          'placeholder' => '15',
          'inline'      => true,
          'hasDynamicData' => false,
        ],
        'easing'       => [
          'type'    => 'text',
          'label'   => esc_html__( 'CSS Easing', 'bricks' ),
          'placeholder' => 'ease-in-out',
          'inline'      => true,
          'hasDynamicData' => false,
        ],
        'start'       => [
          'type'    => 'text',
          'label'   => esc_html__( 'Glitch time start', 'bricks' ),
          'placeholder' => '0.4',
          'inline'      => true,
          'hasDynamicData' => false,
        ],
        'end'       => [
          'type'    => 'text',
          'label'   => esc_html__( 'Glitch time end', 'bricks' ),
          'placeholder' => '0.7',
          'inline'      => true,
          'hasDynamicData' => false,
        ],
        'velocity'       => [
          'type'    => 'text',
          'label'   => esc_html__( 'Shake velocity', 'bricks' ),
          'placeholder' => '10',
          'inline'      => true,
          'hasDynamicData' => false,
        ],
        'amplitudex'       => [
          'type'    => 'text',
          'label'   => esc_html__( 'X amplitude', 'bricks' ),
          'placeholder' => '0.4',
          'inline'      => true,
          'hasDynamicData' => false,
        ],
        'amplitudey'       => [
          'type'    => 'text',
          'label'   => esc_html__( 'Y amplitude', 'bricks' ),
          'placeholder' => '0.4',
          'inline'      => true,
          'hasDynamicData' => false,
        ],
        'count'       => [
          'type'    => 'text',
          'label'   => esc_html__( 'Layers number', 'bricks' ),
          'placeholder' => '4',
          'inline'      => true,
          'hasDynamicData' => false,
        ],
        'velocitystep'       => [
          'type'    => 'text',
          'label'   => esc_html__( 'Steps number', 'bricks' ),
          'placeholder' => '10',
          'inline'      => true,
          'hasDynamicData' => false,
        ],
        'minheight'       => [
          'type'    => 'text',
          'label'   => esc_html__( 'minHeight per slice', 'bricks' ),
          'placeholder' => '0.02',
          'inline'      => true,
          'hasDynamicData' => false,
        ],
        'maxheight'       => [
          'type'    => 'text',
          'label'   => esc_html__( 'maxHeight per slice', 'bricks' ),
          'placeholder' => '0.40',
          'inline'      => true,
          'hasDynamicData' => false,
        ],
        'pulse'       => [
          'label'   => esc_html__( 'Final pulse', 'bricks' ),
          'type'        => 'select',
          'options'     => [
              '2' => 'true',
              '1' => 'false',
          ],
          'clearable'   => false,
          'inline'      => true,
          'placeholder' => 'true',
        ],
      ],
    ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'glitchy', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_glitchy.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);

    wp_enqueue_script( 'glitchy-js', NEXTBRICKS_PLUGIN_URL . 'local_assets/bc_powerglitch.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $glitchyelements = ! empty( $settings['glitchyelements'] ) ? $settings['glitchyelements'] : false;

    if ($glitchyelements) {
      echo '<div class="bc-list-glitchys" data-clases="';
      foreach ( $glitchyelements as $glitchyelement ) {
          if ( isset($glitchyelement['class'])) {
              echo $glitchyelement['class'] . 'd4511782';
          }
          else{
              echo 'unset' . 'd4511782';
          }
      }
      echo '" data-playmodes="';
      foreach ( $glitchyelements as $glitchyelement ) {
          if ( isset($glitchyelement['playmode'])) {
              echo $glitchyelement['playmode'] . 'd4511782';
          }
          else{
              echo 'hover' . 'd4511782';
          }
      }
      echo '" data-durations="';
      foreach ( $glitchyelements as $glitchyelement ) {
          if ( isset($glitchyelement['duration'])) {
              echo $glitchyelement['duration'] . 'd4511782';
          }
          else{
              echo '1000' . 'd4511782';
          }
      }
      echo '" data-iterations="';
      foreach ( $glitchyelements as $glitchyelement ) {
          if ( isset($glitchyelement['iteration'])) {
              echo $glitchyelement['iteration'] . 'd4511782';
          }
          else{
              echo '15' . 'd4511782';
          }
      }
      echo '" data-easings="';
      foreach ( $glitchyelements as $glitchyelement ) {
          if ( isset($glitchyelement['easing'])) {
              echo $glitchyelement['easing'] . 'd4511782';
          }
          else{
              echo 'ease-in-out' . 'd4511782';
          }
      }
      echo '" data-starts="';
      foreach ( $glitchyelements as $glitchyelement ) {
          if ( isset($glitchyelement['start'])) {
              echo $glitchyelement['start'] . 'd4511782';
          }
          else{
              echo '0.4' . 'd4511782';
          }
      }
      echo '" data-ends="';
      foreach ( $glitchyelements as $glitchyelement ) {
          if ( isset($glitchyelement['end'])) {
              echo $glitchyelement['end'] . 'd4511782';
          }
          else{
              echo '0.7' . 'd4511782';
          }
      }
      echo '" data-velocitys="';
      foreach ( $glitchyelements as $glitchyelement ) {
          if ( isset($glitchyelement['velocity'])) {
              echo $glitchyelement['velocity'] . 'd4511782';
          }
          else{
              echo '10' . 'd4511782';
          }
      }
      echo '" data-amplitudexs="';
      foreach ( $glitchyelements as $glitchyelement ) {
          if ( isset($glitchyelement['amplitudex'])) {
              echo $glitchyelement['amplitudex'] . 'd4511782';
          }
          else{
              echo '0.4' . 'd4511782';
          }
      }
      echo '" data-amplitudeys="';
      foreach ( $glitchyelements as $glitchyelement ) {
          if ( isset($glitchyelement['amplitudey'])) {
              echo $glitchyelement['amplitudey'] . 'd4511782';
          }
          else{
              echo '0.4' . 'd4511782';
          }
      }
      echo '" data-counts="';
      foreach ( $glitchyelements as $glitchyelement ) {
          if ( isset($glitchyelement['count'])) {
              echo $glitchyelement['count'] . 'd4511782';
          }
          else{
              echo '4' . 'd4511782';
          }
      }
      echo '" data-velocitysteps="';
      foreach ( $glitchyelements as $glitchyelement ) {
          if ( isset($glitchyelement['velocitystep'])) {
              echo $glitchyelement['velocitystep'] . 'd4511782';
          }
          else{
              echo '10' . 'd4511782';
          }
      }
      echo '" data-minheights="';
      foreach ( $glitchyelements as $glitchyelement ) {
          if ( isset($glitchyelement['minheight'])) {
              echo $glitchyelement['minheight'] . 'd4511782';
          }
          else{
              echo '0.02' . 'd4511782';
          }
      }
      echo '" data-maxheights="';
      foreach ( $glitchyelements as $glitchyelement ) {
          if ( isset($glitchyelement['maxheight'])) {
              echo $glitchyelement['maxheight'] . 'd4511782';
          }
          else{
              echo '0.40' . 'd4511782';
          }
      }
      echo '" data-pulses="';
      foreach ( $glitchyelements as $glitchyelement ) {
          if ( isset($glitchyelement['pulse'])) {
              echo $glitchyelement['pulse'] . 'd4511782';
          }
          else{
              echo '2' . 'd4511782';
          }
      }
      echo '"></div>';
  }
  }
}


