<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class B_Image_Reveal extends \Bricks\Element {
  public $category     = 'Next Bricks - Medias';
  public $name         = 'imagereveal';
  public $icon         = 'fa-solid fa-photo-film';
  public $scripts      = ['image_reveal'];

  public function get_label() {
    return esc_html__( 'Image Reveal', 'bricks' );
  }

  public function set_controls() {
    $this->controls['image'] = [
        'hasDynamicData' => true,
        'tab' => 'content',
        'label' => esc_html__( 'Image', 'bricks' ),
        'type' => 'image',
    ];
    $this->controls['alt'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Alt text', 'bricks' ),
      'type' => 'text',
      'inline' => true,
  ];
    $this->controls['_objectFit'] = [
      'label'   => esc_html__( 'Object fit', 'bricks' ),
      'type'    => 'select',
      'inline'  => true,
      'options' => $this->control_options['objectFit'],
      'css' => [
        [
          'property' => 'object-fit',
          'selector' => '.bc-img-reveal__img',
        ],
      ],
    ];
    $this->controls['_objectPosition'] = [
      'tab' => 'content',
      'label'  => esc_html__( 'Object position', 'bricks' ),
      'type'   => 'text',
      'inline' => true,
      'dd'     => false,
      'css' => [
        [
          'property' => 'object-position',
          'selector' => '.bc-img-reveal__img',
        ],
      ],
    ];
    $this->controls['imageFilters'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Filters', 'bricks' ),
      'type' => 'filters',
      'inline' => true,
      'css' => [
        [
          'property' => 'filter',
          'selector' => '.bc-img-reveal__img',
        ],
      ],
    ];
    $this->controls['width'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Width', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'inline' => true,
      'css' => [
        [
          'property' => 'width',
          'selector' => '', 
        ]
      ],
      'placeholder' => 'auto',
      'default' => 'fit-content',
  ];
    $this->controls['height'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Height', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'inline' => true,
      'css' => [
        [
          'property' => 'height',
          'selector' => '', 
        ]
      ],
      'placeholder' => 'auto',
      'default' => 'auto',
  ];

    $this->controls['animationSeparator'] = [
      'label'      => esc_html__( 'Animation', 'bricks' ),
      'type'       => 'separator',
    ];

    $this->controls['disablebuilder'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Disable at the builder', 'bricks' ),
      'type'     => 'checkbox',
      'default' => false,
    ];

    $this->controls['direction'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Direction', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'left' => 'left',
            'right' => 'right',
            'bottom' => 'bottom',
            'top' => 'top',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'left',
    ];
    $this->controls['scale'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Scale', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'css' => [
          [
            'property' => '--scale',
            'selector' => '.bc-img-reveal__element', 
          ]
        ],
        'placeholder' => '1.3',
        'default' => '1.3',
    ];
    $this->controls['duration'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '1.5',
    ];
    $this->controls['delay'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Delay', 'bricks' ),
      'type' => 'text',
      'inline' => true,
  ];
    $this->controls['ease'] = [
      'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP easing', 'bricks' ),
        'type' => 'select',
        'options'     => [
          'none' => 'none',
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps',
          'custom' => 'custom'
        ],
        'inline' => true,
        'placeholder' => 'sine',
    ];
    $this->controls['customEase'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'ease', '=', 'custom' ],
    ];


    $this->controls['scrolltrigger'] = [
      'label'      => esc_html__( 'ScrollTrigger', 'bricks' ),
      'type'       => 'separator',
      'description' => sprintf(esc_html__( 'Scrolltrigger %s', 'bricks' ), '<a href="https://greensock.com/docs/v3/Plugins/ScrollTrigger" target="_blank">documentation</a>'),
    ];

    $this->controls['trigger'] = [
      'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Trigger', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => 'this',
    ];

    $this->controls['start'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Start', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'top bottom',
    ];

    $this->controls['toggleActions'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'toggleActions', 'bricks' ),
      'type' => 'text',
      'placeholder' => 'play none none none',
    ];

    $this->controls['triggerSeparator'] = [
      'label'      => esc_html__( 'Additional Triggers', 'bricks' ),
      'type'       => 'separator',
    ];

    $this->controls['animationType'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Trigger on', 'bricks' ),
      'type' => 'select',
      'options'     => [
        'Click' => 'Click',
        'Hover' => 'Hover',
      ],
      'inline' => true,
      'placeholder' => ' ',
    ];

    $this->controls['removescroll'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Disable on scroll', 'bricks' ),
      'type'     => 'checkbox',
      'default' => false,
    ];
  
    $this->controls['classTriggerClick'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Element', 'bricks' ),
      'type' => 'text',
      'placeholder' => '.className',
      'inline' => true,
      'required' => [ 'animationType', '=', 'Click'],
    ];
    $this->controls['classTriggerHover'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Element', 'bricks' ),
      'type' => 'text',
      'placeholder' => '.className',
      'inline' => true,
      'required' => [ 'animationType', '=', 'Hover'],
    ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'imagereveal', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_image_reveal.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $disablebuilder    = ! empty( $settings['disablebuilder'] ) ? $settings['disablebuilder'] : 0;
    $removescroll    = ! empty( $settings['removescroll'] ) ? $settings['removescroll'] : 0;
    $animationType    = ! empty( $settings['animationType'] ) ? $settings['animationType'] : '';
    $classTriggerClick    = ! empty( $settings['classTriggerClick'] ) ? $settings['classTriggerClick'] : 0;
    $classTriggerHover    = ! empty( $settings['classTriggerHover'] ) ? $settings['classTriggerHover'] : 0;

    //Render dynamic data
    if (isset($settings['image']['useDynamicData'])){
      $last_image = $this->render_dynamic_data_tag($settings['image']['useDynamicData'], 'image');
      $last_image = wp_get_attachment_url($last_image[0]);

      $attachment_id = attachment_url_to_postid($last_image);
      $image_dimensions = wp_get_attachment_metadata($attachment_id);
      $width = $image_dimensions['width'];
      $height = $image_dimensions['height'];
    }
    //Render normal image
    else if (isset($settings['image'])) {
      $last_image = $settings['image']['url'];

      $image_dimensions = getimagesize($last_image);
      $width = $image_dimensions[0];
      $height = $image_dimensions[1];
    }
    //Render default
    else{
      $last_image = 'https://images.pexels.com/photos/17050728/pexels-photo-17050728/free-photo-of-madera-carretera-paisaje-agua.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=1';

      $image_dimensions = getimagesize($last_image);
      $width = $image_dimensions[0];
      $height = $image_dimensions[1];
    }
    if(!$image_dimensions){
      $width = 0;
      $height = 0;
    }

    $alt = !empty($settings['alt']) ? "alt='{$settings['alt']}'" : '';
    $direction    = ! empty( $settings['direction'] ) ? $settings['direction'] : 'left';
    $duration = ! empty( $settings['duration'] ) ? $settings['duration'] : 1.5;
    $delay = ! empty( $settings['delay'] ) ? $settings['delay'] : 0;
    $ease = ! empty( $settings['ease'] ) ? $settings['ease'] : "sine";
    if ($ease === 'custom') {
      $ease = ! empty( $settings['customEase'] ) ? $settings['customEase'] : 'sine';
    }
    $trigger = ! empty( $settings['trigger'] ) ? $settings['trigger'] : 'this';
    $start = ! empty( $settings['start'] ) ? $settings['start'] : 'top bottom';
    $toggleActions = ! empty( $settings['toggleActions'] ) ? $settings['toggleActions'] : 'play none none none';

    $this->set_attribute( '_root', 'class', 'bc-img-reveal' );

    $this->set_attribute( '_image', 'data-direction', "$direction" );
    $this->set_attribute( '_image', 'data-duration', "$duration");
    $this->set_attribute( '_image', 'data-delay', "$delay");
    $this->set_attribute( '_image', 'data-ease', "$ease");
    $this->set_attribute( '_image', 'data-trigger', "$trigger");
    $this->set_attribute( '_image', 'data-start', "$start");
    $this->set_attribute( '_image', 'data-toggleActions', "$toggleActions");

    $this->set_attribute( '_image', 'data-disable-builder', $disablebuilder);
    $this->set_attribute( '_image', 'data-animationType', $animationType);
    $this->set_attribute( '_image', 'data-remove-scroll', "$removescroll");
    $this->set_attribute( '_image', 'data-classTriggerClick', $classTriggerClick);
    $this->set_attribute( '_image', 'data-classTriggerHover', $classTriggerHover);


    $output = "<div {$this->render_attributes( '_root' )}>

        <div class='bc-img-reveal__element' {$this->render_attributes( '_image' )}>
            <img class='bc-img-reveal__img' src='$last_image' width='$width' height='$height' $alt>
        </div>";

    $output .= '</div>';

	echo $output;
  }
}