<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class B_Marquee extends Element {
  public $category     = 'Next Bricks - Cores';
  public $name         = 'marquee';
  public $icon         = 'fa-solid fa-pallet';
  public $scripts      = ['marquee'];
  public $nestable      = true;

public function get_label() {
    return esc_html__( 'Horizontal Marquee', 'bricks' );
}

public function set_controls() {
    $this->controls['note'] = [
        'tab' => 'content',
        'description' => sprintf(html_entity_decode(esc_html__( 'Drag & Drop elements inside the marquee.<br>If you leave marquee without elements you may need to reload changes.', 'bricks' )))
    ];

    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['marqueeWidth'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'css' => [
          [
            'property' => 'width',
            'selector' => '',
          ]
        ],
        'placeholder' => '100%',
    ];
    $this->controls['marqueeHeight'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Height', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'css' => [
          [
            'property' => 'height',
            'selector' => '',
          ]
        ],
        'placeholder' => 'auto',
    ];
    $this->controls['width'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Gap', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'inline' => true,
      'css' => [
        [
          'property' => 'width',
          'selector' => '.bc-reel__nestable',
        ]
      ],
      'placeholder' => '1px',
      'default' => '25%',
    ];
    $this->controls['rotation'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Rotate', 'bricks' ),
        'type'  => 'number',
        'unit' => 'deg',
        'inline' => true,
        'css' => [
          [
            'property' => '--rotate',
            'selector' => '',
          ]
        ],
        'placeholder' => '0deg',
        'default' => '0deg',
    ];
    $this->controls['blurEdges'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Blur edges', 'bricks' ),
        'type' => 'checkbox',
    ];
    $this->controls['edgesWidth'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Blur width', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'css' => [
          [
            'property' => ' --width',
            'selector' => '',
          ]
        ],
        'placeholder' => '25%',
        'required' => [ 'blurEdges', '=', true],
    ];
    $this->controls['edgesColor'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Blur color', 'bricks' ),
        'type'  => 'color',
        'css' => [
          [
            'property' => ' --color',
            'selector' => '',
          ]
        ],
        'required' => [ 'blurEdges', '=', true],
    ];

    //Default
    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['builderedit'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Disable at the builder', 'bricks' ),
      'type'     => 'checkbox',
    ];
    $this->controls['speed'] = [
          'hasDynamicData' => false,
          'tab' => 'content',
          'label' => esc_html__( 'Speed', 'bricks' ),
          'type' => 'text',
          'inline' => true,
          'placeholder' => '3',
    ];
    $this->controls['defaultloop'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Loop', 'bricks' ),
        'type' => 'checkbox',
        'inline' => true,
        'small' => true,
        'default' => true,
    ];
    $this->controls['defaultreverse'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Reverse', 'bricks' ),
        'type' => 'checkbox',
        'inline' => true,
        'small' => true,
        'default' => false,
    ];
    $this->controls['pauseonhover'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Pause on Hover', 'bricks' ),
        'type' => 'checkbox',
        'inline' => true,
        'small' => true,
        'default' => true,
    ];
    $this->controls['ease'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP easing', 'bricks' ),
        'type' => 'select',
        'options'     => [
          'none' => 'none',
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps',
          'custom' => 'custom'
        ],
        'inline' => true,
        'placeholder' => 'none',
    ];
    $this->controls['customEase'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'ease', '=', 'custom' ],
    ];


    //Scroller
    $this->controls['scrollerSeparator'] = [
        'label'      => esc_html__( 'Scroller', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['scroller'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Enable scroller', 'bricks' ),
        'type' => 'checkbox',
        'inline' => true,
        'small' => true,
        'default' => true,
    ];
    $this->controls['bothdirection'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Both directions', 'bricks' ),
        'type' => 'checkbox',
        'inline' => true,
        'small' => true,
        'default' => false,
        'required' => [ 'scroller', '=', true],
    ];
    $this->controls['scrollerspeed'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Speed', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '1',
        'required' => [ 'scroller', '=', true],
    ];
    $this->controls['multiplier'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Multiplier', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '0.5',
        'required' => [ 'scroller', '=', true],
    ];
    $this->controls['treshold'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Treshold', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '1',
        'required' => [ 'scroller', '=', true],
    ];
    $this->controls['scrollerease'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP easing', 'bricks' ),
        'type' => 'select',
        'options'     => [
          'none' => 'none',
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps',
          'custom' => 'custom'
        ],
        'inline' => true,
        'placeholder' => 'expo',
        'required' => [ 'scroller', '=', true],
    ];
    $this->controls['customScrollerease'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'scrollerease', '=', 'custom' ],
    ];


}

public function get_nestable_item() {
    return [
        'name'     => 'heading',
        'label'    => esc_html__( 'Title', 'bricks' ),
        'settings' => [
          'text' => esc_html__( 'Bricks', 'bricks' ),
          'tag'  => 'span',
          '_cssClasses' => 'bc-reel__example-heading',
        ],
    ];
}

public function get_nestable_children() {
    $children = [];

    for ( $i = 0; $i < 1; $i++ ) { /*Cantidad de item a generar*/
        $item = $this->get_nestable_item();

        // Replace {item_index} with $index
        $item       = json_encode( $item );
        $item       = str_replace( '{item_index}', $i + 1, $item );
        $item       = json_decode( $item, true );
        $children[] = $item;
    }

    return $children;
}


public function enqueue_scripts() {
    wp_enqueue_script( 'marquee', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_marquee.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);

    wp_enqueue_script( 'reeller-js', NEXTBRICKS_PLUGIN_URL . 'local_assets/bc_reeller.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
}

public function render() {
    $settings = $this->settings;
    $speed = ! empty( $settings['speed'] ) ? $settings['speed'] : 3;
    $defaultloop = ! empty( $settings['defaultloop'] ) ? $settings['defaultloop'] : false;
    $defaultreverse = ! empty( $settings['defaultreverse'] ) ? $settings['defaultreverse'] : false;
    $pauseonhover = ! empty( $settings['pauseonhover'] ) ? $settings['pauseonhover'] : false;
    $ease = ! empty( $settings['ease'] ) ? $settings['ease'] : 'none';
    if ($ease === 'custom') {
      $ease = ! empty( $settings['customEase'] ) ? $settings['customEase'] : 'none';
    }

    $scroller = ! empty( $settings['scroller'] ) ? $settings['scroller'] : false;
    $bothdirection = ! empty( $settings['bothdirection'] ) ? $settings['bothdirection'] : false;
    $scrollerspeed = ! empty( $settings['scrollerspeed'] ) ? $settings['scrollerspeed'] : 1;
    $multiplier = ! empty( $settings['multiplier'] ) ? $settings['multiplier'] : 0.5;
    $treshold = ! empty( $settings['treshold'] ) ? $settings['treshold'] : 1;
    $scrollerease = ! empty( $settings['scrollerease'] ) ? $settings['scrollerease'] : 'expo';
    if ($scrollerease === 'custom') {
      $scrollerease = ! empty( $settings['customScrollerease'] ) ? $settings['customScrollerease'] : 'expo';
    }

    $builderedit = ! empty( $settings['builderedit'] ) ? $settings['builderedit'] : 0;
    $blurEdges = ! empty( $settings['blurEdges'] ) ? $settings['blurEdges'] : 0;


    $this->set_attribute( '_root', 'class', 'bc-reel' );

    $this->set_attribute( 'inner_data', 'class', 'bc-reel__to-hide' );
    $this->set_attribute( 'inner_data', 'class', 'bc-reel__element' );
    $this->set_attribute( 'inner_data', 'data-speed-duration', "$speed");
    $this->set_attribute( 'inner_data', 'data-defaultloop', "$defaultloop");
    $this->set_attribute( 'inner_data', 'data-defaultreverse', "$defaultreverse");
    $this->set_attribute( 'inner_data', 'data-pauseonhover', "$pauseonhover");
    $this->set_attribute( 'inner_data', 'data-ease', "$ease");

    $this->set_attribute( 'inner_data', 'data-scroller', "$scroller");
    $this->set_attribute( 'inner_data', 'data-bothdirection', "$bothdirection");
    $this->set_attribute( 'inner_data', 'data-scrollerspeed', "$scrollerspeed");
    $this->set_attribute( 'inner_data', 'data-multiplier', "$multiplier");
    $this->set_attribute( 'inner_data', 'data-treshold', "$treshold");
    $this->set_attribute( 'inner_data', 'data-scrollerease', "$scrollerease");

    $this->set_attribute( 'inner_data', 'data-builderedit', $builderedit);
    $this->set_attribute( '_root', 'data-blur-edges', $blurEdges);


    $output = "<div {$this->render_attributes( '_root' )}>";

    $output .= "<div {$this->render_attributes( 'inner_data' )}>";
    $output .= "<div class='bc-reel__wrapper'>";
    $output .= "<div class='bc-reel__item'>";

    $output .= "<div class='bc-reel__nestable'></div>";
    // Render children elements (= individual items)
    $output .= Frontend::render_children( $this );

    $output .= "</div>";
    $output .= "</div>";
    $output .= "</div>";

    $output .= '</div>';

    echo $output;
}
}