<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class B_Marqueebutton extends \Bricks\Element {
  public $category     = 'Next Bricks - Buttons';
  public $name         = 'marqueebutton';
  public $icon         = 'fa-solid fa-square-minus';
  public $tag      = 'div';
  public $scripts      = ['marqueebutton'];

  public function get_label() {
    return esc_html__( 'Marquee Button', 'bricks' );
  }

  public function set_controls() {
    $this->controls['inner_title'] = [
      'tab'            => 'content',
      'type'           => 'text',
      'hasDynamicData' => 'text',
      'default'        => esc_html__( 'Marquee Button', 'bricks' ),
      'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
  ];
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'span' => 'span',
          'button' => 'button',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    $this->controls['iconsSeparator'] = [
      'label'      => esc_html__( 'Icons', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['includeLeftIcon'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Left Icon', 'bricks' ),
      'type' => 'checkbox',
      'default' => false,
    ];
    $this->controls['leftIcon'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Icon', 'bricks' ),
      'type' => 'icon',
      'css' => [
        [
          'selector' => '&{pseudo} .bc-marquee-button__left-icon',
        ],
      ],
      'required'   => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['leftIconMargin'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Margin', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'margin',
          'selector' => '&{pseudo} .bc-marquee-button__left-icon',
        ],
      ],
      'required' => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['leftIconSize'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Size', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'css'   => [
        [
          'property' => 'font-size',
          'selector' => '&{pseudo} .bc-marquee-button__left-icon',
        ],
      ],
      'required' => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['leftIconColor'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Color', 'bricks' ),
      'type'  => 'color',
      'css'   => [
        [
          'property' => 'color',
          'selector' => '&{pseudo} .bc-marquee-button__left-icon',
        ],
      ],
      'required' => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['includeRightIcon'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Right Icon', 'bricks' ),
      'type' => 'checkbox',
      'default' => false,
    ];
    $this->controls['rightIcon'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Icon', 'bricks' ),
      'type' => 'icon',
      'css' => [
        [
          'selector' => '&{pseudo} .bc-marquee-button__right-icon',
        ],
      ],
      'required'   => [ 'includeRightIcon', '=', true ],
    ];
    $this->controls['rightIconMargin'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Margin', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'margin',
          'selector' => '&{pseudo} .bc-marquee-button__right-icon',
        ],
      ],
      'required' => [ 'includeRightIcon', '=', true ],
    ];
    $this->controls['rightIconSize'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Size', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'css'   => [
        [
          'property' => 'font-size',
          'selector' => '&{pseudo} .bc-marquee-button__right-icon',
        ],
      ],
      'required' => [ 'includeRightIcon', '=', true ],
    ];
    $this->controls['rightIconColor'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Color', 'bricks' ),
      'type'  => 'color',
      'css'   => [
        [
          'property' => 'color',
          'selector' => '&{pseudo} .bc-marquee-button__right-icon',
        ],
      ],
      'required' => [ 'includeRightIcon', '=', true ],
    ];

    $this->controls['styleSeparator'] = [
      'label'      => esc_html__( 'Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['whitespace'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'White space', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'wrap' => 'wrap',
          'nowrap' => 'nowrap',
      ],
      'inline'      => true,
      'css'     => [
          [
            'property' => 'white-space',
            'selector' => '',
          ],
        ],
      'placeholder'        => 'wrap',
  ];
  $this->controls['buttonpadding'] = [
    'tab'         => 'content',
    'label'       => esc_html__( 'Padding', 'bricks' ),
    'type'        => 'spacing',
    'css'     => [
        [
          'property' => 'padding',
          'selector' => '',
        ],
      ],
      'placeholder' => [
        'top' => 20,
        'right' => 50,
        'bottom' => 20,
        'left' => 50,
      ],
      'default' => [
        'top' => '20px',
        'right' => '50px',
        'bottom' => '20px',
        'left' => '50px',
      ],
    ];
    $this->controls['buttontypography'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Typography', 'bricks' ),
        'type'        => 'typography',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'typography',
              'selector' => '',
            ],
          ],
    ];
    $this->controls['buttonbackground'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Background', 'bricks' ),
      'type'        => 'background',
      'inline'      => true,
      'css'     => [
          [
            'property' => 'background',
            'selector' => '',
          ],
        ],
      'default' => [
        'color' => [
          'hex' => '#ffffff',
        ],
      ],
    ];
  $this->controls['buttonborder'] = [
    'tab'         => 'content',
    'label'       => esc_html__( 'Border', 'bricks' ),
    'type'        => 'border',
    'inline'      => true,
    'css'     => [
        [
          'property' => 'border',
          'selector' => '',
        ],
      ],
    'default' => [
      'width' => [
        'top' => 1,
        'right' => 1,
        'bottom' => 1,
        'left' => 1,
      ],
      'style' => 'solid',
      'color' => [
        'hex' => '#c9c9c9',
      ],
      'radius' => [
        'top' => 15,
        'right' => 15,
        'bottom' => 15,
        'left' => 15,
      ],
    ],
  ];

  $this->controls['marqueeSeparator'] = [
    'label'      => esc_html__( 'Marquee', 'bricks' ),
    'type'       => 'separator',
  ];
  $this->controls['marquee_title'] = [
    'tab'            => 'content',
    'type'           => 'text',
    'hasDynamicData' => 'text',
    'default'        => esc_html__( 'Marquee Button', 'bricks' ),
    'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
];
    $this->controls['marqueerepeats'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Repeats', 'bricks' ),
        'type'        => 'number',
        'inline'      => true,
        'placeholder'    => esc_html__( '8', 'bricks' ),
    ];
    $this->controls['marqueepadding'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Units Gap', 'bricks' ),
        'type' => 'number',
        'units' => true,
        'css'     => [
            [
              'property' => 'gap',
              'selector' => '&{pseudo} .bc-marquee-button__units-wrapper',
            ],
          ],
          'placeholder' => '10px',
    ];
    $this->controls['animationduration'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Animation duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'animation-duration',
              'selector' => '&{pseudo} .bc-marquee-button__units-wrapper',
            ],
          ],
        'placeholder'    => esc_html__( '4s', 'bricks' ),
    ];
    $this->controls['marqueeReverse'] = [
        'hasDynamicData' => false,
        'tab'         => 'content',
        'label'       => esc_html__( 'Reverse', 'bricks' ),
        'type'        => 'checkbox',
        'inline'      => true,
        'default'     => false,
        'css'     => [
            [
              'property' => 'animation-direction',
              'selector' => '&{pseudo} .bc-marquee-button__units-wrapper',
              'value' => 'reverse',
            ],
          ],
    ];
    $this->controls['marqueetypography'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Typography', 'bricks' ),
        'type'        => 'typography',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'typography',
              'selector' => '&{pseudo} .bc-marquee-button__unit',
            ],
          ],
    ];

    $this->controls['marqueeIconsSeparator'] = [
      'label'      => esc_html__( 'Icons', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['marqueeIncludeLeftIcon'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Left Icon', 'bricks' ),
      'type' => 'checkbox',
      'default' => false,
    ];
    $this->controls['marqueeLeftIcon'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Icon', 'bricks' ),
      'type' => 'icon',
      'css' => [
        [
          'selector' => '&{pseudo} .bc-marquee-button__left-icon--marquee',
        ],
      ],
      'required'   => [ 'marqueeIncludeLeftIcon', '=', true ],
    ];
    $this->controls['marqueeLeftIconMargin'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Margin', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'margin',
          'selector' => '&{pseudo} .bc-marquee-button__left-icon--marquee',
        ],
      ],
      'required' => [ 'marqueeIncludeLeftIcon', '=', true ],
    ];
    $this->controls['marqueeLeftIconSize'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Size', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'css'   => [
        [
          'property' => 'font-size',
          'selector' => '&{pseudo} .bc-marquee-button__left-icon--marquee',
        ],
      ],
      'required' => [ 'marqueeIncludeLeftIcon', '=', true ],
    ];
    $this->controls['marqueeLeftIconColor'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Color', 'bricks' ),
      'type'  => 'color',
      'css'   => [
        [
          'property' => 'color',
          'selector' => '&{pseudo} .bc-marquee-button__left-icon--marquee',
        ],
      ],
      'required' => [ 'marqueeIncludeLeftIcon', '=', true ],
    ];
    $this->controls['marqueeIncludeRightIcon'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Right Icon', 'bricks' ),
      'type' => 'checkbox',
      'default' => false,
    ];
    $this->controls['marqueeRightIcon'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Icon', 'bricks' ),
      'type' => 'icon',
      'css' => [
        [
          'selector' => '&{pseudo} .bc-marquee-button__right-icon--marquee',
        ],
      ],
      'required'   => [ 'marqueeIncludeRightIcon', '=', true ],
    ];
    $this->controls['marqueeRightIconMargin'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Margin', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'margin',
          'selector' => '&{pseudo} .bc-marquee-button__right-icon--marquee',
        ],
      ],
      'required' => [ 'marqueeIncludeRightIcon', '=', true ],
    ];
    $this->controls['marqueeRightIconSize'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Size', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'css'   => [
        [
          'property' => 'font-size',
          'selector' => '&{pseudo} .bc-marquee-button__right-icon--marquee',
        ],
      ],
      'required' => [ 'marqueeIncludeRightIcon', '=', true ],
    ];
    $this->controls['marqueeRightIconColor'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Color', 'bricks' ),
      'type'  => 'color',
      'css'   => [
        [
          'property' => 'color',
          'selector' => '&{pseudo} .bc-marquee-button__right-icon--marquee',
        ],
      ],
      'required' => [ 'marqueeIncludeRightIcon', '=', true ],
    ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'marqueebutton', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_marquee_button.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Next Bricks';
    $marquee_title    = ! empty( $settings['marquee_title'] ) ? $settings['marquee_title'] : $inner_title;
    $marqueerepeats    = ! empty( $settings['marqueerepeats'] ) ? $settings['marqueerepeats'] : 8;

    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = $this->tag;
    }

    if (is_rtl()) { // RTL
      $this->set_attribute('_root', 'class', 'bc-marquee-button--rtl');
    }
    $this->set_attribute( '_root', 'class', 'bc-marquee-button' );

    $includeLeftIcon = ! empty( $settings['includeLeftIcon'] ) ? $settings['includeLeftIcon'] : 0;
    $includeRightIcon = ! empty( $settings['includeRightIcon'] ) ? $settings['includeRightIcon'] : 0;
    if ( $includeLeftIcon !== 0 ) {
      $leftIcon = self::render_icon( $settings['leftIcon'], [ 'bc-marquee-button__left-icon' ] );
    }else{
      $leftIcon = '';
    }
    if ( $includeRightIcon !== 0 ) {
      $rightIcon = self::render_icon( $settings['rightIcon'], [ 'bc-marquee-button__right-icon' ] );
    }else{
      $rightIcon = '';
    }

    $marqueeIncludeLeftIcon = ! empty( $settings['marqueeIncludeLeftIcon'] ) ? $settings['marqueeIncludeLeftIcon'] : 0;
    $marqueeIncludeRightIcon = ! empty( $settings['marqueeIncludeRightIcon'] ) ? $settings['marqueeIncludeRightIcon'] : 0;
    if ( $marqueeIncludeLeftIcon !== 0 ) {
      $marqueeLeftIcon = self::render_icon( $settings['marqueeLeftIcon'], [ 'bc-marquee-button__left-icon--marquee' ] );
    }else{
      $marqueeLeftIcon = '';
    }
    if ( $marqueeIncludeRightIcon !== 0 ) {
      $marqueeRightIcon = self::render_icon( $settings['marqueeRightIcon'], [ 'bc-marquee-button__right-icon--marquee' ] );
    }else{
      $marqueeRightIcon = '';
    }

    $output = "
    <$root_tag {$this->render_attributes( '_root' )}>
      <span class='bc-marquee-button__title'>$leftIcon$inner_title$rightIcon</span>
      <div class='bc-marquee-button__marquee' aria-hidden='true'>
        <div class='bc-marquee-button__units-wrapper'>";

        for ($i = 0; $i < $marqueerepeats; $i++) {
            $output .= "<span class='bc-marquee-button__unit'>$marqueeLeftIcon$marquee_title$marqueeRightIcon</span>";
        }

        $output .= "
        </div>
      </div>
    </$root_tag>
    ";

	echo $output;
  }
}



