<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Media extends \Bricks\Element {
  public $category     = 'Next Bricks - Medias';
  public $name         = 'bc_media';
  public $icon         = 'fas fa-circle-play';
  public $scripts      = ['bc_media'];

  public function get_label() {
    return esc_html__( 'Media', 'bricks' );
  }

  public function set_control_groups() {
    $this->control_groups['settingsGroup'] = [
        'title' => esc_html__( 'Settings', 'bricks' ),
        'tab'   => 'content',
    ];
    $this->control_groups['posterGroup'] = [
        'title' => esc_html__( 'Poster', 'bricks' ),
        'tab'   => 'content',
    ];
    $this->control_groups['sourcesGroup'] = [
        'title' => esc_html__( 'Sources', 'bricks' ),
        'tab'   => 'content',
    ];
    $this->control_groups['accesibilityGroup'] = [
        'title' => esc_html__( 'Accesibility', 'bricks' ),
        'tab'   => 'content',
    ];
    $this->control_groups['styleGroup'] = [
        'title' => esc_html__( 'Style', 'bricks' ),
        'tab'   => 'content',
    ];
  }

  public function set_controls() {
    $this->controls['videoType'] = [
        'tab'       => 'content',
        'label'     => esc_html__( 'Source', 'bricks' ),
        'type'      => 'select',
        'options'   => [
            'media'   => esc_html__( 'Media', 'bricks' ),
            'file'    => esc_html__( 'File URL', 'bricks' ),
            'meta'    => esc_html__( 'Dynamic Data', 'bricks' ),
        ],
        'default'   => 'media',
        'inline'    => true,
        'clearable' => false,
    ];
    $this->controls['media'] = [
        'tab'      => 'content',
        'label'    => esc_html__( 'Media', 'bricks' ),
        'type'     => 'video',
        'required' => [ 'videoType', '=', 'media' ],
    ];
    $this->controls['fileUrl'] = [
        'tab'      => 'content',
        'label'    => esc_html__( 'Video file URL', 'bricks' ),
        'type'     => 'text',
        'required' => [ 'videoType', '=', 'file' ],
    ];
    $this->controls['useDynamicData'] = [
        'tab'            => 'content',
        'label'          => '',
        'type'           => 'text',
        'placeholder'    => esc_html__( 'Select dynamic data', 'bricks' ),
        'hasDynamicData' => 'link',
        'required'       => [ 'videoType', '=', 'meta' ],
    ];
    $this->controls['streamType'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Stream type', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'on-demand' => 'on-demand',
            'live' => 'live',
            'live:dvr' => 'live:dvr',
            'll-live' => 'll-live',
            'll-live:dvr' => 'll-live:dvr',
        ],
        'inline' => true,
        'placeholder' => 'on-demand',
    ];

    //Inline
    $this->controls['emptySeparator0'] = [
        'type'       => 'info',
        'group'   => 'settingsGroup',
    ];
    $this->controls['title'] = [
        'hasDynamicData' => true,
        'tab' => 'content',
        'label'    => esc_html__( 'Title (aria-label)', 'bricks' ),
        'type'     => 'text',
        'placeholder'     => 'Sprite Fight',
        'group'   => 'settingsGroup',
    ];
    $this->controls['muted'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Muted', 'bricks' ),
        'type'     => 'checkbox',
        'group'   => 'settingsGroup',
        'reloadScripts' => true,
    ];
    $this->controls['autoplay'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Autoplay', 'bricks' ),
        'type'     => 'checkbox',
        'group'   => 'settingsGroup',
    ];
    $this->controls['playsinline'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Playsinline', 'bricks' ),
        'type'     => 'checkbox',
        'group'   => 'settingsGroup',
    ];
    $this->controls['loop'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Loop', 'bricks' ),
        'type'     => 'checkbox',
        'group'   => 'settingsGroup',
    ];
    $this->controls['hide-controls'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Hide controls', 'bricks' ),
        'type'     => 'checkbox',
        'group'   => 'settingsGroup',
    ];
    $this->controls['hide-controls-on-mouse-leave'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Hide controls on mouse leave', 'bricks' ),
        'type'     => 'checkbox',
        'group'   => 'settingsGroup',
    ];
    $this->controls['storageKey'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( "Save data on user's browser", 'bricks' ),
        'type'     => 'checkbox',
        'group'   => 'settingsGroup',
    ];

    //Timing
    $this->controls['timingSeparator'] = [
        'label'      => esc_html__( 'Time', 'bricks' ),
        'type'       => 'separator',
        'group'   => 'settingsGroup',
    ];
    $this->controls['playbackRate'] = [
        'hasDynamicData' => true,
        'tab' => 'content',
        'label'    => esc_html__( 'Playback rate', 'bricks' ),
        'type'     => 'text',
        'placeholder'     => '1',
        'inline' => true,
        'group'   => 'settingsGroup',
    ];
    $this->controls['clipStartTime'] = [
        'hasDynamicData' => true,
        'tab' => 'content',
        'label'    => esc_html__( 'Clip start time', 'bricks' ),
        'type'     => 'text',
        'placeholder'     => '',
        'inline' => true,
        'group'   => 'settingsGroup',
    ];
    $this->controls['clipEndTime'] = [
        'hasDynamicData' => true,
        'tab' => 'content',
        'label'    => esc_html__( 'Clip end time', 'bricks' ),
        'type'     => 'text',
        'placeholder'     => '',
        'inline' => true,
        'group'   => 'settingsGroup',
    ];

    //Loading
    $this->controls['loadingSeparator'] = [
        'label'      => esc_html__( 'Loading', 'bricks' ),
        'type'       => 'separator',
        'group'   => 'settingsGroup',
    ];
    $this->controls['load'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Load', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'eager' => 'eager',
            'visible' => 'visible',
            'play' => 'play',
        ],
        'inline' => true,
        'placeholder' => 'visible',
        'group'   => 'settingsGroup',
    ];

    //Thumbnails
    $this->controls['thumbnailsSeparator'] = [
        'label'      => esc_html__( 'Thumbnails', 'bricks' ),
        'type'       => 'separator',
        'group'   => 'settingsGroup',
    ];
    $this->controls['note1'] = [
        'tab' => 'content',
        'description' => sprintf(html_entity_decode(esc_html__( 'Here you can set the thumbnails file for your video. It must have .vtt extension.', 'bricks' ))),
        'group' => 'settingsGroup',
    ];
    $this->controls['enableThumbnails'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Enable', 'bricks' ),
        'type'     => 'checkbox',
        'group' => 'settingsGroup',
        'default' => true,
    ];
    $this->controls['thumbnails'] = [
        'hasDynamicData' => true,
        'tab' => 'content',
        'label'    => esc_html__( 'File URL', 'bricks' ),
        'type'     => 'text',
        'placeholder'     => 'https://files.vidstack.io/sprite-fight/thumbnails.vtt',
        'group'   => 'settingsGroup',
        'required' => [ 'enableThumbnails', '=', true],
    ];

    //Poster
    $this->controls['posterImage'] = [
        'label'   => esc_html__( 'Image', 'bricks' ),
        'type'    => 'image',
        'group'   => 'posterGroup',
    ];
    $this->controls['posterAlt'] = [
        'hasDynamicData' => true,
        'tab' => 'content',
        'label'    => esc_html__( 'Alt', 'bricks' ),
        'type'     => 'text',
        'placeholder'     => '',
        'inline' => true,
        'group'   => 'posterGroup',
    ];
    $this->controls['posterLoad'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Poster load', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'eager' => 'eager',
            'visible' => 'visible',
        ],
        'inline' => true,
        'placeholder' => 'visible',
        'group'   => 'posterGroup',
    ];

    //Sources group
    $this->controls['note2'] = [
        'tab' => 'content',
        'description' => sprintf(html_entity_decode(esc_html__( 'Provide video qualities/resolutions using multiple video files with different sizes (e.g: 1080p, 720p, 480p)', 'bricks' ))),
        'group' => 'sourcesGroup',
    ];
    $this->controls['sources'] = [
        'tab'           => 'content',
        'type'          => 'repeater',
        'label'         => esc_html__( 'Sources', 'bricks' ),
        'group' => 'sourcesGroup',
        'titleProperty' => 'title',
        'fields'        => [
            'src'       => [
                'type'    => 'text',
                'label'   => esc_html__( 'Video file URL', 'bricks' ),
                'placeholder' => 'https://files.vidstack.io/sprite-fight/1080p.mp4',
            ],
            'type'       => [
                'type'    => 'text',
                'label'   => esc_html__( 'Type', 'bricks' ),
                'inline'      => true,
                'placeholder' => 'video/mp4',
            ],
            'width'       => [
                'type'    => 'text',
                'label'   => esc_html__( 'Width', 'bricks' ),
                'inline'      => true,
                'placeholder'    => '1920',
            ],
            'height'       => [
                'type'    => 'text',
                'label'   => esc_html__( 'Height', 'bricks' ),
                'inline'      => true,
                'placeholder'    => '1080',
            ],
        ],
    ];

    //Accesibility
    $this->controls['emptySeparator1'] = [
        'type'       => 'info',
        'group'   => 'accesibilityGroup',
    ];
    $this->controls['togglePaused'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Toggle paused', 'bricks' ),
        'type'     => 'text',
        'placeholder'     => 'k Space',
        'inline' => true,
        'group'   => 'accesibilityGroup',
    ];
    $this->controls['toggleMuted'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Toggle muted', 'bricks' ),
        'type'     => 'text',
        'placeholder'     => 'm',
        'inline' => true,
        'group'   => 'accesibilityGroup',
    ];
    $this->controls['toggleFullscreen'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Toggle fullscreen', 'bricks' ),
        'type'     => 'text',
        'placeholder'     => 'f',
        'inline' => true,
        'group'   => 'accesibilityGroup',
    ];
    $this->controls['togglePictureInPicture'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Toggle picture in picture', 'bricks' ),
        'type'     => 'text',
        'placeholder'     => 'i',
        'inline' => true,
        'group'   => 'accesibilityGroup',
    ];
    $this->controls['toggleCaptions'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Toggle captions', 'bricks' ),
        'type'     => 'text',
        'placeholder'     => 'c',
        'inline' => true,
        'group'   => 'accesibilityGroup',
    ];
    $this->controls['seekBackward'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Seek backward', 'bricks' ),
        'type'     => 'text',
        'placeholder'     => 'ArrowLeft',
        'inline' => true,
        'group'   => 'accesibilityGroup',
    ];
    $this->controls['seekForward'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Seek forward', 'bricks' ),
        'type'     => 'text',
        'placeholder'     => 'ArrowRight',
        'inline' => true,
        'group'   => 'accesibilityGroup',
    ];
    $this->controls['volumeUp'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Volume up', 'bricks' ),
        'type'     => 'text',
        'placeholder'     => 'ArrowUp',
        'inline' => true,
        'group'   => 'accesibilityGroup',
    ];
    $this->controls['volumeDown'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Volume down', 'bricks' ),
        'type'     => 'text',
        'placeholder'     => 'ArrowDown',
        'inline' => true,
        'group'   => 'accesibilityGroup',
    ];
    $this->controls['speedUp'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Speed up', 'bricks' ),
        'type'     => 'text',
        'placeholder'     => '>',
        'inline' => true,
        'group'   => 'accesibilityGroup',
    ];
    $this->controls['slowDown'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Slow down', 'bricks' ),
        'type'     => 'text',
        'placeholder'     => '<',
        'inline' => true,
        'group'   => 'accesibilityGroup',
    ];

    //Style
    $this->controls['emptySeparator2'] = [
        'type'       => 'info',
        'group'   => 'styleGroup',
    ];
    $this->controls['width'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type'  => 'number',
        'units'  => true,
        'css'   => [
            [
                'property' => '--width',
                'selector' => '',
            ],
        ],
        'placeholder' => '600px',
        'group'   => 'styleGroup',
    ];
    $this->controls['height'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Height', 'bricks' ),
        'type'  => 'number',
        'units'  => true,
        'css'   => [
            [
                'property' => '--height',
                'selector' => '',
            ],
        ],
        'placeholder' => '100%',
        'group'   => 'styleGroup',
    ];
    $this->controls['background'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Background', 'bricks' ),
        'type'  => 'background',
        'css'   => [
            [
                'property' => '--video-bg',
                'selector' => '&, .vds-poster, media-provider',
            ],
        ],
        'group'   => 'styleGroup',
    ];
    $this->controls['border'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Border', 'bricks' ),
        'type'  => 'border',
        'css'   => [
            [
                'property' => 'border',
                'selector' => '',
            ],
        ],
        'group'   => 'styleGroup',
    ];
    $this->controls['entranceDuration'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Controls opacity duration', 'bricks' ),
        'type'  => 'number',
        'unit'  => 's',
        'css'   => [
            [
                'property' => '--media-controls-entrance-duration',
                'selector' => '.vds-video-layout',
            ],
        ],
        'placeholder' => '0.2s',
        'group'   => 'styleGroup',
    ];
    //Buttons style
    $this->controls['buttonsStyleSeparator'] = [
        'label'      => esc_html__( 'Buttons', 'bricks' ),
        'type'       => 'separator',
        'group'   => 'styleGroup',
    ];
    $this->controls['buttonsStyleBackground'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Color', 'bricks' ),
        'type'  => 'color',
        'css'   => [
            [
                'property' => '--media-controls-color',
                'selector' => '.vds-video-layout',
            ],
        ],
        'group'   => 'styleGroup',
    ];
    $this->controls['buttonsStyleBorder'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Border', 'bricks' ),
        'type'  => 'border',
        'css'   => [
            [
                'property' => 'border',
                'selector' => '.vds-button',
            ],
        ],
        'group'   => 'styleGroup',
    ];
    $this->controls['buttonsStyleSize'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Size', 'bricks' ),
        'type'  => 'number',
        'units'  => true,
        'css'   => [
            [
                'property' => '--media-button-size',
                'selector' => '.vds-button',
            ],
        ],
        'placeholder' => '40px',
        'group'   => 'styleGroup',
    ];
    $this->controls['buttonsStylePlayBackground'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Play button background', 'bricks' ),
        'type'  => 'color',
        'css'   => [
            [
                'property' => '--video-sm-play-button-bg',
                'selector' => '.vds-video-layout',
            ],
        ],
        'group'   => 'styleGroup',
    ];
    //Menu settings style
    $this->controls['menuSettingsStyleSeparator'] = [
        'label'      => esc_html__( 'Menu settings', 'bricks' ),
        'type'       => 'separator',
        'group'   => 'styleGroup',
    ];
    $this->controls['colorScheme'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Color scheme', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'light' => 'light',
            'dark' => 'dark',
            'system' => 'system',
        ],
        'inline' => true,
        'placeholder' => 'system',
        'group'   => 'styleGroup',
    ];
    //Time style
    $this->controls['timeStyleSeparator'] = [
        'label'      => esc_html__( 'Time', 'bricks' ),
        'type'       => 'separator',
        'group'   => 'styleGroup',
    ];
    $this->controls['timeTypography'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Typography', 'bricks' ),
        'type'  => 'typography',
        'css'   => [
            [
                'property' => 'typography',
                'selector' => '.vds-video-layout .vds-time, .vds-video-layout .vds-time-divider',
            ],
        ],
        'group'   => 'styleGroup',
    ];
    $this->controls['timeDividerGap'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Divider gap', 'bricks' ),
        'type'  => 'number',
        'units'  => true,
        'css'   => [
            [
                'property' => '--media-time-divider-gap',
                'selector' => '.vds-video-layout',
            ],
        ],
        'placeholder' => '2.5px',
        'group'   => 'styleGroup',
    ];
    //Thumbnails style
    $this->controls['thumbnailsStyleSeparator'] = [
        'label'      => esc_html__( 'Thumbnails', 'bricks' ),
        'type'       => 'separator',
        'group'   => 'styleGroup',
    ];
    $this->controls['thumbnailsBackground'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Background', 'bricks' ),
        'type'  => 'color',
        'css'   => [
            [
                'property' => '--media-thumbnail-bg',
                'selector' => '.vds-video-layout',
            ],
        ],
        'group'   => 'styleGroup',
    ];
    $this->controls['thumbnailsBackground'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Background', 'bricks' ),
        'type'  => 'color',
        'css'   => [
            [
                'property' => '--media-thumbnail-bg',
                'selector' => '.vds-video-layout',
            ],
        ],
        'group'   => 'styleGroup',
    ];
    $this->controls['thumbnailsMinWidth'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Min width', 'bricks' ),
        'type'  => 'number',
        'units'  => true,
        'css'   => [
            [
                'property' => '--media-thumbnail-min-width',
                'selector' => '.vds-video-layout',
            ],
        ],
        'placeholder' => '120px',
        'group'   => 'styleGroup',
    ];
    $this->controls['thumbnailsMaxWidth'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Max width', 'bricks' ),
        'type'  => 'number',
        'units'  => true,
        'css'   => [
            [
                'property' => '--media-thumbnail-max-width',
                'selector' => '.vds-video-layout',
            ],
        ],
        'placeholder' => '180px',
        'group'   => 'styleGroup',
    ];
    $this->controls['thumbnailsBorder'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Border', 'bricks' ),
        'type'  => 'border',
        'css'   => [
            [
                'property' => 'border',
                'selector' => '.vds-thumbnail',
            ],
        ],
        'group'   => 'styleGroup',
    ];
    //Live style
    $this->controls['liveStyleSeparator'] = [
        'label'      => esc_html__( 'Live', 'bricks' ),
        'type'       => 'separator',
        'group'   => 'styleGroup',
        'required' => [ 'streamType', '!=', 'on-demand'],
    ];
    $this->controls['liveStyleTypography'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Typography', 'bricks' ),
        'type'  => 'typography',
        'css'   => [
            [
                'property' => 'typography',
                'selector' => '.vds-live-button-text',
            ],
        ],
        'group'   => 'styleGroup',
        'required' => [ 'streamType', '!=', 'on-demand'],
    ];
    $this->controls['liveStyleBackground'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Background', 'bricks' ),
        'type'  => 'color',
        'css'   => [
            [
                'property' => '--media-live-button-edge-bg',
                'selector' => '.vds-video-layout',
            ],
        ],
        'group'   => 'styleGroup',
        'required' => [ 'streamType', '!=', 'on-demand'],
    ];
    $this->controls['liveStyleBorder'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Border', 'bricks' ),
        'type'  => 'border',
        'css'   => [
            [
                'property' => 'border',
                'selector' => '.vds-live-button-text',
            ],
        ],
        'group'   => 'styleGroup',
        'required' => [ 'streamType', '!=', 'on-demand'],
    ];
    $this->controls['trackColorStyleBackground'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Track color', 'bricks' ),
        'type'  => 'color',
        'css'   => [
            [
                'property' => '--media-slider-track-fill-live-bg',
                'selector' => '.vds-video-layout',
            ],
        ],
        'group'   => 'styleGroup',
        'required' => [ 'streamType', '!=', 'on-demand'],
    ];
    //Tooltip style
    $this->controls['tooltipStyleSeparator'] = [
        'label'      => esc_html__( 'Tooltip', 'bricks' ),
        'type'       => 'separator',
        'group'   => 'styleGroup',
    ];
    $this->controls['tooltipStylePadding'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Padding', 'bricks' ),
        'type'  => 'spacing',
        'css'   => [
            [
                'property' => 'padding',
                'selector' => '.vds-tooltip-content',
            ],
        ],
        'group'   => 'styleGroup',
    ];
    $this->controls['tooltipStyleTypography'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Typography', 'bricks' ),
        'type'  => 'typography',
        'css'   => [
            [
                'property' => 'typography',
                'selector' => '.vds-tooltip-content',
            ],
        ],
        'group'   => 'styleGroup',
    ];
    $this->controls['tooltipStyleBackground'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Background', 'bricks' ),
        'type'  => 'color',
        'css'   => [
            [
                'property' => '--media-tooltip-bg-color',
                'selector' => '.vds-video-layout',
            ],
        ],
        'group'   => 'styleGroup',
    ];
    $this->controls['tooltipStyleBorder'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Border', 'bricks' ),
        'type'  => 'border',
        'css'   => [
            [
                'property' => 'border',
                'selector' => '.vds-tooltip-content',
            ],
        ],
        'group'   => 'styleGroup',
    ];
    $this->controls['tooltipStyleTransition'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Opacity duration', 'bricks' ),
        'type'  => 'number',
        'unit'  => 's',
        'css'   => [
            [
                'property' => '--media-tooltip-entrance-duration',
                'selector' => '.vds-video-layout',
            ],
        ],
        'group'   => 'styleGroup',
        'placeholder'   => '0.2s',
    ];
    //Buffering style
    $this->controls['bufferingStyleSeparator'] = [
        'label'      => esc_html__( 'Buffering', 'bricks' ),
        'type'       => 'separator',
        'group'   => 'styleGroup',
    ];
    $this->controls['bufferingStyleColor'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Color', 'bricks' ),
        'type'  => 'color',
        'css'   => [
            [
                'property' => '--media-buffering-track-color',
                'selector' => '.vds-video-layout',
            ],
        ],
        'group'   => 'styleGroup',
    ];
    $this->controls['bufferingStyleFillColor'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Fill color', 'bricks' ),
        'type'  => 'color',
        'css'   => [
            [
                'property' => '--media-buffering-track-fill-color',
                'selector' => '.vds-video-layout',
            ],
        ],
        'group'   => 'styleGroup',
    ];
    $this->controls['bufferingStyleThickness'] = [
        'hasDynamicData'   => false,
        'inline'   => true,
        'small'  => true,
        'tab'   => 'content',
        'label' => esc_html__( 'Thickness', 'bricks' ),
        'type'  => 'text',
        'css'   => [
            [
                'property' => '--media-buffering-thick',
                'selector' => '.vds-video-layout',
            ],
        ],
        'group'   => 'styleGroup',
        'placeholder'   => '9',
    ];
    $this->controls['bufferingStyleSize'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Size', 'bricks' ),
        'type'  => 'number',
        'units'  => true,
        'css'   => [
            [
                'property' => '--media-buffering-size',
                'selector' => '.vds-video-layout',
            ],
        ],
        'group'   => 'styleGroup',
        'placeholder'   => '64px',
    ];
    $this->controls['bufferingStyleTransition'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Rotation duration', 'bricks' ),
        'type'  => 'number',
        'unit'  => 's',
        'css'   => [
            [
                'property' => '--media-buffering-duration',
                'selector' => '.vds-video-layout',
            ],
        ],
        'group'   => 'styleGroup',
        'placeholder'   => '1s',
    ];
  }


  public function enqueue_scripts() {
    wp_enqueue_style( 'bc_vidstack-theme-css', NEXTBRICKS_PLUGIN_URL . 'local_assets/bc_vidstack_theme.min.css', array(), NEXTBRICKS_VERSION, false);
    wp_enqueue_style( 'bc_vidstack-video-css', NEXTBRICKS_PLUGIN_URL . 'local_assets/bc_vidstack_video.min.css', array(), NEXTBRICKS_VERSION, false);

    wp_enqueue_script( 'bc_vidstack-js', NEXTBRICKS_PLUGIN_URL . 'local_assets/bc_vidstack.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    wp_enqueue_script( 'bc-media-js', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_media.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $videoType = ! empty( $settings['videoType'] ) ? $settings['videoType'] : 'media';
    if($videoType == 'media'){
        $source = ! empty( $settings['media']['url'] ) ? $settings['media']['url'] : 'https://files.vidstack.io/sprite-fight/720p.mp4';
    }else if($videoType == 'file'){
        $source = ! empty( $settings['fileUrl'] ) ? $settings['fileUrl'] : 'https://files.vidstack.io/sprite-fight/720p.mp4';
    }else if($videoType == 'meta'){
        $source = ! empty( $settings['useDynamicData'] ) ? $settings['useDynamicData'] : 'https://files.vidstack.io/sprite-fight/720p.mp4';
    }

    $muted = ! empty( $settings['muted'] ) ? $settings['muted'] : 0;
    $autoplay = ! empty( $settings['autoplay'] ) ? $settings['autoplay'] : 0;
    $playsinline = ! empty( $settings['playsinline'] ) ? $settings['playsinline'] : 0;
    $loop = ! empty( $settings['loop'] ) ? $settings['loop'] : 0;
    $hidecontrols = ! empty( $settings['hide-controls'] ) ? $settings['hide-controls'] : 0;
    $hidecontrolsmouse = ! empty( $settings['hide-controls-on-mouse-leave'] ) ? $settings['hide-controls-on-mouse-leave'] : 0;
    $storageKey = ! empty( $settings['storageKey'] ) ? $settings['storageKey'] : 0;

    $title = ! empty( $settings['title'] ) ? $settings['title'] : 'Sprite Fight';
    $playbackRate = ! empty( $settings['playbackRate'] ) ? $settings['playbackRate'] : '1';
    $clipStartTime = ! empty( $settings['clipStartTime'] ) ? $settings['clipStartTime'] : '';
    $clipEndTime = ! empty( $settings['clipEndTime'] ) ? $settings['clipEndTime'] : '';

    $load = ! empty( $settings['load'] ) ? $settings['load'] : 'visible';
    $posterLoad = ! empty( $settings['posterLoad'] ) ? $settings['posterLoad'] : 'visible';
    $streamType = ! empty( $settings['streamType'] ) ? $settings['streamType'] : 'on-demand';

    $togglePaused = ! empty( $settings['togglePaused'] ) ? $settings['togglePaused'] : 'k Space';
    $toggleMuted = ! empty( $settings['toggleMuted'] ) ? $settings['toggleMuted'] : 'm';
    $toggleFullscreen = ! empty( $settings['toggleFullscreen'] ) ? $settings['toggleFullscreen'] : 'f';
    $togglePictureInPicture = ! empty( $settings['togglePictureInPicture'] ) ? $settings['togglePictureInPicture'] : 'i';
    $toggleCaptions = ! empty( $settings['toggleCaptions'] ) ? $settings['toggleCaptions'] : 'c';
    $seekBackward = ! empty( $settings['seekBackward'] ) ? $settings['seekBackward'] : 'ArrowLeft';
    $seekForward = ! empty( $settings['seekForward'] ) ? $settings['seekForward'] : 'ArrowRight';
    $volumeUp = ! empty( $settings['volumeUp'] ) ? $settings['volumeUp'] : 'ArrowUp';
    $volumeDown = ! empty( $settings['volumeDown'] ) ? $settings['volumeDown'] : 'ArrowDown';
    $speedUp = ! empty( $settings['speedUp'] ) ? $settings['speedUp'] : '>';
    $slowDown = ! empty( $settings['slowDown'] ) ? $settings['slowDown'] : '<';

    $colorScheme = ! empty( $settings['colorScheme'] ) ? $settings['colorScheme'] : 'system';
    $enableThumbnails = ! empty( $settings['enableThumbnails'] ) ? $settings['enableThumbnails'] : 0;
    $thumbnails = ! empty( $settings['thumbnails'] ) ? $settings['thumbnails'] : 'https://files.vidstack.io/sprite-fight/thumbnails.vtt';

    //Player
    $this->set_attribute( '_root', 'class', 'bc-media' );
    $this->set_attribute( '_root', 'src', $source );

    //Player checkboxes
    if($muted == 1){$this->set_attribute( '_root', 'muted', $muted );}
    if($autoplay == 1){$this->set_attribute( '_root', 'autoplay', $autoplay );}
    if($playsinline == 1){$this->set_attribute( '_root', 'playsinline', $playsinline );}
    if($loop == 1){$this->set_attribute( '_root', 'loop', $loop );}
    if($hidecontrols == 1){$this->set_attribute( '_root', 'hide-controls', $hidecontrols );}
    if($hidecontrolsmouse == 1){$this->set_attribute( '_root', 'hide-controls-on-mouse-leave', $hidecontrolsmouse );}
    if($storageKey == 1){$this->set_attribute( '_root', 'storage', 'storage-key' );}

    //Player texts
    if($title != ''){$this->set_attribute( '_root', 'title', $title );}
    if($playbackRate != ''){$this->set_attribute( '_root', 'playback-rate', $playbackRate );}
    if($clipStartTime != ''){$this->set_attribute( '_root', 'clip-start-time', $clipStartTime );}
    if($clipEndTime != ''){$this->set_attribute( '_root', 'clip-end-time', $clipEndTime );}

    //Player selects
    $this->set_attribute( '_root', 'load', $load );
    $this->set_attribute( '_root', 'poster-load', $posterLoad );
    $this->set_attribute( '_root', 'stream-type', $streamType );

    $this->set_attribute( '_root', 'view-type', 'video' );
    $this->set_attribute( '_root', 'key-target', 'player' ); /*no control*/

    //Accesibility

    //Poster
    if (isset($settings['posterImage']['useDynamicData'])){
        $postersrc = $this->render_dynamic_data_tag($settings['posterImage']['useDynamicData'], 'image');
        $postersrc = wp_get_attachment_url($postersrc[0]);

        $posteralt = !empty($settings['posterAlt']) ? "posteralt='{$settings['posterAlt']}'" : '';
        $posteralt = !empty($settings['posterAlt']) ? "alt='{$settings['posterAlt']}'" : '';
    }
    else if (isset($settings['posterImage'])) {
        $postersrc = $settings['posterImage']['url'];

        $posteralt = !empty($settings['posterAlt']) ? "posteralt='{$settings['posterAlt']}'" : '';
        $posteralt = !empty($settings['posterAlt']) ? "alt='{$settings['posterAlt']}'" : '';
    }else{
        $postersrc = 'https://files.vidstack.io/sprite-fight/poster.webp';

        $posteralt = !empty($settings['posterAlt']) ? "posteralt='{$settings['posterAlt']}'" : '';
        $posteralt = !empty($settings['posterAlt']) ? "alt='{$settings['posterAlt']}'" : '';
    }
    $this->set_attribute( '_poster', 'class', 'vds-poster' );
    $this->set_attribute( '_poster', 'src', $postersrc );
    $this->set_attribute( '_poster', 'alt', $posteralt );

    //Sources
    $sources = ! empty( $settings['sources'] ) ? $settings['sources'] : '';
    $sourceElements = '';
    if ($sources) {
        foreach ($sources as $source) {
            $src = $source['src'] ?? 'https://files.vidstack.io/sprite-fight/1080p.mp4';
            $type = $source['type'] ?? 'video/mp4';
            $width = $source['width'] ?? '1920';
            $height = $source['height'] ?? '1080';

            if ($src && $type) {
                $sourceElement = "<source src=\"$src\" type=\"$type\"";
                if ($width) {
                    $sourceElement .= " data-width=\"$width\"";
                }
                if ($height) {
                    $sourceElement .= " data-height=\"$height\"";
                }
                $sourceElement .= "></source>";
    
                $sourceElements .= $sourceElement;
                $sourceElement .= "></source>";
            }
        }
    }

    //Video layout
    $this->set_attribute('_video_layout', 'color-scheme', $colorScheme);
    if($enableThumbnails == 1){
        $this->set_attribute('_video_layout', 'thumbnails', $thumbnails);
    }

    $output = "
    <media-player {$this->render_attributes('_root')}
        data-togglePaused='{$togglePaused}'
        data-toggleMuted='{$toggleMuted}'
        data-toggleFullscreen='{$toggleFullscreen}'
        data-togglePictureInPicture='{$togglePictureInPicture}'
        data-toggleCaptions='{$toggleCaptions}'
        data-seekBackward='{$seekBackward}'
        data-seekForward='{$seekForward}'
        data-volumeUp='{$volumeUp}'
        data-volumeDown='{$volumeDown}'
        data-speedUp='{$speedUp}'
        data-slowDown='{$slowDown}'
    >
        <media-provider>
            <media-poster {$this->render_attributes('_poster')}></media-poster>
            $sourceElements
        </media-provider>

        <media-video-layout {$this->render_attributes('_video_layout')}>
        </media-video-layout>
    </media-player>";

    echo $output;
  }
}