<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Morphing_Menu extends \Bricks\Element {
  public $category     = 'Next Bricks - Menus';
  public $name         = 'morphingmenu';
  public $icon         = 'ti-menu-alt';
  public $tag      = 'div';
  public $scripts      = ['morphingmenu'];
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Morphing Nav', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'section' => 'section',
          'nav' => 'nav',
          'aside' => 'aside',
          'header' => 'header',
          'footer' => 'footer',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['trigger'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Trigger', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'hover' => 'hover',
          'click' => 'click',
      ],
      'inline'      => true,
      'placeholder' => 'hover',
    ];
    $this->controls['activeItemPagename'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( "Page name as active item", 'bricks' ),
      'type' => 'checkbox',
      'default' => false,
    ]; 
    $this->controls['activeitem'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Active Item', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => '1',
      'required' => [ 'activeItemPagename', '!=', true],
    ];
    $this->controls['activeitemcolor'] = [
      'label'       => esc_html__( 'Active Item color', 'bricks' ),
      'type'        => 'color',
      'inline'      => true,
      'css'     => [
          [
            'property' => 'color',
            'selector' => '.bc-morphing-menu__item--active',
          ],
        ],
    ];
    $this->controls['transition'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Morphing transition', 'bricks' ),
			'type'     => 'number',
			'unit'    => 's',
      'inline'      => true,
      'css'     => [
        [
          'property' => '--transition-duration',
          'selector' => '',
        ],
      ],
      'placeholder' => '0.3s',
      'default' => '0.3s',
  ];

    //Morphing Div Styling
    $this->controls['morphingdivSeparator'] = [
      'label'      => esc_html__( 'Morphing Div Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['margindiv'] = [
      'label'       => esc_html__( 'Margin', 'bricks' ),
      'type'        => 'spacing',
      'css'     => [
          [
            'property' => 'margin',
            'selector' => '.bc-morphing-menu__morphing-div',
          ],
        ],
        'reloadScripts' => true,
    ];
    $this->controls['heightdiv'] = [
      'label'       => esc_html__( 'Height', 'bricks' ),
      'type'        => 'number',
      'units'      => true,
      'inline'      => true,
      'css'     => [
          [
            'property' => '--height',
            'selector' => '.demo-morph-bg-target',
          ],
        ],
      'placeholder' => '100%',
      'reloadScripts' => true,
      'default' => '100%',
  ];
    $this->controls['widthdiv'] = [
      'label'       => esc_html__( 'Width', 'bricks' ),
      'type'        => 'number',
      'units'      => true,
      'inline'      => true,
      'css'     => [
          [
            'property' => 'width',
            'selector' => '.demo-morph-bg-target',
          ],
        ],
      'placeholder' => '100%',
      'reloadScripts' => true,
      'default' => '100%',
  ];
    $this->controls['borderdiv'] = [
      'label'       => esc_html__( 'Border', 'bricks' ),
      'type'        => 'border',
      'inline'      => true,
      'css'     => [
          [
            'property' => 'border',
            'selector' => '.demo-morph-bg-target',
          ],
        ],
      'reloadScripts' => true,
    ];
    $this->controls['backgrounddiv'] = [
      'label'       => esc_html__( 'Background', 'bricks' ),
      'type'        => 'background',
      'inline'      => true,
      'css'     => [
          [
            'property' => 'background',
            'selector' => '.bc-morphing-menu__morphing-div',
          ],
        ],
    ];
    $this->controls['boxShadowDiv'] = [
      'label'       => esc_html__( 'Box shadow', 'bricks' ),
      'type'        => 'box-shadow',
      'inline'      => true,
      'css'     => [
          [
            'property' => 'box-shadow',
            'selector' => '.bc-morphing-menu__morphing-div',
          ],
        ],
    ];
  }
  
  /*Render sliders & children*/
public function get_nestable_children() {
  return [
    [
      'name'     => 'morphingmenuitem',
      'label'    => esc_html__( 'Morphing Item', 'bricks' ),
    ],
    [
      'name'     => 'morphingmenuitem',
      'label'    => esc_html__( 'Morphing Item', 'bricks' ),
    ],
    [
      'name'     => 'morphingmenuitem',
      'label'    => esc_html__( 'Morphing Item', 'bricks' ),
    ],
  ];
}

  public function enqueue_scripts() {
    wp_enqueue_script( 'morphing-menu-js', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_morphing_menu.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }



  public function render() {
    $settings = $this->settings;
    $activeItemPagename    = ! empty( $settings['activeItemPagename'] ) ? $settings['activeItemPagename'] : false;
    $activeitem    = ! empty( $settings['activeitem'] ) ? $settings['activeitem'] : '1';
    $trigger    = ! empty( $settings['trigger'] ) ? $settings['trigger'] : 'hover';

    $this->set_attribute( '_root', 'class', 'bc-morphing-menu' );
    
    $page_name = '';
    if($activeItemPagename){
      $page_name = get_the_title();
    }

    $output = "<{$this->tag} {$this->render_attributes( '_root' )}
        data-active-item='{$activeitem}'" . ($activeItemPagename ? " data-page-name='{$page_name}'" : "") . "
        data-trigger='{$trigger}'
        data-morph-bg-preserve=''>";
    $output .= Frontend::render_children( $this ); //Morphing items
    $output .= "<span class='bc-morphing-menu__morphing-div' id='morph-bg-1' data-morph-bg-event='hover' aria-hidden='true'></span>";
    $output .= "</{$this->tag}>";

    echo $output;
  }
}