<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Morphing_Menu_Item extends \Bricks\Element {
  public $name         = 'morphingmenuitem';
  public $icon         = 'ti-link';
  public $scripts      = ['morphingmenu'];
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Morphing Item', 'bricks' );
  }

  public function set_controls() {
    $this->controls['note'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( 'Morphing item is a nestable block element. You can put any elements at it and edit its display settings at the Style tab.', 'bricks' )))
    ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    /*Title*/
    $this->controls['titleSeparator'] = [
      'label'      => esc_html__( 'Title', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['note2'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( "Title is specially useful for having the page name as active item at Morphing Nav. If you don't need it you can just remove it.", 'bricks' )))
    ];
    $this->controls['removeTitle'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Remove Title', 'bricks' ),
      'type'     => 'checkbox',
      'default' => false,
    ];
    $this->controls['inner_title'] = [
      'tab'            => 'content',
      'type'           => 'text',
      'hasDynamicData' => 'text',
      'label' => esc_html__( 'Title', 'bricks' ),
      'default'        => esc_html__( 'Menu item', 'bricks' ),
      'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
      'required' => [ 'removeTitle', '=', false],
    ];
    $this->controls['titleTypography'] = [
      'tab'     => 'content',
      'label'   => esc_html__( 'Typography', 'bricks' ),
      'type'    => 'typography',
      'css'     => [
        [
          'property' => 'typography',
          'selector' => '',
        ],
      ],
      'reloadScripts' => true,
      'required' => [ 'removeTitle', '=', false],
    ];
  }

    
  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Next Bricks';
    $removeTitle    = ! empty( $settings['removeTitle'] ) ? $settings['removeTitle'] : false;

    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = 'div';
    }

    $this->set_attribute( '_root', 'class', 'bc-morphing-menu__item' );
    $this->set_attribute( '_root', 'data-morph-bg', 'morph-bg-1' );
    $this->set_attribute( '_root', 'tabindex', '0' );

    $output = "<$root_tag {$this->render_attributes( '_root' )}>";
      if(!$removeTitle){
        $output .= $inner_title;
      }
      
      $output .= Frontend::render_children( $this );
      $output .= "<span class='demo-morph-bg-target' data-morph-bg-target aria-hidden='true'></span>
    ";
    $output .= "</$root_tag>";

	echo $output;
  }
}