<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class B_Smoothscroll extends \Bricks\Element {
  public $category     = 'Next Bricks - Cores';
  public $name         = 'smoothscroll';
  public $icon         = 'fa-solid fa-bacon';
  public $scripts      = ['smoothscroll'];

  public function get_label() {
    return esc_html__( 'Smooth Scroll', 'bricks' );
  }

  public function set_controls() {
    $this->controls['note'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( 'Live changes at Smooth Scroll will require to reload the builder.', 'bricks' )))
    ];
    $this->controls['type'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Integration', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'lenisjs' => 'Lenis',
          'scrollsmoother' => 'ScrollSmoother',
      ],
      'inline'      => true,
      'clearable' => false,
      'placeholder' => 'Lenis',
      'default' => 'lenisjs',
    ];
    $this->controls['noteGSAP'] = [ //ScrollSmoother
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( 'Put all your content inside your "Content at" element. If you are using fixed position elements (e.g: back to top) then you have to put them outside your "Content at" element.', 'bricks' ))),
      'required' => [ 'type', '=', 'scrollsmoother'],
    ];
    $this->controls['wrapper'] = [ //Lenisjs
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Content at', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'body',
      'required' => [ 'type', '=', 'lenisjs'],
    ];
    $this->controls['wrapperGSAP'] = [ //ScrollSmoother
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Content at', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'main',
      'required' => [ 'type', '=', 'scrollsmoother'],
    ];
    $this->controls['animationSeparator'] = [
      'label'      => esc_html__( 'Animation', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['disablebuilder'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Disable at the builder', 'bricks' ),
      'type'     => 'checkbox',
      'default' => false,
      'reloadScripts' => true,
    ];
    $this->controls['disablescreen'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Disable at touch devices', 'bricks' ),
      'type'     => 'checkbox',
    ];
    $this->controls['duration'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Smooth', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '1.8',
        'reloadScripts' => true,
    ];
    $this->controls['wheelmultiplier'] = [ //Lenisjs
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Wheel multiplier', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => '1',
      'required' => [ 'type', '=', 'lenisjs'],
    ];
    $this->controls['smoothtouch'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Smooth Touch', 'bricks' ),
        'type' => 'checkbox',
        'required' => [ 'disablescreen', '=', false],
    ];
    $this->controls['touchmultiplier'] = [ //Lenisjs
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Touch multiplier', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => '2',
      'required'    => [ ['disablescreen', '=', false] , ['smoothtouch', '=', true] , [ 'type', '=', 'lenisjs'] ],
    ];
    $this->controls['touchsmooth'] = [ //ScrollSmoother
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Smooth Touch', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'required'    => [ ['disablescreen', '=', false] , ['smoothtouch', '=', true] , [ 'type', '=', 'scrollsmoother'] ],
    ];
    $this->controls['ease'] = [ //ScrollSmoother
      'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP easing', 'bricks' ),
        'type' => 'select',
        'options'     => [
          'none' => 'none',
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'custom' => 'custom'
        ],
        'inline' => true,
        'placeholder' => 'expo',
        'required' => [ 'type', '=', 'scrollsmoother'],
    ];
    $this->controls['customEase'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'ease', '=', 'custom' ],
    ];

    $this->controls['infinite'] = [ //Lenisjs
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Infinite scroll', 'bricks' ),
      'type' => 'checkbox',
      'inline' => true,
      'small' => true,
      'default' => false,
      'required' => [ 'type', '=', 'lenisjs'],
    ];
    //Scroll Snap
    $this->controls['scrollSnapSeparator'] = [
      'label'      => esc_html__( 'Scroll Snap', 'bricks' ),
      'type'       => 'separator',
      'required' => [ 'type', '=', 'lenisjs'],
    ];
    $this->controls['enableScrollSnap'] = [ //Lenisjs
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Enable', 'bricks' ),
      'type' => 'checkbox',
      'inline' => true,
      'default' => false,
      'required' => [ 'type', '=', 'lenisjs'],
    ];
    $this->controls['noteScrollSnap'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( 'Set the attribute "scroll-snap-align" to the elements you want to target at their style tab. You can also customize the value: start, center or end.', 'bricks' ))),
      'required'    => [ [ 'type', '=', 'lenisjs'] , [ 'enableScrollSnap', '=', true] ],
    ];
    $this->controls['typeScrollSnap'] = [ //Lenisjs
      'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Snap type', 'bricks' ),
        'type' => 'select',
        'options'     => [
          'mandatory' => 'mandatory',
          'proximity' => 'proximity',
        ],
        'inline' => true,
        'placeholder' => 'mandatory',
        'required'    => [ [ 'type', '=', 'lenisjs'] , [ 'enableScrollSnap', '=', true] ],
    ];
    $this->controls['proximityLimitScrollSnap'] = [ //Lenisjs
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Proximity limit', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => '30%',
      'required'    => [ ['typeScrollSnap', '=', 'proximity'] , ['enableScrollSnap', '=', true] , [ 'type', '=', 'lenisjs'] ],
    ];

    //Parallax //ScrollSmoother
    $this->controls['parallaxSeparator'] = [
      'label'      => esc_html__( 'Parallax', 'bricks' ),
      'type'       => 'separator',
      'required' => [ 'type', '=', 'scrollsmoother'],
    ];
    $this->controls['noteAux'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( 'Speed 0.5 would scroll at half the normal speed and Speed 2 would scroll at twice the normal speed.<br>Lag 0.8 would take 0.8 seconds to "catch up".<br><br>To create parallax effects at images, put the image inside a smaller block that has "overflow: hidden" and set the image class Speed to "auto"', 'bricks' ))),
      'required' => [ 'type', '=', 'scrollsmoother'],
    ];
    $this->controls['parallaxes'] = [
      'tab'           => 'content',
      'type'          => 'repeater',
      'label'         => esc_html__( 'Parallax Items', 'bricks' ),
      'titleProperty' => 'title',
      'fields'        => [
        'class'       => [
          'type'    => 'text',
          'placeholder'    => 'className',
          'label'   => esc_html__( 'Element class', 'bricks' ),
        ],
        'speed'       => [
          'type'    => 'text',
          'label'   => esc_html__( 'Speed', 'bricks' ),
        ],
        'lag'       => [
          'type'    => 'text',
          'label'   => esc_html__( 'Lag', 'bricks' ),
        ],
      ],
      'required' => [ 'type', '=', 'scrollsmoother'],
    ];
  }


  public function enqueue_scripts() {
    $settings = $this->settings;
    $type = ! empty( $settings['type'] ) ? $settings['type'] : 'lenisjs';

    if ($type == 'lenisjs') {
      wp_enqueue_script( 'bc_lenisjs', NEXTBRICKS_PLUGIN_URL . 'local_assets/bc_lenis.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }
    if ($type == 'scrollsmoother') {
      wp_enqueue_script('bc_scroll_smoother', NEXTBRICKS_PLUGIN_URL . 'local_assets/bc_scroll_smoother.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }
    
    wp_enqueue_script( 'smooth_scroll', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_smooth_scroll.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $disablebuilder    = ! empty( $settings['disablebuilder'] ) ? $settings['disablebuilder'] : 0;
    $disablescreen    = ! empty( $settings['disablescreen'] ) ? $settings['disablescreen'] : 0;

    $type = ! empty( $settings['type'] ) ? $settings['type'] : 'lenisjs';
    $duration = ! empty( $settings['duration'] ) ? $settings['duration'] : 1.8;
    $smoothtouch = ! empty( $settings['smoothtouch'] ) ? $settings['smoothtouch'] : 0;

    $wrapper = ! empty( $settings['wrapper'] ) ? $settings['wrapper'] : 'body'; //lenisjs
    $wheelmultiplier = ! empty( $settings['wheelmultiplier'] ) ? $settings['wheelmultiplier'] : 1; //lenisjs
    $touchmultiplier = ! empty( $settings['touchmultiplier'] ) ? $settings['touchmultiplier'] : 1; //lenisjs
    $infinite = ! empty( $settings['infinite'] ) ? $settings['infinite'] : false; //lenisjs

    //lenis scroll snap
    $enableScrollSnap = ! empty( $settings['enableScrollSnap'] ) ? $settings['enableScrollSnap'] : 0;
    $typeScrollSnap = ! empty( $settings['typeScrollSnap'] ) ? $settings['typeScrollSnap'] : 'mandatory';
    $proximityLimitScrollSnap = ! empty( $settings['proximityLimitScrollSnap'] ) ? $settings['proximityLimitScrollSnap'] : '30%';

    $wrapperGSAP = ! empty( $settings['wrapperGSAP'] ) ? $settings['wrapperGSAP'] : 'main'; //scrollsmoother
    $ease = ! empty( $settings['ease'] ) ? $settings['ease'] : 'expo';
    if ($ease === 'custom') {
      $ease = ! empty( $settings['customEase'] ) ? $settings['customEase'] : 'expo';
    } //scrollsmoother
    $touchsmooth = ! empty( $settings['touchsmooth'] ) ? $settings['touchsmooth'] : ''; //scrollsmoother

    $parallaxes = ! empty( $settings['parallaxes'] ) ? $settings['parallaxes'] : ''; //scrollsmoother
    if ($parallaxes) {
        $classes = '';
        $speeds = '';
        $lags = '';
        foreach ($parallaxes as $parallax) {
          if (isset($parallax['class'])) {
            $classes .= $parallax['class'] . 'bc11';
          } else {
            $classes .= 'unset' . 'bc11';
          }
          if (isset($parallax['speed'])) {
            $speeds .= $parallax['speed'] . 'bc11';
          } else {
              $speeds .= 'unset' . 'bc11';
          }
          if (isset($parallax['lag'])) {
            $lags .= $parallax['lag'] . 'bc11';
          } else {
              $lags .= 'unset' . 'bc11';
          }
        }
        $classes .= '';
        $speeds .= '';
        $lags .= '';
    }else{
      $classes = 'unset';
      $speeds = 'unset';
      $lags = 'unset';
    }
    $this->set_attribute( '_root', 'data-classes', $classes); //scrollsmoother
    $this->set_attribute( '_root', 'data-speeds', $speeds); //scrollsmoother
    $this->set_attribute( '_root', 'data-lags', $lags); //scrollsmoother

    $this->set_attribute( '_root', 'data-type', "$type");
    $this->set_attribute( '_root', 'data-duration', "$duration");
    $this->set_attribute( '_root', 'data-smoothtouch', "$smoothtouch");
    
    $this->set_attribute( '_root', 'data-wrapper', "$wrapper"); //lenisjs
    $this->set_attribute( '_root', 'data-wheelmultiplier', "$wheelmultiplier"); //lenisjs
    $this->set_attribute( '_root', 'data-touchmultiplier', "$touchmultiplier"); //lenisjs
    $this->set_attribute( '_root', 'data-infinite', "$infinite"); //lenisjs

    //lenis scroll snap
    $this->set_attribute( '_root', 'data-enable-snap', "$enableScrollSnap"); //lenisjs
    $this->set_attribute( '_root', 'data-type-snap', "$typeScrollSnap"); //lenisjs
    $this->set_attribute( '_root', 'data-proximity-limit-snap', "$proximityLimitScrollSnap"); //lenisjs

    $this->set_attribute( '_root', 'data-wrapperGSAP', "$wrapperGSAP"); //scrollsmoother
    $this->set_attribute( '_root', 'data-ease', "$ease"); //scrollsmoother
    $this->set_attribute( '_root', 'data-touchsmooth', "$touchsmooth"); //scrollsmoother

    $this->set_attribute( '_root', 'data-disable-builder', $disablebuilder);
    $this->set_attribute( '_root', 'data-disable-screen', $disablescreen);

    $this->set_attribute( '_root', 'class', 'bc-smooth-scroll-data' );

    $output = "<div {$this->render_attributes( '_root' )}></div>";

    echo $output;
  }
}



