<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Stripe_MM_ContentList extends \Bricks\Element {
  public $name         = 'stripemmdropdownlist';
  public $icon         = 'ti-layout-width-full';
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Dropdown List', 'bricks' );
  }

  public function set_controls() {
    $this->controls['_children'] = [
      'type'          => 'repeater',
      'titleProperty' => 'label',
      'items'         => 'children',
    ];
  }
    
  public function render() {
    $settings = $this->settings;

    $this->set_attribute( '_root', 'class', 'bc-stripe__morph-dropdown-wrapper' );

    $output = "<div {$this->render_attributes( '_root' )}>";
    $output .= '<div class="bc-stripe__dropdown-list">';
    $output .= "<div class='bc-stripe__dropdown-wrapper'>";
    $output .= Frontend::render_children( $this );
    $output .= '</div>';
    $output .= "<div class='bc-stripe__bg-layer' aria-hidden='true'></div>";
    $output .= '</div>';
    $output .= '</div>';

	echo $output;
  }
}