<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class B_SVG_Title extends \Bricks\Element {
  public $category     = 'Next Bricks - Texts';
  public $name         = 'svgtitle';
  public $icon         = 'ti-text';
  public $tag      = 'h3';
  public $css_selector = '';
  public $scripts      = ['svgtitle'];

  public function get_label() {
    return esc_html__( 'SVG Reveal', 'bricks' );
  }

  public function set_controls() {
    $this->controls['inner_title'] = [
      'tab'            => 'content',
      'type'           => 'text',
	    'hasDynamicData' => 'text',
      'default'        => esc_html__( 'SVG Reveal', 'bricks' ),
      'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['tag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'HTML tag', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'h1' => 'h1',
            'h2' => 'h2',
            'h3' => 'h3',
            'h4' => 'h4',
            'h5' => 'h5',
            'h6' => 'h6',
            'p' => 'p',
            'span' => 'span',
            'custom' => 'custom',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'h3',
        'default'     => 'h3',
    ];
    $this->controls['customTag'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Custom tag', 'bricks' ),
			'type'        => 'text',
			'inline'      => true,
			'placeholder' => 'h3',
			'required'    => [ 'tag', '=', 'custom' ],
    ];
    $this->controls['link'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Link to', 'bricks' ),
      'type'  => 'link',
    ];

    $this->controls['styleSeparator'] = [
      'label'      => esc_html__( 'Style', 'bricks' ),
      'type'       => 'separator',
    ];

    $this->controls['titleTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
          [
            'property' => 'typography',
            'selector' => '.bc-svg-title__element text',
          ],
        ],
    ];
    $this->controls['fill'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Fill', 'bricks' ),
        'type'    => 'color',
        'css'     => [
          [
            'property' => 'fill',
            'selector' => '.bc-svg-title__element text',
          ],
        ],
    ];
    $this->controls['strokecolor'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Stroke color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
          [
            'property' => 'stroke',
            'selector' => '.bc-svg-title__element text',
          ],
        ],
    ];
    $this->controls['strokewidth'] = [
        'inline' => true,
        'tab'     => 'content',
        'label'   => esc_html__( 'Stroke width', 'bricks' ),
        'type'    => 'text',
        'css'     => [
          [
            'property' => 'stroke-width',
            'selector' => '.bc-svg-title__element text',
          ],
        ],
        'placeholder' => '1',
    ];
    $this->controls['width'] = [
        'inline' => true,
        'tab'     => 'content',
        'label'   => esc_html__( 'Width', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'css'     => [
          [
            'property' => 'width',
            'selector' => '.bc-svg-title__element',
          ],
        ],
        'placeholder' => '450px',
    ];
    $this->controls['height'] = [
        'inline' => true,
        'tab'     => 'content',
        'label'   => esc_html__( 'Height', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'css'     => [
          [
            'property' => 'height',
            'selector' => '.bc-svg-title__element',
          ],
        ],
        'placeholder' => 'auto',
    ];

    $this->controls['animationSeparator'] = [
      'label'      => esc_html__( 'Animation', 'bricks' ),
      'type'       => 'separator',
    ];

    $this->controls['disablebuilder'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Disable at the builder', 'bricks' ),
      'type'     => 'checkbox',
      'default' => false,
    ];

    $this->controls['animationduration'] = [
        'inline' => true,
        'tab'     => 'content',
        'label'   => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'css'     => [
          [
            'property' => '--animation-duration',
            'selector' => '',
          ],
        ],
        'placeholder' => '5s',
    ];

    $this->controls['animationdelay'] = [
      'inline' => true,
      'tab'     => 'content',
      'label'   => esc_html__( 'Delay', 'bricks' ),
      'type' => 'number',
      'unit' => 's',
      'css'     => [
        [
          'property' => '--animation-delay',
          'selector' => '',
        ],
      ],
      'placeholder' => '0.2s',
    ];

    $this->controls['scrolltrigger'] = [
      'label'      => esc_html__( 'ScrollTrigger', 'bricks' ),
      'type'       => 'separator',
      'description' => sprintf(esc_html__( 'Scrolltrigger %s', 'bricks' ), '<a href="https://greensock.com/docs/v3/Plugins/ScrollTrigger" target="_blank">documentation</a>'),
    ];

    $this->controls['start'] = [
      'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Start', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => 'top bottom',
    ];
    $this->controls['replay'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Replay on enter back', 'bricks' ),
      'type'     => 'checkbox',
    ];

    $this->controls['triggerSeparator'] = [
      'label'      => esc_html__( 'Additional Triggers', 'bricks' ),
      'type'       => 'separator',
    ];
  
    $this->controls['animationType'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Trigger on', 'bricks' ),
      'type' => 'select',
      'options'     => [
        'Click' => 'Click',
        'Hover' => 'Hover',
      ],
      'inline' => true,
      'placeholder' => ' ',
    ];
  
    $this->controls['classTriggerClick'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Element', 'bricks' ),
      'type' => 'text',
      'placeholder' => '.className',
      'inline' => true,
      'required' => [ 'animationType', '=', 'Click'],
    ];
    $this->controls['classTriggerHover'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Element', 'bricks' ),
      'type' => 'text',
      'placeholder' => '.className',
      'inline' => true,
      'required' => [ 'animationType', '=', 'Hover'],
    ];
  }

  public function enqueue_scripts() {
    wp_enqueue_script( 'svgtitle', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_svg_title.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $disablebuilder    = ! empty( $settings['disablebuilder'] ) ? $settings['disablebuilder'] : 0;
    $animationType    = ! empty( $settings['animationType'] ) ? $settings['animationType'] : '';
    $classTriggerClick    = ! empty( $settings['classTriggerClick'] ) ? $settings['classTriggerClick'] : 0;
    $classTriggerHover    = ! empty( $settings['classTriggerHover'] ) ? $settings['classTriggerHover'] : 0;

    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Bricks';
    $start = ! empty( $settings['start'] ) ? $settings['start'] : 'top bottom';
    $replay = ! empty( $settings['replay'] ) ? $settings['replay'] : 0;

    $this->set_attribute( '_root', 'class', 'bc-svg-title' );

    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = 'div';
    }


    $output = "<$root_tag {$this->render_attributes( '_root' )}>";
    $output .=
    "<{$this->tag}>
      <svg class='bc-svg-title__element' {$this->render_attributes( 'inner_title' )}
        data-animationType='{$animationType}'
        data-classTriggerClick='{$classTriggerClick}'
        data-classTriggerHover='{$classTriggerHover}'
        data-replay='{$replay}'
        data-start='{$start}'
        data-disable-builder='{$disablebuilder}'
      >
        <text text-anchor='middle' alignment-baseline='middle' x='50%' y='50%'>
          $inner_title
        </text>
      </svg>
    </{$this->tag}>";
    $output .= "</$root_tag>";

		echo $output;
  }
}
