<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class B_Title_Images extends Element {
  public $category     = 'Next Bricks - Texts';
  public $name         = 'title-images';
  public $icon         = 'fa-solid fa-images';
  public $tag      = 'h3';
  public $scripts      = ['titleimages'];
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Inline Images', 'bricks' );
  }

  public function set_controls() {
    // Display
		$this->controls['_display'] = [
			'label'     => esc_html__( 'Display', 'bricks' ),
			'type'      => 'select',
			'options'   => [
				'flex'         => 'flex',
				'grid'         => 'grid',
				'block'        => 'block',
				'inline-block' => 'inline-block',
				'inline'       => 'inline',
				'none'         => 'none',
			],
			'inline'    => true,
			'lowercase' => true,
			'css'       => [
				[
					'property' => 'display',
					'selector' => '.bc-title-images__wrapper',
				],
				/**
				 * Use 'required' property to add CSS rule if display is set to 'grid'
				 *
				 * @prev 1.7.2: Used .brx-grid class on nestable to set align-items to initial.
				 *
				 * @since 1.7.2
				 */
				[
					'selector' => '.bc-title-images__wrapper',
					'property' => 'align-items',
					'value'    => 'initial',
					'required' => 'grid',
				],
			],
			'default' => 'flex',
];

		// Display: grid

		$this->controls['_gridGap'] = [
			'label'       => esc_html__( 'Gap', 'bricks' ),
			'type'        => 'number',
			'units'       => true,
			'css'         => [
				[
					'property' => 'grid-gap', // '{column-gap} {row-gap}' e.g. '20px 40px'
					'selector' => '.bc-title-images__wrapper',
				],
			],
			'placeholder' => '',
			'required'    => [ '_display', '=', 'grid' ],
		];

		$this->controls['_gridTemplateColumns'] = [
			'label'          => esc_html__( 'Grid template columns', 'bricks' ),
			'type'           => 'text',
			'tooltip'        => [
				'content'  => 'grid-tempate-columns',
				'position' => 'top-left',
			],
			'hasDynamicData' => false,
			'css'            => [
				[
					'property' => 'grid-template-columns',
					'selector' => '.bc-title-images__wrapper',
				],
			],
			'placeholder'    => '',
			'required'       => [ '_display', '=', 'grid' ],
		];

		$this->controls['_gridTemplateRows'] = [
			'label'          => esc_html__( 'Grid template rows', 'bricks' ),
			'type'           => 'text',
			'tooltip'        => [
				'content'  => 'grid-tempate-rows',
				'position' => 'top-left',
			],
			'hasDynamicData' => false,
			'css'            => [
				[
					'property' => 'grid-template-rows',
					'selector' => '.bc-title-images__wrapper',
				],
			],
			'placeholder'    => '',
			'required'       => [ '_display', '=', 'grid' ],
		];

		$this->controls['_gridAutoColumns'] = [
			'label'          => esc_html__( 'Grid auto columns', 'bricks' ),
			'type'           => 'text',
			'tooltip'        => [
				'content'  => 'grid-auto-columns',
				'position' => 'top-left',
			],
			'hasDynamicData' => false,
			'css'            => [
				[
					'property' => 'grid-auto-columns',
					'selector' => '.bc-title-images__wrapper',
				],
			],
			'required'       => [ '_display', '=', 'grid' ],
		];

		$this->controls['_gridAutoRows'] = [
			'label'          => esc_html__( 'Grid auto rows', 'bricks' ),
			'type'           => 'text',
			'tooltip'        => [
				'content'  => 'grid-auto-rows',
				'position' => 'top-left',
			],
			'hasDynamicData' => false,
			'css'            => [
				[
					'property' => 'grid-auto-rows',
					'selector' => '.bc-title-images__wrapper',
				],
			],
			'required'       => [ '_display', '=', 'grid' ],
		];

		$this->controls['_gridAutoFlow'] = [
			'label'    => esc_html__( 'Grid auto flow', 'bricks' ),
			'type'     => 'select',
			'options'  => [
				'row'    => 'row',
				'column' => 'column',
				'dense'  => 'dense',
			],
			'tooltip'  => [
				'content'  => 'grid-auto-flow',
				'position' => 'top-left',
			],
			'css'      => [
				[
					'property' => 'grid-auto-flow',
					'selector' => '.bc-title-images__wrapper',
				],
			],
			'required' => [ '_display', '=', 'grid' ],
		];

		$this->controls['_justifyItemsGrid'] = [
			'label'     => esc_html__( 'Justify items', 'bricks' ),
			'tooltip'   => [
				'content'  => 'justify-items',
				'position' => 'top-left',
			],
			'type'      => 'justify-content',
			'direction' => 'row',
			'css'       => [
				[
					'property' => 'justify-items',
          'selector' => '.bc-title-images__wrapper',
				],
			],
			'required'  => [ '_display', '=', 'grid' ],
		];

		$this->controls['_alignItemsGrid'] = [
			'label'     => esc_html__( 'Align items', 'bricks' ),
			'tooltip'   => [
				'content'  => 'align-items',
				'position' => 'top-left',
			],
			'type'      => 'align-items',
			'direction' => 'row',
			'css'       => [
				[
					'property' => 'align-items',
          'selector' => '.bc-title-images__wrapper',
				],
			],
			'required'  => [ '_display', '=', 'grid' ],
			'default'   => 'center',
		];

		$this->controls['_justifyContentGrid'] = [
			'label'     => esc_html__( 'Justify content', 'bricks' ),
			'tooltip'   => [
				'content'  => 'justify-content',
				'position' => 'top-left',
			],
			'type'      => 'justify-content',
			'direction' => 'row',
			'css'       => [
				[
					'property' => 'justify-content',
          'selector' => '.bc-title-images__wrapper',
				],
			],
			'required'  => [ '_display', '=', 'grid' ],
			'default'   => 'center',
		];

		$this->controls['_alignContentGrid'] = [
			'label'     => esc_html__( 'Align content', 'bricks' ),
			'tooltip'   => [
				'content'  => 'align-content',
				'position' => 'top-left',
			],
			'type'      => 'align-items',
			'direction' => 'row',
			'css'       => [
				[
					'property' => 'align-content',
          'selector' => '.bc-title-images__wrapper',
				],
			],
			'required'  => [ '_display', '=', 'grid' ],
		];

		// Display: flex

		// Flex controls
		$this->controls['_flexWrap'] = [
			'label'    => esc_html__( 'Flex wrap', 'bricks' ),
			'tooltip'  => [
				'content'  => 'flex-wrap',
				'position' => 'top-left',
			],
			'type'     => 'select',
			'options'  => [
				'nowrap'       => esc_html__( 'No wrap', 'bricks' ),
				'wrap'         => esc_html__( 'Wrap', 'bricks' ),
				'wrap-reverse' => esc_html__( 'Wrap reverse', 'bricks' ),
			],
			'inline'   => true,
			'css'      => [
				[
					'property' => 'flex-wrap',
          'selector' => '.bc-title-images__wrapper',
				],
			],
			'required' => [ '_display', '=', 'flex' ],
		];

		$this->controls['_direction'] = [
			'label'    => esc_html__( 'Direction', 'bricks' ),
			'tooltip'  => [
				'content'  => 'flex-direction',
				'position' => 'top-left',
			],
			'type'     => 'direction',
			'css'      => [
				[
					'property' => 'flex-direction',
          'selector' => '.bc-title-images__wrapper',
				],
			],
			'inline'   => true,
			'rerender' => true,
			'required' => [ '_display', '=', 'flex' ],
			'default'  => 'column',
		];

		$this->controls['_alignSelf'] = [
			'label'    => esc_html__( 'Align self', 'bricks' ),
			'tooltip'  => [
				'content'  => 'align-self',
				'position' => 'top-left',
			],
			'type'     => 'align-items',
			'css'      => [
				[
					'property'  => 'align-self',
          'selector' => '.bc-title-images__wrapper',
					'important' => true,
				],
				[
					'selector' => '',
					'property' => 'width',
					'value'    => '100%',
					'required' => 'stretch', // NOTE: Undocumented (@since 1.4)
				],
			],
			'required' => [ '_display', '=', 'flex' ],
		];

		$this->controls['_justifyContent'] = [
			'label'    => esc_html__( 'Align main axis', 'bricks' ),
			'tooltip'  => [
				'content'  => 'justify-content',
				'position' => 'top-left',
			],
			'type'     => 'justify-content',
			'css'      => [
				[
					'property' => 'justify-content',
          'selector' => '.bc-title-images__wrapper',
				],
			],
			'required' => [ '_display', '=', 'flex' ],
			'default'  => 'center',
		];

		$this->controls['_alignItems'] = [
			'label'    => esc_html__( 'Align cross axis', 'bricks' ),
			'tooltip'  => [
				'content'  => 'align-items',
				'position' => 'top-left',
			],
			'type'     => 'align-items',
			'css'      => [
				[
					'property' => 'align-items',
          'selector' => '.bc-title-images__wrapper',
				],
			],
			'required' => [ '_display', '=', 'flex' ],
			'default'  => 'center',
		];

		$this->controls['_columnGap'] = [
			'label'    => esc_html__( 'Column gap', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'column-gap',
          'selector' => '.bc-title-images__wrapper',
				],
			],
			'required' => [ '_display', '=', 'flex' ],
		];

		$this->controls['_rowGap'] = [
			'label'    => esc_html__( 'Row gap', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'row-gap',
          'selector' => '.bc-title-images__wrapper',
				],
			],
			'required' => [ '_display', '=', 'flex' ],
		];

		// @since 1.3.5
		$this->controls['_flexGrow'] = [
			'label'       => esc_html__( 'Flex grow', 'bricks' ),
			'type'        => 'number',
			'min'         => 0,
			'tooltip'     => [
				'content'  => 'flex-grow',
				'position' => 'top-left',
			],
			'css'         => [
				[
					'property' => 'flex-grow',
          'selector' => '.bc-title-images__wrapper',
				],
			],
			'placeholder' => 0,
			'required'    => [ '_display', '=', 'flex' ],
		];

		$this->controls['_flexShrink'] = [
			'label'       => esc_html__( 'Flex shrink', 'bricks' ),
			'type'        => 'number',
			'min'         => 0,
			'tooltip'     => [
				'content'  => 'flex-shrink',
				'position' => 'top-left',
			],
			'css'         => [
				[
					'property' => 'flex-shrink',
          'selector' => '.bc-title-images__wrapper',
				],
			],
			'placeholder' => 1,
			'required'    => [ '_display', '=', 'flex' ],
		];

		$this->controls['_flexBasis'] = [
			'label'          => esc_html__( 'Flex basis', 'bricks' ),
			'type'           => 'text',
			'tooltip'        => [
				'content'  => 'flex-basis',
				'position' => 'top-left',
			],
			'css'            => [
				[
					'property' => 'flex-basis',
          'selector' => '.bc-title-images__wrapper',
				],
			],
			'inline'         => true,
			'small'          => true,
			'placeholder'    => 'auto',
			'hasDynamicData' => false,
			'required'       => [ '_display', '=', 'flex' ],
		];

    $this->controls['childrenSeparator'] = [
      'label'      => esc_html__( 'Lines', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['_children'] = [
        'type'          => 'repeater',
        'titleProperty' => 'label',
        'items'         => 'children',
    ];
  }

  public function get_nestable_item() {
		return [
			'name'     => 'block',
			'label'    => esc_html__( 'Line wrapper', 'bricks' ),
      'settings' => [
        '_hidden' => [
          '_cssClasses' => 'bc-inline-div',
        ],
      ],
			'children' => [
        [
          'name'     => 'heading',
          'label'    => esc_html__( 'Title', 'bricks' ),
          'settings' => [
            'text' => esc_html__( 'Bricks', 'bricks' ),
            'tag'  => 'span',
            '_hidden'         => [
							'_cssClasses' => 'bc-inline-span',
						],
          ],
				],
				[
					'name'     => 'image',
					'label'    => esc_html__( 'Image', 'bricks' ),
					'settings' => [
						'_hidden'         => [
							'_cssClasses' => 'bc-inline-img',
						],
					],
				],
			],
		];
}

public function get_nestable_children() {
    $item = $this->get_nestable_item();
    return [$item];
}


public function enqueue_scripts() {
  wp_enqueue_script( 'titleimages', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_title_images.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
}

  public function render() {
    $settings = $this->settings;


    $this->set_attribute( '_root', 'class', 'bc-title-images' );

    $output = "<div {$this->render_attributes( '_root' )}>";

    $output .= "<div class='bc-title-images__wrapper'>";
    $output .= Frontend::render_children( $this );
    $output .= '</div>';

    $output .= '</div>';

	echo $output;
  }
}
