<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class B_Twist_Title extends \Bricks\Element {
  public $category     = 'Next Bricks - Texts';
  public $name         = '3d-title';
  public $icon         = 'ti-text';
  public $tag      = 'h3';
  public $css_selector = '';
	public $scripts      = ['twist_title'];

  public function get_label() {
    return esc_html__( 'Twist Reveal', 'bricks' );
  }

  public function set_control_groups() {
    $this->control_groups['gradient'] = [
      'title' => esc_html__( 'Gradient', 'bricks' ),
      'tab'   => 'content',
    ];
  }

  public function set_controls() {
    $this->controls['inner_title'] = [
      'tab'            => 'content',
      'type'           => 'text',
			'hasDynamicData' => 'text',
      'default'        => esc_html__( 'Twist Reveal', 'bricks' ),
      'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];

    $this->controls['tag'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'HTML tag', 'bricks' ),
			'type'        => 'select',
			'options'     => [
				'h1' => 'h1',
				'h2' => 'h2',
				'h3' => 'h3',
				'h4' => 'h4',
				'h5' => 'h5',
				'h6' => 'h6',
        'p' => 'p',
        'span' => 'span',
        'custom' => 'custom',
			],
			'clearable'   => false,
			'inline'      => true,
			'placeholder' => 'h3',
			'default'     => 'h3',
		];
    $this->controls['customTag'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Custom tag', 'bricks' ),
			'type'        => 'text',
			'inline'      => true,
			'placeholder' => 'h3',
			'required'    => [ 'tag', '=', 'custom' ],
    ];

    $this->controls['link'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Link to', 'bricks' ),
      'type'  => 'link',
    ];

    $this->controls['styleSeparator'] = [
      'label'      => esc_html__( 'Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['titleTypography'] = [
      'tab'     => 'content',
      'label'   => esc_html__( 'Typography', 'bricks' ),
      'type'    => 'typography',
			'css'     => [
        [
          'property' => 'typography',
          'selector' => '.bc-twist-title__span',
        ],
      ],
    ];

    $this->controls['animationSeparator'] = [
      'label'      => esc_html__( 'Animation', 'bricks' ),
      'type'       => 'separator',
    ];

    $this->controls['disablebuilder'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Disable at the builder', 'bricks' ),
      'type'     => 'checkbox',
      'default' => false,
    ];

    $this->controls['perspective'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Perspective', 'bricks' ),
      'type' => 'number',
      'unit' => 'px',
      'inline' => true,
      'placeholder' => '200px',
    ];

    $this->controls['duration'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Duration', 'bricks' ),
      'type' => 'number',
      'unit' => 's',
      'inline' => true,
      'placeholder' => '1s',
    ];

    $this->controls['scrolltrigger'] = [
      'label'      => esc_html__( 'ScrollTrigger', 'bricks' ),
      'type'       => 'separator',
      'description' => sprintf(esc_html__( 'Scrolltrigger %s', 'bricks' ), '<a href="https://greensock.com/docs/v3/Plugins/ScrollTrigger" target="_blank">documentation</a>'),
    ];

    $this->controls['start'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Start', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'top bottom',
    ];

    $this->controls['delay'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Delay', 'bricks' ),
      'type' => 'number',
      'unit' => 's',
      'inline' => true,
      'placeholder' => '0.2s',
    ];

    $this->controls['replay'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Replay on enter back', 'bricks' ),
      'type'     => 'checkbox',
    ];

    $this->controls['triggerSeparator'] = [
      'label'      => esc_html__( 'Additional Triggers', 'bricks' ),
      'type'       => 'separator',
    ];
  
    $this->controls['animationType'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Trigger on', 'bricks' ),
      'type' => 'select',
      'options'     => [
        'Click' => 'Click',
        'Hover' => 'Hover',
      ],
      'inline' => true,
      'placeholder' => ' ',
    ];
  
    $this->controls['classTriggerClick'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Element', 'bricks' ),
      'type' => 'text',
      'placeholder' => '.className',
      'inline' => true,
      'required' => [ 'animationType', '=', 'Click'],
    ];
    $this->controls['classTriggerHover'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Element', 'bricks' ),
      'type' => 'text',
      'placeholder' => '.className',
      'inline' => true,
      'required' => [ 'animationType', '=', 'Hover'],
    ];

    //Gradient
    $this->controls['titleGradient'] = [
      'group' => 'gradient',
      'tab' => 'content',
      'type' => 'gradient',
      'css' => [
        [
          'property' => 'background-image',
          'selector' => '.bc-twist-title__span',
        ],
      ],
    ];

    //Padding from style tab applied to the root without link and to the link if exists
    $this->controls['_padding'] = [
      'tab'   => 'style',
      'group' => '_layout',
      'label' => esc_html__( 'Padding', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'padding',
          'selector' => '&:not(:has(> a)), > a',
        ]
      ],
    ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'twist_title', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_twist_title.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $disablebuilder    = ! empty( $settings['disablebuilder'] ) ? $settings['disablebuilder'] : 0;
    $animationType    = ! empty( $settings['animationType'] ) ? $settings['animationType'] : '';
    $classTriggerClick    = ! empty( $settings['classTriggerClick'] ) ? $settings['classTriggerClick'] : 0;
    $classTriggerHover    = ! empty( $settings['classTriggerHover'] ) ? $settings['classTriggerHover'] : 0;

    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Next Bricks';
    $perspective = ! empty( $settings['perspective'] ) ? $settings['perspective'] : 200;
    $duration = ! empty( $settings['duration'] ) ? $settings['duration'] : 1;
    $delay = ! empty( $settings['delay'] ) ? $settings['delay'] : 0.2;
    $start = ! empty( $settings['start'] ) ? $settings['start'] : 'top bottom';
    $replay = ! empty( $settings['replay'] ) ? $settings['replay'] : 0;

    $this->set_attribute( '_root', 'class', 'bc-twist-title' );
    $this->set_attribute( '_root', 'style', "perspective: " . intval($perspective) . "px;");
    $this->set_attribute( '_root', 'data-start', "$start");
    $this->set_attribute( '_root', 'data-replay', "$replay");

    $this->set_attribute( '_root', 'data-disable-builder', $disablebuilder);
    $this->set_attribute( '_root', 'data-animationType', $animationType);
    $this->set_attribute( '_root', 'data-classTriggerClick', $classTriggerClick);
    $this->set_attribute( '_root', 'data-classTriggerHover', $classTriggerHover);

    $this->set_attribute( '_inner', 'class', 'bc-twist-title__span' );
    $this->set_attribute( '_inner', 'style', "transition-duration: " . floatval($duration) . "s;");
    $this->set_attribute( '_inner', 'style', "transition-delay: " . floatval($delay) . "s");

    if ( ! empty( $settings['link'] ) ) {
			$this->set_link_attributes( '_link', $settings['link'] );
      $output ="
      <{$this->tag} {$this->render_attributes( '_root' )}>
        <a class='bc-twist-title__anchor' {$this->render_attributes( '_link' )}>
          <span {$this->render_attributes( '_inner' )}>$inner_title</span>
        </a>
      </{$this->tag}>
      ";
		}else{
      $output ="
      <{$this->tag} {$this->render_attributes( '_root' )}>
        <span {$this->render_attributes( '_inner' )}>$inner_title</span>
      </{$this->tag}>
      ";
    }

		echo $output;
  }
}