<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Unfold_Reveal extends \Bricks\Element {
  public $category     = 'Next Bricks - Texts';
  public $name         = 'unfold-reveal';
  public $icon         = 'ti-text';
  public $tag      = 'h3';
  public $css_selector = '';
  public $scripts      = ['unfoldreveal'];

  public function get_label() {
    return esc_html__( 'Unfold Reveal', 'bricks' );
  }

  public function set_control_groups() {
    $this->control_groups['gradient'] = [
      'title' => esc_html__( 'Gradient', 'bricks' ),
      'tab'   => 'content',
    ];
  }

  public function set_controls() {
    $this->controls['inner_title'] = [
      'tab'            => 'content',
      'type'           => 'text',
	    'hasDynamicData' => 'text',
      'default'        => esc_html__( 'Unfold Reveal', 'bricks' ),
      'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];

    $this->controls['tag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'HTML tag', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'h1' => 'h1',
            'h2' => 'h2',
            'h3' => 'h3',
            'h4' => 'h4',
            'h5' => 'h5',
            'h6' => 'h6',
            'p' => 'p',
            'span' => 'span',
            'custom' => 'custom',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'h3',
        'default'     => 'h3',
    ];
    $this->controls['customTag'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Custom tag', 'bricks' ),
			'type'        => 'text',
			'inline'      => true,
			'placeholder' => 'h3',
			'required'    => [ 'tag', '=', 'custom' ],
    ];

    $this->controls['link'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Link to', 'bricks' ),
      'type'  => 'link',
    ];
    $this->controls['styleSeparator'] = [
      'label'      => esc_html__( 'Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['titleTypography'] = [
      'tab'     => 'content',
      'label'   => esc_html__( 'Typography', 'bricks' ),
      'type'    => 'typography',
            'css'     => [
        [
          'property' => 'typography',
          'selector' => '.bc-unfold-reveal__element',
        ],
      ],
    ];

    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Animation', 'bricks' ),
        'type'       => 'separator',
    ];

    $this->controls['disablebuilder'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Disable at the builder', 'bricks' ),
      'type'     => 'checkbox',
      'default' => false,
    ];

    $this->controls['type'] = [
      'hasDynamicData' => false,
      'tab'         => 'content',
      'label'       => esc_html__( 'Type', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'lines' => 'lines',
          'words' => 'words',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'lines',
    ];
    $this->controls['from'] = [
      'hasDynamicData' => false,
      'tab'         => 'content',
      'label'       => esc_html__( 'From', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'left' => 'left',
          'right' => 'right',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'left',
    ];
    $this->controls['unfold_intensity'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Unfold Intensity', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => '300',
    ];
    $this->controls['duration'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'placeholder' => '0.3s',
    ];
    $this->controls['delay'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Delay', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'placeholder' => '0s',
    ];
    $this->controls['ease'] = [
      'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP easing', 'bricks' ),
        'type' => 'select',
        'options'     => [
          'none' => 'none',
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps',
          'custom' => 'custom'
        ],
        'inline' => true,
        'placeholder' => 'expo',
    ];
    $this->controls['customEase'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'ease', '=', 'custom' ],
    ];

    $this->controls['stagger'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Stagger', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => '0.06',
    ];

    $this->controls['scrolltrigger'] = [
      'label'      => esc_html__( 'ScrollTrigger', 'bricks' ),
      'type'       => 'separator',
      'description' => sprintf(esc_html__( 'Scrolltrigger %s', 'bricks' ), '<a href="https://greensock.com/docs/v3/Plugins/ScrollTrigger" target="_blank">documentation</a>'),
    ];
  
    $this->controls['trigger'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Trigger', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'this',
    ];
  
    $this->controls['start'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Start', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'top bottom',
    ];

    $this->controls['end'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'End', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'false',
    ];
  
    $this->controls['scrub'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Scrub', 'bricks' ),
      'type' => 'checkbox',
      'inline' => true,
      'placeholder' => false,
      'default' => false,
    ];

    $this->controls['scroller'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Scroller', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'body',
    ];

    $this->controls['toggleActions'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'toggleActions', 'bricks' ),
      'type' => 'text',
      'placeholder' => 'play none none none',
    ];

    $this->controls['triggerSeparator'] = [
      'label'      => esc_html__( 'Additional Triggers', 'bricks' ),
      'type'       => 'separator',
    ];
  
    $this->controls['animationType'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Trigger on', 'bricks' ),
      'type' => 'select',
      'options'     => [
        'Click' => 'Click',
        'Hover' => 'Hover',
      ],
      'inline' => true,
      'placeholder' => ' ',
    ];

    $this->controls['removescroll'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Disable on scroll', 'bricks' ),
      'type'     => 'checkbox',
      'default' => false,
    ];
  
    $this->controls['classTriggerClick'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Element', 'bricks' ),
      'type' => 'text',
      'placeholder' => '.className',
      'inline' => true,
      'required' => [ 'animationType', '=', 'Click'],
    ];
    $this->controls['classTriggerHover'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Element', 'bricks' ),
      'type' => 'text',
      'placeholder' => '.className',
      'inline' => true,
      'required' => [ 'animationType', '=', 'Hover'],
    ];

    //Gradient
    $this->controls['titleGradient'] = [
      'group' => 'gradient',
      'tab' => 'content',
      'type' => 'gradient',
      'css' => [
        [
          'property' => 'background-image',
          'selector' => '.char',
        ],
      ],
    ];

    //Padding from style tab applied to the root without link and to the link if exists
    $this->controls['_padding'] = [
      'tab'   => 'style',
      'group' => '_layout',
      'label' => esc_html__( 'Padding', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'padding',
          'selector' => '&:not(:has(> a)), > a',
        ]
      ],
    ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'bc-unfold-reveal', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_unfold_reveal.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $disablebuilder    = ! empty( $settings['disablebuilder'] ) ? $settings['disablebuilder'] : 0;
    $removescroll    = ! empty( $settings['removescroll'] ) ? $settings['removescroll'] : 0;
    $animationType    = ! empty( $settings['animationType'] ) ? $settings['animationType'] : '';
    $classTriggerClick    = ! empty( $settings['classTriggerClick'] ) ? $settings['classTriggerClick'] : 0;
    $classTriggerHover    = ! empty( $settings['classTriggerHover'] ) ? $settings['classTriggerHover'] : 0;

    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Next Bricks';
    $intensity    = ! empty( $settings['unfold_intensity'] ) ? $settings['unfold_intensity'] : 300;
    $delay    = ! empty( $settings['delay'] ) ? $settings['delay'] : 0;
    $duration    = ! empty( $settings['duration'] ) ? $settings['duration'] : 0.3;
    $stagger    = ! empty( $settings['stagger'] ) ? $settings['stagger'] : 0.06;
    $ease    = ! empty( $settings['ease'] ) ? $settings['ease'] : 'expo';
    if ($ease === 'custom') {
      $ease = ! empty( $settings['customEase'] ) ? $settings['customEase'] : 'expo';
    }
    $from    = ! empty( $settings['from'] ) ? $settings['from'] : 'left';
    $type    = ! empty( $settings['type'] ) ? $settings['type'] : 'lines';
    $toggleActions = ! empty( $settings['toggleActions'] ) ? $settings['toggleActions'] : 'play none none none';

    $trigger    = ! empty( $settings['trigger'] ) ? $settings['trigger'] : 'this';
    $start    = ! empty( $settings['start'] ) ? $settings['start'] : 'top bottom';
    $end    = ! empty( $settings['end'] ) ? $settings['end'] : 'false';
    $scrub    = ! empty( $settings['scrub'] ) ? $settings['scrub'] : false;
    $scroller    = ! empty( $settings['scroller'] ) ? $settings['scroller'] : 'body';

    $this->set_attribute( '_root', 'class', 'bc-unfold-reveal' );
    $this->set_attribute( '_inner', 'class', 'bc-unfold-reveal__element' );
    $this->set_attribute( '_inner', 'data-hide', '' );
    $this->set_attribute( '_inner', 'data-type', $type );
    $this->set_attribute( '_inner', 'data-intensity', $intensity );
    $this->set_attribute( '_inner', 'data-delay', $delay );
    $this->set_attribute( '_inner', 'data-duration', $duration );
    $this->set_attribute( '_inner', 'data-stagger', $stagger );
    $this->set_attribute( '_inner', 'data-ease', $ease );
    $this->set_attribute( '_inner', 'data-from', $from );
    $this->set_attribute( '_inner', 'data-scroller', $scroller );
    $this->set_attribute( '_inner', 'data-toggleActions', $toggleActions);

    $this->set_attribute( '_inner', 'data-trigger', $trigger );
    $this->set_attribute( '_inner', 'data-start', $start );
    $this->set_attribute( '_inner', 'data-end', $end );
    $this->set_attribute( '_inner', 'data-scrub', $scrub );

    $this->set_attribute( '_inner', 'data-disable-builder', $disablebuilder);
    $this->set_attribute( '_inner', 'data-animationType', $animationType);
    $this->set_attribute( '_inner', 'data-remove-scroll', "$removescroll");
    $this->set_attribute( '_inner', 'data-classTriggerClick', $classTriggerClick);
    $this->set_attribute( '_inner', 'data-classTriggerHover', $classTriggerHover);

    if ( ! empty( $settings['link'] ) ) {
			$this->set_link_attributes( '_link', $settings['link'] );
      $output ="
      <{$this->tag} {$this->render_attributes( '_root' )}>
        <a class='bc-unfold-reveal__anchor' {$this->render_attributes( '_link' )}>
          <span {$this->render_attributes( '_inner' )}>$inner_title</span>
        </a>
      </{$this->tag}>
      ";
		}else{
      $output ="
      <{$this->tag} {$this->render_attributes( '_root' )}>
        <span {$this->render_attributes( '_inner' )}>$inner_title</span>
      </{$this->tag}>
      ";
    }

	  echo $output;
  }
}