<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class B_Zoom_Lens extends \Bricks\Element {
  public $category     = 'Next Bricks - Medias';
  public $name         = 'zoomlens';
  public $icon         = 'fa-solid fa-magnifying-glass';
  public $scripts      = ['zoom_lens'];

  public function get_label() {
    return esc_html__( 'Zoom Lens', 'bricks' );
  }

  public function set_controls() {
    $this->controls['image'] = [
      'hasDynamicData' => true,
      'tab' => 'content',
      'label' => esc_html__( 'Image', 'bricks' ),
      'type' => 'image',
    ];
      $this->controls['alt'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Alt text', 'bricks' ),
        'type' => 'text',
        'inline' => true,
    ];
    $this->controls['imageFilters'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Filters', 'bricks' ),
      'type' => 'filters',
      'inline' => true,
      'css' => [
        [
          'property' => 'filter',
          'selector' => '.bc-zoom-lens__image, .bc-zoom-lens__glass',
        ],
      ],
    ];
    $this->controls['width'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Width', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'inline' => true,
      'css' => [
        [
          'property' => 'width',
          'selector' => '', 
        ]
      ],
      'placeholder' => 'auto',
      'default' => 'fit-content',
  ];
    $this->controls['height'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Height', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'inline' => true,
      'css' => [
        [
          'property' => 'height',
          'selector' => '', 
        ]
      ],
      'placeholder' => 'auto',
      'default' => 'fit-content',
  ];
    
    $this->controls['lensSeparator'] = [
      'label'      => esc_html__( 'Lens', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['dimensions'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Dimensions', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'placeholder' => '50px',
        'inline' => true,
        'css'     => [
          [
            'property' => '--width',
            'selector' => '.bc-zoom-lens__glass',
          ],
        ],
        'default' => '50px',
    ];
    $this->controls['border'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Border', 'bricks' ),
        'type'    => 'border',
        'inline' => true,
        'css'     => [
          [
            'property' => 'border',
            'selector' => '.bc-zoom-lens__glass',
          ],
        ],
        'default' => [
            'width' => [
                'top' => '1px',
                'right' => '1px',
                'bottom' => '1px',
                'left' => '1px',
            ],
            'style' => 'solid',
            'color' => [
                'hex' => '#ffffff',
            ],
        ],
    ];
    $this->controls['scalezoom'] = [
      'tab'     => 'content',
      'label'   => esc_html__( 'Zoom', 'bricks' ),
      'type'    => 'text',
      'placeholder' => '2',
      'inline' => true,
      'small' => true,
      'css'     => [
        [
          'property' => '--scale',
          'selector' => '.bc-zoom-lens__show',
        ],
      ],
      'hasDynamicData' => false,
      'default' => '2',
  ];
    $this->controls['zoomDistanceX'] = [
      'tab'     => 'content',
      'label'   => esc_html__( 'Zoom X distance', 'bricks' ),
      'type'    => 'text',
      'placeholder' => '0',
      'inline' => true,
      'small' => true,
      'hasDynamicData' => false
    ];
    $this->controls['zoomDistanceY'] = [
      'tab'     => 'content',
      'label'   => esc_html__( 'Zoom Y distance', 'bricks' ),
      'type'    => 'text',
      'placeholder' => '0',
      'inline' => true,
      'small' => true,
      'hasDynamicData' => false
    ];
    $this->controls['opacityduration'] = [
      'tab'     => 'content',
      'label'   => esc_html__( 'Cursor attachment', 'bricks' ),
      'type'    => 'number',
      'small' => true,
      'placeholder' => '100',
      'inline' => true,
  ];

    $this->controls['lensAnimationSeparator'] = [
      'label'      => esc_html__( 'Lens Scale Animation', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['scaleinduration'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'In duration', 'bricks' ),
        'type' => 'number',
        'unit' => 'ms',
        'placeholder' => '200ms',
        'inline' => true,
        'small' => true,
        'css'     => [
          [
            'property' => '--scale-duration',
            'selector' => '.bc-zoom-lens__glass',
          ],
        ],
        'default' => '200ms',
    ];
    $this->controls['scaleoutduration'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Out duration', 'bricks' ),
        'type'    => 'number',
        'small' => true,
        'placeholder' => '200ms',
        'inline' => true,
    ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'bczoomlens', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_zoom_lens.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $width = 0;
    $height = 0;

    // Render dynamic data
    if (isset($settings['image']['useDynamicData'])) {
        $images = $this->render_dynamic_data_tag($settings['image']['useDynamicData'], 'image');
        if (!empty($images) && isset($images[0])) {
            $last_image = wp_get_attachment_url($images[0]);
            $attachment_id = attachment_url_to_postid($last_image);
            $image_metadata = wp_get_attachment_metadata($attachment_id);
            
            $width = isset($image_metadata['width']) ? $image_metadata['width'] : 0;
            $height = isset($image_metadata['height']) ? $image_metadata['height'] : 0;
        }
    }
    // Render normal image
    else if (isset($settings['image']['url'])) {
        $last_image = $settings['image']['url'];
        $image_dimensions = @getimagesize($last_image);
        
        if ($image_dimensions !== false) {
            $width = $image_dimensions[0];
            $height = $image_dimensions[1];
        }
    }
    // Render default
    else {
        $last_image = 'https://images.pexels.com/photos/17050728/pexels-photo-17050728/free-photo-of-madera-carretera-paisaje-agua.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=1';
        $image_dimensions = @getimagesize($last_image);
        
        if ($image_dimensions !== false) {
            $width = $image_dimensions[0];
            $height = $image_dimensions[1];
        }
    }

    // Si no se pudieron obtener dimensiones, usar valores por defecto
    if ($width === 0 || $height === 0) {
        $width = 1260;  // dimensión por defecto
        $height = 750;  // dimensión por defecto
    }

    $alt = !empty($settings['alt']) ? "alt='{$settings['alt']}'" : '';
    $scaleout = !empty($settings['scaleoutduration']) ? $settings['scaleoutduration'] : 200;
    $opacity = !empty($settings['opacityduration']) ? $settings['opacityduration'] : 100;
    $zoomDistanceX = !empty($settings['zoomDistanceX']) ? $settings['zoomDistanceX'] : 0;
    $zoomDistanceY = !empty($settings['zoomDistanceY']) ? $settings['zoomDistanceY'] : 0;

    $this->set_attribute('_root', 'class', 'bc-zoom-lens');
    $this->set_attribute('_root', 'style', "--bgimage: url('$last_image');");
    $this->set_attribute('_root', 'data-scaleout', "$scaleout");
    $this->set_attribute('_root', 'data-opacity', "$opacity");
    $this->set_attribute('_root', 'data-zoom-x-distance', "$zoomDistanceX");
    $this->set_attribute('_root', 'data-zoom-y-distance', "$zoomDistanceY");

    if (strpos($last_image, 'cloudinary.com') !== false) {
      $src_decoding = 'decoding="async"';
    } else {
        $src_decoding = '';
    }

    $output = "<div {$this->render_attributes('_root')} width='$width' height='$height'>";
    $output .= "<img src='$last_image' class='bc-zoom-lens__image' $alt $src_decoding>";
    $output .= '</div>';

    echo $output;
  }
}



