class NextArcTitle{static instances=new Set();constructor(element){this.element=element;this.inner=element.querySelector('.next-arc-title__inner');this.options={spacing:element.getAttribute('data-spacing')||1,size:1};this.canTrig=CSS.supports('(top: calc(sin(1) * 1px))');this.scroll=element.getAttribute('data-scroll')=='true';this.scrollStart=element.getAttribute('data-scroll-start');this.scrollEnd=element.getAttribute('data-scroll-end');this.scrub=element.getAttribute('data-scrub');this.scrollRotation=parseFloat(element.getAttribute('data-scroll-rotation'));this.scrollEasing=element.getAttribute('data-scroll-easing');this.initialize()}
initialize(){if(!this.inner)return;this.updateContent();this.element.removeAttribute('data-flickering');this.createArcText();this.updateStyles()
if(this.scroll){this.initScrollTrigger()}}
updateContent(){const content=this.inner.getAttribute('data-content');if(content){this.options.text=content;this.inner.textContent=content}else{this.options.text=this.inner.textContent||"Arc Title · Next Bricks · "}}
createArcText(){this.inner.innerHTML='';const chars=this.options.text.split('');this.inner.style.setProperty('--char-count',chars.length);chars.forEach((char,index)=>{const span=document.createElement('span');span.className='char';span.setAttribute('aria-hidden','true');span.style.setProperty('--char-index',index);span.textContent=char;this.inner.appendChild(span)});const srSpan=document.createElement('span');srSpan.className='sr-only';srSpan.textContent=this.options.text;this.inner.appendChild(srSpan)}
updateStyles(){const{spacing,size}=this.options;const charCount=this.inner.children.length-1;this.inner.style.setProperty('--font-size',`${size}rem`);this.inner.style.setProperty('--character-width',spacing);const radius=this.canTrig?'calc((var(--character-width) / sin(var(--inner-angle))) * -1ch)':`calc((${spacing} / ${Math.sin(360 / charCount / (180 / Math.PI))}) * -1ch)`;this.inner.style.setProperty('--radius',radius);if(charCount>3){const buffer=this.canTrig?`calc((${spacing} / sin(${360 / charCount}deg)) * ${size}rem)`:`calc((${spacing} / ${Math.sin(360 / charCount / (180 / Math.PI))}) * ${size}rem)`;document.documentElement.style.setProperty('--buffer',buffer)}}
refresh(){this.updateContent();this.createArcText();this.updateStyles()}
destroy(){if(this.inner){const content=this.inner.getAttribute('data-content');if(content){this.inner.textContent=content}
this.inner.removeAttribute('style')}}
static destroyAll(){NextArcTitle.instances.forEach(instance=>{instance.destroy();NextArcTitle.instances.delete(instance)})}
initScrollTrigger(){gsap.to(this.inner,{scrollTrigger:{trigger:this.element,start:this.scrollStart,end:this.scrollEnd==='none'?'+=100%':this.scrollEnd,scrub:this.scrub==='true'?1:parseFloat(this.scrub)||!1,},rotation:this.scrollRotation,ease:this.scrollEasing,immediateRender:!1})}}
function next_arc_title(){NextArcTitle.destroyAll();document.querySelectorAll('.next-arc-title').forEach(element=>{const instance=new NextArcTitle(element);NextArcTitle.instances.add(instance)})}
document.addEventListener("DOMContentLoaded",function(t){bricksIsFrontend&&next_arc_title()})