function next_cursor_trail(){class ImageItem{constructor(el,defaultStyle){this.DOM={el};this.defaultStyle=defaultStyle;this.getRect();this.initEvents()}
initEvents(){window.addEventListener('resize',()=>this.resize())}
resize(){gsap.set(this.DOM.el,this.defaultStyle);this.getRect()}
getRect(){this.rect=this.DOM.el.getBoundingClientRect()}
isActive(){return gsap.isTweening(this.DOM.el)||this.DOM.el.style.opacity!=0}}
class ImageTrail{constructor(options){this.config={container:options.container,itemSelector:options.itemSelector,threshold:options.threshold||100,lerpFactor:options.lerpFactor||0.1,type:options.type||'type-1',animation:options.animation,defaultStyle:options.defaultStyle};this.mousePos=this.lastMousePos=this.cacheMousePos={x:0,y:0};this.zIndexVal=1;this.imgPosition=0;this.winsize={width:window.innerWidth,height:window.innerHeight};this.initDOM();this.initEvents();requestAnimationFrame(()=>this.render())}
initDOM(){this.DOM={content:typeof this.config.container==='string'?document.querySelector(this.config.container):this.config.container};if(!this.DOM.content){throw new Error(`Container ${this.config.container} not found`)}
this.images=[...this.DOM.content.querySelectorAll(this.config.itemSelector)].map(el=>new ImageItem(el,this.config.defaultStyle));this.imagesTotal=this.images.length}
initEvents(){this.DOM.content.addEventListener('mousemove',ev=>this.updateMousePosition(ev));window.addEventListener('resize',()=>{this.winsize={width:window.innerWidth,height:window.innerHeight};this.handleResize()})}
updateMousePosition(ev){const rect=this.DOM.content.getBoundingClientRect();const posx=ev.clientX-rect.left;const posy=ev.clientY-rect.top;this.mousePos={x:posx,y:posy}}
handleResize(){this.images.forEach(img=>img.resize())}
getMouseDistance(){return Math.hypot(this.mousePos.x-this.lastMousePos.x,this.mousePos.y-this.lastMousePos.y)}
showNextImage(){const img=this.images[this.imgPosition];gsap.killTweensOf(img.DOM.el);const timeline=gsap.timeline();switch(this.config.type){case 'type-2':this.showType2(timeline,img);break;case 'type-3':this.showType3(timeline,img);break;case 'type-4':this.showType4(timeline,img);break;case 'type-5':this.showType5(timeline,img);break;default:this.showType1(timeline,img)}}
showType1(timeline,img){timeline.set(img.DOM.el,{opacity:0,scale:1,immediateRender:!0}).set(img.DOM.el,{opacity:1,scale:1,zIndex:this.zIndexVal,x:this.cacheMousePos.x-img.rect.width/2,y:this.cacheMousePos.y-img.rect.height/2}).to(img.DOM.el,{duration:0.9,ease:"expo.out",x:this.mousePos.x-img.rect.width/2,y:this.mousePos.y-img.rect.height/2}).to(img.DOM.el,{duration:1,ease:"power1.out",opacity:0,scale:0.2},"-=0.5")}
showType2(timeline,img){timeline.set(img.DOM.el,{opacity:0,immediateRender:!0}).set(img.DOM.el,{opacity:1,scale:1,zIndex:this.zIndexVal,x:this.cacheMousePos.x-img.rect.width/2,y:this.cacheMousePos.y-img.rect.height/2}).to(img.DOM.el,{duration:1.8,ease:"expo.out",x:this.mousePos.x-img.rect.width/2,y:this.mousePos.y-img.rect.height/2}).to(img.DOM.el,{duration:0.8,ease:"power1.out",opacity:0},"-=1").to(img.DOM.el,{duration:0.8,ease:"quint.inOut",scale:2},"<")}
showType3(timeline,img){timeline.set(img.DOM.el,{opacity:0,immediateRender:!0}).set(img.DOM.el,{opacity:1,zIndex:this.zIndexVal,x:this.cacheMousePos.x-img.rect.width/2,y:this.cacheMousePos.y-img.rect.height/2}).to(img.DOM.el,{duration:1.6,ease:"expo.out",x:this.mousePos.x-img.rect.width/2,y:this.mousePos.y-img.rect.height/2}).to(img.DOM.el,{duration:1,ease:"power1.out",opacity:0},"-=1.2").to(img.DOM.el,{duration:1,ease:"quint.inOut",y:`+=${this.winsize.height + img.rect.height/2}`},"<")}
showType4(timeline,img){img.DOM.el.style.setProperty('--img-maxwidth',`${this.getRandomFloat(150,350)}px`);img.getRect();timeline.set(img.DOM.el,{opacity:0,immediateRender:!0}).set(img.DOM.el,{opacity:1,rotation:0,zIndex:this.zIndexVal,x:this.cacheMousePos.x-img.rect.width/2,y:this.cacheMousePos.y-img.rect.height/2}).to(img.DOM.el,{duration:1.6,ease:"expo.out",x:this.mousePos.x-img.rect.width/2,y:this.mousePos.y-img.rect.height/2}).to(img.DOM.el,{duration:0.8,ease:"power1.out",opacity:0},"-=1").to(img.DOM.el,{duration:1,ease:"quint.out",x:`+=${this.getRandomFloat(-1*(this.winsize.width + img.rect.width/2), this.winsize.width + img.rect.width/2)}`,y:`+=${this.getRandomFloat(-1*(this.winsize.height + img.rect.height/2), this.winsize.height + img.rect.height/2)}`,rotation:this.getRandomFloat(-40,40)},"<")}
showType5(timeline,img){timeline.set(img.DOM.el,{opacity:0,immediateRender:!0}).set(img.DOM.el,{opacity:1,scaleX:1,scaleY:1,zIndex:this.zIndexVal,x:this.mousePos.x-img.rect.width/2,y:this.mousePos.y-img.rect.height/2,transformOrigin:'50% -10%'}).to(img.DOM.el,{duration:0.5,ease:"power1.out",opacity:0},0.4).to(img.DOM.el,{duration:0.2,ease:"quad.in",scaleX:0.5,scaleY:2},"<").to(img.DOM.el,{duration:0.5,ease:"expo.out",scaleX:0.7,scaleY:1.7,y:`+=${this.getRandomFloat(this.winsize.height/2, this.winsize.height)}`})}
getRandomFloat(min,max){return(Math.random()*(max-min)+min).toFixed(2)}
render(){const distance=this.getMouseDistance();this.cacheMousePos.x=this.lerp(this.cacheMousePos.x||this.mousePos.x,this.mousePos.x,this.config.lerpFactor);this.cacheMousePos.y=this.lerp(this.cacheMousePos.y||this.mousePos.y,this.mousePos.y,this.config.lerpFactor);if(distance>this.config.threshold){this.showNextImage();++this.zIndexVal;this.imgPosition=this.imgPosition<this.imagesTotal-1?this.imgPosition+1:0;this.lastMousePos={...this.mousePos}}
const isIdle=!this.images.some(img=>img.isActive());if(isIdle&&this.zIndexVal!==1){this.zIndexVal=1}
requestAnimationFrame(()=>this.render())}
lerp(start,end,factor){return(1-factor)*start+factor*end}}
document.querySelectorAll('.next-cursor-trail').forEach(container=>{new ImageTrail({container:container,itemSelector:'.next-cursor-trail__item',threshold:parseFloat(container.getAttribute('data-threshold')),lerpFactor:parseFloat(container.getAttribute('data-lerp-factor')),type:container.getAttribute('data-type'),animation:{show:{duration:parseFloat(container.getAttribute('data-show-duration')),ease:container.getAttribute('data-show-ease'),scale:1,opacity:1},hide:{duration:parseFloat(container.getAttribute('data-hide-duration')),ease:container.getAttribute('data-hide-ease'),scale:parseFloat(container.getAttribute('data-scale')),opacity:0,delay:parseFloat(container.getAttribute('data-hide-delay'))}},defaultStyle:{scale:1,x:0,y:0,opacity:0}})})}
document.addEventListener("DOMContentLoaded",function(t){bricksIsFrontend&&next_cursor_trail()})