function next_interactive_lines(){class InteractiveLines{constructor(selector,options={}){this.config={cell:options.cell,alpha:options.alpha,line:options.line,width:options.width,speed:options.speed,size:options.size,threshold:options.threshold,intensity:options.intensity,activeColor:options.activeColor,inactiveColor:options.inactiveColor,...options};this.DPR=window.devicePixelRatio||1;this.header=selector instanceof Element?selector:document.querySelector(selector);this.lines=this.header.querySelector('canvas');this.linesCtx=this.lines.getContext('2d');this.cells=[];this.initializeLines();this.setupEventListeners();this.setupProperties()}
drawLines=()=>{this.linesCtx.clearRect(0,0,this.lines.width,this.lines.height);this.cells.forEach((cell)=>{this.linesCtx.save();this.linesCtx.translate(cell.x,cell.y);this.linesCtx.rotate(cell.a);this.linesCtx.beginPath();this.linesCtx.globalAlpha=this.config.alpha;this.linesCtx.lineWidth=this.config.width;const dx=(parseFloat(this.header.style.getPropertyValue('--mx'))||0)-cell.x;const dy=(parseFloat(this.header.style.getPropertyValue('--my'))||0)-cell.y;const distance=Math.sqrt(dx*dx+dy*dy);this.linesCtx.strokeStyle=distance<this.config.size?this.config.activeColor:this.config.inactiveColor;this.linesCtx.moveTo((this.config.cell*this.config.line*-1)/2,0);this.linesCtx.lineTo((this.config.cell*this.config.line)/2,0);this.linesCtx.stroke();this.linesCtx.restore()})}
initializeLines=()=>{const{width,height}=this.lines.getBoundingClientRect();this.lines.width=width*this.DPR;this.lines.height=height*this.DPR;this.linesCtx.scale(this.DPR,this.DPR);this.cells.length=0;for(let x=0;x<width;x+=this.config.cell){for(let y=0;y<height;y+=this.config.cell){this.cells.push({x:x+this.config.cell*0.5,y:y+this.config.cell*0.5,r:0,t:0,a:0})}}
gsap.ticker.add(this.drawLines)}
getShortestRotation=(current,target)=>{let diff=target-current;if(diff>Math.PI)diff-=2*Math.PI;if(diff<-Math.PI)diff+=2*Math.PI;return diff}
syncLines=({x,y})=>{const{left,top}=this.lines.getBoundingClientRect();this.header.style.setProperty('--mx',Math.floor(x-left));this.header.style.setProperty('--my',Math.floor(y-top));this.cells.forEach((cell)=>{const dx=x-(cell.x+left);const dy=y-(cell.y+top);const newAngle=Math.atan2(dy,dx);const diff=this.getShortestRotation(cell.a,newAngle);if(Math.abs(diff)>this.config.threshold){cell.a+=diff*this.config.speed;cell.a=((cell.a+Math.PI)%(2*Math.PI))-Math.PI}else{cell.a=newAngle}
cell.t=newAngle})}
setupEventListeners(){const sizeObserver=new ResizeObserver(()=>this.initializeLines());sizeObserver.observe(this.lines);window.addEventListener(`pointermove`,(e)=>this.syncLines(e))}
setupProperties(){this.header.style.setProperty('--intensity',1-this.config.intensity);this.header.style.setProperty('--mask-size',this.config.size)}
destroy(){gsap.ticker.remove(this.drawLines);window.removeEventListener(`pointermove`,this.syncLines)}}
document.querySelectorAll('.next-interactive-lines').forEach(interactiveLines=>{const computedStyle=window.getComputedStyle(interactiveLines);new InteractiveLines(interactiveLines,{cell:parseFloat(interactiveLines.getAttribute('data-cell')),alpha:parseFloat(interactiveLines.getAttribute('data-alpha')),line:parseFloat(interactiveLines.getAttribute('data-line')),width:parseFloat(interactiveLines.getAttribute('data-width')),speed:parseFloat(interactiveLines.getAttribute('data-speed')),size:parseFloat(interactiveLines.getAttribute('data-size')),threshold:parseFloat(interactiveLines.getAttribute('data-threshold')),intensity:parseFloat(interactiveLines.getAttribute('data-intensity')),activeColor:computedStyle.getPropertyValue('--active-color').trim(),inactiveColor:computedStyle.getPropertyValue('--inactive-color').trim(),})})}
document.addEventListener("DOMContentLoaded",function(t){bricksIsFrontend&&next_interactive_lines()})