function next_interactive_lines_v2(){var isBricks=window.location.href.includes("brickspreview");document.querySelectorAll('.nb-interactive-lines-v2').forEach(interactiveLines=>{if(isBricks&&interactiveLines.getAttribute('data-disable-builder')==='1'){return}
const SPACING=parseFloat(interactiveLines.getAttribute('data-spacing'));const COLS=Math.floor(interactiveLines.offsetWidth/SPACING);const ROWS=Math.floor(interactiveLines.offsetHeight/SPACING);const STROKE_LENGTH=parseFloat(interactiveLines.getAttribute('data-stroke-length'));const STROKE_WIDTH=parseFloat(interactiveLines.getAttribute('data-stroke-width'));const canvas=interactiveLines.querySelector(".nb-interactive-lines-v2__canvas");const ctx=canvas.getContext("2d");const ball=interactiveLines.querySelector(".nb-interactive-lines-v2__ball");let width=COLS*SPACING;let height=ROWS*SPACING;canvas.width=width;canvas.height=height;const ballPosition={x:0,y:0};function snapToGrid(x,y){return{x:Math.round(x/SPACING)*SPACING,y:Math.round(y/SPACING)*SPACING,}}
function draw(){ctx.clearRect(0,0,width,height);const ballRect=ball.getBoundingClientRect();const canvasRect=canvas.getBoundingClientRect();const ballX=ballRect.left-canvasRect.left+ballRect.width/2;const ballY=ballRect.top-canvasRect.top+ballRect.height/2;ballPosition.x=ballX;ballPosition.y=ballY;for(let col=0;col<=COLS;col++){for(let row=0;row<=ROWS;row++){const pointX=col*SPACING;const pointY=row*SPACING;const dx=ballX-pointX;const dy=ballY-pointY;const distance=Math.sqrt(dx*dx+dy*dy);if(distance<15)continue;const angle=Math.atan2(dy,dx);ctx.beginPath();ctx.moveTo(pointX,pointY);ctx.lineTo(pointX+Math.cos(angle)*STROKE_LENGTH,pointY+Math.sin(angle)*STROKE_LENGTH);ctx.strokeStyle=getComputedStyle(interactiveLines).getPropertyValue('--lines-color');ctx.lineWidth=STROKE_WIDTH;ctx.stroke()}}
isAnimating=!1}
interactiveLines.addEventListener("mousemove",(e)=>{const rect=canvas.getBoundingClientRect();const x=e.clientX-rect.left;const y=e.clientY-rect.top;const{x:snapX,y:snapY}=snapToGrid(x,y);gsap.to(ball,{x:snapX,y:snapY,duration:parseFloat(interactiveLines.getAttribute('data-duration')),ease:interactiveLines.getAttribute('data-ease'),onUpdate:draw,})});draw()})}
document.addEventListener("DOMContentLoaded",function(t){bricksIsFrontend&&next_interactive_lines_v2();window.addEventListener("resize",next_interactive_lines_v2)})