<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Blur_Reading extends \Bricks\Element {
  public $category     = 'Next Bricks - Texts';
  public $name         = 'next_blur_reading';
  public $icon         = 'fa-solid fa-align-center';
  public $tag          = 'p';
  public $scripts      = ['next_blur_reading'];

  public function get_label() {
    return esc_html__( 'Blur Reading', 'bricks' );
  }

  public function set_controls() {
    $this->controls['type'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Type', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'v1' => 'v1',
            'v2' => 'v2',
            'v3' => 'v3',
            'v4' => 'v4',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'v1',
        'default'     => 'v1',
    ];
    $this->controls['tag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'HTML tag', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'h1' => 'h1',
            'h2' => 'h2',
            'h3' => 'h3',
            'h4' => 'h4',
            'h5' => 'h5',
            'h6' => 'h6',
            'p' => 'p',
            'span' => 'span',
            'custom' => 'custom',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'p',
        'default'     => 'p',
    ];
    $this->controls['customTag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Custom tag', 'bricks' ),
        'type'        => 'text',
        'inline'      => true,
        'placeholder' => 'p',
        'required'    => [ 'tag', '=', 'custom' ],
    ];

    $this->controls['inner_title'] = [
        'hasDynamicData'      => true,
        'tab'            => 'content',
        'type'           => 'textarea',
        'default'        => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis nec leo et mi mollis dictum. Vivamus bibendum est vel elit eleifend sodales. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis nec leo et mi mollis dictum. Vivamus bibendum est vel elit eleifend sodales. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis nec leo et mi mollis dictum. Vivamus bibendum est vel elit eleifend sodales. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis nec leo et mi mollis dictum. Vivamus bibendum est vel elit eleifend sodales.', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];

    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Style', 'bricks' ),
        'type'       => 'separator',
    ];

    $this->controls['titleTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
          [
            'property' => 'typography',
            'selector' => '',
          ],
        ],
    ];

    $this->controls['blur'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Blur', 'bricks' ),
        'type' => 'number',
        'units' => true,
        'inline' => true,
        'placeholder' => '10px',
    ];

    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Animation', 'bricks' ),
        'type'       => 'separator',
    ];

    $this->controls['disablebuilder'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Disable at the builder', 'bricks' ),
        'type'     => 'checkbox',
        'default' => false,
    ];

    $this->controls['splitType'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Split type', 'bricks' ),
        'type' => 'select',
        'options'     => [
            'chars' => 'chars',
            'words' => 'words',
        ],
        'inline' => true,
        'placeholder' => 'chars',
    ];

    $this->controls['stagger'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Stagger', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '0.05',
    ];

    $this->controls['ease'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP easing', 'bricks' ),
        'type' => 'select',
        'options'     => [
            'none' => 'none',
            'power1' => 'power1',
            'power2' => 'power2',
            'power3' => 'power3',
            'power4' => 'power4',
            'back' => 'back',
            'bounce' => 'bounce',
            'circ' => 'circ',
            'elastic' => 'elastic',
            'expo' => 'expo',
            'sine' => 'sine',
            'steps' => 'steps',
            'custom' => 'custom'
        ],
        'inline' => true,
        'placeholder' => 'none',
      ];
    $this->controls['customEase'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'ease', '=', 'custom' ],
    ];


    $this->controls['scrolltrigger'] = [
        'label'      => esc_html__( 'ScrollTrigger', 'bricks' ),
        'type'       => 'separator',
        'description' => sprintf(esc_html__( 'Scrolltrigger %s', 'bricks' ), '<a href="https://greensock.com/docs/v3/Plugins/ScrollTrigger" target="_blank">documentation</a>'),
    ];

    $this->controls['start'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Start', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => 'top bottom-=15%',
    ];

    $this->controls['end'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'End', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => 'bottom center+=15%',
    ];

    $this->controls['scroller'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Scroller', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => 'body',
    ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'next_blur_reading', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_blur_reading.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $inner_title = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Next Bricks';
    $type = ! empty( $settings['type'] ) ? $settings['type'] : 'v1';
    $blur = ! empty( $settings['blur'] ) ? $settings['blur'] : '10px';
    $disablebuilder = ! empty( $settings['disablebuilder'] ) ? $settings['disablebuilder'] : 0;
    $start = ! empty( $settings['start'] ) ? $settings['start'] : 'top center';
    $end = ! empty( $settings['end'] ) ? $settings['end'] : 'bottom center';
    $stagger = ! empty( $settings['stagger'] ) ? $settings['stagger'] : 0.05;
    $splitType = ! empty( $settings['splitType'] ) ? $settings['splitType'] : 'chars';
    $scroller = ! empty( $settings['scroller'] ) ? $settings['scroller'] : 'body';
    $easing = ! empty( $settings['ease'] ) ? $settings['ease'] : 'none';
    if ($easing === 'custom') {
      $easing = ! empty( $settings['customEase'] ) ? $settings['customEase'] : 'none';
    }

    $this->set_attribute( '_root', 'class', 'next-blur-reading' );
    $this->set_attribute( '_root', 'data-blur', $blur);
    $this->set_attribute( '_root', 'data-disable-builder', $disablebuilder);
    $this->set_attribute( '_root', 'data-start', $start);
    $this->set_attribute( '_root', 'data-end', $end);
    $this->set_attribute( '_root', 'data-stagger', $stagger);
    $this->set_attribute( '_root', 'data-splitType', $splitType);
    $this->set_attribute( '_root', 'data-scroller', $scroller);
    $this->set_attribute( '_root', 'data-easing', $easing);

    if($type == 'v1') {
      $this->set_attribute( '_root', 'class', 'next-blur-reading--v1' );
    }else if($type == 'v2') {
      $this->set_attribute( '_root', 'class', 'next-blur-reading--v2' );
    }else if($type == 'v3') {
      $this->set_attribute( '_root', 'class', 'next-blur-reading--v3' );
    }else if($type == 'v4') {
      $this->set_attribute( '_root', 'class', 'next-blur-reading--v4' );
    }
  

    $output = "<div {$this->render_attributes( '_root' )}>$inner_title</div>";

	echo $output;
  }
}
