<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Blurry_Button extends \Bricks\Element {
  public $category     = 'Next Bricks - Buttons';
  public $name         = 'next-blurry-button';
  public $icon         = 'fa-solid fa-square-minus';
  public $tag      = 'div';

  public function get_label() {
    return esc_html__( 'Blurry Button', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'span' => 'span',
          'button' => 'button',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['inner_title'] = [
        'label'       => esc_html__( 'Title', 'bricks' ),
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Blurry Button', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['blurry_title'] = [
        'label'       => esc_html__( 'Blurry Title', 'bricks' ),
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Blurry Button', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['padding'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Padding', 'bricks' ),
        'type'    => 'spacing',
        'css'     => [
            [
                'property' => 'padding',
                'selector' => '&{pseudo} .nb-blurry-button__text',
            ],
        ],
        'default' => [
            'top'    => 10,
            'right'  => 15, 
            'bottom' => 10,
            'left'   => 15,
        ],
    ];
    $this->controls['titleTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '',
            ],
        ],
        'default' => [
            'font-size' => '16px',
            'color' => [
                'hex' => '#000000',
              ]
        ],
    ];
    $this->controls['blurryTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Blurry Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '&{pseudo}::after',
            ],
        ],
        'default' => [
            'font-size' => '16px',
            'color' => [
                'hex' => '#ffffff',
              ]
        ],
    ];
    $this->controls['background'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '&{pseudo} .nb-blurry-button__background',
            ],
        ],
        'default' => [
            'hex' => '#ffffff',
        ],
    ];
    $this->controls['blurryBackground'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Blurry Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '&{pseudo}::after',
            ],
        ],
        'default' => [
            'hex' => '#000000',
        ],
    ];
    $this->controls['border'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Border', 'bricks'),
        'type'    => 'border',
        'css'     => [
          [
            'property' => 'border',
            'selector' => '&{pseudo} .nb-blurry-button__background',
          ],
        ],
        'default' => [
            'radius' => [
                'top' => 8,
                'right' => 8,
                'bottom' => 8,
                'left' => 8,
            ],
        ]
    ];
    $this->controls['blurryBorder'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Blurry Border', 'bricks'),
        'type'    => 'border',
        'css'     => [
          [
            'property' => 'border',
            'selector' => '&{pseudo}::after',
          ],
        ],
        'default' => [
            'radius' => [
                'top' => 8,
                'right' => 8,
                'bottom' => 8,
                'left' => 8,
            ],
        ]
    ];

    $this->controls['blurSeparator'] = [
        'label'      => esc_html__( 'Blur Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['blur'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Blur', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => '--blur',
                'selector' => '',
            ],
        ],
        'default' => '1em',
    ];
    $this->controls['blurScale'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Scale', 'bricks' ),
        'type'    => 'number',
        'css'     => [
            [
                'property' => '--blur-scale',
                'selector' => '',
            ],
        ],
        'default' => 0.85,
    ];
    $this->controls['blurDuration'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Duration', 'bricks' ),
        'type'    => 'number',
        'unit'    => 's',
        'css'     => [
            [
                'property' => '--blur-duration',
                'selector' => '',
            ],
        ],
        'default' => '1.05s',
    ];
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Blurry Button';
    $blurry_title    = ! empty( $settings['blurry_title'] ) ? $settings['blurry_title'] : 'Blurry Button';

    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = $this->tag;
    }

    $this->set_attribute( '_root', 'class', 'nb-blurry-button' );
    $this->set_attribute( '_root', 'data-text', $blurry_title );

    $output = "
    <$root_tag  {$this->render_attributes( '_root' )}>
        <span class='nb-blurry-button__container'>
            <span class='nb-blurry-button__text'>$inner_title</span>
            <span class='nb-blurry-button__background'></span>
        </span>
    </$root_tag>
    ";

	echo $output;
  }
}