<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Bubbles_Button_Bubble extends \Bricks\Element {
  public $name         = 'next-bubbles-button-bubble';
  public $icon         = 'fa-solid fa-circle';

  public function get_label() {
    return esc_html__( 'Bubble', 'bricks' );
  }

  public function set_controls() {
    $this->controls['width'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Width', 'bricks'),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
          [
            'property' => 'width',
            'selector' => '',
          ],
        ],
        'default' => 40,
    ];
    $this->controls['height'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Height', 'bricks'),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
          [
            'property' => 'height',
            'selector' => '',
          ],
        ],
        'default' => 40,
    ];
    $this->controls['blur'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Blur', 'bricks'),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
          [
            'property' => '--blur',
            'selector' => '',
          ],
        ],
        'default' => 8,
    ];
    $this->controls['background'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => '--background',
                'selector' => '',
            ],
        ],
        'default' => [
            'hex' => '#e21bda',
        ],
    ];

    $this->controls['bubblesAnimationSeparator'] = [
        'label'      => esc_html__( 'Bubble Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['animationType'] = [
        'tab'     => 'content',
        'inline'  => true,
        'label'   => esc_html__( 'Animation Type', 'bricks' ),
        'type'    => 'select',
        'options' => [
            'move-down-right'  => esc_html__( 'Down Right', 'bricks' ),
            'move-up-left'     => esc_html__( 'Up Left', 'bricks' ),
            'move-diagonal'    => esc_html__( 'Diagonal', 'bricks' ),
            'move-right'       => esc_html__( 'Right', 'bricks' ),
            'move-zigzag'      => esc_html__( 'Zigzag', 'bricks' ),
            'move-left'        => esc_html__( 'Left', 'bricks' ),
            'move-up'          => esc_html__( 'Up', 'bricks' ),
            'move-horizontal'  => esc_html__( 'Horizontal', 'bricks' ),
            'move-vertical'    => esc_html__( 'Vertical', 'bricks' ),
            'move-right-up'    => esc_html__( 'Right Up', 'bricks' ),
            'move-straight'    => esc_html__( 'Straight', 'bricks' ),
            'move-right-down'  => esc_html__( 'Right Down', 'bricks' ),
            'none'             => esc_html__( 'None', 'bricks' ),
        ],
        'css'     => [
            [
                'property' => '--animation',
                'selector' => '',
            ],
        ],
        'default' => 'move-zigzag',
    ];
    $this->controls['positionX'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Position X', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => '--x',
                'selector' => '',
            ],
        ],
        'default' => '0px',
    ];
    $this->controls['positionY'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Position Y', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => '--y',
                'selector' => '',
            ],
        ],
        'default' => '0px',
    ];
    $this->controls['bubblesDuration'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Duration', 'bricks' ),
        'type'    => 'number',
        'unit'    => 's',
        'css'     => [
            [
                'property' => '--duration',
                'selector' => '',
            ],
        ],
        'default' => '7s',
    ];
    $this->controls['bubblesDelay'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Delay', 'bricks' ),
        'type'    => 'number',
        'unit'    => 's',
        'css'     => [
            [
                'property' => '--delay',
                'selector' => '',
            ],
        ],
        'default' => '0s',
    ];
    $this->controls['bubblesEasing'] = [
        'tab'     => 'content',
        'inline'  => true,
        'label'   => esc_html__( 'CSS Easing', 'bricks' ),
        'type'    => 'text',
        'css'     => [
            [
                'property' => '--easing',
                'selector' => '',
            ],
        ],
        'default' => 'linear',
    ];
  }

  public function render() {
    $settings = $this->settings;

    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = $this->tag;
    }

    $this->set_attribute( '_root', 'class', 'nb-bubbles-button__circle' );

    $output = "<div {$this->render_attributes( '_root' )}></div>";

	echo $output;
  }
}