<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Cookies extends \Bricks\Element {
    public $category     = 'Next Bricks - Cores';
    public $name         = 'next_cookies';
    public $icon         = 'fas fa-cookie-bite';
    public $scripts      = ['next_cookies'];
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Cookies', 'bricks' );
    }

    public function set_control_groups() {
        $this->control_groups['preferencesItems'] = [
            'title' => esc_html__( 'Preferences Elements', 'bricks' ),
            'tab'   => 'content',
        ];
        $this->control_groups['animations'] = [
            'title' => esc_html__( 'Animations', 'bricks' ),
            'tab'   => 'content',
        ];
     }

    public function set_controls() {
        $this->controls['note'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'You can edit Notification element and its children flex settings at their own tabs, as well as their styles. Preferences are not nestable and need to be customized here.', 'bricks' )))
        ];
        $this->controls['openNotification'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Open Notification at Bricks', 'bricks' ),
            'type' => 'checkbox',
            'inline' => true,
            'default' => false,
        ];
        $this->controls['openPreferences'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Open Preferences at Bricks', 'bricks' ),
            'type' => 'checkbox',
            'inline' => true,
            'default' => false,
        ];
        $this->controls['apply'] = [
            'type' => 'apply',
            'reload' => true,
            'label' => esc_html__( 'Reload Preferences', 'bricks' ),
          ];
        //Process
        $this->controls['processSeparator'] = [
            'label'      => esc_html__( 'How do Cookies work?', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['note0'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Cookies are divided into categories.', 'bricks' )))
        ];
        $this->controls['note1'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Those essential cookies you dont track are understand as necessary cookies. And Necessary category will be always enabled.', 'bricks' )))
        ];
        $this->controls['note2'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'To track and set a non essential cookie at a category, create a category and set the attributes: type="text/plain" and data-category="customName" to the script inserting the cookie. "customName" is the name you have given to the category. The script will be linked to the category automatically.', 'bricks' )))
        ];
        $this->controls['note3'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'To be GDPR compliant, you need to let the visitor manage his preferences at any time. You can set the attribute data-cc="show-preferencesModal" at the element you want to show the preferences modal.', 'bricks' )))
        ];
        //Cookies Settings
        $this->controls['cookiesSettingsSeparator'] = [
            'label'      => esc_html__( 'Cookies Settings', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['cookieName'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Cookie name', 'bricks' ),
            'type' => 'text',
            'inline' => true,
            'placeholder' => 'Cookie consent',
        ];
        $this->controls['expiresAfter'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Days to expire', 'bricks' ),
            'type' => 'text',
            'inline' => true,
            'placeholder' => '365',
        ];
        $this->controls['type'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Preferences type', 'bricks' ),
            'type' => 'select',
            'options'     => [
                'box' => 'Modal',
                'bar' => 'OffCanvas',
            ],
            'inline' => true,
            'placeholder' => 'Modal',
        ];
        $this->controls['position'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Position', 'bricks' ),
            'type' => 'select',
            'options'     => [
                'right' => 'Right',
                'left' => 'Left',
            ],
            'inline' => true,
            'placeholder' => 'Right',
            'required' => [ 'type', '=', 'bar'],
        ];

        //Categories
        $this->controls['categoriesSeparator'] = [
            'label'      => esc_html__( 'Categories', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['necessaryCategoryTitle'] = [
            'hasDynamicData' => true,
            'tab' => 'content',
            'label' => esc_html__( 'Necessary title', 'bricks' ),
            'type' => 'text',
            'inline' => true,
            'placeholder' => 'Necessary cookies',
        ];
        $this->controls['necessaryCategoryDescription'] = [
            'hasDynamicData' => true,
            'tab' => 'content',
            'label' => esc_html__( 'Necessary description', 'bricks' ),
            'type' => 'textarea',
            'placeholder' => 'These cookies are required for the website to function properly.',
        ];
        $this->controls['categories'] = [
            'tab'           => 'content',
            'type'          => 'repeater',
            'label'         => esc_html__( 'Categories', 'bricks' ),
            'placeholder'   => esc_html__( 'Category', 'bricks' ),
            'titleProperty' => 'title',
            'fields'        => [
                'name'       => [
                    'type'    => 'text',
                    'label'   => esc_html__( 'Name', 'bricks' ),
                    'inline'    => true,
                ],
                'title'       => [
                    'type'    => 'text',
                    'label'   => esc_html__( 'Title', 'bricks' ),
                    'inline'    => true,
                ],
                'description'       => [
                    'type'    => 'textarea',
                    'label'   => esc_html__( 'Description', 'bricks' ),
                ],
                'enabled' => [
                    'type' => 'checkbox',
                    'label' => esc_html__( 'Enabled', 'bricks' ),
                    'inline' => true,
                    'default' => false,
                ],
                'readOnly' => [
                    'type' => 'checkbox',
                    'label' => esc_html__( 'Read Only', 'bricks' ),
                    'inline' => true,
                    'default' => false,
                ],
            ],
        ];

        //Preferences Items
        //Modal/OffCanvas
        $this->controls['modalOffCanvasSeparator'] = [
            'group' => 'preferencesItems',
            'label'      => esc_html__( 'Modal / OffCanvas', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['preferencesPadding'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Padding', 'bricks' ),
            'type'    => 'spacing',
            'css'     => [
                [
                    'property' => 'padding',
                    'selector' => '#cc-main .pm',
                ],
            ],
        ];
        $this->controls['preferencesMaxWidth'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Max Width', 'bricks' ),
            'type'    => 'number',
            'units' => true,
            'inline' => true,
            'css'     => [
                [
                    'property' => '--box-max-width',
                    'selector' => '',
                ],
            ],
            'placeholder'    => '688px',
            'required' => [ 'type', '=', 'box'],
        ];
        $this->controls['preferencesMaxHeight'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Max Height', 'bricks' ),
            'type'    => 'number',
            'units' => true,
            'inline' => true,
            'css'     => [
                [
                    'property' => '--box-max-height',
                    'selector' => '',
                ],
            ],
            'placeholder'    => '600px',
            'required' => [ 'type', '=', 'box'],
        ];
        $this->controls['preferencesMaxWidthBar'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Max Width', 'bricks' ),
            'type'    => 'number',
            'units' => true,
            'inline' => true,
            'css'     => [
                [
                    'property' => '--bar-max-width',
                    'selector' => '',
                ],
            ],
            'placeholder'    => '464px',
            'required' => [ 'type', '=', 'bar'],
        ];
        $this->controls['preferencesBackground'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Background', 'bricks' ),
            'type'    => 'background',
            'inline' => true,
            'css'     => [
                [
                    'property' => 'background',
                    'selector' => '#cc-main .pm',
                ],
            ],
        ];
        $this->controls['preferencesBorder'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Border', 'bricks' ),
            'type'    => 'border',
            'inline' => true,
            'css'     => [
                [
                    'property' => 'border',
                    'selector' => '#cc-main .pm',
                ],
            ],
        ];
        $this->controls['preferencesBoxShadow'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Box Shadow', 'bricks' ),
            'type'    => 'box-shadow',
            'inline' => true,
            'css'     => [
                [
                    'property' => 'box-shadow',
                    'selector' => '#cc-main .pm',
                ],
            ],
        ];
        $this->controls['separatorColor'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Separators Color', 'bricks' ),
            'type'    => 'color',
            'inline' => true,
            'css'     => [
                [
                    'property' => '--cc-separator-border-color',
                    'selector' => ''
                ],
            ],
        ];
        $this->controls['overlayBackground'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Overlay Background', 'bricks' ),
            'type'    => 'background',
            'inline' => true,
            'css'     => [
                [
                    'property' => 'background',
                    'selector' => '#cc-main .pm-overlay',
                ],
            ],
        ];
        //Title
        $this->controls['titleSeparator'] = [
            'group' => 'preferencesItems',
            'label'      => esc_html__( 'Title', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['titlePadding'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Padding', 'bricks' ),
            'type'    => 'spacing',
            'css'     => [
                [
                    'property' => 'padding',
                    'selector' => '#cc-main .pm__header',
                ],
            ],
        ];
        $this->controls['titleText'] = [
            'group' => 'preferencesItems',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Title', 'bricks' ),
            'type' => 'text',
            'inline' => true,
            'placeholder' => 'Cookie preferences',
        ];
        $this->controls['titleTypography'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Typography', 'bricks' ),
            'type'    => 'typography',
            'css'     => [
                [
                    'property' => 'typography',
                    'selector' => '#cc-main .pm__title',
                ],
            ],
        ];
        $this->controls['titleGap'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Title/Close gap', 'bricks' ),
            'type'    => 'number',
            'units' => true,
            'inline' => true,
            'css'     => [
                [
                    'property' => '--title-gap',
                    'selector' => '',
                ],
            ],
            'placeholder'    => '32px',
        ];
        //Close Button
        $this->controls['closeButtonSeparator'] = [
            'group' => 'preferencesItems',
            'label'      => esc_html__( 'Close Button', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['closeButtonDimensions'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Dimensions', 'bricks' ),
            'type'    => 'number',
            'units' => true,
            'inline' => true,
            'css'     => [
                [
                    'property' => '--close-dimensions',
                    'selector' => '',
                ],
            ],
            'placeholder'    => '40px',
        ];
        $this->controls['closeButtonCrossColor'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Cross color', 'bricks' ),
            'type'    => 'color',
            'inline' => true,
            'css'     => [
                [
                    'property' => 'stroke',
                    'selector' => '#cc-main .pm__close-btn svg',
                ],
            ],
        ];
        $this->controls['closeButtonCrossColorHover'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Cross color on hover', 'bricks' ),
            'type'    => 'color',
            'inline' => true,
            'css'     => [
                [
                    'property' => '--cc-btn-secondary-hover-color',
                    'selector' => '',
                ],
            ],
        ];
        $this->controls['closeButtonBackground'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Background', 'bricks' ),
            'type'    => 'color',
            'inline' => true,
            'css'     => [
                [
                    'property' => 'background',
                    'selector' => '#cc-main .pm__close-btn',
                ],
            ],
        ];
        $this->controls['closeButtonBackgroundHover'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Background on hover', 'bricks' ),
            'type'    => 'color',
            'inline' => true,
            'css'     => [
                [
                    'property' => '--cc-btn-secondary-hover-bg',
                    'selector' => '',
                ],
            ],
        ];
        $this->controls['closeButtonBorder'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Border', 'bricks' ),
            'type'    => 'border',
            'inline' => true,
            'css'     => [
                [
                    'property' => 'border',
                    'selector' => '#cc-main .pm__close-btn',
                ],
            ],
        ];
        //Categories
        $this->controls['categoriesItemsSeparator'] = [
            'group' => 'preferencesItems',
            'label'      => esc_html__( 'Categories', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['categoriesPadding'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Padding', 'bricks' ),
            'type'    => 'spacing',
            'css'     => [
                [
                    'property' => 'padding',
                    'selector' => '#cc-main .pm__body',
                ],
            ],
        ];
        $this->controls['categoriesGap'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Categories gap', 'bricks' ),
            'type'    => 'number',
            'units' => true,
            'inline' => true,
            'css'     => [
                [
                    'property' => '--sections-gap',
                    'selector' => '',
                ],
            ],
            'placeholder'    => '6px',
        ];
        $this->controls['categoriesBackground'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Background', 'bricks' ),
            'type'    => 'color',
            'inline' => true,
            'css'     => [
                [
                    'property' => 'background',
                    'selector' => '#cc-main .pm__section-title, #cc-main .pm__section-desc-wrapper',
                ],
            ],
        ];
        $this->controls['categoriesBackgroundHover'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Background on hover', 'bricks' ),
            'type'    => 'color',
            'inline' => true,
            'css'     => [
                [
                    'property' => '--cc-cookie-category-block-hover-bg',
                    'selector' => '',
                ],
            ],
        ];
        $this->controls['categoriesBorder'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Border', 'bricks' ),
            'type'    => 'border',
            'inline' => true,
            'css'     => [
                [
                    'property' => 'border',
                    'selector' => '#cc-main .pm__section-desc-wrapper, #cc-main .pm__section-title',
                ],
            ],
        ];
        $this->controls['labelTypography'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Label Typography', 'bricks' ),
            'type'    => 'typography',
            'css'     => [
                [
                    'property' => 'typography',
                    'selector' => '#cc-main .pm__section-title',
                ],
            ],
        ];
        $this->controls['labelPadding'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Label Padding', 'bricks' ),
            'type'    => 'spacing',
            'css'     => [
                [
                    'property' => 'padding',
                    'selector' => '#cc-main .pm__section-title',
                ],
            ],
        ];
        $this->controls['descriptionTypography'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Description Typography', 'bricks' ),
            'type'    => 'typography',
            'css'     => [
                [
                    'property' => 'typography',
                    'selector' => '#cc-main .pm__section-desc',
                ],
            ],
        ];
        $this->controls['descriptionPadding'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Description Padding', 'bricks' ),
            'type'    => 'spacing',
            'css'     => [
                [
                    'property' => 'padding',
                    'selector' => '#cc-main .pm__section-desc',
                ],
            ],
        ];
        $this->controls['arrowDimensions'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Arrow Dimensions', 'bricks' ),
            'type'    => 'number',
            'units' => true,
            'inline' => true,
            'css'     => [
                [
                    'property' => '--arrow-dimensions',
                    'selector' => '',
                ],
            ],
            'placeholder'    => '20px',
        ];
        $this->controls['arrowLeft'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Arrow Left', 'bricks' ),
            'type'    => 'number',
            'units' => true,
            'inline' => true,
            'css'     => [
                [
                    'property' => '--arrow-left',
                    'selector' => '',
                ],
            ],
            'placeholder'    => '18px',
        ];
        $this->controls['arrowBackground'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Arrow Background', 'bricks' ),
            'type'    => 'background',
            'inline' => true,
            'css'     => [
                [
                    'property' => 'background',
                    'selector' => '#cc-main .pm__section-arrow',
                ],
            ],
        ];
        $this->controls['arrowColor'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Arrow Color', 'bricks' ),
            'type'    => 'color',
            'inline' => true,
            'css'     => [
                [
                    'property' => 'stroke',
                    'selector' => '#cc-main .pm__section-arrow svg',
                ],
            ],
        ];
        $this->controls['switchDimensions'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Switch Dimensions', 'bricks' ),
            'type'    => 'number',
            'units' => true,
            'inline' => true,
            'css'     => [
                [
                    'property' => '--toggles-dimensions',
                    'selector' => '',
                ],
            ],
            'placeholder'    => '36px',
        ];
        $this->controls['switchLeft'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Switch Right', 'bricks' ),
            'type'    => 'number',
            'units' => true,
            'inline' => true,
            'css'     => [
                [
                    'property' => '--toggles-right',
                    'selector' => '',
                ],
            ],
            'placeholder'    => '18px',
        ];
        $this->controls['switchOffColor'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Switch Off Color', 'bricks' ),
            'type'    => 'color',
            'inline' => true,
            'css'     => [
                [
                    'property' => '--cc-toggle-off-bg',
                    'selector' => '',
                ],
            ],
        ];
        $this->controls['switchOnColor'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Switch On Color', 'bricks' ),
            'type'    => 'color',
            'inline' => true,
            'css'     => [
                [
                    'property' => '--cc-toggle-on-bg',
                    'selector' => '',
                ],
            ],
        ];
        $this->controls['readOnlyColor'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Read Only Color', 'bricks' ),
            'type'    => 'color',
            'inline' => true,
            'css'     => [
                [
                    'property' => '--cc-toggle-readonly-bg',
                    'selector' => '',
                ],
            ],
        ];
        //Buttons
        $this->controls['buttonsSeparator'] = [
            'group' => 'preferencesItems',
            'label'      => esc_html__( 'Buttons', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['buttonsPadding'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Padding', 'bricks' ),
            'type'    => 'spacing',
            'css'     => [
                [
                    'property' => 'padding',
                    'selector' => '#cc-main .pm__footer',
                ],
            ],
        ];
        $this->controls['buttonsGap'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Buttons gap', 'bricks' ),
            'type'    => 'number',
            'units' => true,
            'inline' => true,
            'css'     => [
                [
                    'property' => '--buttons-gap',
                    'selector' => '',
                ],
            ],
            'placeholder'    => '6px',
        ];
        $this->controls['acceptButtonText'] = [
            'group' => 'preferencesItems',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Accept Text', 'bricks' ),
            'type' => 'text',
            'inline' => true,
            'placeholder' => 'Accept all',
        ];
        $this->controls['rejectButtonText'] = [
            'group' => 'preferencesItems',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Reject Text', 'bricks' ),
            'type' => 'text',
            'inline' => true,
            'placeholder' => 'Reject all',
        ];
        $this->controls['acceptRejectPadding'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Accept/Reject Padding', 'bricks' ),
            'type'    => 'spacing',
            'css'     => [
                [
                    'property' => 'padding',
                    'selector' => '#cc-main .pm__btn:not(.pm__btn--secondary)',
                ],
            ],
        ];
        $this->controls['acceptRejectTypography'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Accept/Reject Typography', 'bricks' ),
            'type'    => 'typography',
            'css'     => [
                [
                    'property' => 'typography',
                    'selector' => '#cc-main .pm__btn:not(.pm__btn--secondary)',
                ],
            ],
        ];
        $this->controls['acceptRejectBackground'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Accept/Reject Background', 'bricks' ),
            'type'    => 'background',
            'inline' => true,
            'css'     => [
                [
                    'property' => 'background',
                    'selector' => '#cc-main .pm__btn:not(.pm__btn--secondary)',
                ],
            ],
        ];
        $this->controls['acceptRejectBackgroundHover'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Accept/Reject Background on hover', 'bricks' ),
            'type'    => 'color',
            'inline' => true,
            'css'     => [
                [
                    'property' => '--cc-btn-primary-hover-bg',
                    'selector' => '',
                ],
            ],
        ];
        $this->controls['acceptRejectBorder'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Accept/Reject Border', 'bricks' ),
            'type'    => 'border',
            'inline' => true,
            'css'     => [
                [
                    'property' => 'border',
                    'selector' => '#cc-main .pm__btn:not(.pm__btn--secondary)',
                ],
            ],
        ];
        $this->controls['acceptRejectBoxShadow'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Accept/Reject Box Shadow', 'bricks' ),
            'type'    => 'box-shadow',
            'inline' => true,
            'css'     => [
                [
                    'property' => 'box-shadow',
                    'selector' => '#cc-main .pm__btn:not(.pm__btn--secondary)',
                ],
            ],
        ];
        $this->controls['saveButtonText'] = [
            'group' => 'preferencesItems',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Save Button', 'bricks' ),
            'type' => 'text',
            'inline' => true,
            'placeholder' => 'Save preferences',
        ];
        $this->controls['saveButtonPadding'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Save Text', 'bricks' ),
            'type'    => 'spacing',
            'css'     => [
                [
                    'property' => 'padding',
                    'selector' => '#cc-main .pm__btn--secondary',
                ],
            ],
        ];
        $this->controls['saveButtonTypography'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Save Typography', 'bricks' ),
            'type'    => 'typography',
            'css'     => [
                [
                    'property' => 'typography',
                    'selector' => '#cc-main .pm__btn--secondary',
                ],
            ],
        ];
        $this->controls['saveButtonBackground'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Save Background', 'bricks' ),
            'type'    => 'background',
            'inline' => true,
            'css'     => [
                [
                    'property' => 'background',
                    'selector' => '#cc-main .pm__btn--secondary',
                ],
            ],
        ];
        $this->controls['saveButtonBackgroundHover'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Save Background on hover', 'bricks' ),
            'type'    => 'color',
            'inline' => true,
            'css'     => [
                [
                    'property' => '--cc-btn-secondary-hover-bg',
                    'selector' => '',
                ],
            ],
        ];
        $this->controls['saveButtonBorder'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Save Border', 'bricks' ),
            'type'    => 'border',
            'inline' => true,
            'css'     => [
                [
                    'property' => 'border',
                    'selector' => '#cc-main .pm__btn--secondary',
                ],
            ],
        ];
        $this->controls['saveButtonBoxShadow'] = [
            'group' => 'preferencesItems',
            'tab'     => 'content',
            'label'   => esc_html__( 'Save Box Shadow', 'bricks' ),
            'type'    => 'box-shadow',
            'inline' => true,
            'css'     => [
                [
                    'property' => 'box-shadow',
                    'selector' => '#cc-main .pm__btn--secondary',
                ],
            ],
        ];

        //Animations
        //Notification
        $this->controls['notificationAnimationSeparator'] = [
            'group' => 'animations',
            'label'      => esc_html__( 'Notification', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['translateAmount'] = [
            'group' => 'animations',
            'tab'     => 'content',
            'label'   => esc_html__( 'Translate', 'bricks' ),
            'type'    => 'number',
            'units' => true,
            'inline' => true,
            'css'     => [
                [
                    'property' => '--notification-translate',
                    'selector' => '',
                ],
            ],
            'placeholder' => '25px',
        ];
        $this->controls['transitionDuration'] = [
            'group' => 'animations',
            'tab'     => 'content',
            'label'   => esc_html__( 'Transition Duration', 'bricks' ),
            'type'    => 'number',
            'unit' => 's',
            'inline' => true,
            'css'     => [
                [
                    'property' => '--notification-transition-duration',
                    'selector' => '',
                ],
            ],
            'placeholder' => '0.3s',
        ];
        $this->controls['transitionEasing'] = [
            'group' => 'animations',
            'tab'     => 'content',
            'label'   => esc_html__( 'Transition CSS easing', 'bricks' ),
            'type'    => 'text',
            'css'     => [
                [
                    'property' => '--notification-transition-easing',
                    'selector' => '',
                ],
            ],
            'placeholder' => 'ease',
        ];
        //Preferences
        $this->controls['preferencesAnimationSeparator'] = [
            'group' => 'animations',
            'label'      => esc_html__( 'Preferences', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['preferencesTransitionDuration'] = [
            'group' => 'animations',
            'tab'     => 'content',
            'label'   => esc_html__( 'Transition Duration', 'bricks' ),
            'type'    => 'number',
            'unit' => 's',
            'inline' => true,
            'css'     => [
                [
                    'property' => '--cc-modal-transition-duration',
                    'selector' => '',
                ],
            ],
            'placeholder' => '0.25s',
        ];
        $this->controls['preferencesTransitionEasing'] = [
            'group' => 'animations',
            'tab'     => 'content',
            'label'   => esc_html__( 'Transition CSS easing', 'bricks' ),
            'type'    => 'text',
            'css'     => [
                [
                    'property' => '--cc-modal-transition-easing',
                    'selector' => '',
                ],
            ],
            'placeholder' => 'ease',
        ];
    }

    public function get_nestable_children() {
        return [
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Notification', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-cookies__notification',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'block',
                        'label'    => esc_html__( 'Content', 'bricks' ),
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'next-cookies__content',
                            ],
                        ],
                        'children' => [
                            [
                                'name'     => 'heading',
                                'label'    => esc_html__( 'Label', 'bricks' ),
                                'settings' => [
                                    'text' => esc_html__( 'Cookies are deployed', 'bricks' ),
                                    'tag'  => 'h3',
                                    '_hidden'  => [
                                        '_cssClasses' => 'next-cookies__label',
                                    ],
                                ],
                            ],
                            [
                                'name'     => 'text',
                                'label'    => esc_html__( 'Line info', 'bricks' ),
                                'settings' => [
                                    'text' => esc_html__( 'We use cookies to enhance your experience.', 'bricks' ),
                                    'tag'  => 'p',
                                    '_hidden'  => [
                                        '_cssClasses' => 'next-cookies__info',
                                    ],
                                ],
                            ]
                        ]
                    ],
                    [
                        'name'     => 'block',
                        'label'    => esc_html__( 'Buttons', 'bricks' ),
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'next-cookies__buttons',
                            ],
                        ],
                        'children' => [
                            [
                                'name'     => 'button',
                                'label'    => esc_html__( 'Manage', 'bricks' ),
                                'settings' => [
                                    'text' => esc_html__( 'Manage', 'bricks' ),
                                    '_hidden'  => [
                                        '_cssClasses' => 'next-cookies__manage',
                                    ],
                                    '_attributes' => [
                                        [
                                        'name' => 'data-cc',
                                        'value' => 'show-preferencesModal',
                                        ],
                                    ]
                                ],
                            ],
                            [
                                'name'     => 'button',
                                'label'    => esc_html__( 'Allow', 'bricks' ),
                                'settings' => [
                                    'text' => esc_html__( 'Allow', 'bricks' ),
                                    '_hidden'  => [
                                        '_cssClasses' => 'next-cookies__allow',
                                    ],
                                    '_attributes' => [
                                        [
                                        'name' => 'data-cc',
                                        'value' => 'accept-all',
                                        ],
                                    ]
                                ],
                            ]
                        ]
                    ],
                ]
            ],
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next_cookieconsent', NEXTBRICKS_PLUGIN_URL . 'local_assets/next_cookieconsent.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
        wp_enqueue_script( 'next_cookies', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_cookies.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $openNotification = ! empty( $settings['openNotification'] ) ? $settings['openNotification'] : 0;
        $openPreferences = ! empty( $settings['openPreferences'] ) ? $settings['openPreferences'] : 0;

        /*Cookies Settings*/
        $cookieName    = ! empty( $settings['cookieName'] ) ? $settings['cookieName'] : 'Cookie consent';
        $expiresAfter  = ! empty( $settings['expiresAfter'] ) ? $settings['expiresAfter'] : 365;
        $blockSite     = ! empty( $settings['blockSite'] ) ? $settings['blockSite'] : 0;
        $type          = ! empty( $settings['type'] ) ? $settings['type'] : 'box';
        $position      = ! empty( $settings['position'] ) ? $settings['position'] : 'right';

        /*Categories*/
        $necessaryCategoryTitle    = ! empty( $settings['necessaryCategoryTitle'] ) ? $settings['necessaryCategoryTitle'] : 'Necessary cookies';
        $necessaryCategoryDescription    = ! empty( $settings['necessaryCategoryDescription'] ) ? $settings['necessaryCategoryDescription'] : 'These cookies are required for the website to function properly.';
        $categories = ! empty( $settings['categories'] ) ? $settings['categories'] : false; /*repeater*/

        /*Preferences Items*/
        $titleText = ! empty( $settings['titleText'] ) ? $settings['titleText'] : 'Cookie preferences';
        $acceptButtonText = ! empty( $settings['acceptButtonText'] ) ? $settings['acceptButtonText'] : 'Accept all';
        $rejectButtonText = ! empty( $settings['rejectButtonText'] ) ? $settings['rejectButtonText'] : 'Reject all';
        $saveButtonText = ! empty( $settings['saveButtonText'] ) ? $settings['saveButtonText'] : 'Save preferences';

        $this->set_attribute( '_root', 'class', "next-cookies");

        $output = "<div {$this->render_attributes( '_root' )}
        data-open-notification=\"$openNotification\"
        data-open-preferences=\"$openPreferences\"
        data-cookie-name=\"$cookieName\"
        data-expires-after=\"$expiresAfter\"
        data-block-site=\"$blockSite\"
        data-type=\"$type\"
        data-position=\"$position\"
        data-necessary-category-title=\"$necessaryCategoryTitle\"
        data-necessary-category-description=\"$necessaryCategoryDescription\"
        data-title-text=\"$titleText\"
        data-accept-button-text=\"$acceptButtonText\"
        data-reject-button-text=\"$rejectButtonText\"
        data-save-button-text=\"$saveButtonText\">";
        $output .= Frontend::render_children( $this );
        if ($categories) {
            $output .= '<div class="next-categories-list" data-name="';
            foreach ( $categories as $category ) {
                if ( isset($category['name'])) {
                    $output .= $category['name'] . 'd4511782';
                }
                else{
                    $output .= 'unset' . 'd4511782';
                }
            }
            $output .= '" data-title="';
            foreach ( $categories as $category ) {
                if ( isset($category['title'])) {
                    $output .= $category['title'] . 'd4511782';
                }
                else{
                    $output .= 'unset' . 'd4511782';
                }
            }
            $output .= '" data-description="';
            foreach ( $categories as $category ) {
                if ( isset($category['description'])) {
                    $output .= $category['description'] . 'd4511782';
                }
                else{
                    $output .= 'unset' . 'd4511782';
                }
            }
            $output .= '" data-enabled="';
            foreach ( $categories as $category ) {
                if ( isset($category['enabled'])) {
                    $output .= $category['enabled'] . 'd4511782';
                }
                else{
                    $output .= '0' . 'd4511782';
                }
            }
            $output .= '" data-read-only="';
            foreach ( $categories as $category ) {
                if ( isset($category['readOnly'])) {
                    $output .= $category['readOnly'] . 'd4511782';
                }
                else{
                    $output .= '0' . 'd4511782';
                }
            }
            $output .= '"></div>';
        }
        $output .= '</div>';

        echo $output;
    }
}