<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_CTA_Nav extends \Bricks\Element {
    public $category     = 'Next Bricks - Menus';
    public $name         = 'nextctanav';
    public $icon         = 'ti-menu-alt';
    public $tag      = 'div';
    public $scripts      = ['next_cta_nav'];
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'CTA Nav', 'bricks' );
    }

    public function set_controls() {
        $this->controls['tag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'HTML tag', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'div' => 'div',
                'section' => 'section',
                'nav' => 'nav',
                'aside' => 'aside',
                'header' => 'header',
                'footer' => 'footer',
                'custom' => 'custom',
            ],
            'clearable'   => false,
            'inline'      => true,
            'placeholder' => 'div',
            'default'     => 'div',
        ];
        $this->controls['customTag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Custom tag', 'bricks' ),
            'type'        => 'text',
            'inline'      => true,
            'placeholder' => 'div',
            'required'    => [ 'tag', '=', 'custom' ],
        ];
        $this->controls['noteAux'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'CTA and Nav styles can be edited at their Style tab. Both of them have a padding applied.', 'bricks' )))
        ];

        //Animation
        $this->controls['animationSeparator'] = [
            'label'      => esc_html__( 'Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['note'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Sticky Offset is the value at which the CTA will stick to the top of the viewport and transform into a Nav.', 'bricks' )))
        ];
        $this->controls['offset'] = [
            'label'       => esc_html__( 'Sticky Offset', 'bricks' ),
            'type'        => 'number',
            'units'      => true,
            'css'     => [
                [
                  'property' => '--offset',
                  'selector' => '',
                ],
            ],
            'placeholder' => '20px',
            'default' => '20px',
        ];
        $this->controls['animationduration'] = [
            'label'       => esc_html__( 'Duration', 'bricks' ),
            'type'        => 'number',
            'unit'      => 's',
            'inline'      => true,
            'css'     => [
                [
                  'property' => '--duration',
                  'selector' => '',
                ],
              ],
            'placeholder' => '0.7s',
            'default' => '0.7s',
        ];
        $this->controls['animationeasing'] = [
            'label'       => esc_html__( 'CSS Easing', 'bricks' ),
            'type'        => 'text',
            'hasDynamicData' => false,
            'inline'      => true,
            'css'     => [
                [
                'property' => '--easing',
                'selector' => '',
                ],
            ],
            'placeholder' => 'ease',
            'default' => 'ease',
        ];

        //Nav style
        $this->controls['navStyleSeparator'] = [
            'label'      => esc_html__( 'Nav style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['width'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'width',
                'selector' => '',
              ]
            ],
            'placeholder' => 'fit-content',
            'default' => 'auto',
        ];
        $this->controls['height'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Height', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'height',
                'selector' => '',
              ]
            ],
            'placeholder' => 'auto',
            'default' => 'auto',
        ];
        $this->controls['background'] = [
            'label'       => esc_html__( 'Background', 'bricks' ),
            'type'        => 'background',
            'css'     => [
                [
                  'property' => 'background',
                  'selector' => '',
                ],
            ],
            'default' => [
                'color' => [
                  'hex' => '#FF98ED',
                ],
            ],
        ];
        $this->controls['border'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Border', 'bricks' ),
            'type'  => 'border',
            'inline' => true,
            'css' => [
              [
                'property' => 'border',
                'selector' => '',
              ]
            ],
            'default' => [
                'radius' => [
                  'top' => 50,
                  'right' => 50,
                  'bottom' => 50,
                  'left' => 50,
                ],
            ],
        ];
        $this->controls['boxShadow'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Box shadow', 'bricks' ),
            'type'  => 'box-shadow',
            'inline' => true,
            'css' => [
              [
                'property' => 'box-shadow',
                'selector' => '',
              ]
            ],
        ];
    }

    public function get_nestable_children() {
        return [
            [
                'name'     => 'block',
                'label'    => esc_html__( 'CTA', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-cta-nav__cta',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'heading',
                        'label'    => esc_html__( 'CTA Item', 'bricks' ),
                        'settings' => [
                            'text' => esc_html__( 'CTA Item', 'bricks' ),
                            'tag'  => 'span',
                        ],
                    ],
                ],
            ],

            [
                'name'     => 'block',
                'label'    => esc_html__( 'Nav', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-cta-nav__nav',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'heading',
                        'label'    => esc_html__( 'Nav Item', 'bricks' ),
                        'settings' => [
                            'text' => esc_html__( 'Nav Item', 'bricks' ),
                            'tag'  => 'span',
                        ],
                    ],
                    [
                        'name'     => 'heading',
                        'label'    => esc_html__( 'Nav Item', 'bricks' ),
                        'settings' => [
                            'text' => esc_html__( 'Nav Item', 'bricks' ),
                            'tag'  => 'span',
                        ],
                    ],
                    [
                        'name'     => 'heading',
                        'label'    => esc_html__( 'Nav Item', 'bricks' ),
                        'settings' => [
                            'text' => esc_html__( 'Nav Item', 'bricks' ),
                            'tag'  => 'span',
                        ],
                    ],
                ],
            ],
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next-cta-nav', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_cta_nav.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $offset = ! empty( $settings['offset'] ) ? $settings['offset'] : 20;

        $this->set_attribute( '_root', 'class', 'next-cta-nav' );
        $this->set_attribute( '_root', 'data-offset', $offset );

        $output = "<{$this->tag} {$this->render_attributes( '_root' )}>";
        $output .= Frontend::render_children( $this );
        $output .= "</{$this->tag}>";

        echo $output;
    }
}