<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Cursor_Trail extends \Bricks\Element {
    public $category     = 'Next Bricks - Cursors';
    public $name         = 'next_cursor_trail';
    public $icon         = 'ion-ios-apps';
    public $scripts      = ['next_cursor_trail'];
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Cursor Trail', 'bricks' );
    }

    public function set_controls() {
        $this->controls['note'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'All your content to be affected by the Cursor Trail should be placed inside the content element.', 'bricks' )))
        ];
        $this->controls['note2'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'The trail effect will use the Trail item elements inside Cursor Trail element. You can remove and duplicate Trail items at pleasure and place any elements at them.', 'bricks' )))
        ];
        /*Content*/
        $this->controls['contentSeparator'] = [
            'label'      => esc_html__( 'Content', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['width'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
                [
                'property' => 'width',
                'selector' => '.next-cursor-trail__content',
                ]
            ],
            'default' => '100%',
        ];
        $this->controls['height'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Height', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
                [
                'property' => 'height',
                'selector' => '.next-cursor-trail__content',
                ]
            ],
            'default' => '100vh',
        ];

        /*Animation*/
        $this->controls['animationSeparator'] = [
            'label'      => esc_html__( 'Trail Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['type'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Type', 'bricks' ),
            'type' => 'select',
            'options'     => [
              'type-1' => 'type1',
              'type-2' => 'type2',
              'type-3' => 'type3',
              'type-4' => 'type4',
              'type-5' => 'type5',
            ],
            'inline' => true,
            'default' => 'type-3',
        ];
        $this->controls['threshold'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Threshold', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'default' => 100,
        ];
        $this->controls['lerpFactor'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Lerp Factor', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'default' => 0.1,
        ];

        /*Show Animation*/
        $this->controls['showAnimationSeparator'] = [
            'label'      => esc_html__( 'Show Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['showDuration'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Duration', 'bricks' ),
            'type' => 'number',
            'unit' => 's',
            'inline' => true,
            'default' => '0.9s',
        ];
        $this->controls['showEase'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'GSAP easing', 'bricks' ),
            'type' => 'select',
            'options'     => [
                'none' => 'none',
                'power1' => 'power1',
                'power2' => 'power2',
                'power3' => 'power3',
                'power4' => 'power4',
                'back' => 'back',
                'bounce' => 'bounce',
                'circ' => 'circ',
                'elastic' => 'elastic',
                'expo' => 'expo',
                'sine' => 'sine',
                'steps' => 'steps',
                'custom' => 'custom'
            ],
            'inline' => true,
            'default' => 'expo',
        ];
    $this->controls['customShowEase'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'showEase', '=', 'custom' ],
    ];




        /*Hide Animation*/
        $this->controls['hideAnimationSeparator'] = [
            'label'      => esc_html__( 'Hide Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['scale'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Scale', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'default' => 0.2,
        ];
        $this->controls['hideDelay'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Delay', 'bricks' ),
            'type' => 'number',
            'unit' => 's',
            'inline' => true,
            'default' => '0.4s',
        ];
        $this->controls['hideDuration'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Duration', 'bricks' ),
            'type' => 'number',
            'unit' => 's',
            'inline' => true,
            'default' => '1s',
        ];
        $this->controls['hideEase'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'GSAP easing', 'bricks' ),
            'type' => 'select',
            'options'     => [
                'none' => 'none',
                'power1' => 'power1',
                'power2' => 'power2',
                'power3' => 'power3',
                'power4' => 'power4',
                'back' => 'back',
                'bounce' => 'bounce',
                'circ' => 'circ',
                'elastic' => 'elastic',
                'expo' => 'expo',
                'sine' => 'sine',
                'steps' => 'steps',
                'custom' => 'custom'
            ],
            'inline' => true,
            'default' => 'power1',
        ];
    $this->controls['customHideEase'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'hideEase', '=', 'custom' ],
    ];



    }

    public function get_nestable_children() {
        return [
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Content', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-cursor-trail__content',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'heading',
                        'label'    => esc_html__( 'Heading', 'bricks' ),
                        'settings' => [
                            'text' => esc_html__( 'Cursor Trail', 'bricks' ),
                            'tag'  => 'h3',
                        ],
                    ]
                ]
            ],
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Trail Item', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-cursor-trail__item',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'image',
                        'label'    => esc_html__( 'Image', 'bricks' ),
                        'settings' => [
                            'image'  => [
                                'url' => 'https://nextbricks.io/wp-content/uploads/2024/09/cursor_slide_1.webp',
                            ],
                        ],
                    ]
                ]
            ],
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Trail Item', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-cursor-trail__item',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'image',
                        'label'    => esc_html__( 'Image', 'bricks' ),
                        'settings' => [
                            'image'  => [
                                'url' => 'https://nextbricks.io/wp-content/uploads/2024/09/cursor_slide_2.webp',
                            ],
                        ],
                    ]
                ]
            ],
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Trail Item', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-cursor-trail__item',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'image',
                        'label'    => esc_html__( 'Image', 'bricks' ),
                        'settings' => [
                            'image'  => [
                                'url' => 'https://nextbricks.io/wp-content/uploads/2024/09/cursor_slide_3.webp',
                            ],
                        ],
                    ]
                ]
            ],
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Trail Item', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-cursor-trail__item',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'image',
                        'label'    => esc_html__( 'Image', 'bricks' ),
                        'settings' => [
                            'image'  => [
                                'url' => 'https://nextbricks.io/wp-content/uploads/2024/09/cursor_slide_4.webp',
                            ],
                        ],
                    ]
                ]
            ],
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next_cursor_trail', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_cursor_trail.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $type = ! empty( $settings['type'] ) ? $settings['type'] : 'type-3';
        $threshold = ! empty( $settings['threshold'] ) ? $settings['threshold'] : 100;
        $lerpFactor = ! empty( $settings['lerpFactor'] ) ? $settings['lerpFactor'] : 0.1;
        $showDuration = ! empty( $settings['showDuration'] ) ? $settings['showDuration'] : 0.9;
        $showEase = ! empty( $settings['showEase'] ) ? $settings['showEase'] : 'expo';
        if ($showEase === 'custom') {
      $showEase = ! empty( $settings['customShowEase'] ) ? $settings['customShowEase'] : 'expo';
    }
        $hideDuration = ! empty( $settings['hideDuration'] ) ? $settings['hideDuration'] : 1;
        $hideEase = ! empty( $settings['hideEase'] ) ? $settings['hideEase'] : 'power1';
        if ($hideEase === 'custom') {
      $hideEase = ! empty( $settings['customHideEase'] ) ? $settings['customHideEase'] : 'power1';
    }
        $hideDelay = ! empty( $settings['hideDelay'] ) ? $settings['hideDelay'] : 0.4;
        $scale = ! empty( $settings['scale'] ) ? $settings['scale'] : 0.2;

        $this->set_attribute( '_root', 'class', "next-cursor-trail");
        $this->set_attribute( '_root', 'data-type', $type);
        $this->set_attribute( '_root', 'data-threshold', $threshold);
        $this->set_attribute( '_root', 'data-lerp-factor', $lerpFactor);
        $this->set_attribute( '_root', 'data-show-duration', $showDuration);
        $this->set_attribute( '_root', 'data-show-ease', $showEase);
        $this->set_attribute( '_root', 'data-hide-duration', $hideDuration);
        $this->set_attribute( '_root', 'data-hide-ease', $hideEase);
        $this->set_attribute( '_root', 'data-hide-delay', $hideDelay);
        $this->set_attribute( '_root', 'data-scale', $scale);

        $output = "<div {$this->render_attributes( '_root' )}>";
        $output .= Frontend::render_children( $this );
        $output .= "</div>";

        echo $output;
    }
}