<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Decode_Card extends \Bricks\Element {
    public $category     = 'Next Bricks - Cores';
    public $name         = 'next_decode_card';
    public $icon         = 'fa-solid fa-square-full';
    public $scripts      = ['next_decode_card'];
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Decode Card', 'bricks' );
    }

    public function set_controls() {
        $this->controls['cardWidth'] = [
            'tab' => 'content',
            'label' => esc_html__('Width', 'bricks'),
            'type' => 'number',
            'css' => [
                [
                    'property' => 'width',
                    'selector' => '',
                ],
            ],
            'units' => true,
            'default' => '400px',
        ];
        $this->controls['cardHeight'] = [
            'tab' => 'content',
            'label' => esc_html__('Height', 'bricks'),
            'type' => 'number',
            'css' => [
                [
                    'property' => 'height',
                    'selector' => '',
                ],
            ],
            'units' => true,
            'default' => '400px',
        ];
        $this->controls['innerBackground'] = [
            'tab' => 'content',
            'label' => esc_html__('Background', 'bricks'),
            'type' => 'background',
            'css' => [
                [
                    'property' => 'background',
                    'selector' => '.next-decode-card__inner',
                ],
            ],
            'default' => [
                'color' => [
                    'hex' => '#000000',
                ],
            ],
        ];
        $this->controls['innerBorder'] = [
            'tab' => 'content',
            'label' => esc_html__('Border', 'bricks'),
            'type' => 'border',
            'css' => [
                [
                    'property' => 'border',
                    'selector' => '.next-decode-card__inner',
                ],
            ],
            'units' => true,
            'default' => [
                'radius' => [
                    'top' => 16,
                    'right' => 16,
                    'bottom' => 16,
                    'left' => 16,
                ],
            ],
        ];
        $this->controls['innerPadding'] = [
            'tab' => 'content',
            'label' => esc_html__('Padding', 'bricks'),
            'type' => 'spacing',
            'css' => [
                [
                    'property' => 'padding',
                    'selector' => '.next-decode-card__inner',
                ],
            ],
            'units' => true,
            'default' => [
                'top'    => 12,
                'right'  => 20, 
                'bottom' => 12,
                'left'   => 20,
            ],
        ];

        // Decode Settings
        $this->controls['decodeSettingsSeparator'] = [
            'tab' => 'content',
            'label' => esc_html__('Decode Settings', 'bricks'),
            'type' => 'separator',
        ];
        $this->controls['titleTypography'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Typography', 'bricks' ),
            'type'    => 'typography',
            'css'     => [
                [
                    'property' => 'typography',
                    'selector' => '.next-decode-card__random-text',
                ],
            ],
            'default' => [
                'font-size' => '12px',
                'font-weight' => '700',
                'line-height' => '1',
                'color' => [
                    'hex' => '#fff',
                ],
            ],
        ];
        $this->controls['colorLeft'] = [
            'tab' => 'content',
            'label' => esc_html__('Gradient Left', 'bricks'),
            'type' => 'color',
            'css' => [
                [
                    'property' => '--gradient-left',
                    'selector' => '',
                ],
            ],
            'default' => [
                'hex' => '#00ff00',
            ],
        ];

        $this->controls['colorRight'] = [
            'tab' => 'content', 
            'label' => esc_html__('Gradient Right', 'bricks'),
            'type' => 'color',
            'css' => [
                [
                    'property' => '--gradient-right',
                    'selector' => '',
                ],
            ],
            'default' => [
                'hex' => '#ff0000',
            ],
        ];
        $this->controls['backdropFilter'] = [
            'tab' => 'content',
            'label' => esc_html__('Backdrop Filter Blur', 'bricks'),
            'type' => 'number',
            'css' => [
                [
                    'property' => '--backdrop-filter',
                    'selector' => '',
                ],
            ],
            'units' => true,
            'default' => '24px',
        ];
        $this->controls['fadeDuration'] = [
            'tab' => 'content',
            'label' => esc_html__('Fade Duration', 'bricks'),
            'type' => 'number',
            'unit' => 's',
            'css' => [
                [
                    'property' => '--fade-duration',
                    'selector' => '',
                ],
            ],
            'units' => true,
            'default' => '0.5s',
        ];
        $this->controls['fadeEasing'] = [
            'tab' => 'content',
            'label' => esc_html__('Fade CSS Easing', 'bricks'),
            'type' => 'text',
            'css' => [
                [
                    'property' => '--fade-easing',
                    'selector' => '',
                ],
            ],
            'default' => 'ease',
        ];

        // Content Container
        $this->controls['contentSeparator'] = [
            'tab' => 'content',
            'label' => esc_html__('Content Mask', 'bricks'),
            'type' => 'separator',
        ];
        $this->controls['contentSize'] = [
            'tab' => 'content',
            'label' => esc_html__('Size', 'bricks'),
            'type' => 'number',
            'css' => [
                [
                    'property' => '--content-size',
                    'selector' => '',
                ],
            ],
            'units' => true,
            'default' => '150px',
        ];
        $this->controls['contentRadius'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Radius', 'bricks' ),
            'type'    => 'number',
            'css'     => [
                [
                    'property' => '--content-radius',
                    'selector' => '',
                ],
            ],
            'units' => true,
            'default' => 9999,
        ];
        $this->controls['contentBlur'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Blur', 'bricks' ),
            'type'    => 'number',
            'css'     => [
                [
                    'property' => '--content-blur',
                    'selector' => '',
                ],
            ],
            'units' => true,
            'default' => 8,
        ];
        $this->controls['contentColor'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Color', 'bricks' ),
            'type'    => 'color',
            'css'     => [
                [
                    'property' => '--content-color',
                    'selector' => '',
                ],
            ],
            'default' => [
                'hex' => '#000',
            ],
        ];
        $this->controls['contentTypography'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Typography', 'bricks' ),
            'type'    => 'typography',
            'css'     => [
                [
                    'property' => 'typography',
                    'selector' => '.next-decode-card__hover-container',
                ],
            ],
            'default' => [
                'font-size' => '16px',
                'font-weight' => '700',
                'color' => [
                    'hex' => '#fff',
                ],
            ],
        ];

        //Animation - JS
        $this->controls['animationSeparator'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Animation', 'bricks' ),
            'type' => 'separator',
        ];
        $this->controls['includeCharacters'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Include Characters', 'bricks' ),
            'type' => 'checkbox',
            'default' => true,
        ];
        $this->controls['characters'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Characters', 'bricks' ),
            'type' => 'textarea',
            'default' => 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789',
            'required' => [ 'includeCharacters', '=', true],
        ];

        $this->controls['textLength'] = [
            'tab' => 'content', 
            'label' => esc_html__( 'Text Length', 'bricks' ),
            'type' => 'number',
            'default' => 2500,
            'required' => [ 'includeCharacters', '=', true],
        ];

        $this->controls['gradientSize'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Gradient Size', 'bricks' ),
            'type' => 'number', 
            'default' => 250,
        ];
    }

    public function get_nestable_children() {
        return [
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Content Mask', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-decode-card__hover-container',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'heading',
                        'label'    => esc_html__( 'Heading', 'bricks' ),
                        'settings' => [
                            'text' => esc_html__( 'Decode', 'bricks' ),
                            'tag'  => 'span',
                        ],
                    ]
                ]
            ],
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next_decode_card', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_decode_card.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $characters = ! empty( $settings['characters'] ) ? $settings['characters'] : 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
        $textLength = ! empty( $settings['textLength'] ) ? $settings['textLength'] : 2500;
        $gradientSize = ! empty( $settings['gradientSize'] ) ? $settings['gradientSize'] : 250;
        $includeCharacters = ! empty( $settings['includeCharacters'] ) ? $settings['includeCharacters'] : 0;

        $this->set_attribute( '_root', 'class', "next-decode-card");
        $this->set_attribute( '_root', 'data-characters', $characters);
        $this->set_attribute( '_root', 'data-text-length', $textLength);
        $this->set_attribute( '_root', 'data-gradient-size', $gradientSize);
        $this->set_attribute( '_root', 'data-include-characters', $includeCharacters);

        $output = "
        <div {$this->render_attributes( '_root' )}>
            <div class='next-decode-card__inner'>
                <div class='next-decode-card__pattern'>
                    <div class='next-decode-card__pattern-gradient'></div>
                    <div class='next-decode-card__pattern-motion'></div>
                    <div class='next-decode-card__pattern-text'>
                        <div class='next-decode-card__random-text'></div>
                    </div>
                </div>
                <div class='next-decode-card__content'>";
                    $output .= Frontend::render_children( $this );
                $output .= "</div>
            </div>
        </div>";

        echo $output;
    }
}