<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Exchange_Title_V2 extends \Bricks\Element {
    public $category     = 'Next Bricks - Texts';
    public $name         = 'next_exchange_title_v2';
    public $icon         = 'ti-layout-width-default';
    public $scripts      = ['next_exchange_title_v2'];
    public $tag      = 'div';

    public function get_label() {
    return esc_html__( 'Exchange Title v2', 'bricks' );
    }

    public function set_controls() {
        $this->controls['tag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'HTML tag', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'h1' => 'h1',
                'h2' => 'h2',
                'h3' => 'h3',
                'h4' => 'h4',
                'h5' => 'h5',
                'h6' => 'h6',
                'div' => 'div',
                'span' => 'span',
                'custom' => 'custom',
            ],
            'clearable'   => false,
            'inline'      => true,
            'placeholder' => 'div',
            'default'     => 'div',
        ];
        $this->controls['customTag'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Custom tag', 'bricks' ),
			'type'        => 'text',
			'inline'      => true,
			'placeholder' => 'div',
			'required'    => [ 'tag', '=', 'custom' ],
        ];

        $this->controls['prefix'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Prefix', 'bricks' ),
            'type' => 'text',
            'inline' => true,
            'default' => 'Next Bricks',
        ];
        $this->controls['gap'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Gap', 'bricks' ),
            'type' => 'number',
            'units' => true,
            'css' => [
                [
                    'property' => 'gap',
                    'selector' => '',
                ],
            ],
            'default' => 10,
        ];
        $this->controls['lines'] = [
            'tab' => 'content',
            'label' => esc_html__('Lines', 'bricks'),
            'type' => 'repeater',
            'titleProperty' => 'line',
            'fields' => [
                'line' => [
                    'label' => esc_html__('Line', 'bricks'),
                    'type' => 'text',
                    'default' => esc_html__('Great Line', 'bricks'),
                ],
            ],
            'default' => [
                ['line' => 'Exchange'],
                ['line' => 'Title'],
                ['line' => 'version 2'],
                ['line' => '😎😎'],
            ],
        ];

        $this->controls['styleseparator'] = [
            'label'      => esc_html__( 'Text Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['prefix_typography'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Prefix Typography', 'bricks' ),
            'type'    => 'typography',
            'css'     => [
              [
                'property' => 'typography',
                'selector' => '.next-exchange-title-v2__prefix',
              ],
            ],
            'default' => [
                'font-size' => '32px',
                'font-weight' => '700',
                'line-height' => '1',
            ],
        ];
        $this->controls['typography'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Lines Typography', 'bricks' ),
            'type'    => 'typography',
            'css'     => [
              [
                'property' => 'typography',
                'selector' => '.next-exchange-title-v2__animated-container',
              ],
            ],
            'default' => [
                'font-size' => '32px',
                'line-height' => '1',
                'color' => [
                    'hex' => '#fff',
                ],
            ],
        ];

        $this->controls['boxstyleseparator'] = [
            'label'      => esc_html__( 'Box Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['horizontal_padding'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Horizontal Padding', 'bricks' ),
            'type'    => 'number',
            'units'   => true,
            'css'     => [
                [
                    'property' => '--horizontal-padding',
                    'selector' => '',
                ],
            ],
            'default' => 12,
        ];
        $this->controls['vertical_padding'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Vertical Padding', 'bricks' ),
            'type'    => 'number',
            'units'   => true,
            'css'     => [
                [
                    'property' => '--vertical-padding',
                    'selector' => '',
                ],
            ],
            'default' => 8,
        ];
        $this->controls['background'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Background', 'bricks' ),
            'type'    => 'color',
            'css'     => [
                [
                    'property' => 'background-color',
                    'selector' => '.next-exchange-title-v2__animated-container',
                ],
            ],
            'default' => [
                'hex' => '#b22bf1',
            ],
        ];
        $this->controls['border'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Border', 'bricks' ),
            'type'    => 'border',
            'units'   => true,
            'css'     => [
                [
                    'property' => 'border',
                    'selector' => '.next-exchange-title-v2__animated-container',
                ],
            ],
            'default' => [
                'radius' => [
                  'top' => 12,
                  'right' => 12,
                  'bottom' => 12,
                  'left' => 12,
                ],
            ],
        ];

        $this->controls['animationseparator'] = [
            'label'      => esc_html__( 'Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['disablebuilder'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Disable at the builder', 'bricks' ),
            'type'     => 'checkbox',
            'default' => false,
        ];
        $this->controls['line_duration'] = [
            'tab' => 'content',
            'label' => esc_html__('Seconds until next line', 'bricks'),
            'type' => 'number',
            'units' => true,
            'default' => 0.7,
        ];
        $this->controls['box_duration'] = [
            'tab' => 'content',
            'label' => esc_html__('Box Animation Duration', 'bricks'),
            'type' => 'number',
            'units' => true,
            'default' => 0.4,
        ];
        $this->controls['box_ease'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Box GSAP easing', 'bricks' ),
            'type' => 'select',
            'options'     => [
                'none' => 'none',
                'power1' => 'power1',
                'power2' => 'power2',
                'power3' => 'power3',
                'power4' => 'power4',
                'back' => 'back',
                'bounce' => 'bounce',
                'circ' => 'circ',
                'elastic' => 'elastic',
                'expo' => 'expo',
                'sine' => 'sine',
                'steps' => 'steps',
                'custom' => 'custom'
            ],
            'inline' => true,
            'default' => 'back',
        ];
    $this->controls['custom_box_ease'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'box_ease', '=', 'custom' ],
    ];



        $this->controls['letter_duration'] = [
            'tab' => 'content',
            'label' => esc_html__('Swap Animation Duration', 'bricks'),
            'type' => 'number',
            'units' => true,
            'default' => 0.5,
        ];
        $this->controls['letter_stagger'] = [
            'tab' => 'content',
            'label' => esc_html__('Swap Stagger', 'bricks'),
            'type' => 'number',
            'units' => true,
            'default' => 0.02,
        ];
        $this->controls['letter_ease'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Swap GSAP easing', 'bricks' ),
            'type' => 'select',
            'options'     => [
                'none' => 'none',
                'power1' => 'power1',
                'power2' => 'power2',
                'power3' => 'power3',
                'power4' => 'power4',
                'back' => 'back',
                'bounce' => 'bounce',
                'circ' => 'circ',
                'elastic' => 'elastic',
                'expo' => 'expo',
                'sine' => 'sine',
                'steps' => 'steps',
                'custom' => 'custom'
            ],
            'inline' => true,
            'default' => 'expo',
        ];
    $this->controls['custom_letter_ease'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'letter_ease', '=', 'custom' ],
    ];



    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next_exchange_title_v2', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_exchange_title_v2.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $disablebuilder    = ! empty( $settings['disablebuilder'] ) ? $settings['disablebuilder'] : 0;
        $boxDuration = ! empty( $settings['box_duration'] ) ? $settings['box_duration'] : 0.5;
        $boxEase = ! empty( $settings['box_ease'] ) ? $settings['box_ease'] : 'power2.inOut';
        if ($boxEase === 'custom') {
      $boxEase = ! empty( $settings['customBox_ease'] ) ? $settings['customBox_ease'] : 'power2.inOut';
    }
        $lineDuration = ! empty( $settings['line_duration'] ) ? $settings['line_duration'] : 1;
        $letterEase = ! empty( $settings['letter_ease'] ) ? $settings['letter_ease'] : 'expo';
        if ($letterEase === 'custom') {
      $letterEase = ! empty( $settings['customLetter_ease'] ) ? $settings['customLetter_ease'] : 'expo';
    }
        $letterDuration = ! empty( $settings['letter_duration'] ) ? $settings['letter_duration'] : 0.4;
        $letterStagger = ! empty( $settings['letter_stagger'] ) ? $settings['letter_stagger'] : 0.02;

        $this->set_attribute( '_root', 'class', 'next-exchange-title-v2' );

        $lines = ! empty( $settings['lines'] ) ? $settings['lines'] : '';
        if ($lines) {
            $finallines = '';
            foreach ( $lines as $line ) {
                if ( isset($line['line'])) {
                    $finallines .= $line['line'] . 'next11';
                }else{
                    $finallines .= 'unset' . 'next11';
                }
            }
            $finallines .= '';
        }else{
            $finallines = 'unset';
        }
        $this->set_attribute( '_root', 'data-lines', $finallines);
        $this->set_attribute( '_root', 'data-disable-builder', $disablebuilder);
        $this->set_attribute( '_root', 'data-box-duration', $boxDuration );
        $this->set_attribute( '_root', 'data-box-ease', $boxEase );
        $this->set_attribute( '_root', 'data-line-duration', $lineDuration );
        $this->set_attribute( '_root', 'data-letter-ease', $letterEase );
        $this->set_attribute( '_root', 'data-letter-duration', $letterDuration );
        $this->set_attribute( '_root', 'data-letter-stagger', $letterStagger );

        
        $prefix    = ! empty( $settings['prefix'] ) ? $settings['prefix'] : '';

        $output = "<{$this->tag} {$this->render_attributes( '_root' )}>";
        if($prefix) {
            $output .= "<span class='next-exchange-title-v2__prefix'>{$prefix}</span>";
        }
        $output .= "
        <div class='next-exchange-title-v2__animated-container'>
            <div class='next-exchange-title-v2__word'></div>
        </div>";
        $output .= "</{$this->tag}>";

        echo $output;
    }
}