<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Exchange_Title_V3 extends \Bricks\Element {
    public $category     = 'Next Bricks - Texts';
    public $name         = 'next_exchange_title_v3';
    public $icon         = 'ti-layout-width-default';
    public $tag          = 'div';
    public $scripts      = [ 'next_exchange_title_v3' ];
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Exchange Title v3', 'bricks' );
    }

    public function set_controls() {
        $this->controls['tag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'HTML tag', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'div' => 'div',
                'section' => 'section',
                'article' => 'article',
                'aside' => 'aside',
                'header' => 'header',
                'footer' => 'footer',
                'main' => 'main',
                'custom' => 'custom',
            ],
            'clearable'   => false,
            'inline'      => true,
            'placeholder' => 'div',
            'default'     => 'div',
        ];

        $this->controls['customTag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Custom tag', 'bricks' ),
            'type'        => 'text',
            'inline'      => true,
            'placeholder' => 'div',
            'required'    => [ 'tag', '=', 'custom' ],
        ];

        $this->controls['prefix'] = [
            'tab'            => 'content',
            'type'           => 'text',
            'label'          => esc_html__( 'Prefix', 'bricks' ),
            'hasDynamicData' => 'text',
            'default'        => esc_html__( 'Made for ', 'bricks' ),
        ];

        $this->controls['suffix'] = [
            'tab'            => 'content',
            'type'           => 'text',
            'label'          => esc_html__( 'Suffix', 'bricks' ),
            'hasDynamicData' => 'text',
        ];

        $this->controls['layoutSeparator'] = [
            'label' => esc_html__( 'Layout', 'bricks' ),
            'type'  => 'separator',
        ];

        $this->controls['prefixTypography'] = [
            'label' => esc_html__( 'Prefix typography', 'bricks' ),
            'type'  => 'typography',
            'css'   => [
                [
                    'property' => 'typography',
                    'selector' => '.nb-exchange-title-v3__prefix',
                ],
            ],
            'default' => [
                'font-size'   => '23px',
                'font-weight' => '500',
                'color'       => [
                    'hex' => '#999999',
                ]
            ],
        ];

        $this->controls['linesTypography'] = [
            'label' => esc_html__( 'Lines typography', 'bricks' ),
            'type'  => 'typography',
            'css'   => [
                [
                    'property' => 'typography',
                    'selector' => '.nb-exchange-title-v3__char',
                ],
            ],
            'default' => [
                'font-size'   => '23px',
                'font-weight' => '500',
                'color'       => [
                    'hex' => '#000000',
                ]
            ],
        ];

        $this->controls['suffixTypography'] = [
            'label' => esc_html__( 'Suffix typography', 'bricks' ),
            'type'  => 'typography',
            'css'   => [
                [
                    'property' => 'typography',
                    'selector' => '.nb-exchange-title-v3__suffix',
                ],
            ],
        ];

        $this->controls['blurSeparator'] = [
            'label' => esc_html__( 'Blur animation', 'bricks' ),
            'type'  => 'separator',
        ];

        $this->controls['disablebuilder'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Disable in the Builder', 'bricks' ),
            'type'    => 'checkbox',
            'inline'  => true,
            'default' => false,
        ];

        $this->controls['blurValue'] = [
            'tab'            => 'content',
            'label'          => esc_html__( 'Blur', 'bricks' ),
            'type'           => 'number',
            'units'          => true,
            'inline'         => true,
            'default'        => '15px',
            'css'            => [
                [
                    'property' => '--blur',
                    'selector' => '',
                ],
            ],
        ];

        $this->controls['loopDuration'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Cycle duration', 'bricks' ),
            'type'    => 'number',
            'inline'  => true,
            'default' => '3s',
        ];

        $this->controls['blurDuration'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Blur duration', 'bricks' ),
            'type'    => 'number',
            'inline'  => true,
            'default' => '0.5s',
        ];

        $this->controls['blurStagger'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Blur stagger', 'bricks' ),
            'type'    => 'number',
            'inline'  => true,
            'default' => '0.03',
        ];

        $this->controls['blurEase'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Blur easing', 'bricks' ),
            'type'    => 'select',
            'inline'  => true,
            'options' => [
                'power1' => 'power1',
                'power2' => 'power2',
                'power3' => 'power3',
                'power4' => 'power4',
                'back'   => 'back',
                'expo'   => 'expo',
                'sine'   => 'sine',
                'circ'   => 'circ',
                'elastic'=> 'elastic',
                'steps'  => 'steps',
                'custom' => 'custom'
            ],
            'default' => 'power1',
        ];
    $this->controls['customBlurEase'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'blurEase', '=', 'custom' ],
    ];




        $this->controls['sizeAnimationSeparator'] = [
            'label' => esc_html__( 'Width animation', 'bricks' ),
            'type'  => 'separator',
        ];

        $this->controls['expandingDuration'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Duration', 'bricks' ),
            'type'    => 'number',
            'inline'  => true,
            'default' => '0.7s',
        ];

        $this->controls['expandingEase'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Easing', 'bricks' ),
            'type'    => 'select',
            'inline'  => true,
            'options' => [
                'power1' => 'power1',
                'power2' => 'power2',
                'power3' => 'power3',
                'power4' => 'power4',
                'back'   => 'back',
                'expo'   => 'expo',
                'sine'   => 'sine',
                'circ'   => 'circ',
                'elastic'=> 'elastic',
                'steps'  => 'steps',
                'custom' => 'custom'
            ],
            'default' => 'power3',
        ];
    $this->controls['customExpandingEase'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'expandingEase', '=', 'custom' ],
    ];



    }

    public function get_nestable_children() {
        return [
            [
                'name'     => 'heading',
                'label'    => esc_html__( 'Line', 'bricks' ),
                'settings' => [
                    'text' => esc_html__( 'Designers', 'bricks' ),
                    'tag'  => 'span',
                    '_hidden' => [
                        '_cssClasses' => 'nb-exchange-title-v3__line',
                    ],
                ],
            ],
            [
                'name'     => 'heading',
                'label'    => esc_html__( 'Line', 'bricks' ),
                'settings' => [
                    'text' => esc_html__( 'Startups', 'bricks' ),
                    'tag'  => 'span',
                    '_hidden' => [
                        '_cssClasses' => 'nb-exchange-title-v3__line',
                    ],
                ],
            ],
            [
                'name'     => 'heading',
                'label'    => esc_html__( 'Line', 'bricks' ),
                'settings' => [
                    'text' => esc_html__( 'Entrepreneurs', 'bricks' ),
                    'tag'  => 'span',
                    '_hidden' => [
                        '_cssClasses' => 'nb-exchange-title-v3__line',
                    ],
                ],
            ],
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next_exchange_title_v3', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_exchange_title_v3.min.js', array( 'bricks-scripts' ), NEXTBRICKS_VERSION, false );
    }

    public function render() {
        $settings    = $this->settings;
        $is_builder  = bricks_is_builder();

        $loopDuration       = ! empty( $settings['loopDuration'] ) ? $settings['loopDuration'] : '3';
        $blurDuration       = ! empty( $settings['blurDuration'] ) ? $settings['blurDuration'] : '0.5';
        $blurStagger        = ! empty( $settings['blurStagger'] ) ? $settings['blurStagger'] : '0.03';
        $blurEase           = ! empty( $settings['blurEase'] ) ? $settings['blurEase'] : 'power1';
        if ($blurEase === 'custom') {
      $blurEase = ! empty( $settings['customBlurEase'] ) ? $settings['customBlurEase'] : 'power1';
    }
        $expandingDuration  = ! empty( $settings['expandingDuration'] ) ? $settings['expandingDuration'] : '0.7';
        $expandingEase      = ! empty( $settings['expandingEase'] ) ? $settings['expandingEase'] : 'power3';
        if ($expandingEase === 'custom') {
      $expandingEase = ! empty( $settings['customExpandingEase'] ) ? $settings['customExpandingEase'] : 'power3';
    }
        $prefix             = isset( $settings['prefix'] ) ? $settings['prefix'] : '';
        $suffix             = isset( $settings['suffix'] ) ? $settings['suffix'] : '';
        $disablebuilder     = ! empty( $settings['disablebuilder'] ) ? 1 : 0;

        $this->set_attribute( '_root', 'class', 'nb-exchange-title-v3' );

        if ( ! $is_builder ) {
            $this->set_attribute( '_root', 'data-flickering', '1' );
        }

        $this->set_attribute( '_root', 'data-loop-duration', $loopDuration );
        $this->set_attribute( '_root', 'data-blur-duration', $blurDuration );
        $this->set_attribute( '_root', 'data-blur-stagger', $blurStagger );
        $this->set_attribute( '_root', 'data-blur-easing', $blurEase );
        $this->set_attribute( '_root', 'data-expanding-duration', $expandingDuration );
        $this->set_attribute( '_root', 'data-expanding-easing', $expandingEase );
        $this->set_attribute( '_root', 'data-disable-builder', $disablebuilder );

        $output = "<{$this->tag} {$this->render_attributes( '_root' )}>";

        if ( $prefix ) {
            $output .= "<span class='nb-exchange-title-v3__prefix'>" . wp_kses_post( $prefix ) . "</span>";
        }

        $output .= "<span class='nb-exchange-title-v3__lines'>";
        $output .= Frontend::render_children( $this );
        $output .= '</span>';

        if ( $suffix ) {
            $output .= "<span class='nb-exchange-title-v3__suffix'>" . wp_kses_post( $suffix ) . "</span>";
        }

        $output .= "</{$this->tag}>";

        echo $output;
    }
}
