<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Lightbox extends \Bricks\Element {
    public $category     = 'Next Bricks - Medias';
    public $name         = 'next_lightbox';
    public $icon         = 'fas fa-images';
    public $tag      = 'div';
    public $scripts      = ['next_lightbox'];
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Lightbox', 'bricks' );
    }

    public function set_control_groups() {
        $this->control_groups['styles'] = [
          'title' => esc_html__( 'Styles', 'bricks' ),
          'tab'   => 'content',
        ];
        $this->control_groups['animations'] = [
            'title' => esc_html__( 'Animations', 'bricks' ),
            'tab'   => 'content',
        ];
    }

    public function set_controls() {
        $this->controls['elements'] = [
            'tab'           => 'content',
            'type'          => 'repeater',
            'label'         => esc_html__( 'Lightbox Images', 'bricks' ),
            'placeholder'   => esc_html__( 'Image', 'bricks' ),
            'titleProperty' => 'title',
            'default' => [
                [
                    'image'  => [
                        'url' => 'https://images.unsplash.com/photo-1609342122563-a43ac8917a3a?ixlib=rb-1.2.1&ixid=MXwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHw%3D&auto=format&fit=crop&w=1600&q=80',
                    ],
                    'alt' => 'layers of blue.',
                    'content-description' => "<p>Location - <a href='https://unsplash.com/s/photos/puezgruppe%2C-wolkenstein-in-gr%C3%B6den%2C-s%C3%BCdtirol%2C-italien'>Puezgruppe, Wolkenstein in Gröden, Südtirol, Italien</a>layers of blue.</p>",
                ],
                [
                    'image'  => [
                        'url' => 'https://images.unsplash.com/photo-1608481337062-4093bf3ed404?ixlib=rb-1.2.1&ixid=MXwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHw%3D&auto=format&fit=crop&w=1600&q=80',
                    ],
                    'alt' => 'This is the Way',
                    'content-description' => "<p>Location - <a href='https://unsplash.com/s/photos/tre-cime-di-lavaredo%2C-italia'>Tre Cime di Lavaredo, Italia</a>This is the Way</p>",
                ],
                [
                    'image'  => [
                        'url' => 'https://images.unsplash.com/photo-1605973029521-8154da591bd7?ixlib=rb-1.2.1&ixid=MXwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHw%3D&auto=format&fit=crop&w=1600&q=80',
                    ],
                    'alt' => 'Pizol, Mels, Schweiz',
                    'content-description' => "<p>Location - <a href='https://unsplash.com/s/photos/pizol%2C-mels%2C-schweiz'>Pizol, Mels, Schweiz</a></p>",
                ],
                [
                    'image'  => [
                        'url' => 'https://images.unsplash.com/photo-1526281216101-e55f00f0db7a?ixlib=rb-1.2.1&ixid=MXwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHw%3D&auto=format&fit=crop&w=1600&q=80',
                    ],
                    'alt' => 'Foggy Road',
                    'content-description' => "<p>Foggy Road</p>",
                ],
                [
                    'image'  => [
                        'url' => 'https://images.unsplash.com/photo-1418065460487-3e41a6c84dc5?ixid=MXwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHw%3D&ixlib=rb-1.2.1&auto=format&fit=crop&w=1600&q=80',
                    ],
                    'alt' => 'Misty shroud over a forest',
                    'content-description' => "<p>Misty shroud over a forest</p>",
                ],
                [
                    'image'  => [
                        'url' => 'https://images.unsplash.com/photo-1505820013142-f86a3439c5b2?ixlib=rb-1.2.1&ixid=MXwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHw%3D&auto=format&fit=crop&w=1600&q=80',
                    ],
                    'alt' => 'Bled, Slovenia',
                    'content-description' => "<p>Location - <a href='Bled, Slovenia'>Bled, Slovenia</a> </p>",
                ],
                [
                    'image'  => [
                        'url' => 'https://images.unsplash.com/photo-1477322524744-0eece9e79640?ixid=MXwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHw%3D&ixlib=rb-1.2.1&auto=format&fit=crop&w=1600&q=80',
                    ],
                    'alt' => 'Wooded lake island',
                    'content-description' => "<p>Location - <a href='Bled, Slovenia'>Bled, Slovenia</a> Wooded lake island </p>",
                ],
                [
                    'image'  => [
                        'url' => 'https://images.unsplash.com/photo-1469474968028-56623f02e42e?ixid=MXwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHw%3D&ixlib=rb-1.2.1&auto=format&fit=crop&w=1600&q=80',
                    ],
                    'alt' => 'Alone in the unspoilt wilderness',
                    'content-description' => "<p>Location - <a href='https://unsplash.com/s/photos/ciuca%C8%99-peak%2C-romania'>Ciucaș Peak, Romania</a> Alone in the unspoilt wilderness </p>",
                ],
              ],
            'fields'        => [
                'image'       => [
                    'type'    => 'image',
                    'label'   => esc_html__( 'Image', 'bricks' ),
                ],
                'alt'       => [
                    'type'    => 'text',
                    'label'   => esc_html__( 'Alt', 'bricks' ),
                    'inline'    => true,
                ],
                'content-description'       => [
                    'type'    => 'textarea',
                    'label'   => esc_html__( 'Content Description', 'bricks' ),
                ],
            ],
        ];

        /*styles*/
        $this->controls['blockStyleSeparator'] = [
            'group' => 'styles',
            'label'      => esc_html__( 'List Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['note'] = [
            'group' => 'styles',
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Lightbox element will list all images using flex. But you can change it to grid and add any additional properties on the Style Tab', 'bricks' )))
        ];
        $this->controls['gap'] = [
            'group' => 'styles',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Gap', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'gap',
                'selector' => '', 
              ]
            ],
            'default' => '10px',
        ];
        $this->controls['width'] = [
            'group' => 'styles',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'width',
                'selector' => '', 
              ]
            ],
            'default' => '100%',
        ];
        $this->controls['maxWidth'] = [
            'group' => 'styles',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Max Width', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'max-width',
                'selector' => '', 
              ]
            ],
        ];
        $this->controls['height'] = [
            'group' => 'styles',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Height', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'height',
                'selector' => '', 
              ]
            ],
            'default' => 'auto',
        ];
        $this->controls['maxHeight'] = [
            'group' => 'styles',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Max Height', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'max-height',
                'selector' => '', 
              ]
            ],
        ];

        $this->controls['itemStyleSeparator'] = [
            'group' => 'styles',
            'label'      => esc_html__( 'List Item Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['listItemWidth'] = [
            'group' => 'styles',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'width',
                'selector' => '.nb-lightbox__item', 
              ]
            ],
            'default' => '240px',
        ];
        $this->controls['listItemHeight'] = [
            'group' => 'styles',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Height', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'height',
                'selector' => '.nb-lightbox__item', 
              ]
            ],
            'default' => 'fit-content',
        ];

        $this->controls['lightboxSeparator'] = [
            'group' => 'styles',
            'label'      => esc_html__( 'Lightbox Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['lightboxzIndex'] = [
            'group' => 'styles',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Z-Index', 'bricks' ),
            'type'  => 'number',
            'css' => [
                [
                    'property' => '--z-index',
                    'selector' => '',
                ]
            ],
            'default' => '9999',
        ];
        $this->controls['lightboxBlur'] = [
            'group' => 'styles',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Blur', 'bricks' ),
            'type'  => 'number',
            'units' => 'px',
            'css' => [
            [
                'property' => '--blur',
                'selector' => '.lg-backdrop', 
            ]
            ],
            'default' => '20',
        ];
        $this->controls['lightboxBackground'] = [
            'group' => 'styles',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Background', 'bricks' ),
            'type'  => 'color',
            'css' => [
            [
                'property' => 'background',
                'selector' => '.lg-backdrop', 
            ]
            ],
            'default' => [
                'hex' => '#00000090',
            ]
        ];

        $this->controls['toolbarSeparator'] = [
            'group' => 'styles',
            'label'      => esc_html__( 'Toolbar Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['toolbarPadding'] = [
            'group' => 'styles',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Padding', 'bricks' ),
            'type'  => 'spacing',
            'css' => [
                [
                    'property' => 'padding',
                    'selector' => '.lg-toolbar',
                ]
            ],
            'default' => [
                'top' => '0',
                'right' => '0',
                'bottom' => '0',
                'left' => '0',
            ],
        ];
        $this->controls['toolbarBackground'] = [
            'group' => 'styles',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Background', 'bricks' ),
            'type'  => 'color',
            'css' => [
                [
                    'property' => 'background',
                    'selector' => '.lg-toolbar',
                ]
            ],
            'default' => [
                'hex' => '#000000',
                'alpha' => 0,
            ],
        ];

        $this->controls['iconsSeparator'] = [
            'group' => 'styles',
            'label'      => esc_html__( 'Icons Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['iconsPadding'] = [
            'group' => 'styles',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Padding', 'bricks' ),
            'type'  => 'spacing',
            'css' => [
                [
                    'property' => 'padding',
                    'selector' => '.lg-toolbar .lg-icon',
                ]
            ],
            'default' => [
                'top' => '10',
                'right' => '12',
                'bottom' => '10',
                'left' => '12',
            ],
        ];
        $this->controls['iconsColor'] = [
            'group' => 'styles',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Color', 'bricks' ),
            'type'  => 'color',
            'css' => [
                [
                    'property' => 'color',
                    'selector' => '.lg-toolbar .lg-icon',
                ]
            ],
            'default' => [
                'hex' => '#ffffff',
            ]
        ];
        $this->controls['iconsSize'] = [
            'group' => 'styles',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Size', 'bricks' ),
            'type'  => 'number',
            'unit' => 'px',
            'css' => [
                [
                    'property' => 'font-size',
                    'selector' => '.lg-toolbar .lg-icon',
                ]
            ],
            'default' => '24px'
        ];
        $this->controls['iconsWeight'] = [
            'group' => 'styles',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Weight', 'bricks' ),
            'type'  => 'select',
            'inline' => true,
            'options' => [
                '100' => '100',
                '200' => '200',
                '300' => '300',
                '400' => '400',
                '500' => '500',
                '600' => '600',
                '700' => '700',
                '800' => '800',
                '900' => '900',
            ],
            'css' => [
                [
                    'property' => 'font-weight',
                    'selector' => '.lg-toolbar .lg-icon',
                ]
            ],
            'default' => '400'
        ];

        $this->controls['counterSeparator'] = [
            'group' => 'styles',
            'label'      => esc_html__( 'Counter Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['counterPadding'] = [
            'group' => 'styles',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Padding', 'bricks' ),
            'type'  => 'spacing',
            'css' => [
                [
                    'property' => 'padding',
                    'selector' => '.lg-counter',
                ]
            ],
            'default' => [
                'top' => '12',
                'right' => '0',
                'bottom' => '0',
                'left' => '20',
            ],
        ];
        $this->controls['counterTypography'] = [
            'group' => 'styles',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Typography', 'bricks' ),
            'type'  => 'typography',
            'css' => [
                [
                    'property' => 'typography',
                    'selector' => '.lg-counter',
                ],
            ],
            'default' => [
                'font-size' => '16px',
                'color' => [
                    'hex' => '#ffffff',
                ]
            ],
        ];

        $this->controls['arrowsSeparator'] = [
            'group' => 'styles',
            'label'      => esc_html__( 'Arrows Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['arrowsPadding'] = [
            'group' => 'styles',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Padding', 'bricks' ),
            'type'  => 'spacing',
            'css' => [
                [
                    'property' => 'padding',
                    'selector' => '.lg-next, .lg-prev',
                ],
            ],
            'default' => [
                'top' => '10',
                'right' => '10',
                'bottom' => '10',
                'left' => '10',
            ],
        ];
        $this->controls['arrowsSize'] = [
            'group' => 'styles',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Size', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'css' => [
                [
                    'property' => 'font-size',
                    'selector' => '.lg-next, .lg-prev',
                ],
            ],
            'default' => '22px'
        ];
        $this->controls['arrowsWeight'] = [
            'group' => 'styles',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Weight', 'bricks' ),
            'type'  => 'select',
            'inline' => true,
            'options' => [
                '100' => '100',
                '200' => '200',
                '300' => '300',
                '400' => '400',
                '500' => '500',
                '600' => '600',
                '700' => '700',
                '800' => '800',
                '900' => '900',
            ],
            'css' => [
                [
                    'property' => 'font-weight',
                    'selector' => '.lg-next, .lg-prev',
                ]
            ],
            'default' => '400'
        ];
        $this->controls['arrowsColor'] = [
            'group' => 'styles',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Color', 'bricks' ),
            'type'  => 'color',
            'css' => [
                [
                    'property' => 'color',
                    'selector' => '.lg-next, .lg-prev',
                ],
            ],
            'default' => [
                'hex' => '#ffffff',
            ],
        ];
        $this->controls['arrowsBackground'] = [
            'group' => 'styles',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Background', 'bricks' ),
            'type'  => 'color',
            'css' => [
                [
                    'property' => 'background-color',
                    'selector' => '.lg-next, .lg-prev',
                ],
            ],
            'default' => [
                'hex' => '#000000',
                'alpha' => 0.45,
            ],
        ];
        $this->controls['arrowsBorder'] = [
            'group' => 'styles',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Border', 'bricks' ),
            'type'  => 'border',
            'css' => [
                [
                    'property' => 'border',
                    'selector' => '.lg-next, .lg-prev',
                ],
            ],
            'default' => [
                'style' => 'none',
            ],
        ];

        $this->controls['descriptionSeparator'] = [
            'group' => 'styles',
            'label'      => esc_html__( 'Description Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['descriptionPadding'] = [
            'group' => 'styles',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Padding', 'bricks' ),
            'type'  => 'spacing',
            'css' => [
                [
                    'property' => 'padding',
                    'selector' => '.lg-sub-html',
                ],
            ],
            'default' => [
                'top' => '20',
                'right' => '40',
                'bottom' => '20',
                'left' => '40',
            ],
        ];
        $this->controls['descriptionTypography'] = [
            'group' => 'styles',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Typography', 'bricks' ),
            'type'  => 'typography',
            'css' => [
                [
                    'property' => 'typography',
                    'selector' => '.lg-sub-html',
                ],
            ],
            'default' => [
                'font-size' => '14px',
                'text-align' => 'center',
                'color' => [
                    'hex' => '#ffffff',
                ]
            ],
        ];

        $this->controls['thumbnailsSeparator'] = [
            'group' => 'styles',
            'label'      => esc_html__( 'Thumbnails Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['thumbnailsContainerBackground'] = [
            'group' => 'styles',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Container Background', 'bricks' ),
            'type'  => 'background',
            'css' => [
                [
                    'property' => 'background',
                    'selector' => '.lg-outer .lg-thumb-outer',
                ],
            ],
            'default' => [
                'color' => [
                    'hex' => '#0d0a0a',
                ],
            ],
        ];
        $this->controls['thumbnailsBorder'] = [
            'group' => 'styles',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Border', 'bricks' ),
            'type'  => 'border',
            'css' => [
                [
                    'property' => 'border',
                    'selector' => '.lg-outer .lg-thumb-item',
                ],
            ],
            'default' => [
                'width' => '2px',
                'style' => 'solid',
                'color' => [
                    'hex' => '#ffffff',
                ],
            ],
        ];
        $this->controls['thumbnailsActiveBorder'] = [
            'group' => 'styles',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Active Border', 'bricks' ),
            'type'  => 'border',
            'css' => [
                [
                    'property' => 'border',
                    'selector' => '.lg-outer .lg-thumb-item.active, .lg-outer .lg-thumb-item:hover',
                ],
            ],
            'default' => [
                'width' => '1px',
                'style' => 'solid',
                'color' => [
                    'hex' => '#ffffff',
                ],
            ],
        ];

        $this->controls['progressSeparator'] = [
            'group' => 'styles',
            'label'      => esc_html__( 'Progress Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['progressHeight'] = [
            'group' => 'styles',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Height', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'css' => [
                [
                    'property' => '--height',
                    'selector' => '.lg-progress-bar',
                ],
            ],
            'default' => '3px'
        ];
        $this->controls['progressColor'] = [
            'group' => 'styles',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Color', 'bricks' ),
            'type'  => 'color',
            'css' => [
                [
                    'property' => 'background-color',
                    'selector' => '.lg-progress-bar .lg-progress',
                ],
            ],
            'default' => [
                'hex' => '#1582e8',
            ],
        ];
        $this->controls['progressPathColor'] = [
            'group' => 'styles',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Path Color', 'bricks' ),
            'type'  => 'color',
            'css' => [
                [
                    'property' => 'background-color',
                    'selector' => '.lg-progress-bar',
                ],
            ],
            'default' => [
                'hex' => '#000000',
            ],
        ];

        /*animations*/
        $this->controls['speed'] = [
            'group' => 'animations',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Lightbox Speed', 'bricks' ),
            'type'  => 'number',
            'unit' => 'ms',
            'default' => '400ms',
        ];
        $this->controls['startAnimationDuration'] = [
            'group' => 'animations',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Lightbox Open Duration', 'bricks' ),
            'type'  => 'number',
            'unit' => 'ms',
            'default' => '400ms',
        ];
        $this->controls['backdropDuration'] = [
            'group' => 'animations',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Backdrop Duration', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'default' => '300ms',
        ];
        $this->controls['mode'] = [
            'group' => 'animations',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Slide Animation', 'bricks' ),
            'type'  => 'select',
            'inline' => true,
            'options' => [
                'lg-slide' => esc_html__( 'Slide', 'bricks' ),
                'lg-fade' => esc_html__( 'Fade', 'bricks' ),
                'lg-zoom-in' => esc_html__( 'Zoom In', 'bricks' ),
                'lg-zoom-in-big' => esc_html__( 'Zoom In Big', 'bricks' ),
                'lg-zoom-out' => esc_html__( 'Zoom Out', 'bricks' ),
                'lg-zoom-out-big' => esc_html__( 'Zoom Out Big', 'bricks' ),
                'lg-zoom-out-in' => esc_html__( 'Zoom Out In', 'bricks' ),
                'lg-zoom-in-out' => esc_html__( 'Zoom In Out', 'bricks' ),
                'lg-soft-zoom' => esc_html__( 'Soft Zoom', 'bricks' ),
                'lg-scale-up' => esc_html__( 'Scale Up', 'bricks' ),
                'lg-slide-circular' => esc_html__( 'Slide Circular', 'bricks' ),
                'lg-slide-circular-vertical' => esc_html__( 'Slide Circular Vertical', 'bricks' ),
                'lg-slide-vertical' => esc_html__( 'Slide Vertical', 'bricks' ),
                'lg-slide-vertical-growth' => esc_html__( 'Slide Vertical Growth', 'bricks' ),
                'lg-slide-skew-only' => esc_html__( 'Slide Skew Only', 'bricks' ),
                'lg-slide-skew-only-rev' => esc_html__( 'Slide Skew Only Reverse', 'bricks' ),
                'lg-slide-skew-only-y' => esc_html__( 'Slide Skew Only Y', 'bricks' ),
                'lg-slide-skew-only-y-rev' => esc_html__( 'Slide Skew Only Y Reverse', 'bricks' ),
                'lg-slide-skew' => esc_html__( 'Slide Skew', 'bricks' ),
                'lg-slide-skew-rev' => esc_html__( 'Slide Skew Reverse', 'bricks' ),
                'lg-slide-skew-cross' => esc_html__( 'Slide Skew Cross', 'bricks' ),
                'lg-slide-skew-cross-rev' => esc_html__( 'Slide Skew Cross Reverse', 'bricks' ),
                'lg-slide-skew-ver' => esc_html__( 'Slide Skew Vertical', 'bricks' ),
                'lg-slide-skew-ver-rev' => esc_html__( 'Slide Skew Vertical Reverse', 'bricks' ),
                'lg-slide-skew-ver-cross' => esc_html__( 'Slide Skew Vertical Cross', 'bricks' ),
                'lg-slide-skew-ver-cross-rev' => esc_html__( 'Slide Skew Vertical Cross Reverse', 'bricks' ),
                'lg-lollipop' => esc_html__( 'Lollipop', 'bricks' ),
                'lg-lollipop-rev' => esc_html__( 'Lollipop Reverse', 'bricks' ),
                'lg-rotate' => esc_html__( 'Rotate', 'bricks' ),
                'lg-rotate-rev' => esc_html__( 'Rotate Reverse', 'bricks' ),
                'lg-tube' => esc_html__( 'Tube', 'bricks' ),
            ],
            'default' => 'lg-slide',
        ];
        $this->controls['easing'] = [
            'group' => 'animations',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Slide CSS Easing', 'bricks' ),
            'type'  => 'text',
            'inline' => true,
            'default' => 'ease',
        ];
        $this->controls['index'] = [
            'group' => 'animations',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Initial Image (0 to show selected)', 'bricks' ),
            'type'  => 'text',
            'inline' => true,
            'default' => '0',
        ];
        $this->controls['loop'] = [
            'group' => 'animations',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Enable Loop', 'bricks' ),
            'type'  => 'checkbox',
            'default' => true,
        ];

        $this->controls['zoom'] = [
            'group' => 'animations',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Enable Zoom', 'bricks' ),
            'type'  => 'checkbox',
            'default' => true,
        ];
        $this->controls['thumbnail'] = [
            'group' => 'animations',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Enable Thumbnails', 'bricks' ),
            'type'  => 'checkbox',
            'default' => true,
        ];
        $this->controls['thumbHeight'] = [
            'group' => 'animations',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Thumbnail Height', 'bricks' ),
            'type'  => 'number',
            'unit' => 'px',
            'default' => '180px',
            'required' => [ 'thumbnail', '=', true],
        ];
        $this->controls['thumbMargin'] = [
            'group' => 'animations',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Gap between thumbnails', 'bricks' ),
            'type'  => 'number',
            'default' => 5,
            'required' => [ 'thumbnail', '=', true],
        ];

        $this->controls['rotate'] = [
            'group' => 'animations',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Enable Rotate', 'bricks' ),
            'type'  => 'checkbox',
            'default' => true,
        ];
        $this->controls['rotateSpeed'] = [
            'group' => 'animations',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Rotate Speed', 'bricks' ),
            'type'  => 'number',
            'unit' => 'ms',
            'default' => 400,
            'required' => [ 'rotate', '=', true],
        ];

        $this->controls['fullscreen'] = [
            'group' => 'animations',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Enable Fullscreen', 'bricks' ),
            'type'  => 'checkbox',
            'default' => true,
        ];
        $this->controls['autoplay'] = [
            'group' => 'animations',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Enable Autoplay', 'bricks' ),
            'type'  => 'checkbox',
            'default' => true,
        ];
        $this->controls['forceSlideShowAutoplay'] = [
            'group' => 'animations',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Force Slideshow Autoplay', 'bricks' ),
            'type'  => 'checkbox',
            'default' => false,
            'required' => [ 'autoplay', '=', true],
        ];
        $this->controls['progressBar'] = [
            'group' => 'animations',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Display Progress Bar', 'bricks' ),
            'type'  => 'checkbox',
            'default' => true,
            'required' => [ 'autoplay', '=', true],
        ];
        $this->controls['slideShowInterval'] = [
            'group' => 'animations',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Slideshow Interval', 'bricks' ),
            'type'  => 'number',
            'unit' => 'ms',
            'default' => 5000,
            'required' => [ 'autoplay', '=', true],
        ];

        $this->controls['displaysSeparator'] = [
            'group' => 'animations',
            'label'      => esc_html__( 'Displays', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['controls'] = [
            'group' => 'animations',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Controls', 'bricks' ),
            'type'  => 'checkbox',
            'default' => true,
        ];
        $this->controls['counter'] = [
            'group' => 'animations',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Counter', 'bricks' ),
            'type'  => 'checkbox',
            'default' => true,
        ];
        $this->controls['download'] = [
            'group' => 'animations',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Download Button', 'bricks' ),
            'type'  => 'checkbox',
            'default' => true,
        ];
        $this->controls['showCloseIcon'] = [
            'group' => 'animations',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Close Icon', 'bricks' ),
            'type'  => 'checkbox',
            'default' => true,
            'required' => [ 'closable', '=', true],
        ];

        $this->controls['accesibilitySeparator'] = [
            'group' => 'animations',
            'label'      => esc_html__( 'Accesibility', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['closable'] = [
            'group' => 'animations',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Closable', 'bricks' ),
            'type'  => 'checkbox',
            'default' => true,
        ];
        $this->controls['closeOnTap'] = [
            'group' => 'animations',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Close on Tap', 'bricks' ),
            'type'  => 'checkbox',
            'default' => true,
        ];
        $this->controls['escKey'] = [
            'group' => 'animations',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Close on ESC', 'bricks' ),
            'type'  => 'checkbox',
            'default' => true,
        ];
        $this->controls['mousewheel'] = [
            'group' => 'animations',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Enable Mousewheel', 'bricks' ),
            'type'  => 'checkbox',
            'default' => true,
        ];
        $this->controls['enableDrag'] = [
            'group' => 'animations',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Enable Drag on desktop', 'bricks' ),
            'type'  => 'checkbox',
            'default' => true,
        ];
        $this->controls['enableSwipe'] = [
            'group' => 'animations',
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Enable Swipe on mobile', 'bricks' ),
            'type'  => 'checkbox',
            'default' => true,
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next_lightgallery', NEXTBRICKS_PLUGIN_URL . 'local_assets/lightgallery/lightgallery.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
        wp_enqueue_script( 'next_lightgallery_autoplay', NEXTBRICKS_PLUGIN_URL . 'local_assets/lightgallery/lightgallery-autoplay.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
        wp_enqueue_script( 'next_lightgallery_fullscreen', NEXTBRICKS_PLUGIN_URL . 'local_assets/lightgallery/lightgallery-fullscreen.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
        wp_enqueue_script( 'next_lightgallery_thumbnail', NEXTBRICKS_PLUGIN_URL . 'local_assets/lightgallery/lightgallery-thumbnail.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
        wp_enqueue_script( 'next_lightgallery_rotate', NEXTBRICKS_PLUGIN_URL . 'local_assets/lightgallery/lightgallery-rotate.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
        wp_enqueue_script( 'next_lightgallery_zoom', NEXTBRICKS_PLUGIN_URL . 'local_assets/lightgallery/lightgallery-zoom.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
        
        wp_enqueue_script( 'next_lightbox', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_lightbox.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $elements = ! empty( $settings['elements'] ) ? $settings['elements'] : 0;
        $speed = ! empty( $settings['speed'] ) ? $settings['speed'] : '400ms';
        $startAnimationDuration = ! empty( $settings['startAnimationDuration'] ) ? $settings['startAnimationDuration'] : '400ms';
        $backdropDuration = ! empty( $settings['backdropDuration'] ) ? $settings['backdropDuration'] : '300ms';
        $mode = ! empty( $settings['mode'] ) ? $settings['mode'] : 'lg-slide';
        $easing = ! empty( $settings['easing'] ) ? $settings['easing'] : 'ease';
        $index = ! empty( $settings['index'] ) ? $settings['index'] : '0';
        $loop = ! empty( $settings['loop'] ) ? $settings['loop'] : 0;
        $zoom = ! empty( $settings['zoom'] ) ? $settings['zoom'] : 0;
        $thumbnail = ! empty( $settings['thumbnail'] ) ? $settings['thumbnail'] : 0;
        $thumbHeight = ! empty( $settings['thumbHeight'] ) ? $settings['thumbHeight'] : '180px';
        $thumbMargin = ! empty( $settings['thumbMargin'] ) ? $settings['thumbMargin'] : 5;
        $rotate = ! empty( $settings['rotate'] ) ? $settings['rotate'] : 0;
        $rotateSpeed = ! empty( $settings['rotateSpeed'] ) ? $settings['rotateSpeed'] : 400;
        $fullscreen = ! empty( $settings['fullscreen'] ) ? $settings['fullscreen'] : 0;
        $autoplay = ! empty( $settings['autoplay'] ) ? $settings['autoplay'] : 0;
        $forceSlideShowAutoplay = ! empty( $settings['forceSlideShowAutoplay'] ) ? $settings['forceSlideShowAutoplay'] : 0;
        $progressBar = ! empty( $settings['progressBar'] ) ? $settings['progressBar'] : 0;
        $slideShowInterval = ! empty( $settings['slideShowInterval'] ) ? $settings['slideShowInterval'] : 5000;
        $controls = ! empty( $settings['controls'] ) ? $settings['controls'] : 0;
        $counter = ! empty( $settings['counter'] ) ? $settings['counter'] : 0;
        $download = ! empty( $settings['download'] ) ? $settings['download'] : 0;
        $showCloseIcon = ! empty( $settings['showCloseIcon'] ) ? $settings['showCloseIcon'] : 0;
        $closable = ! empty( $settings['closable'] ) ? $settings['closable'] : 0;
        $closeOnTap = ! empty( $settings['closeOnTap'] ) ? $settings['closeOnTap'] : 0;
        $escKey = ! empty( $settings['escKey'] ) ? $settings['escKey'] : 0;
        $mousewheel = ! empty( $settings['mousewheel'] ) ? $settings['mousewheel'] : 0;
        $enableDrag = ! empty( $settings['enableDrag'] ) ? $settings['enableDrag'] : 0;
        $enableSwipe = ! empty( $settings['enableSwipe'] ) ? $settings['enableSwipe'] : 0;
        
        $this->set_attribute( '_root', 'class', "nb-lightbox");
        $this->set_attribute( '_root', 'data-speed', $speed);
        $this->set_attribute( '_root', 'data-start-animation-duration', $startAnimationDuration);
        $this->set_attribute( '_root', 'data-backdrop-duration', $backdropDuration);
        $this->set_attribute( '_root', 'data-mode', $mode);
        $this->set_attribute( '_root', 'data-easing', $easing);
        $this->set_attribute( '_root', 'data-index', $index);
        $this->set_attribute( '_root', 'data-loop', $loop);
        $this->set_attribute( '_root', 'data-zoom', $zoom);
        $this->set_attribute( '_root', 'data-thumbnail', $thumbnail);
        $this->set_attribute( '_root', 'data-thumb-height', $thumbHeight);
        $this->set_attribute( '_root', 'data-thumb-margin', $thumbMargin);
        $this->set_attribute( '_root', 'data-rotate', $rotate);
        $this->set_attribute( '_root', 'data-rotate-speed', $rotateSpeed);
        $this->set_attribute( '_root', 'data-fullscreen', $fullscreen);
        $this->set_attribute( '_root', 'data-autoplay', $autoplay);
        $this->set_attribute( '_root', 'data-force-slide-show-autoplay', $forceSlideShowAutoplay);
        $this->set_attribute( '_root', 'data-progress-bar', $progressBar);
        $this->set_attribute( '_root', 'data-slide-show-interval', $slideShowInterval);
        $this->set_attribute( '_root', 'data-controls', $controls);
        $this->set_attribute( '_root', 'data-counter', $counter);
        $this->set_attribute( '_root', 'data-download', $download);
        $this->set_attribute( '_root', 'data-show-close-icon', $showCloseIcon);
        $this->set_attribute( '_root', 'data-closable', $closable);
        $this->set_attribute( '_root', 'data-close-on-tap', $closeOnTap);
        $this->set_attribute( '_root', 'data-esc-key', $escKey);
        $this->set_attribute( '_root', 'data-mousewheel', $mousewheel);
        $this->set_attribute( '_root', 'data-enable-drag', $enableDrag);
        $this->set_attribute( '_root', 'data-enable-swipe', $enableSwipe);
        

        $output = "<{$this->tag} {$this->render_attributes( '_root' )}>";
            if ($elements) {
                foreach ( $elements as $element ) {
                    $src;
                    $alt;
                    $contentdescription;

                    //Get source
                    if ( !isset($element['image'])) {
                        $src = 'https://images.pexels.com/photos/31887348/pexels-photo-31887348.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=2'; //defalt image
                    }else if ( isset($element['image']['mediaData']['url'])) {
                        $src = $element['image']['mediaData']['url'];
                    }else if ( isset($element['image']['url'])) {
                        $src = $element['image']['url'];
                    }else{
                        $src = 'https://images.pexels.com/photos/31887348/pexels-photo-31887348.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=2'; //defalt image
                    }
    
                    //Get alt
                    if ( isset($element['alt'])) {
                        $alt = $element['alt'];
                    }
                    else{
                        $alt = 'gallery-image';
                    }
                    
                    if ( isset($element['content-description'])) {
                        $contentdescription = $element['content-description'];
                    }else{
                        $contentdescription = '';
                    }

                    if (strpos($src, 'cloudinary.com') !== false) {
                        $src_decoding = 'decoding="async"';
                    } else {
                        $src_decoding = '';
                    }

                    $output .= "
                        <a class='nb-lightbox__item' data-src='$src' data-sub-html='" . htmlspecialchars($contentdescription) . "'>
                            <img class='nb-lightbox__item-img' src='$src' $src_decoding />
                        </a>
                    ";
                }
            }
        $output .= "</{$this->tag}>";

        echo $output;
    }
}
