<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Meteor extends \Bricks\Element {
    public $name         = 'next_meteor';
    public $icon         = 'fas fa-meteor';

    public function get_label() {
        return esc_html__( 'Meteor', 'bricks' );
    }

    public function set_controls() {
        /*Line Style*/
        $this->controls['lineStyleSeparator'] = [
            'label'      => esc_html__( 'Line Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['top'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Top', 'bricks' ),
            'type'  => 'number',
            'units'  => true,
            'css'   => [
                [
                    'property' => 'top',
                    'selector' => '',
                ],
            ],
        ];
        $this->controls['width'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type'  => 'number',
            'units'  => true,
            'css'   => [
                [
                    'property' => 'width',
                    'selector' => '',
                ],
            ],
            'placeholder' => '2px',
        ];
        $this->controls['height'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Height', 'bricks' ),
            'type'  => 'number',
            'units'  => true,
            'css'   => [
                [
                    'property' => 'height',
                    'selector' => '',
                ],
            ],
            'placeholder' => '150vmax',
        ];
        $this->controls['rotate'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Rotate', 'bricks' ),
            'type'  => 'number',
            'unit'  => 'deg',
            'css'   => [
                [
                    'property' => 'rotate',
                    'selector' => '',
                ],
            ],
            'placeholder' => '50deg',
        ];
        $this->controls['background'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Background', 'bricks' ),
            'type'  => 'background',
            'inline' => true,
            'css' => [
              [
                'property' => 'background',
                'selector' => '',
              ]
            ],
            'default' => [
                'color' => [
                  'hex' => '#00000015',
                ],
            ],
        ];

        /*Meteor Style*/
        $this->controls['meteorStyleSeparator'] = [
            'label'      => esc_html__( 'Meteor Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['METEORwidth'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type'  => 'number',
            'units'  => true,
            'placeholder' => '5',
        ];
        $this->controls['METEORhue'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Hue', 'bricks' ),
            'type' => 'slider',
            'units'    => [
                'px' => [
                    'min' => 0,
                    'max' => 360,
                    'step' => 1,
                ],
            ],
            'default' => '30',
            'placeholder' => '30',
        ];
        $this->controls['METEORsaturation'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Saturation', 'bricks' ),
            'type' => 'slider',
            'units'    => [
                'px' => [
                    'min' => 0,
                    'max' => 100,
                    'step' => 1,
                ],
            ],
            'default' => '100',
            'placeholder' => '100',
        ];

        /*Meteor Animation*/
        $this->controls['meteorAnimationSeparator'] = [
            'label'      => esc_html__( 'Meteor Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['METEORspeed'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Speed', 'bricks' ),
            'type'  => 'number',
            'unit'  => 's',
            'css'   => [
                [
                    'property' => '--speed',
                    'selector' => '',
                ],
            ],
            'placeholder' => '8s',
        ];
        $this->controls['METEORdelay'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Delay', 'bricks' ),
            'type'  => 'number',
            'unit'  => 's',
            'css'   => [
                [
                    'property' => '--delay',
                    'selector' => '',
                ],
            ],
            'placeholder' => '-2s',
        ];
        $this->controls['METEORease'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'CSS easing', 'bricks' ),
            'type'  => 'text',
            'css'   => [
                [
                    'property' => '--ease',
                    'selector' => '',
                ],
            ],
            'placeholder' => 'linear',
        ];  
    }

    public function render() {
        $settings = $this->settings;
        $METEORwidth    = ! empty( $settings['METEORwidth'] ) ? $settings['METEORwidth'] : 5;
        $METEORhue      = ! empty( $settings['METEORhue'] ) ? $settings['METEORhue'] : 30;
        $METEORsaturation = ! empty( $settings['METEORsaturation'] ) ? $settings['METEORsaturation'] : 100;

        $this->set_attribute( '_root', 'class', "next-meteors__line");
        $this->set_attribute( '_meteor', 'data-width', $METEORwidth);
        $this->set_attribute( '_meteor', 'data-hue', $METEORhue);
        $this->set_attribute( '_meteor', 'data-saturation', $METEORsaturation);

        $output = "<div {$this->render_attributes( '_root' )}>";
        $output .= "<canvas class='next-meteors__meteor' {$this->render_attributes( '_meteor' )}></canvas>";
        $output .= '</div>';

        echo $output;
    }
}