<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Parallax_Slider extends \Bricks\Element {
    public $category     = 'Next Bricks - Sliders';
    public $name         = 'next_parallax_slider';
    public $icon         = 'ti-layout-list-large-image';
    public $scripts      = ['next_parallax_slider'];
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Parallax Slider', 'bricks' );
    }

    public function set_controls() {
        //Slider Style
        $this->controls['SliderStyleSeparator'] = [
            'label'      => esc_html__( 'Slider Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['padding'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Padding', 'bricks' ),
            'type'  => 'spacing',
            'units' => true,
            'css' => [
              [
                'property' => 'padding',
                'selector' => '.next-parallax-slider__container',
              ]
            ],
            'default' => [
                'top' => '0',
                'right' => '50px',
                'bottom' => '0',
                'left' => '50px',
            ],
        ];
        $this->controls['gap'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Gap', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'gap',
                'selector' => '.next-parallax-slider__container',
              ]
            ],
            'placeholder' => '50px',
            'default' => '50px',
        ];

        //Slider Items Style
        $this->controls['sliderItemsStyleSeparator'] = [
            'label'      => esc_html__( 'Slider Items Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['note'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Images can be set at each Slider Item. Width has to set here and is shared at all of them. Rest of styles can be set at each Slider Item', 'bricks' )))
        ];
        $this->controls['ITEMwidth'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => '--items-width',
                'selector' => '.next-parallax-slider__slider',
              ]
            ],
            'placeholder' => '40vw',
        ];
        $this->controls['ITEMheight'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Height', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'height',
                'selector' => '.next-parallax-slider__slider',
              ]
            ],
            'placeholder' => '600px',
            'default' => '600px',
        ];

        //Progress Style
        $this->controls['progressStyleSeparator'] = [
            'label'      => esc_html__( 'Progress Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['PROGRESSmargin'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Margin', 'bricks' ),
            'type'  => 'spacing',
            'units' => true,
            'css' => [
              [
                'property' => 'margin',
                'selector' => '.next-parallax-slider__progress',
              ]
            ],
        ];
        $this->controls['PROGRESSwidth'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'width',
                'selector' => '.next-parallax-slider__progress-line-wrap',
              ]
            ],
            'placeholder' => '80%',
            'default' => '80%',
        ];
        $this->controls['PROGRESSheight'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Height', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => '--progress-height',
                'selector' => '.next-parallax-slider__progress-line-wrap',
              ]
            ],
            'placeholder' => '1px',
        ];
        $this->controls['PROGRESSpathcolor'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Path color', 'bricks' ),
            'type'  => 'color',
            'inline' => true,
            'css' => [
              [
                'property' => 'background-color',
                'selector' => '.next-parallax-slider__progress-line-wrap',
              ]
            ],
            'default' => [
                'hex' => '#d6d6d6',
            ],
        ];
        $this->controls['PROGRESSlinecolor'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Line color', 'bricks' ),
            'type'  => 'color',
            'inline' => true,
            'css' => [
              [
                'property' => 'background-color',
                'selector' => '.next-parallax-slider__progress-line',
              ]
            ],
            'default' => [
                'hex' => '#000',
            ],
        ];

        //Animation
        $this->controls['animationSeparator'] = [
            'label'      => esc_html__( 'Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['noteScroll'] = [
          'tab' => 'content',
          'description' => sprintf(html_entity_decode(esc_html__( 'Scroll Direction determines the users movement direction to use the slider.', 'bricks' )))
        ];
        $this->controls['scrollDirection'] = [
          'hasDynamicData' => false,
          'tab' => 'content',
          'label' => esc_html__( 'Scroll Direction', 'bricks' ),
          'inline' => true,
          'type' => 'select',
          'options' => [
              'upward' => esc_html__('Upward', 'bricks'),
              'downward' => esc_html__('Downward', 'bricks'),
          ],
          'default' => 'upward',
          'placeholder' => 'upward',
      ];
        $this->controls['scale'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Parallax scale', 'bricks' ),
            'type'  => 'text',
            'inline' => true,
            'small' => true,
            'css' => [
              [
                'property' => '--parallax-scale',
                'selector' => '',
              ]
            ],
            'placeholder' => '1.75',
            'default' => '1.75',
        ];
        $this->controls['ease'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Ease', 'bricks' ),
            'type'  => 'text',
            'inline' => true,
            'small' => true,
            'placeholder' => '0.1',
        ];
        $this->controls['scrollMultiplier'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Scroll multiplier', 'bricks' ),
            'type'  => 'text',
            'inline' => true,
            'small' => true,
            'placeholder' => '0.45',
        ];
        $this->controls['dragSpeed'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Drag speed', 'bricks' ),
            'type'  => 'text',
            'inline' => true,
            'small' => true,
            'placeholder' => '1.5',
        ];
    }

    public function get_nestable_children() {
        return [
            [
                'name'     => 'next_parallax_slider_item',
                'label'    => esc_html__( 'Slider Item', 'bricks' ),
                'children' => [
                    [
                        'name'     => 'heading',
                    ]
                ]
            ],
            [
                'name'     => 'next_parallax_slider_item',
                'label'    => esc_html__( 'Slider Item', 'bricks' ),
                'children' => [
                    [
                        'name'     => 'heading',
                    ]
                ]
            ],
            [
                'name'     => 'next_parallax_slider_item',
                'label'    => esc_html__( 'Slider Item', 'bricks' ),
                'children' => [
                    [
                        'name'     => 'heading',
                    ]
                ]
            ],
            [
                'name'     => 'next_parallax_slider_item',
                'label'    => esc_html__( 'Slider Item', 'bricks' ),
                'children' => [
                    [
                        'name'     => 'heading',
                    ]
                ]
            ],
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next_parallax_slider', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_parallax_slider.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $is_builder = bricks_is_builder();
        $scale = ! empty( $settings['scale'] ) ? $settings['scale'] : 1.75;
        $ease = ! empty( $settings['ease'] ) ? $settings['ease'] : 0.1;
        $scrollMultiplier = ! empty( $settings['scrollMultiplier'] ) ? $settings['scrollMultiplier'] : 0.45;
        $dragSpeed = ! empty( $settings['dragSpeed'] ) ? $settings['dragSpeed'] : 1.5;
        $scrollDirection = !empty($settings['scrollDirection']) ? $settings['scrollDirection'] : 'upward';

        $this->set_attribute( '_root', 'class', "next-parallax-slider");

        if ( ! $is_builder ) {
            $this->set_attribute( '_root', 'data-flickering', "");
        }
        $this->set_attribute( '_root', 'data-parallax-scale', $scale );
        $this->set_attribute( '_root', 'data-scroll-ease', $ease );
        $this->set_attribute( '_root', 'data-scroll-multiplier', $scrollMultiplier );
        $this->set_attribute( '_root', 'data-drag-speed', $dragSpeed );
        $this->set_attribute( '_root', 'data-scroll-direction', $scrollDirection );
        $output = "<div {$this->render_attributes( '_root' )}>";

        $output .= '<div class="next-parallax-slider__slider">';
        $output .= '<div class="next-parallax-slider__container" data-parallax-slider-scroll>';
        $output .= Frontend::render_children( $this );
        $output .= '</div>';
        $output .= '</div>';

        $output .= '<div class="next-parallax-slider__progress">';
        $output .= '<div class="next-parallax-slider__progress-line-wrap">';
        $output .= '<div class="next-parallax-slider__progress-line"></div>';
        $output .= '</div>';
        $output .= '</div>';

        $output .= '</div>';

        echo $output;
    }
}
