<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Proximity_Hover extends \Bricks\Element {
  public $category     = 'Next Bricks - Texts';
  public $name         = 'next-proximity-hover';
  public $icon         = 'ti-text';
  public $tag      = 'h3';
  public $scripts      = ['next_proximity_hover'];

  public function get_label() {
    return esc_html__( 'Proximity Hover', 'bricks' );
  }

  public function set_controls() {
    $this->controls['inner_title'] = [
        'tab'            => 'content',
        'type'           => 'textarea',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Proximity Hover', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];

    $this->controls['tag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'HTML tag', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'h1' => 'h1',
            'h2' => 'h2',
            'h3' => 'h3',
            'h4' => 'h4',
            'h5' => 'h5',
            'h6' => 'h6',
            'p' => 'p',
            'span' => 'span',
            'custom' => 'custom',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'h3',
        'default'     => 'h3',
    ];
    $this->controls['customTag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Custom tag', 'bricks' ),
        'type'        => 'text',
        'inline'      => true,
        'placeholder' => 'h3',
        'required'    => [ 'tag', '=', 'custom' ],
    ];

    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['typography'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Typography', 'bricks' ),
        'type'  => 'typography',
        'css'   => [
            [
                'property' => 'typography',
                'selector' => '',
            ],
        ],
        'default' => [
            'color' => [
                'hex' => '#1f2937',
            ],
            'font-size' => '32px',
        ],
    ];

    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['type'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Proximity Type', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'weight' => 'Weight',
            'size'   => 'Size',
        ],
        'clearable'   => false,
        'inline'      => true,
        'default'     => 'size',
        'rerender' => true,
    ];
    $this->controls['radius'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Proximity Distance', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'default' => 150,
        'rerender' => true,
    ];
    $this->controls['minWeight'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Min Weight', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'default' => 100,
        'required' => [ 'type', '=', 'weight' ],
        'rerender' => true,
    ];
    $this->controls['maxWeight'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Max Weight', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'default' => 900,
        'required' => [ 'type', '=', 'weight' ],
        'rerender' => true,
    ];
    $this->controls['minScale'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Min Scale', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'default' => 1,
        'required' => [ 'type', '=', 'size' ],
        'rerender' => true,
    ];
    $this->controls['maxScale'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Max Scale', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'default' => 1.5,
        'required' => [ 'type', '=', 'size' ],
        'rerender' => true,
    ];
    $this->controls['duration'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Duration', 'bricks' ),
        'type'    => 'number',
        'unit'   => 'ms',
        'css'     => [
            [
                'property' => '--duration',
                'selector' => '',
            ],
        ],
        'default' => '75ms',
    ];

    $this->controls['easing'] = [
        'tab'     => 'content', 
        'label'   => esc_html__( 'CSS Easing', 'bricks' ),
        'type'    => 'text',
        'css'     => [
            [
                'property' => '--easing',
                'selector' => '',
            ],
        ],
        'default' => 'ease-out',
    ];
  }

  public function enqueue_scripts() {
    wp_enqueue_script( 'next-proximity-hover', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_proximity_hover.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : '';
    $type = ! empty( $settings['type'] ) ? $settings['type'] : 'size';
    $radius = ! empty( $settings['radius'] ) ? $settings['radius'] : 150;
    $minWeight = ! empty( $settings['minWeight'] ) ? $settings['minWeight'] : 100;
    $maxWeight = ! empty( $settings['maxWeight'] ) ? $settings['maxWeight'] : 900;
    $minScale = ! empty( $settings['minScale'] ) ? $settings['minScale'] : 1;
    $maxScale = ! empty( $settings['maxScale'] ) ? $settings['maxScale'] : 1.5;

    $this->set_attribute( '_root', 'class', 'next-proximity-hover' );
    $this->set_attribute( '_inner', 'class', 'next-proximity-hover__inner' );

    $this->set_attribute( '_inner', 'data-type', $type );
    $this->set_attribute( '_inner', 'data-radius', $radius );
    $this->set_attribute( '_inner', 'data-min-weight', $minWeight );
    $this->set_attribute( '_inner', 'data-max-weight', $maxWeight );
    $this->set_attribute( '_inner', 'data-min-scale', $minScale );
    $this->set_attribute( '_inner', 'data-max-scale', $maxScale );

    if ( ! empty( $settings['link'] ) ) {
        $this->set_link_attributes( '_link', $settings['link'] );
        $output ="
        <{$this->tag} {$this->render_attributes( '_root' )}>
            <a class='next-proximity-hover__anchor' {$this->render_attributes( '_link' )}>
                <span {$this->render_attributes( '_inner' )}>$inner_title</span>
            </a>
        </{$this->tag}>
        ";
    }else{
        $output ="
        <{$this->tag} {$this->render_attributes( '_root' )}>
            <span {$this->render_attributes( '_inner' )}>$inner_title</span>
        </{$this->tag}>
        ";
    }

    echo $output;
  }
}

