<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Rainbow_Button extends \Bricks\Element {
    public $category     = 'Next Bricks - Buttons';
    public $name         = 'next-rainbow-button';
    public $icon         = 'fa-solid fa-square-minus';
    public $tag      = 'div';
    public $scripts      = ['next_rainbow_button'];

    public function get_label() {
        return esc_html__( 'Rainbow Button', 'bricks' );
    }

    public function set_controls() {
        $this->controls['tag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'HTML tag', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'div' => 'div',
                'span' => 'span',
                'button' => 'button',
                'custom' => 'custom',
            ],
            'clearable'   => false,
            'inline'      => true,
            'placeholder' => 'div',
            'default'     => 'div',
        ];
        $this->controls['customTag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Custom tag', 'bricks' ),
            'type'        => 'text',
            'inline'      => true,
            'placeholder' => 'div',
            'required'    => [ 'tag', '=', 'custom' ],
        ];
        $this->controls['inner_title'] = [
            'tab'            => 'content',
            'type'           => 'text',
            'hasDynamicData' => 'text',
            'default'        => esc_html__( 'Rainbow Button', 'bricks' ),
            'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
        ];
        $this->controls['link'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Link to', 'bricks' ),
            'type'  => 'link',
        ];

        $this->controls['iconsSeparator'] = [
            'label'      => esc_html__( 'Icons', 'bricks' ),
            'type'       => 'separator',
          ];
          $this->controls['includeLeftIcon'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Left Icon', 'bricks' ),
            'type' => 'checkbox',
            'default' => false,
          ];
          $this->controls['leftIcon'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Icon', 'bricks' ),
            'type' => 'icon',
            'css' => [
              [
                'selector' => '&{pseudo} .next-rainbow-button__left-icon',
              ],
            ],
            'required'   => [ 'includeLeftIcon', '=', true ],
          ];
          $this->controls['leftIconMargin'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Margin', 'bricks' ),
            'type'  => 'spacing',
            'css'   => [
              [
                'property' => 'margin',
                'selector' => '&{pseudo} .next-rainbow-button__left-icon',
              ],
            ],
            'required' => [ 'includeLeftIcon', '=', true ],
          ];
          $this->controls['leftIconSize'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Size', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'css'   => [
              [
                'property' => 'font-size',
                'selector' => '&{pseudo} .next-rainbow-button__left-icon',
              ],
            ],
            'required' => [ 'includeLeftIcon', '=', true ],
          ];
          $this->controls['leftIconColor'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Color', 'bricks' ),
            'type'  => 'color',
            'css'   => [
              [
                'property' => 'color',
                'selector' => '&{pseudo} .next-rainbow-button__left-icon',
              ],
            ],
            'required' => [ 'includeLeftIcon', '=', true ],
          ];
          $this->controls['includeRightIcon'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Right Icon', 'bricks' ),
            'type' => 'checkbox',
            'default' => false,
          ];
          $this->controls['rightIcon'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Icon', 'bricks' ),
            'type' => 'icon',
            'css' => [
              [
                'selector' => '&{pseudo} .next-rainbow-button__right-icon',
              ],
            ],
            'required'   => [ 'includeRightIcon', '=', true ],
          ];
          $this->controls['rightIconMargin'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Margin', 'bricks' ),
            'type'  => 'spacing',
            'css'   => [
              [
                'property' => 'margin',
                'selector' => '&{pseudo} .next-rainbow-button__right-icon',
              ],
            ],
            'required' => [ 'includeRightIcon', '=', true ],
          ];
          $this->controls['rightIconSize'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Size', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'css'   => [
              [
                'property' => 'font-size',
                'selector' => '&{pseudo} .next-rainbow-button__right-icon',
              ],
            ],
            'required' => [ 'includeRightIcon', '=', true ],
          ];
          $this->controls['rightIconColor'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Color', 'bricks' ),
            'type'  => 'color',
            'css'   => [
              [
                'property' => 'color',
                'selector' => '&{pseudo} .next-rainbow-button__right-icon',
              ],
            ],
            'required' => [ 'includeRightIcon', '=', true ],
          ];

        $this->controls['styleSeparator'] = [
          'label'      => esc_html__( 'Style', 'bricks' ),
          'type'       => 'separator',
        ];
        $this->controls['padding'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Padding', 'bricks' ),
            'type'        => 'spacing',
            'css'     => [
                [
                    'property' => 'padding',
                    'selector' => '',
                ],
            ],
            'default' => [
                'top' => 8,
                'right' => 12,
                'bottom' => 8,
                'left' => 12,
            ],
        ];
        $this->controls['typography'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Typography', 'bricks' ),
            'type'  => 'typography',
            'css'   => [
              [
                'property' => 'typography',
                'selector' => '',
              ],
            ],
            'default' => [
                'color' => [
                    'hex' => '#fff',
                ],
              'font-size' => '14px',
            ],
        ];
        $this->controls['background'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Background', 'bricks' ),
            'type'    => 'color',
            'css'     => [
                [
                    'property' => 'background-color',
                    'selector' => '&{pseudo} .next-rainbow-button__bg',
                ],
            ],
            'default' => [
                'hex' => '#000',
            ],
        ];
        $this->controls['borderColor'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Border color', 'bricks' ),
            'type'    => 'color',
            'css'     => [
                [
                    'property' => '--border',
                    'selector' => '',
                ],
            ],
            'default' => [
                'hex' => '#333333',
            ],
        ];
        $this->controls['borderWidth'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Border width', 'bricks' ),
            'type'    => 'number',
            'units'   => true,
            'css'     => [
                [
                    'property' => '--border-width',
                    'selector' => '',
                ],
            ],
            'default' => 3,
        ];
        $this->controls['borderRadius'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Border radius', 'bricks' ),
            'type'    => 'number',
            'units'   => true,
            'css'     => [
                [
                    'property' => '--border-radius',
                    'selector' => '',
                ],
            ],
            'default' => 8,
        ];

        $this->controls['rainbowSeparator'] = [
          'label'      => esc_html__( 'Rainbow Colors', 'bricks' ),
          'type'       => 'separator',
        ];
        $this->controls['colors'] = [
          'tab'           => 'content',
          'type'          => 'repeater',
          'label'         => esc_html__( 'Colors', 'bricks' ),
          'titleProperty' => 'title',
          'fields'        => [
              'gradientcolor'       => [
                  'type'    => 'color',
                  'label'   => esc_html__( 'Color', 'bricks' ),
              ],
          ],
          'default' => [
            [
                'gradientcolor' => [
                  'hex' => '#f47373',
                ],
            ],
            [
                'gradientcolor' => [
                  'hex' => '#f79a49',
                ],
            ],
            [
                'gradientcolor' => [
                  'hex' => '#f6ce3a',
                ],
            ],
            [
                'gradientcolor' => [
                  'hex' => '#b5e04b',
                ],
            ],
            [
                'gradientcolor' => [
                  'hex' => '#5ae390',
                ],
            ],
            [
                'gradientcolor' => [
                  'hex' => '#54d7d7',
                ],
            ],
            [
                'gradientcolor' => [
                  'hex' => '#4caff0',
                ],
            ],
            [
                'gradientcolor' => [
                  'hex' => '#6485e2',
                ],
            ],
            [
                'gradientcolor' => [
                  'hex' => '#9c6edb',
                ],
            ],
            [
                'gradientcolor' => [
                  'hex' => '#d86acb',
                ],
            ],
            [
                'gradientcolor' => [
                  'hex' => '#f47373',
                ],
            ],
          ],
      ];
        
        //Animation
        $this->controls['AnimationSeparator'] = [
            'label'       => esc_html__( 'Rainbow animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['alwaysPlay'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Always play', 'bricks' ),
            'type' => 'checkbox',
            'rerender' => true,
        ];
        $this->controls['duration'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Duration', 'bricks' ),
            'type'    => 'number',
            'unit'    =>  's',
            'css'     => [
                [
                    'property' => '--rainbow-duration',
                    'selector' => '',
                ],
            ],
            'default' => '12s',
        ];
        $this->controls['ease'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'CSS Easing', 'bricks' ),
            'type'    => 'text',
            'css'     => [
                [
                    'property' => '--rainbow-easing',
                    'selector' => '',
                ],
            ],
            'default' => 'linear',
        ];
    }

    public function enqueue_scripts() {
      wp_enqueue_script( 'next_rainbow_button', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_rainbow_button.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Rainbow Button';
        $alwaysPlay = ! empty( $settings['alwaysPlay'] ) ? $settings['alwaysPlay'] : '0';

        if ( ! empty( $settings['link'] ) ) {
            $this->set_link_attributes( '_root', $settings['link'] );
            $root_tag = 'a';
        }else{
            $root_tag = $this->tag;
        }

        $includeLeftIcon = ! empty( $settings['includeLeftIcon'] ) ? $settings['includeLeftIcon'] : 0;
        $includeRightIcon = ! empty( $settings['includeRightIcon'] ) ? $settings['includeRightIcon'] : 0;
        if ( $includeLeftIcon !== 0 ) {
        $leftIcon = self::render_icon( $settings['leftIcon'], [ 'next-rainbow-button__left-icon' ] );
        }else{
        $leftIcon = '';
        }
        if ( $includeRightIcon !== 0 ) {
        $rightIcon = self::render_icon( $settings['rightIcon'], [ 'next-rainbow-button__right-icon' ] );
        }else{
        $rightIcon = '';
        }

        $this->set_attribute( '_root', 'class', 'next-rainbow-button' );

        if($alwaysPlay == '1'){
            $this->set_attribute( '_root', 'data-always-play', '1' );
        }else{
            $this->set_attribute( '_root', 'data-play-hover', '1' );
        }

        $colors = ! empty( $settings['colors'] ) ? $settings['colors'] : '';
        if ($colors) {
            $gradientcolors = '';
            foreach ( $colors as $color ) {
                if ( isset($color['gradientcolor']) && is_array($color['gradientcolor'])) {
                    if (isset($color['gradientcolor']['rgb'])) {
                      $gradientcolor = $color['gradientcolor']['rgb'];
                    }else if(isset($color['gradientcolor']['raw'])){
                      $gradientcolor = $color['gradientcolor']['raw'];
                    }else if(isset($color['gradientcolor']['hex'])){
                      $gradientcolor = $color['gradientcolor']['hex'];
                    }
                    $gradientcolors .= $gradientcolor . 'next11';
                }else{
                    $gradientcolors .= '#f47373next11#f79a49next11#f6ce3anext11#b5e04bnext11#5ae390next11#54d7d7next11#4caff0next11#6485e2next11#9c6edbnext11#d86acbnext11#f47373next11';
                }
            }
            $gradientcolors .= '';
        }else{
            $gradientcolors = '#f47373next11#f79a49next11#f6ce3anext11#b5e04bnext11#5ae390next11#54d7d7next11#4caff0next11#6485e2next11#9c6edbnext11#d86acbnext11#f47373next11';
        }
        $this->set_attribute( '_root', 'data-gradient-colors', $gradientcolors);

        $output = "
        <$root_tag  {$this->render_attributes( '_root' )}>
            <span>$leftIcon$inner_title$rightIcon</span>
            <div class='next-rainbow-button__bg'></div>
        </$root_tag>
        ";

        echo $output;
    }
}